/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.subscriber;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.util.Util;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSSyncTreeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.mappings.model.ModelProject;
import org.eclipse.team.tests.ccvs.core.mappings.model.mapping.ModelResourceMapping;
import org.eclipse.team.tests.ccvs.core.subscriber.CVSSyncSubscriberTest;
import org.eclipse.team.tests.ccvs.core.subscriber.SyncInfoSource;
import org.eclipse.team.tests.ccvs.ui.ModelParticipantSyncInfoSource;

public class CVSWorkspaceSubscriberTest
extends CVSSyncSubscriberTest {
    public CVSWorkspaceSubscriberTest() {
    }

    public CVSWorkspaceSubscriberTest(String name) {
        super(name);
    }

    public static Test suite() {
        String testName = System.getProperty("eclipse.cvs.testName");
        if (testName == null) {
            TestSuite suite = new TestSuite(CVSWorkspaceSubscriberTest.class);
            return new CVSTestSetup((Test)suite);
        }
        return new CVSTestSetup((Test)new CVSWorkspaceSubscriberTest(testName));
    }

    @Override
    protected boolean isFailOnSyncInfoMismatch() {
        return CVSTestSetup.FAIL_ON_BAD_DIFF;
    }

    protected CVSSyncTreeSubscriber getSubscriber() throws TeamException {
        return (CVSSyncTreeSubscriber)this.getWorkspaceSubscriber();
    }

    @Override
    protected void shareProject(IProject project) throws TeamException, CoreException {
        this.mapNewProject(project);
        this.assertSyncEquals(project.getName(), (Subscriber)this.getSubscriber(), (IResource)project, 0);
        this.assertAllSyncEquals(project.members(true), 5, 2);
        this.commitNewProject(project);
        this.assertAllSyncEquals((IResource)project, 0, 2);
    }

    protected void assertAllSyncEquals(final IResource rootResource, final int kind, int depth) throws CoreException {
        if (!rootResource.exists() && !rootResource.isPhantom()) {
            CVSWorkspaceSubscriberTest.assertTrue((kind == 0 ? 1 : 0) != 0);
            return;
        }
        rootResource.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                CVSWorkspaceSubscriberTest.this.assertSyncEquals(rootResource.getName(), (Subscriber)CVSWorkspaceSubscriberTest.this.getSubscriber(), resource, kind);
                return true;
            }
        }, depth, true);
    }

    private void assertAllSyncEquals(IResource[] resources, int kind, int depth) throws CoreException {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            this.assertAllSyncEquals(resource, kind, depth);
            ++i;
        }
    }

    @Override
    protected void setContentsAndEnsureModified(IFile file) throws CoreException, TeamException {
        super.setContentsAndEnsureModified(file);
        SyncInfo info = this.getSyncInfoSource().getSyncInfo((Subscriber)this.getSubscriber(), (IResource)file);
        int kind = info.getKind();
        CVSWorkspaceSubscriberTest.assertTrue(((kind & 3) == 3 ? 1 : 0) != 0);
        CVSWorkspaceSubscriberTest.assertTrue(((kind & 4) > 0 ? 1 : 0) != 0);
    }

    private void assertSyncEquals(String string, IProject project, String[] strings, boolean refresh, int[] kinds) throws CoreException, TeamException {
        this.assertSyncEquals(string, (Subscriber)this.getSubscriber(), (IContainer)project, strings, refresh, kinds);
    }

    private void assertSyncEquals(IProject project, String[] strings, boolean refresh, int[] kinds) throws CoreException, TeamException {
        this.assertSyncEquals(this.getName(), (Subscriber)this.getSubscriber(), (IContainer)project, strings, refresh, kinds);
    }

    private void assertSyncEquals(String message, IResource resource, int syncKind) throws CoreException {
        this.assertSyncEquals(message, (Subscriber)this.getSubscriber(), resource, syncKind);
    }

    @Override
    protected void addResources(IResource[] resources) throws TeamException, CVSException, CoreException {
        IResource[] affectedChildren = this.collect(resources, new CVSSyncSubscriberTest.ResourceCondition(){

            @Override
            public boolean matches(IResource resource) throws CoreException, TeamException {
                ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
                return !cvsResource.isManaged() && !cvsResource.isIgnored();
            }
        }, 2);
        IResource[] affectedParents = this.collectAncestors(resources, new CVSSyncSubscriberTest.ResourceCondition(){

            @Override
            public boolean matches(IResource resource) throws CoreException, TeamException {
                if (resource.getType() == 4) {
                    return false;
                }
                ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
                return !cvsResource.isManaged() && !cvsResource.isIgnored();
            }
        });
        HashSet<IResource> affected = new HashSet<IResource>();
        affected.addAll(Arrays.asList(affectedChildren));
        affected.addAll(Arrays.asList(affectedParents));
        this.registerSubscriberListener();
        super.addResources(resources);
        ISubscriberChangeEvent[] changes = this.deregisterSubscriberListener();
        this.assertSyncChangesMatch(changes, affected.toArray(new IResource[affected.size()]));
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.getType() == 1) {
                this.assertSyncEquals("Add", resource, 5);
            } else {
                this.assertSyncEquals("Add", resource, 0);
            }
            ++i;
        }
    }

    private void registerSubscriberListener() throws TeamException {
        this.registerSubscriberListener((Subscriber)this.getSubscriber());
    }

    @Override
    protected void deleteResources(IResource[] resources) throws TeamException, CoreException {
        IResource[] affected = this.collect(resources, new CVSSyncSubscriberTest.ResourceCondition(), 2);
        this.registerSubscriberListener();
        super.deleteResources(resources);
        ISubscriberChangeEvent[] changes = this.deregisterSubscriberListener();
        this.assertSyncChangesMatch(changes, affected);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.getType() == 1) {
                this.assertSyncEquals("Delete", resource, 6);
            } else {
                this.assertSyncEquals("Delete", resource, 0);
            }
            ++i;
        }
    }

    private ISubscriberChangeEvent[] deregisterSubscriberListener() throws TeamException {
        return this.deregisterSubscriberListener((Subscriber)this.getSubscriber());
    }

    @Override
    protected void commitResources(IResource[] resources, int depth) throws TeamException, CVSException, CoreException {
        IResource[] affected = this.collect(resources, new CVSSyncSubscriberTest.ResourceCondition(){

            @Override
            public boolean matches(IResource resource) throws CoreException, TeamException {
                ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
                return !cvsResource.isFolder() && cvsResource.isManaged() && cvsResource.isModified(DEFAULT_MONITOR);
            }
        }, 2);
        this.registerSubscriberListener();
        super.commitResources(resources, depth);
        ISubscriberChangeEvent[] changes = this.deregisterSubscriberListener();
        this.assertSyncChangesMatch(changes, affected);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.exists()) {
                this.assertSyncEquals("Commit", resource, 0);
            }
            ++i;
        }
    }

    @Override
    protected void unmanageResources(IResource[] resources) throws CoreException, TeamException {
        IResource[] affected = this.collect(resources, new CVSSyncSubscriberTest.ResourceCondition(){

            @Override
            public boolean matches(IResource resource) throws CoreException, TeamException {
                ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
                return cvsResource.isManaged();
            }
        }, 2);
        this.registerSubscriberListener();
        super.unmanageResources(resources);
        ISubscriberChangeEvent[] changes = this.deregisterSubscriberListener();
        this.assertSyncChangesMatch(changes, affected);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.exists()) {
                this.assertSyncEquals("Unmanage", resource, 0);
            }
            ++i;
        }
    }

    public IResource[] update(IContainer container, String[] hierarchy) throws CoreException {
        IResource[] resources = this.getResources(container, hierarchy);
        this.getSyncInfoSource().updateResources((Subscriber)this.getSubscriber(), resources);
        return resources;
    }

    public IResource[] commit(IContainer container, String[] hierarchy) throws CoreException {
        IResource[] resources = this.getResources(container, hierarchy);
        this.getSyncInfoSource().commitResources((Subscriber)this.getSubscriber(), resources);
        return resources;
    }

    public IResource[] overrideAndUpdate(IContainer container, String[] hierarchy, boolean shouldPrompt) throws CoreException, TeamException {
        IResource[] resources = this.getResources(container, hierarchy);
        this.getSyncInfoSource().overrideAndUpdateResources((Subscriber)this.getSubscriber(), shouldPrompt, resources);
        return resources;
    }

    public IResource[] overrideAndCommit(IContainer container, String[] hierarchy, boolean shouldPrompt) throws CoreException, TeamException {
        IResource[] resources = this.getResources(container, hierarchy);
        this.getSyncInfoSource().overrideAndCommitResources((Subscriber)this.getSubscriber(), resources);
        return resources;
    }

    public void testBug302163WithoutModel() throws CoreException {
        IProject modelProject = this.getUniqueTestProject("test1");
        this.buildResources((IContainer)modelProject, new String[]{"file.mod", "f1.moe"}, true);
        modelProject.getFile("file.mod").setContents((InputStream)new ByteArrayInputStream("\nf1.moe".getBytes()), false, true, null);
        this.shareProject(modelProject);
        this.assertValidCheckout(modelProject);
        IProject copyModelProject = this.checkoutCopy(modelProject, "-copy");
        copyModelProject.getFile("file.mod").setContents((InputStream)new ByteArrayInputStream("\nf1.moe\nf2.moe".getBytes()), false, true, null);
        this.commitProject(copyModelProject);
        try {
            RepositoryProviderOperation.consultModelsWhenBuildingScope = true;
            CVSWorkspaceSubscriberTest.setSyncSource(new SyncInfoSource());
            this.refresh((Subscriber)this.getSubscriber(), (IResource)modelProject);
            try {
                this.update((IContainer)modelProject, new String[]{"file.mod"});
            }
            catch (CVSException e) {
                CVSWorkspaceSubscriberTest.fail((String)"Update without models failed", (Throwable)e);
            }
        }
        finally {
            RepositoryProviderOperation.consultModelsWhenBuildingScope = false;
            CVSWorkspaceSubscriberTest.setSyncSource(new ModelParticipantSyncInfoSource());
        }
    }

    public void testBug302163WithModel() throws CoreException {
        IProject project = this.createProject("test", new String[]{"file1.txt"});
        ModelResourceMapping.projectName = project.getName();
        IProject modelProject = this.getUniqueTestProject("test1");
        this.buildResources((IContainer)modelProject, new String[]{"file.mod", "f1.moe"}, true);
        modelProject.getFile("file.mod").setContents((InputStream)new ByteArrayInputStream("\nf1.moe".getBytes()), false, true, null);
        ModelProject.makeModProject(modelProject, (IProgressMonitor)new NullProgressMonitor());
        this.shareProject(modelProject);
        this.assertValidCheckout(modelProject);
        IProject copyModelProject = this.checkoutCopy(modelProject, "-copy");
        copyModelProject.getFile("file.mod").setContents((InputStream)new ByteArrayInputStream("\nf1.moe\nf2.moe".getBytes()), false, true, null);
        this.commitProject(copyModelProject);
        try {
            RepositoryProviderOperation.consultModelsWhenBuildingScope = true;
            CVSWorkspaceSubscriberTest.setSyncSource(new SyncInfoSource());
            this.refresh((Subscriber)this.getSubscriber(), (IResource)modelProject);
            try {
                this.update((IContainer)modelProject, new String[]{"file.mod"});
            }
            catch (CVSException e) {
                CVSWorkspaceSubscriberTest.fail((String)"Update without models failed", (Throwable)e);
            }
        }
        finally {
            RepositoryProviderOperation.consultModelsWhenBuildingScope = false;
            CVSWorkspaceSubscriberTest.setSyncSource(new ModelParticipantSyncInfoSource());
        }
    }

    public void testIncomingChanges() throws IOException, TeamException, CoreException {
        IProject project = this.createProject("testIncomingChanges", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.setContentsAndEnsureModified(copy.getFile("folder1/a.txt"));
        this.addResources((IContainer)copy, new String[]{"folder2/folder3/add.txt"}, false);
        this.deleteResources((IContainer)copy, new String[]{"folder1/b.txt"}, false);
        this.commitProject(copy);
        int[] nArray = new int[7];
        nArray[2] = 11;
        nArray[3] = 10;
        nArray[4] = 9;
        nArray[5] = 9;
        nArray[6] = 9;
        this.assertSyncEquals("testIncomingChanges", project, new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt", "folder2/", "folder2/folder3/", "folder2/folder3/add.txt"}, true, nArray);
        this.update((IContainer)project, new String[]{"folder1/a.txt", "folder1/b.txt", "folder2/", "folder2/folder3/", "folder2/folder3/add.txt"});
        this.assertSyncEquals("testIncomingChanges", project, new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder2/", "folder2/folder3/", "folder2/folder3/add.txt"}, true, new int[6]);
        this.assertDeleted("testIncomingChanges", (IContainer)project, new String[]{"folder1/b.txt"});
        this.assertEquals(project, copy);
    }

    public void testOutgoingChanges() throws TeamException, CoreException {
        IProject project = this.createProject("testOutgoingChanges", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        this.setContentsAndEnsureModified(project.getFile("folder1/a.txt"));
        this.addResources((IContainer)project, new String[]{"folder2/folder3/add.txt"}, false);
        this.deleteResources((IContainer)project, new String[]{"folder1/b.txt"}, false);
        int[] nArray = new int[7];
        nArray[2] = 7;
        nArray[3] = 6;
        nArray[6] = 5;
        this.assertSyncEquals("testOutgoingChanges", project, new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt", "folder2/", "folder2/folder3/", "folder2/folder3/add.txt"}, true, nArray);
        this.commit((IContainer)project, new String[]{"folder1/a.txt", "folder1/b.txt", "folder2/folder3/add.txt"});
        this.assertSyncEquals("testOutgoingChanges", project, new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder2/", "folder2/folder3/", "folder2/folder3/add.txt"}, true, new int[6]);
        this.assertDeleted("testOutgoingChanges", (IContainer)project, new String[]{"folder1/b.txt"});
    }

    public void testOverideAndUpdateSimple() throws CVSException, CoreException, IOException {
        IProject project = this.createProject("testOutgoingChangesOverideAndUpdate", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        this.setContentsAndEnsureModified(project.getFile("folder1/a.txt"));
        this.addResources((IContainer)project, new String[]{"folder2/folder3/add.txt"}, false);
        this.deleteResources((IContainer)project, new String[]{"folder1/b.txt"}, false);
        int[] nArray = new int[7];
        nArray[2] = 7;
        nArray[3] = 6;
        nArray[6] = 5;
        this.assertSyncEquals("testOutgoingChangesOverwrite", project, new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt", "folder2/", "folder2/folder3/", "folder2/folder3/add.txt"}, true, nArray);
        this.overrideAndUpdate((IContainer)project, new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt", "folder2/", "folder2/folder3/", "folder2/folder3/add.txt"}, true);
        this.assertSyncEquals("testOutgoingChangesOverwrite", project, new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder2/", "folder2/folder3/", "folder2/folder3/add.txt"}, true, new int[6]);
        this.assertExistsInWorkspace("testOutgoingChangesOverwrite", (IResource)project.getFile((IPath)new Path("folder1/b.txt")));
        IProject copy = this.checkoutCopy(project, "-copy");
        this.appendText((IResource)copy.getFile("file1.txt"), "prefix" + eol, true);
        this.setContentsAndEnsureModified(copy.getFile("folder1/a.txt"), "Use a custom string to avoid intermittent errors!");
        this.commitProject(copy);
        this.appendText((IResource)project.getFile("file1.txt"), String.valueOf(eol) + "postfix", false);
        this.setContentsAndEnsureModified(project.getFile("folder1/a.txt"));
        int[] nArray2 = new int[3];
        nArray2[0] = 15;
        nArray2[2] = 15;
        this.assertSyncEquals("testFileConflict", project, new String[]{"file1.txt", "folder1/", "folder1/a.txt"}, true, nArray2);
        this.overrideAndUpdate((IContainer)project, new String[]{"file1.txt", "folder1/", "folder1/a.txt"}, true);
        this.assertSyncEquals("testFileConflict", project, new String[]{"file1.txt", "folder1/", "folder1/a.txt"}, true, new int[3]);
    }

    public void testOverrideOutgoingChanges() throws IOException, TeamException, CoreException {
        IProject project = this.createProject("testOverrideOutgoingChanges", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        IProject original = this.checkoutCopy(project, "-copy");
        this.setContentsAndEnsureModified(project.getFile("folder1/a.txt"));
        this.addResources((IContainer)project, new String[]{"folder2/folder3/add.txt"}, false);
        this.deleteResources((IContainer)project, new String[]{"folder1/b.txt"}, false);
        int[] nArray = new int[7];
        nArray[2] = 7;
        nArray[3] = 6;
        nArray[6] = 5;
        this.assertSyncEquals("testOverrideOutgoingChanges", project, new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt", "folder2/", "folder2/folder3/", "folder2/folder3/add.txt"}, true, nArray);
        this.overrideAndUpdate((IContainer)project, new String[]{"folder1/a.txt", "folder1/b.txt", "folder2/folder3/add.txt"}, true);
        this.assertDeleted("testOverrideOutgoingChanges", (IContainer)project, new String[]{"folder2/", "folder2/folder3/", "folder2/folder3/add.txt"});
        this.assertSyncEquals("testOverrideOutgoingChanges", project, new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt", "folder2/"}, true, new int[5]);
        this.assertEquals(project, original);
    }

    public void testOutgoingQuestionables() throws TeamException, CoreException {
        IProject project = this.createProject("testIncomingChanges", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        this.buildResources((IContainer)project, new String[]{"folder2/folder3/add.txt"}, false);
        IFile file = project.getFile("folder1/b.txt");
        file.delete(true, DEFAULT_MONITOR);
        int[] nArray = new int[7];
        nArray[3] = 6;
        nArray[4] = 5;
        nArray[5] = 5;
        nArray[6] = 5;
        this.assertSyncEquals("testOutgoingQuestionables", project, new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt", "folder2/", "folder2/folder3/", "folder2/folder3/add.txt"}, true, nArray);
        this.commit((IContainer)project, new String[]{"folder1/b.txt", "folder2/", "folder2/folder3/", "folder2/folder3/add.txt"});
        this.assertSyncEquals("testOutgoingQuestionables", project, new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder2/", "folder2/folder3/", "folder2/folder3/add.txt"}, true, new int[6]);
        this.assertDeleted("testOutgoingQuestionables", (IContainer)project, new String[]{"folder1/b.txt"});
    }

    public void testFileConflict() throws IOException, TeamException, CoreException {
        IProject project = this.createProject("testFileConflict", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        this.setContentsAndEnsureModified(project.getFile("file1.txt"), "Use a custom string" + eol + " to ensure proper merging");
        this.commitProject(project);
        IProject copy = this.checkoutCopy(project, "-copy");
        this.appendText((IResource)copy.getFile("file1.txt"), "prefix" + eol, true);
        this.setContentsAndEnsureModified(copy.getFile("folder1/a.txt"), "Use a custom string to avoid intermittent errors!");
        this.commitProject(copy);
        this.appendText((IResource)project.getFile("file1.txt"), String.valueOf(eol) + "postfix", false);
        this.setContentsAndEnsureModified(project.getFile("folder1/a.txt"));
        int[] nArray = new int[3];
        nArray[0] = 15;
        nArray[2] = 15;
        this.assertSyncEquals("testFileConflict", project, new String[]{"file1.txt", "folder1/", "folder1/a.txt"}, true, nArray);
        this.update((IContainer)project, new String[]{"file1.txt"});
        int[] nArray2 = new int[3];
        nArray2[0] = 7;
        nArray2[2] = 15;
        this.assertSyncEquals("testFileConflict", project, new String[]{"file1.txt", "folder1/", "folder1/a.txt"}, true, nArray2);
        this.overrideAndCommit((IContainer)project, new String[]{"folder1/a.txt"}, true);
        this.commit((IContainer)project, new String[]{"file1.txt"});
        this.assertSyncEquals("testFileConflict", project, new String[]{"file1.txt", "folder1/", "folder1/a.txt"}, true, new int[3]);
    }

    public void testAdditionConflicts() throws CoreException {
        IProject project = this.createProject("testAdditionConflicts", new String[]{"file.txt"});
        this.addResources((IContainer)project, new String[]{"add1a.txt", "add1b.txt"}, false);
        this.addResources((IContainer)project, new String[]{"add3.txt"}, false);
        this.buildResources((IContainer)project, new String[]{"add2a.txt", "add2b.txt"}, false);
        IProject copy = this.checkoutCopy(project, "-copy");
        this.addResources((IContainer)copy, new String[]{"add1a.txt", "add1b.txt", "add2a.txt", "add2b.txt", "add3.txt"}, true);
        this.deleteResources((IContainer)copy, new String[]{"add3.txt"}, true);
        int[] nArray = new int[6];
        nArray[1] = 13;
        nArray[2] = 13;
        nArray[3] = 13;
        nArray[4] = 13;
        nArray[5] = 5;
        this.assertSyncEquals("testAdditionConflicts", project, new String[]{"file.txt", "add1a.txt", "add1b.txt", "add2a.txt", "add2b.txt", "add3.txt"}, true, nArray);
        this.overrideAndCommit((IContainer)project, new String[]{"add1b.txt", "add2b.txt"}, true);
        this.commit((IContainer)project, new String[]{"add3.txt"});
        this.assertSyncEquals("testAdditionConflicts", project, new String[]{"file.txt", "add1b.txt", "add2b.txt", "add3.txt"}, true, new int[4]);
        this.overrideAndUpdate((IContainer)project, new String[]{"add1a.txt", "add2a.txt"}, true);
        this.assertSyncEquals("testAdditionConflicts", project, new String[]{"add1a.txt", "add2a.txt"}, true, new int[2]);
    }

    public void testDeletionConflicts() throws CoreException {
        IProject project = this.createProject("testDeletionConflictsA", new String[]{"delete1.txt", "delete2.txt", "delete3.txt", "delete4.txt", "delete5.txt"});
        IFile file = project.getFile("delete1.txt");
        file.delete(false, DEFAULT_MONITOR);
        this.deleteResources((IContainer)project, new String[]{"delete2.txt"}, false);
        this.setContentsAndEnsureModified(project.getFile("delete3.txt"));
        file = project.getFile("delete4.txt");
        file.delete(false, DEFAULT_MONITOR);
        this.deleteResources((IContainer)project, new String[]{"delete5.txt"}, false);
        this.assertSyncEquals("testDeletionConflicts", project, new String[]{"delete1.txt", "delete2.txt", "delete3.txt", "delete4.txt", "delete5.txt"}, true, new int[]{6, 6, 7, 6, 6});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.setContentsAndEnsureModified(copy.getFile("delete1.txt"));
        this.setContentsAndEnsureModified(copy.getFile("delete2.txt"));
        this.deleteResources((IContainer)copy, new String[]{"delete3.txt", "delete4.txt", "delete5.txt"}, false);
        this.commitProject(copy);
        int[] nArray = new int[5];
        nArray[0] = 15;
        nArray[1] = 15;
        nArray[2] = 15;
        this.assertSyncEquals("testDeletionConflictsA", project, new String[]{"delete1.txt", "delete2.txt", "delete3.txt", "delete4.txt", "delete5.txt"}, true, nArray);
        this.overrideAndUpdate((IContainer)project, new String[]{"delete1.txt", "delete2.txt", "delete3.txt", "delete4.txt", "delete5.txt"}, true);
        this.assertSyncEquals("testDeletionConflictsA", project, new String[]{"delete1.txt", "delete2.txt"}, true, new int[2]);
        this.assertDeleted("testDeletionConflictsA", (IContainer)project, new String[]{"delete3.txt", "delete4.txt", "delete5.txt"});
        project = this.createProject("testDeletionConflictsB", new String[]{"delete1.txt", "delete2.txt", "delete3.txt", "delete4.txt", "delete5.txt"});
        file = project.getFile("delete1.txt");
        file.delete(false, DEFAULT_MONITOR);
        this.deleteResources((IContainer)project, new String[]{"delete2.txt"}, false);
        this.setContentsAndEnsureModified(project.getFile("delete3.txt"));
        file = project.getFile("delete4.txt");
        file.delete(false, DEFAULT_MONITOR);
        this.deleteResources((IContainer)project, new String[]{"delete5.txt"}, false);
        copy = this.checkoutCopy(project, "-copy");
        this.setContentsAndEnsureModified(copy.getFile("delete1.txt"));
        this.setContentsAndEnsureModified(copy.getFile("delete2.txt"));
        this.deleteResources((IContainer)copy, new String[]{"delete3.txt", "delete4.txt", "delete5.txt"}, false);
        this.commitProject(copy);
        int[] nArray2 = new int[5];
        nArray2[0] = 15;
        nArray2[1] = 15;
        nArray2[2] = 15;
        this.assertSyncEquals("testDeletionConflictsB", project, new String[]{"delete1.txt", "delete2.txt", "delete3.txt", "delete4.txt", "delete5.txt"}, true, nArray2);
        this.overrideAndCommit((IContainer)project, new String[]{"delete1.txt", "delete2.txt", "delete3.txt"}, true);
        this.commit((IContainer)project, new String[]{"delete4.txt", "delete5.txt"});
        this.assertSyncEquals("testDeletionConflictsB", project, new String[]{"delete3.txt"}, true, new int[1]);
        this.assertDeleted("testDeletionConflictsB", (IContainer)project, new String[]{"delete1.txt", "delete2.txt", "delete4.txt", "delete5.txt"});
    }

    public void testSyncOnEmptyProject() throws TeamException, CoreException {
        IProject project = this.createProject(new String[]{"file1.txt", "folder1/file2.txt"});
        IProject newProject = this.getUniqueTestProject("empty-" + this.getName());
        FolderSyncInfo info = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project).getFolderSyncInfo();
        CVSWorkspaceRoot.getCVSFolderFor((IContainer)newProject).setFolderSyncInfo(info);
        RepositoryProvider.map((IProject)newProject, (String)CVSProviderPlugin.getTypeId());
        this.assertSyncEquals(newProject, new String[]{"file1.txt", "folder1/", "folder1/file2.txt"}, true, new int[]{9, 9, 9});
    }

    public void testFolderConflict() throws CoreException {
        IProject project = this.createProject("testFolderConflict", new String[]{"file.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.addResources((IContainer)copy, new String[]{"folder1/file.txt", "folder2/file.txt"}, true);
        IResource[] resources = this.buildResources((IContainer)project, new String[]{"folder1/"});
        ((IFolder)resources[0]).create(false, true, DEFAULT_MONITOR);
        int[] nArray = new int[5];
        nArray[1] = 13;
        nArray[2] = 9;
        nArray[3] = 9;
        nArray[4] = 9;
        this.assertSyncEquals("testFolderConflict", project, new String[]{"file.txt", "folder1/", "folder1/file.txt", "folder2/", "folder2/file.txt"}, true, nArray);
        this.update((IContainer)project, new String[]{"folder1/"});
        int[] nArray2 = new int[5];
        nArray2[2] = 9;
        nArray2[3] = 9;
        nArray2[4] = 9;
        this.assertSyncEquals("testFolderConflict", project, new String[]{"file.txt", "folder1/", "folder1/file.txt", "folder2/", "folder2/file.txt"}, true, nArray2);
    }

    public void testOutgoingDeletion() throws TeamException, CoreException {
        IProject project = this.createProject("testOutgoingDeletion", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        IFile file = project.getFile("folder1/b.txt");
        file.delete(true, DEFAULT_MONITOR);
        int[] nArray = new int[4];
        nArray[3] = 6;
        this.assertSyncEquals("testOutgoingDeletion", project, new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"}, true, nArray);
        this.commit((IContainer)project, new String[]{"folder1/b.txt"});
        this.assertSyncEquals("testOutgoingDeletion", project, new String[]{"file1.txt", "folder1/", "folder1/a.txt"}, true, new int[3]);
        this.assertDeleted("testOutgoingDeletion", (IContainer)project, new String[]{"folder1/b.txt"});
    }

    public void testIncomingAddition() throws CoreException {
        IProject project = this.createProject("testIncomingAddition", new String[]{"file1.txt", "folder1/", "folder1/a.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.addResources((IContainer)copy, new String[]{"folder1/add.txt"}, true);
        int[] nArray = new int[4];
        nArray[3] = 9;
        this.assertSyncEquals("testIncomingAddition", project, new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/add.txt"}, true, nArray);
        this.update((IContainer)project, new String[]{"folder1/add.txt"});
        this.assertSyncEquals("testIncomingAddition", project, new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/add.txt"}, true, new int[4]);
    }

    public void testSyncOnBranch() throws CoreException {
        IProject project = this.createProject(new String[]{"file1.txt", "file2.txt", "file3.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        CVSTag branch = new CVSTag("branch1", 1);
        this.tagProject(project, branch, false);
        this.updateProject(project, branch, false);
        IProject copy = this.checkoutCopy(project, branch);
        this.addResources((IContainer)copy, new String[]{"addition.txt", "folderAddition/", "folderAddition/new.txt"}, true);
        this.deleteResources((IContainer)copy, new String[]{"folder1/b.txt"}, true);
        this.changeResources((IContainer)copy, new String[]{"file1.txt", "file2.txt"}, true);
        int[] nArray = new int[9];
        nArray[0] = 11;
        nArray[1] = 11;
        nArray[5] = 10;
        nArray[6] = 9;
        nArray[7] = 9;
        nArray[8] = 9;
        this.assertSyncEquals(project, new String[]{"file1.txt", "file2.txt", "file3.txt", "folder1/", "folder1/a.txt", "folder1/b.txt", "addition.txt", "folderAddition/", "folderAddition/new.txt"}, true, nArray);
    }

    public void testRenameProject() throws CoreException {
        String[] resourceNames = new String[]{"changed.txt", "folder1/", "folder1/a.txt"};
        int[] inSync = new int[3];
        IProject project = this.createProject("testRenameProject", new String[]{"changed.txt", "folder1/", "folder1/a.txt"});
        this.assertSyncEquals("sync should be in sync", project, resourceNames, true, inSync);
        IProjectDescription desc = project.getDescription();
        String newName = String.valueOf(project.getName()) + "_renamed";
        desc.setName(newName);
        project.move(desc, false, null);
        project = ResourcesPlugin.getWorkspace().getRoot().getProject(newName);
        CVSWorkspaceSubscriberTest.assertTrue((boolean)project.exists());
        this.assertSyncEquals("sync should be in sync", project, resourceNames, true, inSync);
    }

    public void testDeleteProject() throws CoreException {
        String[] resourceNames = new String[]{"deleted.txt", "file1.txt", "folder1/", "folder1/a.txt"};
        int[] inSync = new int[4];
        IProject project = this.createProject("testDeleteProject", resourceNames);
        this.assertSyncEquals("sync should be in sync", project, resourceNames, true, inSync);
        this.setContentsAndEnsureModified(project.getFile("folder1/a.txt"));
        this.addResources((IContainer)project, new String[]{"folder2/folder3/add.txt"}, false);
        this.deleteResources((IContainer)project, new String[]{"deleted.txt"}, false);
        int[] nArray = new int[7];
        nArray[2] = 6;
        nArray[3] = 7;
        nArray[6] = 5;
        this.assertSyncEquals("testOutgoingChanges", project, new String[]{"file1.txt", "folder1/", "deleted.txt", "folder1/a.txt", "folder2/", "folder2/folder3/", "folder2/folder3/add.txt"}, true, nArray);
        project.delete(true, false, DEFAULT_MONITOR);
        this.assertProjectRemoved(this.getWorkspaceSubscriber(), project);
    }

    public void testFolderDeletion() throws TeamException, CoreException {
        IProject project = this.createProject("testFolderDeletion", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/folder2/file.txt"});
        project.getFolder("folder1").delete(false, false, null);
        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project.getFolder("folder1"));
        CVSWorkspaceSubscriberTest.assertTrue((String)"Deleted folder not in proper state", (!folder.exists() && folder.isManaged() && folder.isCVSFolder() ? 1 : 0) != 0);
        int[] nArray = new int[4];
        nArray[1] = 6;
        nArray[3] = 6;
        this.assertSyncEquals("testFolderDeletion sync check", project, new String[]{"folder1/", "folder1/a.txt", "folder1/folder2/", "folder1/folder2/file.txt"}, true, nArray);
        this.commit((IContainer)project, new String[]{"folder1/a.txt"});
        int[] nArray2 = new int[3];
        nArray2[2] = 6;
        this.assertSyncEquals("testFolderDeletion sync check", project, new String[]{"folder1/", "folder1/folder2/", "folder1/folder2/file.txt"}, true, nArray2);
        this.assertDeleted("testFolderDeletion", (IContainer)project, new String[]{"folder1/a.txt"});
        this.commit((IContainer)project, new String[]{"folder1/folder2/file.txt"});
        this.assertDeleted("testFolderDeletion", (IContainer)project, new String[]{"folder1/", "folder1/folder2/", "folder1/folder2/file.txt"});
    }

    public void testTagRetrievalForFolderWithNoFile() throws TeamException, CoreException {
        IProject project = this.createProject("testTagRetrievalForFolderWithNoFile", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        CVSTag version = new CVSTag("v1", 1);
        CVSTag branch = new CVSTag("branch1", 1);
        this.makeBranch(new IResource[]{copy}, version, branch, true);
        this.addResources((IContainer)copy, new String[]{"folder2/folder3/a.txt"}, true);
        this.refresh((Subscriber)this.getSubscriber(), (IResource)project);
    }

    public void testIgnoredResource() throws CoreException, TeamException {
        IProject project = this.createProject("testIgnoredResource", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        this.buildResources((IContainer)project, new String[]{"ignored.txt"}, false);
        this.assertSyncEquals("testIgnoredResource", project, new String[]{"ignored.txt"}, true, new int[]{5});
        IFile ignores = project.getFile(".cvsignore");
        ignores.create((InputStream)new ByteArrayInputStream("ignored.txt".getBytes()), false, DEFAULT_MONITOR);
        this.addResources(new IResource[]{ignores});
        int[] nArray = new int[2];
        nArray[1] = 5;
        this.assertSyncEquals("testIgnoredResource", project, new String[]{"ignored.txt", ".cvsignore"}, true, nArray);
    }

    public void testRenameUnshared() throws CoreException, TeamException {
        IProject project = this.createProject("testRenameUnshared", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        this.buildResources((IContainer)project, new String[]{"oldName.txt"}, false);
        this.assertSyncEquals("testRenameUnshared", project, new String[]{"oldName.txt"}, true, new int[]{5});
        IFile rename = project.getFile("oldName.txt");
        rename.move((IPath)new Path("newName.txt"), false, false, DEFAULT_MONITOR);
        this.assertDeleted("testRenameUnshared", (IContainer)project, new String[]{"oldName.txt"});
        this.assertSyncEquals("testRenameUnshared", project, new String[]{"newName.txt"}, true, new int[]{5});
    }

    public void testOutgoingEmptyFolder() throws CoreException, TeamException {
        IProject project = this.createProject("testOutgoingEmptyFolder", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        this.buildResources((IContainer)project, new String[]{"folder2/"}, false);
        this.assertSyncEquals("testOutgoingEmptyFolder", project, new String[]{"folder2/"}, true, new int[]{5});
        this.commit((IContainer)project, new String[]{"folder2"});
        this.assertSyncEquals("testOutgoingEmptyFolder", project, new String[]{"folder2/"}, true, new int[1]);
        CVSWorkspaceSubscriberTest.assertTrue((String)"Folder should still exist", (boolean)project.getFolder("folder2").exists());
    }

    public void testDisconnectingProject() throws CoreException {
        IProject project = this.createProject("testDisconnect", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        RepositoryProvider.unmap((IProject)project);
        this.assertProjectRemoved(this.getWorkspaceSubscriber(), project);
    }

    public void testConflictingFolderDeletion() throws CoreException {
        IProject project = this.createProject("testConflictingFolderDeletion", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.deleteResources((IContainer)project, new String[]{"folder1/"}, false);
        this.deleteResources((IContainer)copy, new String[]{"folder1/"}, true);
        this.assertSyncEquals("testConflictingFolderDeletion sync check", project, new String[]{"folder1/", "folder1/a.txt", "folder1/b.txt"}, true, new int[3]);
    }

    public void testOverrideAndUpdateOutgoingAddition() throws TeamException, CoreException {
        IProject project = this.createProject(new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        IFolder newFolder = project.getFolder("newFolder");
        newFolder.create(false, true, null);
        this.buildResources((IContainer)newFolder, new String[]{"newFile"}, false);
        this.overrideAndUpdate((IContainer)project, new String[]{"newFolder", "newFolder/newFile"}, true);
        this.assertDoesNotExistInFileSystem((IResource)newFolder);
    }

    public void testProjectClose() throws TeamException, CoreException {
        IProject project = this.createProject(new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        this.setContentsAndEnsureModified(project.getFile("file1.txt"));
        this.assertSyncEquals("testProjectClose sync check", project, new String[]{"file1.txt"}, true, new int[]{7});
        project.close(null);
        this.assertProjectRemoved(this.getWorkspaceSubscriber(), project);
    }

    public void testUpdateBinaryConflict() throws CoreException {
        IProject project = this.createProject(new String[]{"binary.gif"});
        this.assertIsBinary(project.getFile("binary.gif"));
        IProject copy = this.checkoutCopy(project, "-copy");
        this.assertIsBinary(copy.getFile("binary.gif"));
        this.setContentsAndEnsureModified(copy.getFile("binary.gif"));
        this.commitProject(copy);
        this.setContentsAndEnsureModified(project.getFile("binary.gif"));
        this.assertSyncEquals("testProjectClose sync check", project, new String[]{"binary.gif"}, true, new int[]{15});
        this.update((IContainer)project, new String[]{"binary.gif"});
        this.assertSyncEquals("testProjectClose sync check", project, new String[]{"binary.gif"}, true, new int[]{15});
    }

    public void testNestedMarkAsMerged() throws CoreException, InvocationTargetException, InterruptedException {
        if (Util.isMac()) {
            return;
        }
        IProject project = this.createProject(new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.buildResources((IContainer)project, new String[]{"folder2/", "folder2/file.txt", "folder2/file2.txt"}, false);
        this.addResources((IContainer)copy, new String[]{"folder2/", "folder2/file.txt", "folder2/file2.txt"}, true);
        this.assertSyncEquals("testNestedMarkAsMerged sync check", project, new String[]{"folder2/", "folder2/file.txt", "folder2/file.txt"}, true, new int[]{13, 13, 13});
        this.markAsMerged(this.getSubscriber(), project, new String[]{"folder2/file.txt"});
        int[] nArray = new int[3];
        nArray[1] = 7;
        nArray[2] = 13;
        this.assertSyncEquals("testNestedMarkAsMerged sync check", project, new String[]{"folder2/", "folder2/file.txt", "folder2/file2.txt"}, true, nArray);
    }

    public void testMarkAsMergedOnBinaryFile() throws TeamException, CoreException, InvocationTargetException, InterruptedException {
        if (Util.isMac()) {
            return;
        }
        IProject project = this.createProject(new String[]{"file1.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.buildResources((IContainer)project, new String[]{"binary.gif"}, false);
        this.addResources((IContainer)copy, new String[]{"binary.gif"}, true);
        this.assertIsBinary(copy.getFile("binary.gif"));
        this.assertSyncEquals("testMarkAsMergedOnBinaryFile sync check", project, new String[]{"binary.gif"}, true, new int[]{13});
        this.markAsMerged(this.getSubscriber(), project, new String[]{"binary.gif"});
        this.assertSyncEquals("testMarkAsMergedOnBinaryFile sync check", project, new String[]{"binary.gif"}, true, new int[]{7});
        this.assertIsBinary(project.getFile("binary.gif"));
        CVSWorkspaceRoot.getCVSFileFor((IFile)project.getFile("binary.gif")).unmanage(DEFAULT_MONITOR);
        this.assertSyncEquals("testMarkAsMergedOnBinaryFile sync check", project, new String[]{"binary.gif"}, true, new int[]{13});
        this.markAsMerged(this.getSubscriber(), project, new String[]{"binary.gif"});
        this.assertSyncEquals("testMarkAsMergedOnBinaryFile sync check", project, new String[]{"binary.gif"}, true, new int[]{7});
        this.assertIsBinary(project.getFile("binary.gif"));
    }

    public void testSyncAfterImport() throws CoreException {
        String[] resources = new String[]{"file.txt"};
        IProject project = this.getUniqueTestProject(this.getName());
        this.buildResources((IContainer)project, resources, true);
        this.importProject(project);
        IProject copy = CVSWorkspaceSubscriberTest.getWorkspace().getRoot().getProject(String.valueOf(project.getName()) + "copy");
        CVSWorkspaceSubscriberTest.checkout((ICVSRepositoryLocation)this.getRepository(), copy, project.getName(), null, DEFAULT_MONITOR);
        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)copy.getFile("file.txt"));
        CVSWorkspaceSubscriberTest.assertTrue((String)"File in wrong state", (cvsFile.isManaged() && cvsFile.getSyncInfo().getRevision().equals("1.1.1.1") ? 1 : 0) != 0);
        IProject anotherCopy = this.checkoutCopy(copy, "another");
        cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)anotherCopy.getFile("file.txt"));
        CVSWorkspaceSubscriberTest.assertTrue((String)"File in wrong state", (cvsFile.isManaged() && cvsFile.getSyncInfo().getRevision().equals("1.1.1.1") ? 1 : 0) != 0);
        this.setContentsAndEnsureModified(anotherCopy.getFile("file.txt"));
        this.commitProject(anotherCopy);
        this.assertSyncEquals("testSyncAfterImport sync check", copy, new String[]{"file.txt"}, true, new int[]{11});
    }

    public void testOverUpdateAfterExternalDeletion() throws TeamException, CoreException {
        IProject project = this.createProject(new String[]{"file1.txt"});
        int count = 0;
        while (!project.getFile("file1.txt").getLocation().toFile().delete()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            CVSWorkspaceSubscriberTest.assertTrue((count++ < 5 ? 1 : 0) != 0);
        }
        project.refreshLocal(2, DEFAULT_MONITOR);
        this.assertSyncEquals("testOverUpdateAfterExternalDeletion sync check", project, new String[]{"file1.txt"}, true, new int[]{6});
        this.overrideAndUpdate((IContainer)project, new String[]{"file1.txt"}, true);
        this.assertSyncEquals("testOverUpdateAfterExternalDeletion sync check", project, new String[]{"file1.txt"}, true, new int[1]);
        CVSWorkspaceSubscriberTest.assertTrue((boolean)project.getFile("file1.txt").exists());
    }

    public void testBinaryAddition() throws CoreException {
        Command.KSubstOption option = CVSProviderPlugin.getPlugin().getDefaultTextKSubstOption();
        try {
            CVSProviderPlugin.getPlugin().setDefaultTextKSubstOption(Command.KSUBST_TEXT_KEYWORDS_ONLY);
            IProject project = this.createProject(new String[]{"a.txt"});
            IProject copy = this.checkoutCopy(project, "-copy");
            this.create((IResource)copy.getFile("binaryFile"), true);
            this.setContentsAndEnsureModified(copy.getFile("binaryFile"), "/n/n\n\n");
            this.addResources(new IResource[]{copy.getFile("binaryFile")});
            this.commitProject(copy);
            this.getSyncInfoSource().refresh((Subscriber)this.getSubscriber(), (IResource)project);
            this.getSyncInfoSource().updateResources((Subscriber)this.getSubscriber(), new IResource[]{project.getFile("binaryFile")});
            this.assertContentsEqual(copy.getFile("binaryFile"), project.getFile("binaryFile"));
        }
        finally {
            CVSProviderPlugin.getPlugin().setDefaultTextKSubstOption(option);
        }
    }

    public void testBinaryMarkAsMerged() throws CoreException, InvocationTargetException, InterruptedException {
        Command.KSubstOption option = CVSProviderPlugin.getPlugin().getDefaultTextKSubstOption();
        try {
            CVSProviderPlugin.getPlugin().setDefaultTextKSubstOption(Command.KSUBST_TEXT_KEYWORDS_ONLY);
            IProject project = this.createProject(new String[]{"a.txt"});
            IProject copy = this.checkoutCopy(project, "-copy");
            this.create((IResource)copy.getFile("binaryFile"), true);
            this.setContentsAndEnsureModified(copy.getFile("binaryFile"), "/n/n\n\n");
            this.addResources(new IResource[]{copy.getFile("binaryFile")});
            this.commitProject(copy);
            this.create((IResource)project.getFile("binaryFile"), true);
            this.setContentsAndEnsureModified(project.getFile("binaryFile"), "/n/nSome Content\n\n");
            this.getSyncInfoSource().refresh((Subscriber)this.getSubscriber(), (IResource)project);
            this.getSyncInfoSource().markAsMerged((Subscriber)this.getSubscriber(), new IResource[]{project.getFile("binaryFile")});
            this.assertIsBinary(project.getFile("binaryFile"));
        }
        finally {
            CVSProviderPlugin.getPlugin().setDefaultTextKSubstOption(option);
        }
    }

    public void testDisabledDirectoryDiscovery() throws CoreException {
        IProject project = this.createProject(new String[]{"file1.txt"});
        this.setFetchAbsentDirectories(project, false);
        IProject copy = this.checkoutCopy(project, "-copy");
        this.addResources((IContainer)copy, new String[]{"added.txt", "folder2/", "folder2/added.txt"}, true);
        int[] nArray = new int[4];
        nArray[1] = 9;
        this.assertSyncEquals("testDisabledDirectoryDiscovery", project, new String[]{"file1.txt", "added.txt", "folder2/", "folder2/added.txt"}, true, nArray);
    }

    private void setFetchAbsentDirectories(IProject project, boolean fetch) throws CVSException {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId());
        ((CVSTeamProvider)provider).setFetchAbsentDirectories(fetch);
    }
}

