/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteCompareOperation;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.ui.CVSOperationTest;
import org.eclipse.ui.IWorkbenchPart;

public class CompareOperationTests
extends CVSOperationTest {
    public CompareOperationTests() {
    }

    public CompareOperationTests(String name) {
        super(name);
    }

    public static Test suite() {
        String testName = System.getProperty("eclipse.cvs.testName");
        if (testName == null) {
            TestSuite suite = new TestSuite(CompareOperationTests.class);
            return new CVSTestSetup((Test)suite);
        }
        return new CVSTestSetup((Test)new CompareOperationTests(testName));
    }

    private void assertRevisionsMatch(ICVSRemoteFolder folder, IProject project, String[] filePathsWithRevisions, String[] filePathsWithoutRevisions) throws CoreException {
        if (filePathsWithRevisions == null) {
            filePathsWithRevisions = new String[]{};
        }
        if (filePathsWithoutRevisions == null) {
            filePathsWithoutRevisions = new String[]{};
        }
        IResource[] filesWithRevisions = this.getResources((IContainer)project, filePathsWithRevisions);
        IResource[] filesWithoutRevisions = this.getResources((IContainer)project, filePathsWithoutRevisions);
        ICVSRemoteFile[] files = this.getAllFiles(folder);
        CompareOperationTests.assertTrue((String)"The number of remote files with differences does not match the expected number", (files.length == filePathsWithoutRevisions.length + filePathsWithRevisions.length ? 1 : 0) != 0);
        int i = 0;
        while (i < files.length) {
            String localRevision;
            ResourceSyncInfo info;
            ICVSFile cvsFile;
            IResource local;
            ICVSRemoteFile remoteFile = files[i];
            int j = 0;
            while (j < filesWithRevisions.length) {
                local = filesWithRevisions[j];
                cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)local));
                if (cvsFile.getRepositoryRelativePath().equals(remoteFile.getRepositoryRelativePath())) {
                    info = cvsFile.getSyncInfo();
                    CompareOperationTests.assertNotNull((Object)info);
                    localRevision = info.getRevision();
                    CompareOperationTests.assertNotNull((Object)localRevision);
                    String remoteRevision = files[i].getRevision();
                    CompareOperationTests.assertNotNull((Object)remoteRevision);
                    CompareOperationTests.assertEquals((String)("Revisions do not match for " + local.getProjectRelativePath()), (String)localRevision, (String)remoteRevision);
                }
                ++j;
            }
            j = 0;
            while (j < filesWithoutRevisions.length) {
                local = filesWithoutRevisions[j];
                cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)local));
                if (cvsFile.getRepositoryRelativePath().equals(remoteFile.getRepositoryRelativePath())) {
                    info = cvsFile.getSyncInfo();
                    CompareOperationTests.assertNotNull((Object)info);
                    localRevision = info.getRevision();
                    CompareOperationTests.assertNotNull((Object)localRevision);
                }
                ++j;
            }
            ++i;
        }
    }

    private ICVSRemoteFile[] getAllFiles(ICVSRemoteFolder folder) {
        ArrayList<Object> result = new ArrayList<Object>();
        ICVSRemoteResource[] children = ((RemoteFolder)folder).getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                ICVSRemoteResource resource = children[i];
                if (resource.isContainer()) {
                    result.addAll(Arrays.asList(this.getAllFiles((ICVSRemoteFolder)resource)));
                } else {
                    result.add(resource);
                }
                ++i;
            }
        }
        return result.toArray(new ICVSRemoteFile[result.size()]);
    }

    public void testCompareWithLatest() throws TeamException, CoreException {
        IProject project = this.createProject(new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        CVSTag v1 = new CVSTag("v1", 2);
        this.tagProject(project, v1, false);
        IProject copy = this.checkoutCopy(project, "-copy");
        this.setContentsAndEnsureModified(copy.getFile("folder1/a.txt"));
        this.addResources((IContainer)copy, new String[]{"folder1/newFile", "folder2/folder3/add.txt"}, false);
        this.deleteResources((IContainer)copy, new String[]{"folder1/b.txt"}, false);
        this.commitResources(new IResource[]{copy}, 2);
        ICVSRemoteResource remoteResource = CVSWorkspaceRoot.getRemoteResourceFor((IResource)project);
        TestRemoteCompareOperation op = new TestRemoteCompareOperation(null, remoteResource, v1);
        this.run((CVSOperation)op);
        this.assertRevisionsMatch(op.getRightTree(), project, new String[]{"folder1/a.txt", "folder1/b.txt"}, null);
        this.assertRevisionsMatch(op.getLeftTree(), copy, new String[]{"folder1/a.txt"}, new String[]{"folder1/newFile", "folder2/folder3/add.txt"});
        remoteResource = CVSWorkspaceRoot.getRemoteResourceFor((IResource)project);
        remoteResource = ((ICVSRemoteFolder)remoteResource).forTag(v1);
        op = new TestRemoteCompareOperation(null, remoteResource, CVSTag.DEFAULT);
        this.run((CVSOperation)op);
        this.assertRevisionsMatch(op.getLeftTree(), project, new String[]{"folder1/a.txt"}, new String[]{"folder1/b.txt"});
        this.assertRevisionsMatch(op.getRightTree(), copy, new String[]{"folder1/a.txt", "folder1/newFile", "folder2/folder3/add.txt"}, null);
        remoteResource = CVSWorkspaceRoot.getRemoteResourceFor((IResource)project.getFolder("folder1"));
        op = new TestRemoteCompareOperation(null, remoteResource, v1);
        this.run((CVSOperation)op);
        this.assertRevisionsMatch(op.getRightTree(), project, new String[]{"folder1/a.txt", "folder1/b.txt"}, null);
        this.assertRevisionsMatch(op.getLeftTree(), copy, new String[]{"folder1/a.txt"}, new String[]{"folder1/newFile"});
        remoteResource = CVSWorkspaceRoot.getRemoteResourceFor((IResource)copy.getFile("folder1/a.txt"));
        op = new TestRemoteCompareOperation(null, remoteResource, v1);
        this.run((CVSOperation)op);
        this.assertRevisionsMatch(op.getRightTree(), project, new String[]{"folder1/a.txt"}, null);
        this.assertRevisionsMatch(op.getLeftTree(), copy, new String[]{"folder1/a.txt"}, null);
        remoteResource = CVSWorkspaceRoot.getRemoteResourceFor((IResource)copy.getFile("folder1/a.txt"));
        op = new TestRemoteCompareOperation(null, remoteResource, RemoteCompareOperation.getTag((ICVSRemoteResource)CVSWorkspaceRoot.getRemoteResourceFor((IResource)project.getFile("folder1/a.txt"))));
        this.run((CVSOperation)op);
        this.assertRevisionsMatch(op.getRightTree(), project, new String[]{"folder1/a.txt"}, null);
        this.assertRevisionsMatch(op.getLeftTree(), copy, new String[]{"folder1/a.txt"}, null);
    }

    public class TestRemoteCompareOperation
    extends RemoteCompareOperation {
        private ICVSRemoteFolder leftTree;
        private ICVSRemoteFolder rightTree;

        public TestRemoteCompareOperation(IWorkbenchPart part, ICVSRemoteResource resource, CVSTag tag) {
            super(part, resource, tag);
        }

        protected void openCompareEditor(RemoteCompareOperation.CompareTreeBuilder builder) {
            this.leftTree = builder.getLeftTree();
            this.rightTree = builder.getRightTree();
        }

        public ICVSRemoteFolder getLeftTree() {
            return this.leftTree;
        }

        public ICVSRemoteFolder getRightTree() {
            return this.rightTree;
        }
    }
}

