/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui.benchmark;

import java.io.File;
import junit.framework.Test;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.tests.ccvs.core.subscriber.SyncInfoSource;
import org.eclipse.team.tests.ccvs.ui.benchmark.BenchmarkTest;
import org.eclipse.team.tests.ccvs.ui.benchmark.BenchmarkTestSetup;
import org.eclipse.team.tests.ccvs.ui.benchmark.BenchmarkUtils;
import org.eclipse.team.tests.ccvs.ui.benchmark.SequenceGenerator;

public class WorkflowTests
extends BenchmarkTest {
    private int FILE_SIZE_MEAN = 16384;
    private int FILE_SIZE_VARIANCE = 12288;
    private int PROB_BINARY = 5;
    private static final String SHARE_PROJECT = "Share";
    private static final String CHECKOUT_PROJECT = "Checkout";
    private static final String COMMIT1 = "Commit1";
    private static final String COMMIT2 = "Commit2";
    private static final String COMMIT3 = "Commit3";
    private static final String COMMIT4 = "Commit4";
    private static final String UPDATE1 = "Update1";
    private static final String UPDATE2 = "Update2";
    private static final String UPDATE3 = "Update3";
    private static final String UPDATE4 = "Update4";
    private static final String REPLACE1 = "Replace1";
    private static final String REPLACE2 = "Replace2";
    private static final String REPLACE3 = "Replace3";
    private static final String TAG1 = "Tag1";
    private static final String[] PERFORMANCE_GROUPS = new String[]{"Share", "Checkout", "Commit1", "Commit2", "Commit3", "Commit4", "Update1", "Update2", "Update3", "Update4", "Replace1", "Replace2", "Replace3", "Tag1"};

    public WorkflowTests() {
    }

    public WorkflowTests(String name) {
        super(name);
    }

    public static Test suite() {
        return WorkflowTests.suite(WorkflowTests.class);
    }

    public void testBigWorkflowNoUI() throws Exception {
        this.runWorkflowTests("testBigWithNoUI", BenchmarkTestSetup.BIG_ZIP_FILE, "CVS Workflow No UI", BenchmarkTestSetup.LOOP_COUNT, false, new SyncInfoSource());
    }

    protected void waitForBuild() {
        super.waitForBuild();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            Job.getJobManager().beginRule((ISchedulingRule)root, null);
        }
        finally {
            Job.getJobManager().endRule((ISchedulingRule)root);
        }
    }

    protected void runWorkflowTests(String name, File initialContents, String globalName, int loopCount, boolean global, SyncInfoSource source) throws Exception {
        this.openEmptyPerspective();
        this.setupGroups(PERFORMANCE_GROUPS, globalName, global);
        int i = 0;
        while (i < loopCount) {
            SequenceGenerator gen = new SequenceGenerator();
            IProject outProject = this.createAndImportProject(name, initialContents);
            this.startGroup(SHARE_PROJECT);
            this.shareProject(outProject);
            this.endGroup();
            String moduleName = outProject.getName();
            BenchmarkUtils.renameResource((IResource)outProject, String.valueOf(moduleName) + "out");
            outProject = BenchmarkUtils.getProject(String.valueOf(moduleName) + "out");
            this.waitForBuild();
            IProject inProject = BenchmarkUtils.getProject(moduleName);
            this.startGroup(CHECKOUT_PROJECT);
            this.checkoutProject(inProject, moduleName, null);
            this.endGroup();
            this.startGroup(COMMIT1);
            BenchmarkUtils.modifyRandomDeepFiles(gen, (IContainer)outProject, 5);
            BenchmarkUtils.touchRandomDeepFiles(gen, (IContainer)outProject, 2);
            IFolder componentRoot = BenchmarkUtils.createRandomDeepFolder(gen, (IContainer)outProject);
            BenchmarkUtils.createRandomDeepFiles(gen, (IContainer)componentRoot, 12, this.FILE_SIZE_MEAN, this.FILE_SIZE_VARIANCE, this.PROB_BINARY);
            this.syncCommitResources(source, new IResource[]{outProject}, "");
            this.endGroup();
            this.startGroup(UPDATE1);
            this.syncUpdateResources(source, new IResource[]{inProject});
            this.endGroup();
            this.startGroup(COMMIT2);
            BenchmarkUtils.modifyRandomDeepFiles(gen, (IContainer)componentRoot, 2);
            BenchmarkUtils.touchRandomDeepFiles(gen, (IContainer)componentRoot, 2);
            this.syncCommitResources(source, new IResource[]{outProject}, "");
            this.endGroup();
            this.startGroup(UPDATE2);
            this.syncUpdateResources(source, new IResource[]{inProject});
            this.endGroup();
            this.startGroup(COMMIT3);
            BenchmarkUtils.modifyRandomDeepFiles(gen, (IContainer)outProject, 5);
            BenchmarkUtils.modifyRandomDeepFiles(gen, (IContainer)componentRoot, 12);
            BenchmarkUtils.renameResource((IResource)componentRoot, BenchmarkUtils.makeUniqueName(gen, "folder", null));
            this.syncCommitResources(source, new IResource[]{outProject}, "");
            this.endGroup();
            this.startGroup(UPDATE3);
            this.syncUpdateResources(source, new IResource[]{inProject});
            this.endGroup();
            this.startGroup(COMMIT4);
            BenchmarkUtils.deleteRandomDeepFiles(gen, (IContainer)outProject, 4);
            BenchmarkUtils.modifyRandomDeepFiles(gen, (IContainer)outProject, 20);
            BenchmarkUtils.renameRandomDeepFiles(gen, (IContainer)outProject, 5);
            BenchmarkUtils.createRandomDeepFiles(gen, (IContainer)outProject, 4, this.FILE_SIZE_MEAN, this.FILE_SIZE_VARIANCE, this.PROB_BINARY);
            this.syncCommitResources(source, new IResource[]{outProject}, "");
            this.endGroup();
            this.startGroup(UPDATE4);
            this.syncUpdateResources(source, new IResource[]{inProject});
            this.endGroup();
            this.startGroup(TAG1);
            this.tagProject(outProject, new CVSTag("v101", 2), false);
            this.endGroup();
            this.startGroup(REPLACE1);
            this.replace(new IResource[]{inProject}, null, true);
            this.endGroup();
            this.startGroup(REPLACE2);
            BenchmarkUtils.deleteRandomDeepFiles(gen, (IContainer)inProject, 4);
            BenchmarkUtils.modifyRandomDeepFiles(gen, (IContainer)inProject, 6);
            BenchmarkUtils.createRandomDeepFiles(gen, (IContainer)inProject, 4, this.FILE_SIZE_MEAN, this.FILE_SIZE_VARIANCE, this.PROB_BINARY);
            this.replace(new IResource[]{inProject}, null, true);
            this.endGroup();
            BenchmarkUtils.deleteRandomDeepFiles(gen, (IContainer)outProject, 10);
            BenchmarkUtils.modifyRandomDeepFiles(gen, (IContainer)outProject, 42);
            BenchmarkUtils.renameRandomDeepFiles(gen, (IContainer)outProject, 8);
            BenchmarkUtils.createRandomDeepFiles(gen, (IContainer)outProject, 10, this.FILE_SIZE_MEAN, this.FILE_SIZE_VARIANCE, this.PROB_BINARY);
            this.syncCommitResources(source, new IResource[]{outProject}, "");
            this.startGroup(REPLACE3);
            this.replace(new IResource[]{inProject}, null, true);
            this.endGroup();
            ++i;
        }
        this.commitGroups(global);
    }
}

