/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IServerConnection;
import org.eclipse.team.internal.ccvs.core.connection.CVSAuthenticationException;

public class TestConnection
implements IServerConnection {
    public static TestConnection currentConnection;
    public static List<String> previousLines;
    public static StringBuffer currentLine;
    private ByteArrayInputStream serverResponse;
    private static final String VALID_SERVER_REQUESTS = "Valid-requests Root Valid-responses valid-requests Repository Directory Max-dotdot Static-directory Sticky Checkin-prog Update-prog Entry Kopt Checkin-time Modified Is-modified UseUnchanged Unchanged Notify Questionable Case Argument Argumentx Global_option Gzip-stream wrapper-sendme-rcsOptions Set Kerberos-encrypt Gssapi-encrypt Gssapi-authenticate expand-modules ci co update diff log rlog add remove update-patches gzip-file-contents status rdiff tag rtag import admin export history release watch-on watch-off watch-add watch-remove watchers editors init annotate rannotate noop version";

    public static IServerConnection createConnection(ICVSRepositoryLocation location, String password) {
        currentConnection = new TestConnection();
        return currentConnection;
    }

    public static String getLastLine() {
        if (previousLines.isEmpty()) {
            return null;
        }
        return previousLines.get(previousLines.size() - 1);
    }

    public void open(IProgressMonitor monitor) throws IOException, CVSAuthenticationException {
        this.resetStreams();
    }

    public void close() throws IOException {
        this.resetStreams();
    }

    private void resetStreams() {
        currentLine = new StringBuffer();
        previousLines = new ArrayList<String>();
    }

    public InputStream getInputStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                if (TestConnection.this.serverResponse == null) {
                    throw new IOException("Not prepared to make a response");
                }
                return TestConnection.this.serverResponse.read();
            }
        };
    }

    public OutputStream getOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int output) throws IOException {
                byte b = (byte)output;
                if (b == 10) {
                    String sentLine = currentLine.toString();
                    previousLines.add(sentLine);
                    currentLine = new StringBuffer();
                    TestConnection.this.respondToSentLine(sentLine);
                } else {
                    currentLine.append((char)b);
                }
            }
        };
    }

    protected void respondToSentLine(String sentLine) {
        if (sentLine.equals("valid-requests")) {
            this.serverResponse = new ByteArrayInputStream("Valid-requests Root Valid-responses valid-requests Repository Directory Max-dotdot Static-directory Sticky Checkin-prog Update-prog Entry Kopt Checkin-time Modified Is-modified UseUnchanged Unchanged Notify Questionable Case Argument Argumentx Global_option Gzip-stream wrapper-sendme-rcsOptions Set Kerberos-encrypt Gssapi-encrypt Gssapi-authenticate expand-modules ci co update diff log rlog add remove update-patches gzip-file-contents status rdiff tag rtag import admin export history release watch-on watch-off watch-add watch-remove watchers editors init annotate rannotate noop version\nok\n".getBytes());
        }
    }
}

