/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.cvsresources;

import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.team.core.ScmUrlImportDescription;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProjectSetCapability;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.filesystem.CVSURI;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.EclipseTest;

public class CVSURITest
extends EclipseTest {
    public CVSURITest() {
    }

    public CVSURITest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(CVSURITest.class);
        return new CVSTestSetup((Test)suite);
    }

    public void testURIParse() throws URISyntaxException, CVSException {
        URI uri = new URI("cvs://_pserver_user~host.here_!root!path/project/path");
        CVSURI cvsUri = CVSURI.fromUri((URI)uri);
        CVSURITest.assertEquals((String)"/project/path", (String)cvsUri.getPath().toString());
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:user@host.here:/root/path");
        CVSURITest.assertEquals((String)cvsUri.getRepository().getLocation(false), (String)location.getLocation(false));
        CVSURITest.assertEquals((Object)cvsUri.getTag(), null);
        CVSURITest.assertEquals((Object)cvsUri.toURI(), (Object)uri);
    }

    public void testURIParse2() throws URISyntaxException, CVSException {
        URI uri = new URI("cvs://_pserver_user_password~host.here_1234!root!path/project/path");
        CVSURI cvsUri = CVSURI.fromUri((URI)uri);
        CVSURITest.assertEquals((String)"/project/path", (String)cvsUri.getPath().toString());
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:user:password@host.here:1234/root/path");
        CVSURITest.assertEquals((String)cvsUri.getRepository().getLocation(false), (String)location.getLocation(false));
        CVSURITest.assertEquals((Object)cvsUri.getTag(), null);
        CVSURITest.assertEquals((Object)cvsUri.toURI(), (Object)uri);
    }

    public void testURIParse3() throws URISyntaxException, CVSException {
        URI uri = new URI("cvs://_pserver_user_password~host.here_1234!root!path/project/path?version=v1");
        CVSURI cvsUri = CVSURI.fromUri((URI)uri);
        CVSURITest.assertEquals((String)"/project/path", (String)cvsUri.getPath().toString());
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:user:password@host.here:1234/root/path");
        CVSURITest.assertEquals((String)cvsUri.getRepository().getLocation(false), (String)location.getLocation(false));
        CVSURITest.assertEquals((Object)cvsUri.getTag(), (Object)new CVSTag("v1", 2));
        CVSURITest.assertEquals((Object)cvsUri.toURI(), (Object)uri);
    }

    public void testURIParse4() throws URISyntaxException, CVSException {
        URI uri = new URI("cvs://_pserver_user_password~host.here_1234!root!path/project/path?branch=b1");
        CVSURI cvsUri = CVSURI.fromUri((URI)uri);
        CVSURITest.assertEquals((String)"/project/path", (String)cvsUri.getPath().toString());
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:user:password@host.here:1234/root/path");
        CVSURITest.assertEquals((String)cvsUri.getRepository().getLocation(false), (String)location.getLocation(false));
        CVSURITest.assertEquals((Object)cvsUri.getTag(), (Object)new CVSTag("b1", 1));
        CVSURITest.assertEquals((Object)cvsUri.toURI(), (Object)uri);
    }

    public void testURIParse5() throws URISyntaxException, CVSException {
        URI uri = new URI("cvs://_pserver_user_password~host.here_1234!root!path/project/path?revision=1.5");
        CVSURI cvsUri = CVSURI.fromUri((URI)uri);
        CVSURITest.assertEquals((String)"/project/path", (String)cvsUri.getPath().toString());
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:user:password@host.here:1234/root/path");
        CVSURITest.assertEquals((String)cvsUri.getRepository().getLocation(false), (String)location.getLocation(false));
        CVSURITest.assertEquals((String)cvsUri.getRevision(), (String)"1.5");
        CVSURITest.assertEquals((Object)cvsUri.toURI(), (Object)uri);
    }

    public void testURIParse6() throws URISyntaxException, CVSException {
        URI uri = new URI("cvs://_pserver_user_pass~~word~host.here_1234!the__root!path!!/project/path?revision=1.5");
        CVSURI cvsUri = CVSURI.fromUri((URI)uri);
        CVSURITest.assertEquals((String)"/project/path", (String)cvsUri.getPath().toString());
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:user:pass~word@host.here:1234/the_root/path!");
        CVSURITest.assertEquals((String)cvsUri.getRepository().getLocation(false), (String)location.getLocation(false));
        CVSURITest.assertEquals((String)cvsUri.getRevision(), (String)"1.5");
        CVSURITest.assertEquals((Object)cvsUri.toURI(), (Object)uri);
    }

    public void testURIParse7() throws URISyntaxException, CVSException {
        URI uri = new URI("cvs://_pserver_username_password~testserver.acme.com_!root/");
        CVSURI cvsUri = CVSURI.fromUri((URI)uri);
        CVSURITest.assertEquals((String)"/", (String)cvsUri.getPath().toString());
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver;username=username;password=password:testserver.acme.com/root");
        CVSURITest.assertEquals((String)"pserver", (String)location.getMethod().getName());
        CVSURITest.assertEquals((String)"username", (String)location.getUsername());
        CVSURITest.assertEquals((int)0, (int)location.getPort());
        CVSURITest.assertEquals((String)"testserver.acme.com", (String)location.getHost());
        CVSURITest.assertEquals((String)"/root", (String)location.getRootDirectory());
        CVSURITest.assertEquals((String)cvsUri.getRepository().getLocation(false), (String)location.getLocation(false));
        CVSURITest.assertEquals(null, (Object)cvsUri.getTag());
        CVSURITest.assertEquals((Object)cvsUri.toURI(), (Object)uri);
    }

    public void testScmUri1() throws CVSException {
        URI uri = URI.create("scm:cvs:pserver:host.com:/cvsroot/path:module;tag=tag");
        CVSURI cvsUri = CVSURI.fromUri((URI)uri);
        CVSURITest.assertEquals((String)"module", (String)cvsUri.getPath().toString());
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:host.com:/cvsroot/path");
        CVSURITest.assertEquals((String)cvsUri.getRepository().getLocation(false), (String)location.getLocation(false));
        CVSURITest.assertEquals((Object)cvsUri.getTag(), (Object)new CVSTag("tag", 2));
        String refString = new CVSProjectSetCapability().asReference(uri, "project");
        CVSURITest.assertEquals((String)"1.0,:pserver:host.com:/cvsroot/path,module,project,tag", (String)refString);
    }

    public void testScmUri2() throws CVSException {
        URI uri = URI.create("scm:cvs:pserver:host.com:/cvsroot/path:module;version=version");
        CVSURI cvsUri = CVSURI.fromUri((URI)uri);
        CVSURITest.assertEquals((String)"module", (String)cvsUri.getPath().toString());
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:host.com:/cvsroot/path");
        CVSURITest.assertEquals((String)cvsUri.getRepository().getLocation(false), (String)location.getLocation(false));
        CVSURITest.assertEquals((Object)cvsUri.getTag(), (Object)new CVSTag("version", 2));
        String refString = new CVSProjectSetCapability().asReference(uri, "project");
        CVSURITest.assertEquals((String)"1.0,:pserver:host.com:/cvsroot/path,module,project,version", (String)refString);
    }

    public void testScmUri3() throws CVSException {
        URI uri = URI.create("scm:cvs:pserver:host.com:/cvsroot/path:path/to/module;version=version;project=project1");
        CVSURI cvsUri = CVSURI.fromUri((URI)uri);
        CVSURITest.assertEquals((String)"path/to/module", (String)cvsUri.getPath().toString());
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:host.com:/cvsroot/path");
        CVSURITest.assertEquals((String)cvsUri.getRepository().getLocation(false), (String)location.getLocation(false));
        CVSURITest.assertEquals((Object)cvsUri.getTag(), (Object)new CVSTag("version", 2));
        String refString = new CVSProjectSetCapability().asReference(uri, "project2");
        CVSURITest.assertEquals((String)"1.0,:pserver:host.com:/cvsroot/path,path/to/module,project2,version", (String)refString);
    }

    public void testScmUri4() throws CVSException {
        URI uri = URI.create("scm:cvs:pserver:host.com:/cvsroot/path:path/to/module;version=version;project=project1");
        CVSURI cvsUri = CVSURI.fromUri((URI)uri);
        CVSURITest.assertEquals((String)"path/to/module", (String)cvsUri.getPath().toString());
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:host.com:/cvsroot/path");
        CVSURITest.assertEquals((String)cvsUri.getRepository().getLocation(false), (String)location.getLocation(false));
        CVSURITest.assertEquals((Object)cvsUri.getTag(), (Object)new CVSTag("version", 2));
        String refString = new CVSProjectSetCapability().asReference(uri, null);
        CVSURITest.assertEquals((String)"1.0,:pserver:host.com:/cvsroot/path,path/to/module,project1,version", (String)refString);
    }

    public void testScmUri5() throws CVSException {
        URI uri = URI.create("scm:cvs:pserver:host.com:/cvsroot/path:path/to/module;project=project1;version=version");
        CVSURI cvsUri = CVSURI.fromUri((URI)uri);
        CVSURITest.assertEquals((String)"path/to/module", (String)cvsUri.getPath().toString());
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:host.com:/cvsroot/path");
        CVSURITest.assertEquals((String)cvsUri.getRepository().getLocation(false), (String)location.getLocation(false));
        CVSURITest.assertEquals((Object)cvsUri.getTag(), (Object)new CVSTag("version", 2));
        String refString = new CVSProjectSetCapability().asReference(uri, null);
        CVSURITest.assertEquals((String)"1.0,:pserver:host.com:/cvsroot/path,path/to/module,project1,version", (String)refString);
    }

    public void testScmUri6() throws CVSException {
        URI uri = URI.create("scm:cvs:pserver:host.com:/cvsroot/path:path/to/module;tag=tag");
        CVSURI cvsUri = CVSURI.fromUri((URI)uri);
        CVSURITest.assertEquals((String)"path/to/module", (String)cvsUri.getPath().toString());
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:host.com:/cvsroot/path");
        CVSURITest.assertEquals((String)cvsUri.getRepository().getLocation(false), (String)location.getLocation(false));
        CVSURITest.assertEquals((Object)cvsUri.getTag(), (Object)new CVSTag("tag", 2));
        String refString = new CVSProjectSetCapability().asReference(uri, null);
        CVSURITest.assertEquals((String)"1.0,:pserver:host.com:/cvsroot/path,path/to/module,module,tag", (String)refString);
    }

    public void testScmUri7() throws CVSException {
        URI uri = URI.create("scm:cvs:pserver:host.com:/cvsroot/path:path/to/module;version=version");
        CVSURI cvsUri = CVSURI.fromUri((URI)uri);
        CVSURITest.assertEquals((String)"path/to/module", (String)cvsUri.getPath().toString());
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:host.com:/cvsroot/path");
        CVSURITest.assertEquals((String)cvsUri.getRepository().getLocation(false), (String)location.getLocation(false));
        CVSURITest.assertEquals((Object)cvsUri.getTag(), (Object)new CVSTag("version", 2));
        String refString = new CVSProjectSetCapability().asReference(uri, null);
        CVSURITest.assertEquals((String)"1.0,:pserver:host.com:/cvsroot/path,path/to/module,module,version", (String)refString);
    }

    public void testScmUri8() throws CVSException {
        URI uri = URI.create("scm:cvs:pserver:host.com:/cvsroot/path:path/to/module;project=");
        CVSURI cvsUri = CVSURI.fromUri((URI)uri);
        CVSURITest.assertEquals((String)"path/to/module", (String)cvsUri.getPath().toString());
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:host.com:/cvsroot/path");
        CVSURITest.assertEquals((String)cvsUri.getRepository().getLocation(false), (String)location.getLocation(false));
        CVSURITest.assertEquals((Object)cvsUri.getTag(), (Object)CVSTag.DEFAULT);
        String refString = new CVSProjectSetCapability().asReference(uri, null);
        CVSURITest.assertEquals((String)"1.0,:pserver:host.com:/cvsroot/path,path/to/module,module", (String)refString);
    }

    public void testScmUri9() throws CVSException {
        URI uri = URI.create("scm:cvs:pserver:host.com:/cvsroot/path:path/to/module");
        CVSURI cvsUri = CVSURI.fromUri((URI)uri);
        CVSURITest.assertEquals((String)"path/to/module", (String)cvsUri.getPath().toString());
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:host.com:/cvsroot/path");
        CVSURITest.assertEquals((String)cvsUri.getRepository().getLocation(false), (String)location.getLocation(false));
        CVSURITest.assertEquals((Object)cvsUri.getTag(), (Object)CVSTag.DEFAULT);
        String refString = new CVSProjectSetCapability().asReference(uri, "project");
        CVSURITest.assertEquals((String)"1.0,:pserver:host.com:/cvsroot/path,path/to/module,project", (String)refString);
    }

    public void testScmUri10() throws URISyntaxException, CVSException {
        URI uri = new URI("scm:cvs:pserver:anonymous:@host.com:/cvsroot/path:module");
        CVSURI cvsUri = CVSURI.fromUri((URI)uri);
        CVSURITest.assertEquals((String)"module", (String)cvsUri.getPath().toString());
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:anonymous:@host.com:/cvsroot/path");
        CVSURITest.assertEquals((String)cvsUri.getRepository().getLocation(false), (String)location.getLocation(false));
        CVSURITest.assertEquals((Object)cvsUri.getTag(), (Object)CVSTag.DEFAULT);
        String refString = new CVSProjectSetCapability().asReference(uri, "project");
        CVSURITest.assertEquals((String)"1.0,:pserver:anonymous:@host.com:/cvsroot/path,module,project", (String)refString);
    }

    public void testScmUri11() throws URISyntaxException, CVSException {
        URI uri = new URI("scm:cvs:pserver:username@host.com:/cvsroot/path:module");
        CVSURI cvsUri = CVSURI.fromUri((URI)uri);
        CVSURITest.assertEquals((String)"module", (String)cvsUri.getPath().toString());
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:username@host.com:/cvsroot/path");
        CVSURITest.assertEquals((String)cvsUri.getRepository().getLocation(false), (String)location.getLocation(false));
        CVSURITest.assertEquals((Object)cvsUri.getTag(), (Object)CVSTag.DEFAULT);
        String refString = new CVSProjectSetCapability().asReference(uri, "project");
        CVSURITest.assertEquals((String)"1.0,:pserver:username@host.com:/cvsroot/path,module,project", (String)refString);
    }

    public void testScmUri12() throws URISyntaxException {
        URI uri = new URI("notScm:cvs:pserver:username@host.com:/cvsroot/path:module");
        try {
            new CVSProjectSetCapability().asReference(uri, "project");
            CVSURITest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testScmUri13() throws URISyntaxException {
        URI uri = new URI("scm:cvs:pserver:username@host.com:/cvsroot/path:");
        String refString = new CVSProjectSetCapability().asReference(uri, null);
        CVSURITest.assertNull((Object)refString);
    }

    public void testScmUri14() {
        try {
            URI.create("scm:cvs:pserver:host.com:/cvsroot/path:path/to/module;tag=\"tag\"");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testScmUri15() throws CVSException {
        ScmUrlImportDescription description = new ScmUrlImportDescription("scm:cvs:pserver:host.com:/cvsroot/path:path/to/module;tag=\"tag\"", null);
        URI uri = description.getUri();
        CVSURI cvsUri = CVSURI.fromUri((URI)uri);
        CVSURITest.assertEquals((String)"path/to/module", (String)cvsUri.getPath().toString());
        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)":pserver:host.com:/cvsroot/path");
        CVSURITest.assertEquals((String)cvsUri.getRepository().getLocation(false), (String)location.getLocation(false));
        CVSURITest.assertEquals((Object)cvsUri.getTag(), (Object)new CVSTag("tag", 2));
        String refString = new CVSProjectSetCapability().asReference(uri, null);
        CVSURITest.assertEquals((String)"1.0,:pserver:host.com:/cvsroot/path,path/to/module,module,tag", (String)refString);
    }
}

