/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.jsch;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jsch.internal.core.JSchCorePlugin;
import org.eclipse.jsch.internal.core.PreferenceInitializer;
import org.eclipse.team.tests.ccvs.core.EclipseTest;

public class PreferenceInitializerTest
extends EclipseTest {
    private boolean PREF_HAS_CHANGED_DEFAULT_WIN32_SSH_HOME_value = false;
    private boolean PREF_HAS_MIGRATED_SSH2_PREFS_value = false;
    private String KEY_SSH2HOME_value = null;
    private String KEY_PRIVATEKEY_value = null;

    @Override
    protected void setUp() throws Exception {
        if (!Platform.getOS().equals("win32")) {
            return;
        }
        super.setUp();
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(JSchCorePlugin.ID);
        this.PREF_HAS_CHANGED_DEFAULT_WIN32_SSH_HOME_value = preferences.getBoolean("org.eclipse.jsch.core.hasChangedDefaultWin32SshHome", false);
        this.PREF_HAS_MIGRATED_SSH2_PREFS_value = preferences.getBoolean("org.eclipse.jsch.core.hasMigratedSsh2Preferences", false);
        this.KEY_SSH2HOME_value = preferences.get("SSH2HOME", null);
        this.KEY_PRIVATEKEY_value = preferences.get("PRIVATEKEY", null);
    }

    @Override
    protected void tearDown() throws Exception {
        if (!Platform.getOS().equals("win32")) {
            return;
        }
        super.tearDown();
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(JSchCorePlugin.ID);
        preferences.putBoolean("org.eclipse.jsch.core.hasChangedDefaultWin32SshHome", this.PREF_HAS_CHANGED_DEFAULT_WIN32_SSH_HOME_value);
        preferences.putBoolean("org.eclipse.jsch.core.hasMigratedSsh2Preferences", this.PREF_HAS_MIGRATED_SSH2_PREFS_value);
        if (this.KEY_SSH2HOME_value != null) {
            preferences.put("SSH2HOME", this.KEY_SSH2HOME_value);
        } else {
            preferences.remove("SSH2HOME");
        }
        if (this.KEY_PRIVATEKEY_value != null) {
            preferences.put("PRIVATEKEY", this.KEY_PRIVATEKEY_value);
        } else {
            preferences.remove("PRIVATEKEY");
        }
    }

    public void testChangeDefaultWin32SshHomeOldWorkspace() {
        File file;
        if (!Platform.getOS().equals("win32")) {
            return;
        }
        if (PreferenceInitializer.SSH_OLD_WIN32_HOME_DEFAULT != null && !(file = new File(PreferenceInitializer.SSH_OLD_WIN32_HOME_DEFAULT)).exists()) {
            file.mkdir();
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(JSchCorePlugin.ID);
        preferences.remove("org.eclipse.jsch.core.hasChangedDefaultWin32SshHome");
        preferences.putBoolean("org.eclipse.jsch.core.hasMigratedSsh2Preferences", true);
        preferences.remove("SSH2HOME");
        PreferenceInitializerTest.assertFalse((boolean)preferences.getBoolean("org.eclipse.jsch.core.hasChangedDefaultWin32SshHome", false));
        PreferenceInitializerTest.assertTrue((boolean)preferences.getBoolean("org.eclipse.jsch.core.hasMigratedSsh2Preferences", false));
        PreferenceInitializer preferenceInitializer = new PreferenceInitializer();
        preferenceInitializer.initializeDefaultPreferences();
        PreferenceInitializerTest.assertTrue((boolean)preferences.getBoolean("org.eclipse.jsch.core.hasChangedDefaultWin32SshHome", false));
        PreferenceInitializerTest.assertEquals((String)PreferenceInitializer.SSH_OLD_WIN32_HOME_DEFAULT, (String)preferences.get("SSH2HOME", null));
    }

    public void _testDontChangeDefaultWin32SshHomeNewWorkspace() {
        File file;
        if (!Platform.getOS().equals("win32")) {
            return;
        }
        if (PreferenceInitializer.SSH_OLD_WIN32_HOME_DEFAULT != null && !(file = new File(PreferenceInitializer.SSH_OLD_WIN32_HOME_DEFAULT)).exists()) {
            file.mkdir();
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(JSchCorePlugin.ID);
        preferences.remove("org.eclipse.jsch.core.hasChangedDefaultWin32SshHome");
        preferences.remove("org.eclipse.jsch.core.hasMigratedSsh2Preferences");
        preferences.remove("SSH2HOME");
        PreferenceInitializerTest.assertFalse((boolean)preferences.getBoolean("org.eclipse.jsch.core.hasChangedDefaultWin32SshHome", false));
        PreferenceInitializerTest.assertFalse((boolean)preferences.getBoolean("org.eclipse.jsch.core.hasMigratedSsh2Preferences", false));
        PreferenceInitializer preferenceInitializer = new PreferenceInitializer();
        preferenceInitializer.initializeDefaultPreferences();
        PreferenceInitializerTest.assertTrue((boolean)preferences.getBoolean("org.eclipse.jsch.core.hasChangedDefaultWin32SshHome", false));
        PreferenceInitializerTest.assertNull((Object)preferences.get("SSH2HOME", null));
    }

    public static Test suite() {
        return new TestSuite(PreferenceInitializerTest.class);
    }
}

