/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.provider;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.util.Util;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.IResourceStateChangeListener;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.util.ResourceStateChangeListeners;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.EclipseTest;

public class IsModifiedTests
extends EclipseTest {
    Set previouslyModified = new HashSet();
    Map changedResources = new HashMap();
    IResourceStateChangeListener listener = new IResourceStateChangeListener(){

        public void resourceSyncInfoChanged(IResource[] changedResources) {
            try {
                int i = 0;
                while (i < changedResources.length) {
                    IResource resource = changedResources[i];
                    ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
                    this.recordModificationState(cvsResource);
                    this.recordParents(cvsResource);
                    if (cvsResource.isFolder()) {
                        this.recordChildren((ICVSFolder)cvsResource);
                    }
                    ++i;
                }
            }
            catch (CVSException e) {
                IsModifiedTests.fail((String)e.getMessage());
            }
        }

        public void externalSyncInfoChange(IResource[] changedResources) {
            this.resourceSyncInfoChanged(changedResources);
        }

        private void recordChildren(ICVSFolder folder) {
            try {
                folder.accept(new ICVSResourceVisitor(){

                    public void visitFile(ICVSFile file) throws CVSException {
                        this.recordModificationState((ICVSResource)file);
                    }

                    public void visitFolder(ICVSFolder folder) throws CVSException {
                        this.recordModificationState((ICVSResource)folder);
                        folder.acceptChildren((ICVSResourceVisitor)this);
                    }
                });
            }
            catch (CVSException e) {
                IsModifiedTests.fail((String)e.getMessage());
            }
        }

        private void recordParents(ICVSResource cvsResource) throws CVSException {
            if (cvsResource.getIResource().getType() == 8) {
                return;
            }
            this.recordModificationState(cvsResource);
            this.recordParents((ICVSResource)cvsResource.getParent());
        }

        private void recordModificationState(ICVSResource cvsResource) throws CVSException {
            IsModifiedTests.this.changedResources.put(cvsResource.getIResource(), cvsResource.isModified(null) ? Boolean.TRUE : Boolean.FALSE);
        }

        public void resourceModified(IResource[] changedResources) {
            try {
                int i = 0;
                while (i < changedResources.length) {
                    IResource resource = changedResources[i];
                    ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
                    IsModifiedTests.this.changedResources.put(resource, cvsResource.isModified(null) ? Boolean.TRUE : Boolean.FALSE);
                    this.recordParents(cvsResource);
                    if (cvsResource.isFolder()) {
                        this.recordChildren((ICVSFolder)cvsResource);
                    }
                    ++i;
                }
            }
            catch (CVSException e) {
                IsModifiedTests.fail((String)e.getMessage());
            }
        }

        public void projectConfigured(IProject project) {
        }

        public void projectDeconfigured(IProject project) {
        }
    };

    public IsModifiedTests() {
    }

    public IsModifiedTests(String name) {
        super(name);
    }

    public static Test suite() {
        String testName = System.getProperty("eclipse.cvs.testName");
        if (testName == null) {
            TestSuite suite = new TestSuite(IsModifiedTests.class);
            return new CVSTestSetup((Test)suite);
        }
        return new CVSTestSetup((Test)new IsModifiedTests(testName));
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.previouslyModified.clear();
        this.changedResources.clear();
        ResourceStateChangeListeners.getListener().addResourceStateChangeListener(this.listener);
    }

    @Override
    protected void tearDown() throws Exception {
        this.previouslyModified.clear();
        this.changedResources.clear();
        ResourceStateChangeListeners.getListener().removeResourceStateChangeListener(this.listener);
        super.tearDown();
    }

    private void assertModificationState(IContainer container, String[] resources, final boolean listedResourcesShouldBeModified) throws CVSException {
        final ICVSFolder rootFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)container);
        final ArrayList<Path> resourceList = new ArrayList<Path>();
        HashSet modifiedResources = new HashSet();
        if (resources != null) {
            int i = 0;
            while (i < resources.length) {
                String string = resources[i];
                resourceList.add(new Path(string));
                ++i;
            }
        }
        IsModifiedTests.waitForIgnoreFileHandling();
        rootFolder.accept(new ICVSResourceVisitor(){

            public void visitFile(ICVSFile file) throws CVSException {
                this.assertModificationState((ICVSResource)file);
            }

            public void visitFolder(ICVSFolder folder) throws CVSException {
                folder.acceptChildren((ICVSResourceVisitor)this);
                this.assertModificationState((ICVSResource)folder);
            }

            public void assertModificationState(ICVSResource resource) throws CVSException {
                Path relativePath = new Path(resource.getRelativePath(rootFolder));
                boolean resourceModified = resource.isModified(null);
                boolean resourceListed = resourceList.contains(relativePath);
                if (CVSTestSetup.FAIL_ON_BAD_DIFF) {
                    IsModifiedTests.assertTrue((String)(String.valueOf(resource.getIResource().getFullPath().toString()) + (resourceModified ? " should not be modified but is" : " should be modified but isn't")), (listedResourcesShouldBeModified && resourceModified == resourceListed || !listedResourcesShouldBeModified && !resourceModified == resourceListed ? 1 : 0) != 0);
                } else if (!resourceModified) {
                    IsModifiedTests.assertTrue((String)(String.valueOf(resource.getIResource().getFullPath().toString()) + " should be modified but isn't"), (listedResourcesShouldBeModified && !resourceListed || !listedResourcesShouldBeModified && resourceListed ? 1 : 0) != 0);
                }
            }
        });
        this.changedResources.clear();
        this.previouslyModified.clear();
        this.previouslyModified.addAll(modifiedResources);
    }

    @Override
    protected IProject createProject(String prefix, String[] resources) throws CoreException, TeamException {
        IProject project = super.createProject(prefix, resources);
        this.assertModificationState((IContainer)project, null, true);
        return project;
    }

    public void testFileModifications() throws CoreException, TeamException {
        IProject project = this.createProject("testFileModifications", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        this.setContentsAndEnsureModified(project.getFile("changed.txt"));
        this.assertModificationState((IContainer)project, new String[]{".", "changed.txt"}, true);
        this.setContentsAndEnsureModified(project.getFile((IPath)new Path("folder1/a.txt")));
        this.assertModificationState((IContainer)project, new String[]{".", "changed.txt", "folder1/", "folder1/a.txt"}, true);
        this.commitResources((IContainer)project, new String[]{"folder1/a.txt"});
        this.assertModificationState((IContainer)project, new String[]{".", "changed.txt"}, true);
        this.replace(new IResource[]{project.getFile("changed.txt")}, null, true);
        this.assertModificationState((IContainer)project, null, true);
    }

    public void testFileDeletions() throws CoreException, TeamException {
        if (Util.isMac()) {
            return;
        }
        IProject project = this.createProject("testFileDeletions", new String[]{"changed.txt", "folder1/", "folder1/deleted.txt", "folder1/a.txt"});
        project.getFile("folder1/deleted.txt").delete(false, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/deleted.txt"}, true);
        this.commitResources((IContainer)project, new String[]{"folder1/deleted.txt"});
        this.assertModificationState((IContainer)project, null, true);
        this.setContentsAndEnsureModified(project.getFile("changed.txt"));
        this.assertModificationState((IContainer)project, new String[]{".", "changed.txt"}, true);
        project.getFile("changed.txt").delete(false, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, new String[]{".", "changed.txt"}, true);
        this.replace(new IResource[]{project.getFile("changed.txt")}, null, true);
        this.assertModificationState((IContainer)project, null, true);
        this.setContentsAndEnsureModified(project.getFile("changed.txt"));
        this.assertModificationState((IContainer)project, new String[]{".", "changed.txt"}, true);
        project.getFile("changed.txt").delete(false, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, new String[]{".", "changed.txt"}, true);
        this.commitResources((IContainer)project, new String[]{"changed.txt"});
        this.assertModificationState((IContainer)project, null, true);
        project.getFile("folder1/a.txt").delete(false, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/a.txt"}, true);
        this.buildResources((IContainer)project, new String[]{"folder1/a.txt"}, false);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/a.txt"}, true);
        this.commitResources((IContainer)project, new String[]{"folder1/a.txt"});
        this.assertModificationState((IContainer)project, null, true);
    }

    public void testFileAdditions() throws CoreException, TeamException {
        IProject project = this.createProject("testFileAdditions", new String[]{"changed.txt", "folder1/", "folder1/deleted.txt", "folder1/a.txt"});
        IResource[] addedResources = this.buildResources((IContainer)project, new String[]{"folder1/added.txt"}, false);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/added.txt"}, true);
        this.addResources(addedResources);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/added.txt"}, true);
        this.commitResources((IContainer)project, new String[]{"folder1/added.txt"});
        this.assertModificationState((IContainer)project, null, true);
        this.addResources((IContainer)project, new String[]{"added.txt"}, false);
        this.assertModificationState((IContainer)project, new String[]{".", "added.txt"}, true);
        project.getFile("added.txt").delete(false, false, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, null, true);
        addedResources = this.buildResources((IContainer)project, new String[]{"folder1/another.txt"}, false);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/another.txt"}, true);
        project.getFile("folder1/another.txt").delete(false, false, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, null, true);
        addedResources = this.buildResources((IContainer)project, new String[]{"ignored.txt"}, false);
        this.assertModificationState((IContainer)project, new String[]{".", "ignored.txt"}, true);
        project.getFile(".cvsignore").create((InputStream)new ByteArrayInputStream("ignored.txt".getBytes()), false, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, new String[]{".", ".cvsignore"}, true);
        this.addResources(new IResource[]{project.getFile(".cvsignore")});
        this.assertModificationState((IContainer)project, new String[]{".", ".cvsignore"}, true);
        this.commitResources((IContainer)project, new String[]{".cvsignore"});
        this.assertModificationState((IContainer)project, null, true);
        project.getFile(".cvsignore").delete(false, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, new String[]{".", "ignored.txt", ".cvsignore"}, true);
        this.commitResources((IContainer)project, new String[]{".cvsignore"});
        this.assertModificationState((IContainer)project, new String[]{".", "ignored.txt"}, true);
        project.getFile(".cvsignore").create((InputStream)new ByteArrayInputStream("ignored.txt".getBytes()), false, DEFAULT_MONITOR);
        this.addResources(new IResource[]{project.getFile(".cvsignore")});
        this.assertModificationState((IContainer)project, new String[]{".", ".cvsignore"}, true);
        this.commitResources((IContainer)project, new String[]{".cvsignore"});
        this.assertModificationState((IContainer)project, null, true);
        project.getFile("ignored.txt").delete(false, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, null, true);
        this.buildResources((IContainer)project, new String[]{"ignored.txt"}, false);
        this.assertModificationState((IContainer)project, null, true);
        this.addResources(new IResource[]{project.getFile("ignored.txt")});
        this.assertModificationState((IContainer)project, new String[]{".", "ignored.txt"}, true);
        this.commitProject(project);
        this.assertModificationState((IContainer)project, null, true);
    }

    public void testFileMoveAndCopy() throws CoreException, TeamException {
        IProject project;
        block2: {
            project = this.createProject("testFileMoveAndCopy", new String[]{"changed.txt", "folder1/", "folder2/", "folder1/a.txt"});
            project.getFile("folder1/a.txt").move(project.getFile("folder2/a.txt").getFullPath(), false, DEFAULT_MONITOR);
            this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/a.txt", "folder2/", "folder2/a.txt"}, true);
            this.commitResources((IContainer)project, new String[]{"folder1/a.txt"});
            this.assertModificationState((IContainer)project, new String[]{".", "folder2/", "folder2/a.txt"}, true);
            project.getFolder("folder1").create(false, true, DEFAULT_MONITOR);
            project.getFile("folder2/a.txt").copy(project.getFile("folder1/a.txt").getFullPath(), false, DEFAULT_MONITOR);
            this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/a.txt", "folder2/", "folder2/a.txt"}, true);
            this.addResources(new IResource[]{project.getFile("folder1/a.txt")});
            project.getFile("folder2/a.txt").delete(false, DEFAULT_MONITOR);
            this.commitProject(project);
            this.assertModificationState((IContainer)project, null, true);
            project.getFile("folder1/a.txt").move(project.getFile("folder2/a.txt").getFullPath(), false, DEFAULT_MONITOR);
            this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/a.txt", "folder2/", "folder2/a.txt"}, true);
            project.getFile("folder2/a.txt").copy(project.getFile("folder1/a.txt").getFullPath(), false, DEFAULT_MONITOR);
            this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/a.txt", "folder2/", "folder2/a.txt"}, true);
            this.addResources(new IResource[]{project.getFile("folder2/a.txt")});
            try {
                this.commitProject(project);
            }
            catch (CVSException e) {
                if (e.getStatus().getSeverity() != 4) break block2;
                throw e;
            }
        }
        this.assertModificationState((IContainer)project, null, true);
    }

    public void testFolderAdditions() throws CoreException, TeamException {
        IProject project = this.createProject("testFileAdditions", new String[]{"changed.txt", "folder1/", "folder1/deleted.txt", "folder1/a.txt"});
        project.getFolder("folder1/folder2").create(false, true, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/folder2/"}, true);
        this.addResources(new IResource[]{project.getFolder("folder1/folder2/")});
        this.assertModificationState((IContainer)project, null, true);
        project.getFolder("folder1/folder2/folder3").create(false, true, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/folder2/", "folder1/folder2/folder3"}, true);
        this.buildResources((IContainer)project, new String[]{"folder1/folder2/folder3/add1.txt", "folder1/folder2/folder3/add2.txt", "folder1/folder2/folder3/folder4/", "folder1/folder2/folder3/folder5/"}, false);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/folder2/", "folder1/folder2/folder3", "folder1/folder2/folder3/add1.txt", "folder1/folder2/folder3/add2.txt", "folder1/folder2/folder3/folder4/", "folder1/folder2/folder3/folder5/"}, true);
        project.getFile("folder1/folder2/folder3/add2.txt").delete(false, DEFAULT_MONITOR);
        project.getFolder("folder1/folder2/folder3/folder5/").delete(false, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/folder2/", "folder1/folder2/folder3", "folder1/folder2/folder3/add1.txt", "folder1/folder2/folder3/folder4/"}, true);
        this.addResources(new IResource[]{project.getFile("folder1/folder2/folder3/add1.txt"), project.getFolder("folder1/folder2/folder3/folder4/")});
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/folder2/", "folder1/folder2/folder3", "folder1/folder2/folder3/add1.txt"}, true);
        this.commitResources((IContainer)project, new String[]{"folder1/folder2/folder3/add1.txt"});
        this.assertModificationState((IContainer)project, null, true);
        project.getFolder("folder1/ignored").create(false, true, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/ignored/"}, true);
        this.buildResources((IContainer)project, new String[]{"folder1/ignored/file.txt"}, false);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/ignored/", "folder1/ignored/file.txt"}, true);
        project.getFile("folder1/.cvsignore").create((InputStream)new ByteArrayInputStream("ignored".getBytes()), false, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/.cvsignore"}, true);
        this.addResources(new IResource[]{project.getFile("folder1/.cvsignore")});
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/.cvsignore"}, true);
        this.commitResources((IContainer)project, new String[]{"folder1/.cvsignore"});
        this.assertModificationState((IContainer)project, null, true);
        project.getFile("folder1/.cvsignore").delete(false, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/.cvsignore", "folder1/ignored/", "folder1/ignored/file.txt"}, true);
        this.commitResources((IContainer)project, new String[]{"folder1/.cvsignore"});
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/ignored/", "folder1/ignored/file.txt"}, true);
        project.getFile("folder1/.cvsignore").create((InputStream)new ByteArrayInputStream("ignored".getBytes()), false, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/.cvsignore"}, true);
        this.addResources(new IResource[]{project.getFile("folder1/.cvsignore")});
        this.commitResources((IContainer)project, new String[]{"folder1/.cvsignore"});
        this.assertModificationState((IContainer)project, null, true);
        project.getFolder("folder/ignored").delete(false, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, null, true);
        this.buildResources((IContainer)project, new String[]{"folder1/ignored/file.txt"}, false);
        this.assertModificationState((IContainer)project, null, true);
        this.addResources(new IResource[]{project.getFile("folder1/ignored/file.txt")});
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/ignored/", "folder1/ignored/file.txt"}, true);
        this.commitProject(project);
        this.assertModificationState((IContainer)project, null, true);
    }

    public void testFolderDeletions() throws CoreException, TeamException {
        IProject project = this.createProject("testFileAdditions", new String[]{"changed.txt", "folder1/", "folder1/deleted.txt", "folder1/a.txt"});
        project.getFolder("folder1/folder2").create(false, true, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/folder2/"}, true);
        project.getFolder("folder1/folder2").delete(false, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, null, true);
        project.getFolder("folder1/folder2").create(false, true, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/folder2/"}, true);
        this.buildResources((IContainer)project, new String[]{"folder1/folder2/file.txt"}, false);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/folder2/", "folder1/folder2/file.txt"}, true);
        project.getFolder("folder1/folder2").delete(false, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, null, true);
        project.getFolder("folder1").delete(false, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/deleted.txt", "folder1/a.txt"}, true);
        project.getFolder("folder1").create(false, true, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/deleted.txt", "folder1/a.txt"}, true);
        this.replace(new IResource[]{project.getFile("folder1/deleted.txt"), project.getFile("folder1/a.txt")}, null, true);
        this.assertModificationState((IContainer)project, null, true);
        project.getFolder("folder1").delete(false, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/deleted.txt", "folder1/a.txt"}, true);
        this.commitProject(project);
        this.assertModificationState((IContainer)project, null, true);
    }

    public void testFolderMoveAndCopy() throws CoreException, TeamException {
        IProject project;
        block2: {
            project = this.createProject("testFolderMoveAndCopy", new String[]{"changed.txt", "folder1/", "folder2/", "folder1/a.txt", "folder1/folder3/file.txt"});
            project.getFolder("folder1/folder3").move(project.getFolder("folder2/folder3").getFullPath(), false, DEFAULT_MONITOR);
            this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/folder3", "folder1/folder3/file.txt", "folder2/", "folder2/folder3/", "folder2/folder3/file.txt"}, true);
            this.commitResources((IContainer)project, new String[]{"folder1/folder3"});
            this.assertModificationState((IContainer)project, new String[]{".", "folder2/", "folder2/folder3/", "folder2/folder3/file.txt"}, true);
            project.getFolder("folder2/folder3/").copy(project.getFolder("folder1/folder3").getFullPath(), false, DEFAULT_MONITOR);
            this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/folder3", "folder1/folder3/file.txt", "folder2/", "folder2/folder3/", "folder2/folder3/file.txt"}, true);
            this.addResources(new IResource[]{project.getFile("folder1/folder3/file.txt")});
            project.getFolder("folder2/folder3").delete(false, DEFAULT_MONITOR);
            this.commitProject(project);
            this.assertModificationState((IContainer)project, null, true);
            project.getFolder("folder1/folder3").move(project.getFolder("folder2/folder3").getFullPath(), false, DEFAULT_MONITOR);
            this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/folder3", "folder1/folder3/file.txt", "folder2/", "folder2/folder3/", "folder2/folder3/file.txt"}, true);
            project.getFolder("folder2/folder3/").copy(project.getFolder("folder1/folder3").getFullPath(), false, DEFAULT_MONITOR);
            this.assertModificationState((IContainer)project, new String[]{".", "folder1/", "folder1/folder3", "folder1/folder3/file.txt", "folder2/", "folder2/folder3/", "folder2/folder3/file.txt"}, true);
            this.addResources(new IResource[]{project.getFolder("folder2/folder3/")});
            try {
                this.commitProject(project);
            }
            catch (CVSException e) {
                if (e.getStatus().getSeverity() != 4) break block2;
                throw e;
            }
        }
        this.assertModificationState((IContainer)project, null, true);
    }

    public void testUpdate() throws TeamException, CoreException {
        IProject project = this.createProject("testUpdate", new String[]{"changed.txt", "merged.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        IProject copy = this.checkoutCopy(project, "-copy");
        this.assertModificationState((IContainer)copy, null, true);
        this.addResources((IContainer)copy, new String[]{"added.txt", "folder2/", "folder2/added.txt"}, false);
        this.setContentsAndEnsureModified(copy.getFile("changed.txt"));
        this.setContentsAndEnsureModified(copy.getFile("merged.txt"));
        this.deleteResources(new IResource[]{copy.getFile("deleted.txt")});
        this.assertModificationState((IContainer)copy, new String[]{".", "added.txt", "folder2/", "folder2/added.txt", "changed.txt", "merged.txt", "deleted.txt"}, true);
        this.commitResources(new IResource[]{copy}, 2);
        this.assertModificationState((IContainer)copy, null, true);
        this.setContentsAndEnsureModified(project.getFile("merged.txt"));
        this.updateProject(project, null, false);
        this.assertModificationState((IContainer)project, new String[]{".", "merged.txt"}, true);
    }

    public void testUpdateIgnoreLocal() throws TeamException, CoreException {
        IProject project = this.createProject("testUpdateIgnoreLocal", new String[]{"changed.txt", "merged.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        this.setContentsAndEnsureModified(project.getFile("changed.txt"));
        this.assertModificationState((IContainer)project, new String[]{".", "changed.txt"}, true);
        this.updateProject(project, null, true);
        this.assertModificationState((IContainer)project, null, true);
    }

    public void testExternalDeletion() throws CoreException, TeamException {
        IProject project = this.createProject("testExternalDeletion", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/folder2/b.txt"});
        IFile file = project.getFile("folder1/unmanaged.txt");
        file.create((InputStream)new ByteArrayInputStream("stuff".getBytes()), false, DEFAULT_MONITOR);
        file.getLocation().toFile().delete();
        file.refreshLocal(0, DEFAULT_MONITOR);
        IsModifiedTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        this.assertModificationState((IContainer)project, null, true);
    }

    public void testIgnoredAfterCheckout() throws TeamException, CoreException {
        IProject project = this.createProject("testIgnoredAfterCheckout", new String[]{".changed.txt", "deleted.txt", "folder1/", "folder1/a.txt", "folder1/folder2/b.txt"});
        project.getFile(".cvsignore").create((InputStream)new ByteArrayInputStream("ignored".getBytes()), false, DEFAULT_MONITOR);
        this.addResources(new IResource[]{project.getFile(".cvsignore")});
        this.commitProject(project);
        this.assertModificationState((IContainer)project, null, true);
        project.getFolder("ignored").create(false, true, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)project, null, true);
        IProject copy = this.checkoutCopy(project, "-copy");
        this.assertModificationState((IContainer)copy, null, true);
        copy.getFolder("ignored").create(false, true, DEFAULT_MONITOR);
        this.assertModificationState((IContainer)copy, null, true);
    }

    public void testBug62547() throws TeamException, CoreException {
        IProject project = this.createProject("testBug62547Project", new String[]{"file1.txt", "file2.txt"});
        this.setContentsAndEnsureModified(project.getFile("file1.txt"));
        this.setContentsAndEnsureModified(project.getFile("file2.txt"));
        project.getFile("file2.txt").setLocalTimeStamp(project.getFile("file1.txt").getLocalTimeStamp());
        IsModifiedTests.assertEquals((long)project.getFile("file1.txt").getLocalTimeStamp(), (long)project.getFile("file2.txt").getLocalTimeStamp());
        this.commitResources((IContainer)project, new String[]{"file1.txt", "file2.txt"});
        project.getFile("file1.txt").delete(true, this.getMonitor());
        project.getFile("file2.txt").copy(project.getFile("file1.txt").getFullPath(), true, this.getMonitor());
        IsModifiedTests.assertEquals((long)project.getFile("file1.txt").getLocalTimeStamp(), (long)project.getFile("file2.txt").getLocalTimeStamp());
        this.assertModificationState((IContainer)project, new String[]{".", "file1.txt"}, true);
    }
}

