/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.provider;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import junit.framework.Test;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot;
import org.eclipse.team.tests.ccvs.core.EclipseTest;

public class RepositoryRootTest
extends EclipseTest {
    private RepositoryRoot repositoryRoot;
    private RepositoryManager repositoryManager;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.repositoryManager = CVSUIPlugin.getPlugin().getRepositoryManager();
        this.repositoryRoot = this.repositoryManager.getRepositoryRootFor((ICVSRepositoryLocation)this.getRepository());
        this.clearRepositoryRootCache();
    }

    public static Test suite() {
        return RepositoryRootTest.suite(RepositoryRootTest.class);
    }

    private void clearRepositoryRootCache() {
        String[] remotePaths = this.repositoryRoot.getKnownRemotePaths();
        int i = 0;
        while (i < remotePaths.length) {
            this.repositoryRoot.removeTags(remotePaths[i], this.repositoryRoot.getAllKnownTags(remotePaths[i]));
            ++i;
        }
        RepositoryRootTest.assertEquals((String)"Repository cache was not cleaned.", (int)0, (int)this.repositoryRoot.getAllKnownTags().length);
    }

    private CVSTag[] refreshTags(IProject project) throws TeamException {
        return this.refreshTags(CVSWorkspaceRoot.getCVSFolderFor((IContainer)project));
    }

    private CVSTag[] refreshTags(ICVSFolder folder) throws TeamException {
        return this.repositoryManager.refreshDefinedTags(folder, true, true, DEFAULT_MONITOR);
    }

    private IProject createProject(String baseName, String repoPrefix) throws CoreException {
        IProject project = this.getUniqueTestProject(baseName);
        this.shareProject(this.getRepository(), project, repoPrefix == null ? project.getName() : String.valueOf(repoPrefix) + "/" + project.getName(), DEFAULT_MONITOR);
        this.assertValidCheckout(project);
        this.addResources((IContainer)project, new String[]{"file1.txt"}, true);
        return project;
    }

    private void assertTags(List knownTags, CVSTag[] tagsToHave, CVSTag[] tagsNotToHave) {
        int i = 0;
        while (i < tagsToHave.length) {
            RepositoryRootTest.assertTrue((String)("Missing tag " + tagsToHave[i].getName()), (boolean)knownTags.contains(tagsToHave[i]));
            ++i;
        }
        i = 0;
        while (i < tagsNotToHave.length) {
            RepositoryRootTest.assertFalse((String)("Extraneous tag " + tagsNotToHave[i].getName()), (boolean)knownTags.contains(tagsNotToHave[i]));
            ++i;
        }
    }

    private void assertProjectTags(CVSCacheTestData data) throws CVSException {
        List<CVSTag> knownTags = Arrays.asList(this.repositoryRoot.getAllKnownTags());
        this.assertTags(knownTags, new CVSTag[]{data.branch_1, data.branch_2, data.branch_3, data.version_1, data.version_2, data.version_3}, new CVSTag[0]);
        knownTags = Arrays.asList(this.repositoryManager.getKnownTags(CVSWorkspaceRoot.getCVSFolderFor((IContainer)data.project1)));
        this.assertTags(knownTags, new CVSTag[]{data.branch_1, data.branch_2, data.version_1, data.version_2}, new CVSTag[]{data.branch_3, data.version_3});
        knownTags = Arrays.asList(this.repositoryManager.getKnownTags(CVSWorkspaceRoot.getCVSFolderFor((IContainer)data.project2)));
        this.assertTags(knownTags, new CVSTag[]{data.branch_1, data.branch_3, data.version_1, data.version_3}, new CVSTag[]{data.branch_2, data.version_2});
    }

    public void testProjectsAtRoot() throws CoreException {
        CVSCacheTestData data = new CVSCacheTestData(null, null);
        this.assertProjectTags(data);
        this.clearRepositoryRootCache();
        this.refreshTags(data.project1);
        this.refreshTags(data.project2);
        this.assertProjectTags(data);
    }

    public void testProjectsInSubmodule() throws CoreException {
        String submodule = "Submodule_1" + System.currentTimeMillis();
        CVSCacheTestData data = new CVSCacheTestData(submodule, submodule);
        ICVSRemoteFolder submoduleFolder = this.repositoryRoot.getRemoteFolder(submodule, null, this.getMonitor());
        this.assertProjectTags(data);
        this.clearRepositoryRootCache();
        this.refreshTags(data.project1);
        this.refreshTags(data.project2);
        this.assertProjectTags(data);
        List<CVSTag> knownTags = Arrays.asList(this.repositoryManager.getKnownTags((ICVSFolder)submoduleFolder));
        this.assertTags(knownTags, new CVSTag[]{data.branch_1, data.branch_2, data.branch_3, data.version_1, data.version_2, data.version_3}, new CVSTag[0]);
        this.clearRepositoryRootCache();
        this.refreshTags((ICVSFolder)submoduleFolder);
        this.assertProjectTags(data);
        knownTags = Arrays.asList(this.repositoryManager.getKnownTags((ICVSFolder)submoduleFolder));
        this.assertTags(knownTags, new CVSTag[]{data.branch_1, data.branch_2, data.branch_3, data.version_1, data.version_2, data.version_3}, new CVSTag[0]);
    }

    public void testProjectsInTwoSubmodules() throws CoreException {
        String submodule1 = "Submodule_1" + System.currentTimeMillis();
        String submodule2 = "Submodule_2" + System.currentTimeMillis();
        CVSCacheTestData data = new CVSCacheTestData(submodule1, submodule2);
        ICVSRemoteFolder submoduleFolder1 = this.repositoryRoot.getRemoteFolder(submodule1, null, this.getMonitor());
        ICVSRemoteFolder submoduleFolder2 = this.repositoryRoot.getRemoteFolder(submodule2, null, this.getMonitor());
        this.assertProjectTags(data);
        this.clearRepositoryRootCache();
        this.refreshTags(data.project1);
        this.refreshTags(data.project2);
        this.assertProjectTags(data);
        List<CVSTag> knownTags = Arrays.asList(this.repositoryManager.getKnownTags((ICVSFolder)submoduleFolder1));
        this.assertTags(knownTags, new CVSTag[]{data.branch_1, data.branch_2, data.version_1, data.version_2}, new CVSTag[]{data.branch_3, data.version_3});
        knownTags = Arrays.asList(this.repositoryManager.getKnownTags((ICVSFolder)submoduleFolder2));
        this.assertTags(knownTags, new CVSTag[]{data.branch_1, data.branch_3, data.version_1, data.version_3}, new CVSTag[]{data.branch_2, data.version_2});
        this.clearRepositoryRootCache();
        this.refreshTags((ICVSFolder)submoduleFolder1);
        knownTags = Arrays.asList(this.repositoryManager.getKnownTags((ICVSFolder)submoduleFolder1));
        this.assertTags(knownTags, new CVSTag[]{data.branch_1, data.branch_2, data.version_1, data.version_2}, new CVSTag[]{data.branch_3, data.version_3});
        knownTags = Arrays.asList(this.repositoryRoot.getAllKnownTags());
        this.assertTags(knownTags, new CVSTag[]{data.branch_1, data.branch_2, data.version_1, data.version_2}, new CVSTag[]{data.branch_3, data.version_3});
        this.refreshTags((ICVSFolder)submoduleFolder2);
        knownTags = Arrays.asList(this.repositoryManager.getKnownTags((ICVSFolder)submoduleFolder2));
        this.assertTags(knownTags, new CVSTag[]{data.branch_1, data.branch_3, data.version_1, data.version_3}, new CVSTag[]{data.branch_2, data.version_2});
        this.assertProjectTags(data);
    }

    public void testNestedProjects() throws CoreException {
        IProject superProject = this.createProject("SuperProject", (String)null);
        CVSTag superProjectBranch = new CVSTag("Branch_" + superProject.getName(), 1);
        CVSTag superProjectVersion = new CVSTag("Root_" + superProjectBranch.getName(), 2);
        this.makeBranch(new IResource[]{superProject}, superProjectVersion, superProjectBranch, true);
        IProject subProject1 = this.createProject("SubProject_1", superProject.getName());
        CVSTag subProject1Branch = new CVSTag("Branch_" + subProject1.getName(), 1);
        CVSTag subProject1Version = new CVSTag("Root_" + subProject1Branch.getName(), 2);
        this.makeBranch(new IResource[]{subProject1}, subProject1Version, subProject1Branch, true);
        IProject subProject2 = this.createProject("SubProject_2", superProject.getName());
        CVSTag subProject2Branch = new CVSTag("Branch_" + subProject2.getName(), 1);
        CVSTag subProject2Version = new CVSTag("Root_" + subProject2Branch.getName(), 2);
        this.makeBranch(new IResource[]{subProject2}, subProject2Version, subProject2Branch, true);
        List<CVSTag> knownTags = Arrays.asList(this.repositoryManager.getKnownTags(CVSWorkspaceRoot.getCVSFolderFor((IContainer)superProject)));
        this.assertTags(knownTags, new CVSTag[]{superProjectBranch, superProjectVersion, subProject1Branch, subProject1Version, subProject2Branch, subProject2Version}, new CVSTag[0]);
        knownTags = Arrays.asList(this.repositoryManager.getKnownTags(CVSWorkspaceRoot.getCVSFolderFor((IContainer)subProject1)));
        this.assertTags(knownTags, new CVSTag[]{superProjectBranch, superProjectVersion, subProject1Branch, subProject1Version}, new CVSTag[]{subProject2Branch, subProject2Version});
        knownTags = Arrays.asList(this.repositoryManager.getKnownTags(CVSWorkspaceRoot.getCVSFolderFor((IContainer)subProject2)));
        this.assertTags(knownTags, new CVSTag[]{superProjectBranch, superProjectVersion, subProject2Branch, subProject2Version}, new CVSTag[]{subProject1Branch, subProject1Version});
        this.repositoryManager.removeTags(CVSWorkspaceRoot.getCVSFolderFor((IContainer)subProject1), new CVSTag[]{superProjectBranch, superProjectVersion});
        knownTags = Arrays.asList(this.repositoryManager.getKnownTags(CVSWorkspaceRoot.getCVSFolderFor((IContainer)superProject)));
        this.assertTags(knownTags, new CVSTag[]{superProjectBranch, superProjectVersion, subProject1Branch, subProject1Version, subProject2Branch, subProject2Version}, new CVSTag[0]);
        knownTags = Arrays.asList(this.repositoryManager.getKnownTags(CVSWorkspaceRoot.getCVSFolderFor((IContainer)subProject1)));
        this.assertTags(knownTags, new CVSTag[]{subProject1Branch, subProject1Version}, new CVSTag[]{subProject2Branch, subProject2Version});
        knownTags = Arrays.asList(this.repositoryManager.getKnownTags(CVSWorkspaceRoot.getCVSFolderFor((IContainer)subProject2)));
        this.assertTags(knownTags, new CVSTag[]{superProjectBranch, superProjectVersion, subProject2Branch, subProject2Version}, new CVSTag[]{subProject1Branch, subProject1Version});
    }

    public void testTagsForSubfolder() throws TeamException, CoreException {
        IProject project = this.createProject("Project_1", (String)null);
        String folderName = "testFolder";
        this.addResources((IContainer)project, new String[]{String.valueOf(folderName) + "/", String.valueOf(folderName) + "/testFile.txt"}, true);
        IFolder folder = project.getFolder(folderName);
        CVSTag branch1 = new CVSTag("Branch_1" + System.currentTimeMillis(), 1);
        CVSTag version1 = new CVSTag("Root_" + branch1.getName(), 2);
        this.makeBranch(new IResource[]{project}, version1, branch1, true);
        ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)folder);
        List<CVSTag> knownTags = Arrays.asList(this.repositoryManager.getKnownTags(cvsFolder));
        this.assertTags(knownTags, new CVSTag[]{branch1, version1}, new CVSTag[0]);
        this.repositoryManager.removeTags(cvsFolder, new CVSTag[]{branch1, version1});
        knownTags = Arrays.asList(this.repositoryManager.getKnownTags(cvsFolder));
        this.assertTags(knownTags, new CVSTag[0], new CVSTag[]{branch1, version1});
        this.refreshTags(cvsFolder);
        knownTags = Arrays.asList(this.repositoryManager.getKnownTags(cvsFolder));
        this.assertTags(knownTags, new CVSTag[]{branch1, version1}, new CVSTag[0]);
        knownTags = Arrays.asList(this.repositoryManager.getKnownTags(CVSWorkspaceRoot.getCVSFolderFor((IContainer)project)));
        this.assertTags(knownTags, new CVSTag[]{branch1, version1}, new CVSTag[0]);
    }

    public void testRefreshProjectUsingAutoRefreshFile() throws CoreException {
        IProject project = this.createProject("Project_1", (String)null);
        String autoRefreshFileName = "sampleAuthoRefresh.txt";
        String notAutoRefreshFileName = "notAutoRefresh.txt";
        this.addResources((IContainer)project, new String[]{autoRefreshFileName, notAutoRefreshFileName}, true);
        IFile autoRefreshFile = project.getFile(autoRefreshFileName);
        IFile notAutoRefreshFile = project.getFile(notAutoRefreshFileName);
        this.repositoryManager.setAutoRefreshFiles(CVSWorkspaceRoot.getCVSFolderFor((IContainer)project), new String[]{CVSWorkspaceRoot.getCVSResourceFor((IResource)autoRefreshFile).getRepositoryRelativePath()});
        CVSTag branch1 = new CVSTag("Branch_1" + System.currentTimeMillis(), 1);
        CVSTag version1 = new CVSTag("Root_" + branch1.getName(), 2);
        this.makeBranch(new IResource[]{autoRefreshFile}, version1, branch1, true);
        CVSTag branch2 = new CVSTag("Branch_2" + System.currentTimeMillis(), 1);
        CVSTag version2 = new CVSTag("Root_" + branch2.getName(), 2);
        this.makeBranch(new IResource[]{notAutoRefreshFile}, version2, branch2, true);
        this.clearRepositoryRootCache();
        this.refreshTags(project);
        List<CVSTag> knownTags = Arrays.asList(this.repositoryManager.getKnownTags(CVSWorkspaceRoot.getCVSFolderFor((IContainer)project)));
        this.assertTags(knownTags, new CVSTag[]{branch1, version1}, new CVSTag[]{branch2, version2});
    }

    public void testProjectWithNoTags() throws CoreException {
        IProject project = this.createProject("Project_1", (String)null);
        CVSTag[] knownTags = this.repositoryManager.getKnownTags(CVSWorkspaceRoot.getCVSFolderFor((IContainer)project));
        RepositoryRootTest.assertEquals((int)0, (int)knownTags.length);
        knownTags = this.refreshTags(project);
        RepositoryRootTest.assertEquals((int)0, (int)knownTags.length);
    }

    public void testDateTags() throws CoreException {
        CVSTag dateTag = new CVSTag(new Date());
        this.repositoryManager.addDateTag((ICVSRepositoryLocation)this.getRepository(), dateTag);
        CVSTag[] dateTags = this.repositoryManager.getDateTags((ICVSRepositoryLocation)this.getRepository());
        RepositoryRootTest.assertEquals((int)1, (int)dateTags.length);
        RepositoryRootTest.assertEquals((Object)dateTag, (Object)dateTags[0]);
        dateTags = this.repositoryManager.getKnownTags((ICVSRepositoryLocation)this.getRepository(), 3);
        RepositoryRootTest.assertEquals((int)1, (int)dateTags.length);
        RepositoryRootTest.assertEquals((Object)dateTag, (Object)dateTags[0]);
        IProject project = this.createProject("Project_1", (String)null);
        CVSTag[] allTags = this.repositoryManager.getKnownTags(CVSWorkspaceRoot.getCVSFolderFor((IContainer)project));
        RepositoryRootTest.assertEquals((int)1, (int)allTags.length);
        RepositoryRootTest.assertEquals((Object)dateTag, (Object)allTags[0]);
    }

    private class CVSCacheTestData {
        IProject project1;
        IProject project2;
        CVSTag branch_1;
        CVSTag branch_2;
        CVSTag branch_3;
        CVSTag version_1;
        CVSTag version_2;
        CVSTag version_3;

        private void init(String project1Path, String project2Path) throws CoreException {
            this.project1 = RepositoryRootTest.this.createProject("Project_1", project1Path);
            this.project2 = RepositoryRootTest.this.createProject("Project_2", project2Path);
            this.branch_1 = new CVSTag("Branch_1" + System.currentTimeMillis(), 1);
            this.version_1 = new CVSTag("Root_" + this.branch_1.getName(), 2);
            this.branch_2 = new CVSTag("Branch_2" + System.currentTimeMillis(), 1);
            this.version_2 = new CVSTag("Root_" + this.branch_2.getName(), 2);
            this.branch_3 = new CVSTag("Branch_3" + System.currentTimeMillis(), 1);
            this.version_3 = new CVSTag("Root_" + this.branch_3.getName(), 2);
            RepositoryRootTest.this.makeBranch(new IResource[]{this.project1, this.project2}, this.version_1, this.branch_1, true);
            RepositoryRootTest.this.makeBranch(new IResource[]{this.project1}, this.version_2, this.branch_2, true);
            RepositoryRootTest.this.makeBranch(new IResource[]{this.project2}, this.version_3, this.branch_3, true);
        }

        public CVSCacheTestData(String project1Path, String project2Path) throws CoreException {
            this.init(project1Path, project2Path);
        }
    }
}

