/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.provider;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.EclipseTest;

public class WatchEditTest
extends EclipseTest {
    public WatchEditTest() {
    }

    public WatchEditTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(WatchEditTest.class);
        return new CVSTestSetup((Test)suite);
    }

    @Override
    protected boolean isFailOnSyncInfoMismatch() {
        return CVSTestSetup.FAIL_ON_BAD_DIFF;
    }

    private void setReadOnly(boolean b) {
        CVSProviderPlugin.getPlugin().getPluginPreferences().setValue("cvs.read.only", b);
    }

    public void testReadOnlyCheckout() throws CoreException, TeamException {
        IProject project = this.createProject("testReadOnlyCheckout", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        IProject copy = this.checkoutCopy(project, "copy");
        this.assertReadOnly(new IResource[]{copy}, true, true);
    }

    public void testEditUnedit() throws CoreException, TeamException, IOException {
        IProject project = this.createProject("testEditUnedit", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        IProject copy = this.checkoutCopy(project, "copy");
        this.assertReadOnly(new IResource[]{copy}, true, true);
        this.editResources((IContainer)copy, new String[]{"changed.txt", "deleted.txt"});
        this.setContentsAndEnsureModified(copy.getFile("changed.txt"));
        this.deleteResources((IContainer)copy, new String[]{"deleted.txt"}, false);
        this.uneditResources((IContainer)copy, new String[]{"changed.txt", "deleted.txt"});
        this.assertEquals(project, copy);
    }

    public void testCommit() throws CoreException, TeamException, IOException {
        IProject project = this.createProject("testCommit", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        IProject copy = this.checkoutCopy(project, "copy");
        this.editResources((IContainer)copy, new String[]{"changed.txt"});
        this.setContentsAndEnsureModified(copy.getFile("changed.txt"));
        this.commitProject(copy);
        this.assertReadOnly(new IResource[]{copy.getFile("changed.txt")}, true, true);
    }

    public void testEditMergeUnedit() throws CoreException, TeamException, IOException {
        IProject project = this.createProject("testEditMergeUnedit", new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"});
        IProject copy = this.checkoutCopy(project, "copy");
        IProject copy2 = this.checkoutCopy(project, "copy2");
        this.editResources((IContainer)copy2, new String[]{"changed.txt"});
        this.setContentsAndEnsureModified(copy2.getFile("changed.txt"));
        this.commitProject(copy2);
        this.editResources((IContainer)copy, new String[]{"changed.txt"});
        this.setContentsAndEnsureModified(copy.getFile("changed.txt"));
        this.updateProject(copy, CVSTag.DEFAULT, false);
        if (copy.getFile("changed.txt").isReadOnly()) {
            this.editResources((IContainer)copy, new String[]{"changed.txt"});
        }
        this.uneditResources((IContainer)copy, new String[]{"changed.txt", "deleted.txt"});
        IFile backup = copy.getFile(".#changed.txt.1.1");
        if (backup.exists()) {
            backup.delete(true, false, null);
        }
        this.assertEquals(project, copy);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setReadOnly(true);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.setReadOnly(false);
    }
}

