/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.subscriber;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMergeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSSyncTreeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.subscriber.CVSSyncSubscriberTest;

public class CVSMergeSubscriberTest
extends CVSSyncSubscriberTest {
    public static Test suite() {
        String testName = System.getProperty("eclipse.cvs.testName");
        if (testName == null) {
            TestSuite suite = new TestSuite(CVSMergeSubscriberTest.class);
            return new CVSTestSetup((Test)suite);
        }
        return new CVSTestSetup((Test)new CVSMergeSubscriberTest(testName));
    }

    public CVSMergeSubscriberTest() {
    }

    public CVSMergeSubscriberTest(String name) {
        super(name);
    }

    private IProject branchProject(IProject project, CVSTag root, CVSTag branch) throws TeamException {
        IProject copy = this.checkoutCopy(project, "-copy");
        this.tagProject(project, root, false);
        this.tagProject(project, branch, false);
        this.updateProject(copy, branch, false);
        return copy;
    }

    private void mergeResources(CVSMergeSubscriber subscriber, IProject project, String[] resourcePaths, boolean allowOverwrite) throws CoreException, TeamException, InvocationTargetException, InterruptedException {
        IResource[] resources = this.getResources((IContainer)project, resourcePaths);
        this.getSyncInfoSource().mergeResources((Subscriber)subscriber, resources, allowOverwrite);
    }

    public void testIncomingChanges() throws InvocationTargetException, InterruptedException, CVSException, CoreException, IOException {
        IProject project = this.createProject("testIncomingChanges", new String[]{"file1.txt", "file2.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        CVSTag root = new CVSTag("root_branch1", 2);
        CVSTag branch = new CVSTag("branch1", 1);
        IProject copy = this.branchProject(project, root, branch);
        this.addResources((IContainer)copy, new String[]{"addition.txt", "folderAddition/", "folderAddition/new.txt"}, true);
        this.deleteResources((IContainer)copy, new String[]{"folder1/a.txt"}, true);
        this.appendText((IResource)copy.getFile("file1.txt"), "Appended text 1", false);
        this.commitProject(copy);
        this.appendText((IResource)copy.getFile("file1.txt"), "Appended text 2", false);
        this.commitProject(copy);
        this.appendText((IResource)copy.getFile("file2.txt"), "appended text", false);
        this.commitProject(copy);
        this.appendText((IResource)project.getFile("file2.txt"), "prefixed text", true);
        this.commitProject(project);
        CVSMergeSubscriber subscriber = this.getSyncInfoSource().createMergeSubscriber(project, root, branch);
        int[] nArray = new int[7];
        nArray[0] = 11;
        nArray[1] = 15;
        nArray[3] = 10;
        nArray[4] = 9;
        nArray[5] = 9;
        nArray[6] = 9;
        this.assertSyncEquals("testIncomingChanges", (Subscriber)subscriber, (IContainer)project, new String[]{"file1.txt", "file2.txt", "folder1/", "folder1/a.txt", "addition.txt", "folderAddition/", "folderAddition/new.txt"}, true, nArray);
        this.mergeResources(subscriber, project, new String[]{"file1.txt", "file2.txt", "folder1/a.txt", "addition.txt", "folderAddition/", "folderAddition/new.txt"}, true);
        int[] nArray2 = new int[7];
        nArray2[0] = 7;
        nArray2[1] = 7;
        nArray2[3] = 6;
        nArray2[4] = 5;
        nArray2[6] = 5;
        this.assertSyncEquals("testIncomingChanges", this.getWorkspaceSubscriber(), (IContainer)project, new String[]{"file1.txt", "file2.txt", "folder1/", "folder1/a.txt", "addition.txt", "folderAddition/", "folderAddition/new.txt"}, true, nArray2);
        this.assertEndsWith(project.getFile("file1.txt"), "Appended text 1" + eol + "Appended text 2");
        this.assertStartsWith(project.getFile("file2.txt"), "prefixed text");
        this.assertEndsWith(project.getFile("file2.txt"), "appended text");
    }

    public void _test46007() throws InvocationTargetException, InterruptedException, CVSException, CoreException, IOException {
        IProject project = this.createProject("test46007", new String[]{"file1.txt"});
        this.appendText((IResource)project.getFile("file1.txt"), "dummy", true);
        this.commitProject(project);
        CVSTag root = new CVSTag("root_branch1", 2);
        CVSTag branch = new CVSTag("branch1", 1);
        IProject copy = this.branchProject(project, root, branch);
        this.appendText((IResource)copy.getFile("file1.txt"), "Appended text 1", true);
        this.commitProject(copy);
        CVSTag root2 = new CVSTag("v1", 2);
        this.tagProject(copy, root2, true);
        this.appendText((IResource)copy.getFile("file1.txt"), "Appended text 2", false);
        this.commitProject(copy);
        CVSTag root3 = new CVSTag("v2", 2);
        this.tagProject(copy, root3, true);
        CVSMergeSubscriber subscriber = this.getSyncInfoSource().createMergeSubscriber(project, root2, root3);
        this.assertSyncEquals("test46007", (Subscriber)subscriber, (IContainer)project, new String[]{"file1.txt"}, true, new int[]{15});
        this.mergeResources(subscriber, project, new String[]{"file1.txt"}, true);
        this.assertSyncEquals("test46007", this.getWorkspaceSubscriber(), (IContainer)project, new String[]{"file1.txt"}, true, new int[]{7});
        this.assertEndsWith(project.getFile("file1.txt"), "Appended text 2");
        this.assertStartsWith(project.getFile("file1.txt"), "dummy");
    }

    public void testMergableConflicts() throws IOException, TeamException, CoreException, InvocationTargetException, InterruptedException {
        IProject project = this.createProject("testMergableConflicts", new String[]{"file1.txt", "file2.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        this.setContentsAndEnsureModified(project.getFile("file1.txt"), "some text\nwith several lines\n");
        this.setContentsAndEnsureModified(project.getFile("file2.txt"), "some text\nwith several lines\n");
        this.commitProject(project);
        CVSTag root = new CVSTag("root_branch1", 2);
        CVSTag branch = new CVSTag("branch1", 1);
        IProject branchedProject = this.branchProject(project, root, branch);
        this.appendText((IResource)branchedProject.getFile("file1.txt"), "first line\n", true);
        this.appendText((IResource)branchedProject.getFile("file2.txt"), "last line\n", false);
        this.commitProject(branchedProject);
        this.appendText((IResource)project.getFile("file1.txt"), "last line\n", false);
        this.commitProject(project);
        this.appendText((IResource)project.getFile("file2.txt"), "first line\n", true);
        CVSMergeSubscriber subscriber = this.getSyncInfoSource().createMergeSubscriber(project, root, branch);
        this.assertSyncEquals("testMergableConflicts", (Subscriber)subscriber, (IContainer)project, new String[]{"file1.txt", "file2.txt"}, true, new int[]{15, 15});
        this.mergeResources(subscriber, project, new String[]{"file1.txt", "file2.txt"}, false);
        this.assertSyncEquals("testMergableConflicts", this.getWorkspaceSubscriber(), (IContainer)project, new String[]{"file1.txt", "file2.txt"}, true, new int[]{7, 7});
    }

    public void testUnmergableConflicts() throws IOException, TeamException, CoreException, InvocationTargetException, InterruptedException {
        IProject project = this.createProject("testUnmergableConflicts", new String[]{"delete.txt", "file1.txt", "file2.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        this.setContentsAndEnsureModified(project.getFile("file1.txt"), "some text\nwith several lines\n");
        this.setContentsAndEnsureModified(project.getFile("file2.txt"), "some text\nwith several lines\n");
        this.commitProject(project);
        CVSTag root = new CVSTag("root_branch1", 2);
        CVSTag branch = new CVSTag("branch1", 1);
        IProject branchedProject = this.branchProject(project, root, branch);
        this.appendText((IResource)branchedProject.getFile("file1.txt"), "first line\n", true);
        this.appendText((IResource)branchedProject.getFile("file2.txt"), "last line\n", false);
        this.addResources((IContainer)branchedProject, new String[]{"addition.txt"}, false);
        this.deleteResources((IContainer)branchedProject, new String[]{"delete.txt", "folder1/a.txt"}, false);
        this.setContentsAndEnsureModified(branchedProject.getFile("folder1/b.txt"));
        this.commitProject(branchedProject);
        this.appendText((IResource)project.getFile("file1.txt"), "conflict line\n", true);
        this.setContentsAndEnsureModified(project.getFile("folder1/a.txt"));
        this.deleteResources((IContainer)project, new String[]{"delete.txt", "folder1/b.txt"}, false);
        this.addResources((IContainer)project, new String[]{"addition.txt"}, false);
        this.appendText((IResource)project.getFile("file2.txt"), "conflict line\n", false);
        CVSMergeSubscriber subscriber = this.getSyncInfoSource().createMergeSubscriber(project, root, branch);
        int[] nArray = new int[6];
        nArray[1] = 15;
        nArray[2] = 15;
        nArray[3] = 13;
        nArray[4] = 15;
        nArray[5] = 15;
        this.assertSyncEquals("testUnmergableConflicts", (Subscriber)subscriber, (IContainer)project, new String[]{"delete.txt", "file1.txt", "file2.txt", "addition.txt", "folder1/a.txt", "folder1/b.txt"}, true, nArray);
        this.commitProject(project);
        int[] nArray2 = new int[6];
        nArray2[1] = 15;
        nArray2[2] = 15;
        nArray2[3] = 13;
        nArray2[4] = 15;
        nArray2[5] = 15;
        this.assertSyncEquals("testUnmergableConflicts", (Subscriber)subscriber, (IContainer)project, new String[]{"delete.txt", "file1.txt", "file2.txt", "addition.txt", "folder1/a.txt", "folder1/b.txt"}, true, nArray2);
        this.mergeResources(subscriber, project, new String[]{"delete.txt", "file1.txt", "file2.txt", "addition.txt", "folder1/a.txt", "folder1/b.txt"}, true);
        this.assertSyncEquals("testUnmergableConflicts", this.getWorkspaceSubscriber(), (IContainer)project, new String[]{"file1.txt", "file2.txt", "addition.txt", "folder1/a.txt", "folder1/b.txt"}, true, new int[]{7, 7, 7, 6, 5});
        this.assertDeleted("testUnmergableConflicts", (IContainer)project, new String[]{"delete.txt"});
    }

    public void testLocalScrub() throws IOException, TeamException, CoreException, InvocationTargetException, InterruptedException {
        CVSMergeSubscriberTest.dumpProperties();
        IProject project = this.createProject("testLocalScrub", new String[]{"delete.txt", "file1.txt", "works.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        this.setContentsAndEnsureModified(project.getFile("file1.txt"), "some text\nwith several lines\n");
        this.setContentsAndEnsureModified(project.getFile("works.txt"), "some text\nwith several lines\n");
        this.commitProject(project);
        CVSTag root = new CVSTag("root_branch1", 2);
        CVSTag branch = new CVSTag("branch1", 1);
        IProject branchedProject = this.branchProject(project, root, branch);
        this.appendText((IResource)branchedProject.getFile("file1.txt"), "first line\n", true);
        this.appendText((IResource)branchedProject.getFile("works.txt"), "last line\n", false);
        this.addResources((IContainer)branchedProject, new String[]{"addition.txt"}, false);
        this.deleteResources((IContainer)branchedProject, new String[]{"delete.txt", "folder1/a.txt"}, false);
        this.setContentsAndEnsureModified(branchedProject.getFile("folder1/b.txt"));
        this.commitProject(branchedProject);
        CVSMergeSubscriber subscriber = this.getSyncInfoSource().createMergeSubscriber(project, root, branch);
        this.assertSyncEquals("testLocalScrub", (Subscriber)subscriber, (IContainer)project, new String[]{"delete.txt", "file1.txt", "works.txt", "addition.txt", "folder1/a.txt", "folder1/b.txt"}, true, new int[]{10, 11, 11, 9, 10, 11});
        project.refreshLocal(2, DEFAULT_MONITOR);
        IResource[] members = project.members();
        int i = 0;
        while (i < members.length) {
            IResource resource = members[i];
            if (!resource.getName().equals(".project")) {
                CVSMergeSubscriberTest.delete(resource, 1, DEFAULT_MONITOR);
            }
            ++i;
        }
        this.mergeResources(subscriber, project, new String[]{"delete.txt", "file1.txt", "works.txt", "addition.txt", "folder1/a.txt", "folder1/b.txt"}, true);
        this.commitProject(project);
    }

    private static void dumpProperties() {
        System.out.println("eclipse.cvs.repository: " + CVSTestSetup.REPOSITORY_LOCATION);
        System.out.println("eclipse.cvs.initrepo: " + CVSTestSetup.INITIALIZE_REPO);
        System.out.println("eclipse.cvs.debug: " + CVSTestSetup.DEBUG);
        System.out.println("eclipse.cvs.rsh: " + CVSTestSetup.RSH);
        System.out.println("eclipse.cvs.localRepo: " + CVSTestSetup.LOCAL_REPO);
        System.out.println("eclipse.cvs.waitFactor: " + CVSTestSetup.WAIT_FACTOR);
        System.out.println("eclipse.cvs.compressionLevel: " + CVSTestSetup.COMPRESSION_LEVEL);
        System.out.println("eclipse.cvs.failLog: " + CVSTestSetup.FAIL_IF_EXCEPTION_LOGGED);
        System.out.println("eclipse.cvs.recordProtocolTraffic: " + CVSTestSetup.RECORD_PROTOCOL_TRAFFIC);
        System.out.println("eclipse.cvs.sequentialAccess: " + CVSTestSetup.ENSURE_SEQUENTIAL_ACCESS);
        System.out.println("eclipse.cvs.failOnBadDiff: " + CVSTestSetup.FAIL_ON_BAD_DIFF);
    }

    public void testBug37546MergeWantsToDeleteNewDirectories() throws CVSException, CoreException {
        IProject project = this.createProject("testBug37546", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        this.setContentsAndEnsureModified(project.getFile("file1.txt"), "some text\nwith several lines\n");
        this.commitProject(project);
        CVSTag root = new CVSTag("root_branch1", 2);
        CVSTag branch = new CVSTag("branch1", 1);
        IProject branchedProject = this.branchProject(project, root, branch);
        this.addResources((IContainer)branchedProject, new String[]{"folder2/", "folder2/c.txt"}, true);
        this.addResources((IContainer)project, new String[]{"folder2/"}, true);
        this.addResources((IContainer)project, new String[]{"folder3/"}, true);
        this.addResources((IContainer)project, new String[]{"folder4/", "folder4/d.txt"}, false);
        CVSMergeSubscriber subscriber = this.getSyncInfoSource().createMergeSubscriber(project, root, branch);
        int[] nArray = new int[5];
        nArray[1] = 9;
        this.assertSyncEquals("testBug37546", (Subscriber)subscriber, (IContainer)project, new String[]{"folder2/", "folder2/c.txt", "folder3/", "folder4/", "folder4/d.txt"}, true, nArray);
    }

    public void testOutgoingDeletionAfterMergeBug53129() throws TeamException, CoreException, InvocationTargetException, InterruptedException {
        IProject project = this.createProject("testBug53129", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        this.setContentsAndEnsureModified(project.getFile("file1.txt"), "some text\nwith several lines\n");
        this.commitProject(project);
        CVSTag root = new CVSTag("root_branch1", 2);
        CVSTag branch = new CVSTag("branch1", 1);
        IProject branchedProject = this.branchProject(project, root, branch);
        this.deleteResources((IContainer)branchedProject, new String[]{"folder1/a.txt", "folder1/b.txt"}, true);
        CVSMergeSubscriber subscriber = this.getSyncInfoSource().createMergeSubscriber(project, root, branch);
        int[] nArray = new int[4];
        nArray[2] = 10;
        nArray[3] = 10;
        this.assertSyncEquals("testBug53129 - 1", (Subscriber)subscriber, (IContainer)project, new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"}, true, nArray);
        this.mergeResources(subscriber, project, new String[]{"folder1/a.txt", "folder1/b.txt"}, true);
        int[] nArray2 = new int[4];
        nArray2[2] = 6;
        nArray2[3] = 6;
        this.assertSyncEquals("testBug53129 - 2", this.getWorkspaceSubscriber(), (IContainer)project, new String[]{"file1.txt", "folder1", "folder1/a.txt", "folder1/b.txt"}, true, nArray2);
        IFolder f = project.getFolder("folder1");
        CVSMergeSubscriberTest.delete((IResource)f, 1, null);
        int[] nArray3 = new int[4];
        nArray3[2] = 6;
        nArray3[3] = 6;
        this.assertSyncEquals("testBug53129 - 3", this.getWorkspaceSubscriber(), (IContainer)project, new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"}, true, nArray3);
    }

    public void testDisconnectingProject() throws CoreException, IOException, TeamException, InterruptedException {
        IProject project = this.createProject("testDisconnect", new String[]{"file1.txt", "file2.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        this.setContentsAndEnsureModified(project.getFile("file1.txt"), "some text\nwith several lines\n");
        this.setContentsAndEnsureModified(project.getFile("file2.txt"), "some text\nwith several lines\n");
        this.commitProject(project);
        CVSTag root = new CVSTag("root_branch1", 2);
        CVSTag branch = new CVSTag("branch1", 1);
        IProject branchedProject = this.branchProject(project, root, branch);
        this.appendText((IResource)branchedProject.getFile("file1.txt"), "first line\n", true);
        this.appendText((IResource)branchedProject.getFile("file2.txt"), "last line\n", false);
        this.commitProject(branchedProject);
        CVSMergeSubscriber subscriber = this.getSyncInfoSource().createMergeSubscriber(project, root, branch);
        RepositoryProvider.unmap((IProject)project);
        this.assertProjectRemoved((Subscriber)subscriber, project);
    }

    public void testMarkAsMerged() throws IOException, TeamException, CoreException, InvocationTargetException, InterruptedException {
        IProject project = this.createProject("testMarkAsMerged", new String[]{"delete.txt", "file1.txt", "file2.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        this.setContentsAndEnsureModified(project.getFile("file1.txt"), "some text\nwith several lines\n");
        this.setContentsAndEnsureModified(project.getFile("file2.txt"), "some text\nwith several lines\n");
        this.commitProject(project);
        CVSTag root = new CVSTag("root_branch1", 2);
        CVSTag branch = new CVSTag("branch1", 1);
        IProject branchedProject = this.branchProject(project, root, branch);
        this.appendText((IResource)branchedProject.getFile("file1.txt"), "first line\n", true);
        this.appendText((IResource)branchedProject.getFile("file2.txt"), "last line\n", false);
        this.addResources((IContainer)branchedProject, new String[]{"addition.txt"}, false);
        this.deleteResources((IContainer)branchedProject, new String[]{"delete.txt", "folder1/a.txt"}, false);
        this.setContentsAndEnsureModified(branchedProject.getFile("folder1/b.txt"));
        this.commitProject(branchedProject);
        this.appendText((IResource)project.getFile("file1.txt"), "conflict line\n", true);
        this.setContentsAndEnsureModified(project.getFile("folder1/a.txt"));
        this.setContentsAndEnsureModified(project.getFile("delete.txt"));
        this.addResources((IContainer)project, new String[]{"addition.txt"}, false);
        this.appendText((IResource)project.getFile("file2.txt"), "conflict line\n", false);
        CVSMergeSubscriber subscriber = this.getSyncInfoSource().createMergeSubscriber(project, root, branch);
        this.assertSyncEquals("testMarkAsMergedConflicts", (Subscriber)subscriber, (IContainer)project, new String[]{"delete.txt", "file1.txt", "file2.txt", "addition.txt", "folder1/a.txt"}, true, new int[]{15, 15, 15, 13, 15});
        this.markAsMerged((CVSSyncTreeSubscriber)subscriber, project, new String[]{"delete.txt", "file1.txt", "file2.txt", "addition.txt", "folder1/a.txt"});
        this.assertSyncEquals("testMarkAsMerged", (Subscriber)subscriber, (IContainer)project, new String[]{"delete.txt", "file1.txt", "file2.txt", "addition.txt", "folder1/a.txt"}, true, new int[5]);
    }

    @Override
    protected void tearDown() throws Exception {
        this.getSyncInfoSource().tearDown();
        super.tearDown();
    }

    public void testDeletedAddition() throws TeamException, CoreException, InvocationTargetException, InterruptedException {
        IProject project = this.createProject("testDeletedAddition", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        CVSTag root = new CVSTag("root_branch1", 2);
        CVSTag branch = new CVSTag("branch1", 1);
        IProject branchedProject = this.branchProject(project, root, branch);
        this.addResources((IContainer)branchedProject, new String[]{"folder2/", "folder2/added.txt"}, true);
        CVSMergeSubscriber subscriber = this.getSyncInfoSource().createMergeSubscriber(project, root, branch);
        this.assertSyncEquals("testDeletedAddition", (Subscriber)subscriber, (IContainer)project, new String[]{"folder2/", "folder2/added.txt"}, true, new int[]{9, 9});
        this.mergeResources(subscriber, project, new String[]{"folder2/", "folder2/added.txt"}, true);
        this.assertSyncEquals("testDeletedAddition", (Subscriber)subscriber, (IContainer)project, new String[]{"folder2/", "folder2/added.txt"}, true, new int[2]);
        this.deleteResources((IContainer)branchedProject, new String[]{"folder2/added.txt"}, true);
        int[] nArray = new int[2];
        nArray[1] = 15;
        this.assertSyncEquals("testDeletedAddition", (Subscriber)subscriber, (IContainer)project, new String[]{"folder2/", "folder2/added.txt"}, true, nArray);
    }

    public void testFileAddedToBranch() throws InvocationTargetException, InterruptedException, CoreException, IOException {
        IProject project = this.createProject(new String[]{"delete.txt", "file1.txt", "file2.txt", "folder1/", "folder1/a.txt", "folder1/b.txt"});
        CVSTag root = new CVSTag("root_branch1", 2);
        CVSTag branch = new CVSTag("branch1", 1);
        IProject branchedProject = this.branchProject(project, root, branch);
        this.addResources((IContainer)branchedProject, new String[]{"folder2/", "folder2/added.txt"}, true);
        CVSMergeSubscriber subscriber = this.getSyncInfoSource().createMergeSubscriber(project, root, branch);
        this.assertSyncEquals("testFileAddedToBranch", (Subscriber)subscriber, (IContainer)project, new String[]{"folder2/", "folder2/added.txt"}, true, new int[]{9, 9});
        this.mergeResources(subscriber, project, new String[]{"folder2/", "folder2/added.txt"}, true);
        this.assertContentsEqual((IContainer)project, (IContainer)branchedProject);
        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)project.getFile("folder2/added.txt"));
        ResourceSyncInfo syncInfo = cvsFile.getSyncInfo();
        CVSTag tag = syncInfo.getTag();
        if (tag != null && !tag.equals((Object)CVSTag.DEFAULT)) {
            CVSMergeSubscriberTest.fail((String)"Invalid tag for added file");
        }
        this.setContentsAndEnsureModified(branchedProject.getFile("folder2/added.txt"), "Unmergable contents");
        this.commitProject(branchedProject);
        this.assertSyncEquals("testFileAddedToBranch", (Subscriber)subscriber, (IContainer)project, new String[]{"folder2/added.txt"}, true, new int[]{15});
        this.mergeResources(subscriber, project, new String[]{"folder2/added.txt"}, true);
        this.commitProject(project);
        this.assertContentsEqual((IContainer)project, (IContainer)branchedProject);
        this.setContentsAndEnsureModified(branchedProject.getFile("folder2/added.txt"), "More unmergable");
        this.commitProject(branchedProject);
        this.assertSyncEquals("testFileAddedToBranch", (Subscriber)subscriber, (IContainer)project, new String[]{"folder2/added.txt"}, true, new int[]{15});
        this.mergeResources(subscriber, project, new String[]{"folder2/added.txt"}, true);
        this.assertContentsEqual((IContainer)project, (IContainer)branchedProject);
    }

    public void testBinaryAddition() throws CoreException {
        Command.KSubstOption option = CVSProviderPlugin.getPlugin().getDefaultTextKSubstOption();
        try {
            CVSProviderPlugin.getPlugin().setDefaultTextKSubstOption(Command.KSUBST_TEXT_KEYWORDS_ONLY);
            IProject project = this.createProject(new String[]{"a.txt"});
            CVSTag root = new CVSTag("root_branch1", 2);
            CVSTag branch = new CVSTag("branch1", 1);
            IProject branchedProject = this.branchProject(project, root, branch);
            this.create((IResource)branchedProject.getFile("binaryFile"), true);
            this.setContentsAndEnsureModified(branchedProject.getFile("binaryFile"), "/n/n\n\n");
            this.addResources(new IResource[]{branchedProject.getFile("binaryFile")});
            this.commitProject(branchedProject);
            CVSMergeSubscriber subscriber = this.getSyncInfoSource().createMergeSubscriber(project, root, branch);
            this.getSyncInfoSource().refresh((Subscriber)subscriber, (IResource)project);
            this.getSyncInfoSource().updateResources((Subscriber)subscriber, new IResource[]{project.getFile("binaryFile")});
            this.assertContentsEqual(branchedProject.getFile("binaryFile"), project.getFile("binaryFile"));
        }
        finally {
            CVSProviderPlugin.getPlugin().setDefaultTextKSubstOption(option);
        }
    }

    public void testBinaryMarkAsMerged() throws CoreException, InvocationTargetException, InterruptedException {
        Command.KSubstOption option = CVSProviderPlugin.getPlugin().getDefaultTextKSubstOption();
        try {
            CVSProviderPlugin.getPlugin().setDefaultTextKSubstOption(Command.KSUBST_TEXT_KEYWORDS_ONLY);
            IProject project = this.createProject(new String[]{"a.txt"});
            CVSTag root = new CVSTag("root_branch1", 2);
            CVSTag branch = new CVSTag("branch1", 1);
            IProject branchedProject = this.branchProject(project, root, branch);
            this.create((IResource)branchedProject.getFile("binaryFile"), true);
            this.setContentsAndEnsureModified(branchedProject.getFile("binaryFile"), "/n/n\n\n");
            this.addResources(new IResource[]{branchedProject.getFile("binaryFile")});
            this.commitProject(branchedProject);
            this.create((IResource)project.getFile("binaryFile"), true);
            this.setContentsAndEnsureModified(project.getFile("binaryFile"), "/n/nSome Content\n\n");
            CVSMergeSubscriber subscriber = this.getSyncInfoSource().createMergeSubscriber(project, root, branch);
            this.getSyncInfoSource().refresh((Subscriber)subscriber, (IResource)project);
            this.getSyncInfoSource().markAsMerged((Subscriber)subscriber, new IResource[]{project.getFile("binaryFile")});
            this.assertIsBinary(project.getFile("binaryFile"));
        }
        finally {
            CVSProviderPlugin.getPlugin().setDefaultTextKSubstOption(option);
        }
    }

    public void testMergeNewFileToBranch() throws InvocationTargetException, InterruptedException, CoreException, IOException {
        IProject project = this.createProject(new String[]{"file1.txt"});
        CVSTag root = new CVSTag("root_branch1", 2);
        CVSTag branch = new CVSTag("branch1", 1);
        IProject branchedProject = this.branchProject(project, root, branch);
        this.addResources((IContainer)project, new String[]{"added.txt"}, true);
        CVSMergeSubscriber subscriber = this.getSyncInfoSource().createMergeSubscriber(branchedProject, root, CVSTag.DEFAULT);
        this.assertSyncEquals("testFileAddedToBranch", (Subscriber)subscriber, (IContainer)branchedProject, new String[]{"added.txt"}, true, new int[]{9});
        this.mergeResources(subscriber, branchedProject, new String[]{"added.txt"}, true);
        this.assertContentsEqual((IContainer)project, (IContainer)branchedProject);
        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)branchedProject.getFile("added.txt"));
        ResourceSyncInfo syncInfo = cvsFile.getSyncInfo();
        CVSMergeSubscriberTest.assertEquals((String)"Invalid tag for added file", (Object)syncInfo.getTag(), (Object)branch);
        this.addResources((IContainer)project, new String[]{"folder1/added.txt"}, true);
        this.assertSyncEquals("testFileAddedToBranch", (Subscriber)subscriber, (IContainer)branchedProject, new String[]{"folder1/added.txt"}, true, new int[]{9});
        this.mergeResources(subscriber, branchedProject, new String[]{"folder1/added.txt"}, true);
        this.assertContentsEqual((IContainer)project, (IContainer)branchedProject);
        cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)branchedProject.getFile("folder1/added.txt"));
        syncInfo = cvsFile.getSyncInfo();
        CVSMergeSubscriberTest.assertEquals((String)"Invalid tag for added file", (Object)syncInfo.getTag(), (Object)branch);
    }
}

