/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.subscriber;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.ISubscriberChangeListener;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberChangeEvent;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSSyncTreeSubscriber;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.tests.ccvs.core.EclipseTest;
import org.eclipse.team.tests.ccvs.core.subscriber.SyncInfoSource;
import org.eclipse.team.tests.ccvs.ui.ModelParticipantSyncInfoSource;

public abstract class CVSSyncSubscriberTest
extends EclipseTest {
    private ISubscriberChangeListener listener;
    private List accumulatedTeamDeltas = new ArrayList();
    private static SyncInfoSource source = new ModelParticipantSyncInfoSource();

    public CVSSyncSubscriberTest() {
    }

    public CVSSyncSubscriberTest(String name) {
        super(name);
    }

    public static void setSyncSource(SyncInfoSource newSource) {
        source = newSource;
    }

    protected Subscriber getWorkspaceSubscriber() throws TeamException {
        return this.getSyncInfoSource().createWorkspaceSubscriber();
    }

    public SyncInfoSource getSyncInfoSource() {
        CVSSyncSubscriberTest.assertNotNull((Object)source);
        return source;
    }

    protected void refresh(Subscriber subscriber, IResource resource) throws TeamException {
        this.getSyncInfoSource().refresh(subscriber, resource);
    }

    protected void assertSyncEquals(String message, Subscriber subscriber, IContainer root, String[] resourcePaths, boolean refresh, int[] syncKinds) throws CoreException, TeamException {
        CVSSyncSubscriberTest.assertTrue((resourcePaths.length == syncKinds.length ? 1 : 0) != 0);
        if (refresh) {
            this.refresh(subscriber, (IResource)root);
        }
        IResource[] resources = this.getResources(root, resourcePaths);
        int i = 0;
        while (i < resources.length) {
            this.assertSyncEquals(message, subscriber, resources[i], syncKinds[i]);
            ++i;
        }
    }

    protected void assertSyncEquals(String message, Subscriber subscriber, IResource resource, int syncKind) throws CoreException {
        this.getSyncInfoSource().assertSyncEquals(message, subscriber, resource, syncKind);
    }

    protected void assertDiffKindEquals(String message, Subscriber subscriber, IContainer root, String[] resourcePaths, boolean refresh, int[] diffKinds) throws CoreException, TeamException {
        CVSSyncSubscriberTest.assertTrue((resourcePaths.length == diffKinds.length ? 1 : 0) != 0);
        if (refresh) {
            this.refresh(subscriber, (IResource)root);
        }
        IResource[] resources = this.getResources(root, resourcePaths);
        int i = 0;
        while (i < resources.length) {
            this.getSyncInfoSource().assertDiffKindEquals(message, subscriber, resources[i], diffKinds[i]);
            ++i;
        }
    }

    protected void assertSyncChangesMatch(ISubscriberChangeEvent[] changes, IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            boolean found = false;
            int j = 0;
            while (j < changes.length) {
                ISubscriberChangeEvent delta = changes[j];
                if (delta.getResource().equals((Object)resource)) {
                    found = true;
                    break;
                }
                ++j;
            }
            CVSSyncSubscriberTest.assertTrue((String)("No change reported for " + resource), (boolean)found);
            ++i;
        }
    }

    protected void assertDeleted(String message, IContainer root, String[] resourcePaths) throws CoreException, TeamException {
        IResource[] resources = this.getResources(root, resourcePaths);
        int i = 0;
        while (i < resources.length) {
            try {
                if (!resources[i].exists()) {
                }
            }
            catch (AssertionFailedError assertionFailedError) {}
            break;
            CVSSyncSubscriberTest.assertTrue((String)(String.valueOf(message) + ": resource " + resources[i] + " still exists in some form"), (boolean)false);
            ++i;
        }
    }

    protected IResource[] collect(IResource[] resources, final ResourceCondition condition, int depth) throws CoreException, TeamException {
        final HashSet<IResource> affected = new HashSet<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.exists() || resource.isPhantom()) {
                resource.accept(new IResourceVisitor(){

                    public boolean visit(IResource r) throws CoreException {
                        try {
                            if (condition.matches(r)) {
                                affected.add(r);
                            }
                        }
                        catch (TeamException e) {
                            throw new CoreException(e.getStatus());
                        }
                        return true;
                    }
                }, depth, true);
            } else if (condition.matches(resource)) {
                affected.add(resource);
            }
            ++i;
        }
        return affected.toArray(new IResource[affected.size()]);
    }

    protected IResource[] collectAncestors(IResource[] resources, ResourceCondition condition) throws CoreException, TeamException {
        HashSet<IResource> affected = new HashSet<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            while (resource.getType() != 8) {
                if (!condition.matches(resource)) break;
                affected.add(resource);
                resource = resource.getParent();
            }
            ++i;
        }
        return affected.toArray(new IResource[affected.size()]);
    }

    protected ISubscriberChangeEvent[] deregisterSubscriberListener(Subscriber subscriber) throws TeamException {
        subscriber.removeListener(this.listener);
        return (ISubscriberChangeEvent[])this.accumulatedTeamDeltas.toArray(new SubscriberChangeEvent[this.accumulatedTeamDeltas.size()]);
    }

    protected ISubscriberChangeListener registerSubscriberListener(Subscriber subscriber) throws TeamException {
        this.listener = new ISubscriberChangeListener(){

            public void subscriberResourceChanged(ISubscriberChangeEvent[] deltas) {
                CVSSyncSubscriberTest.this.accumulatedTeamDeltas.addAll(Arrays.asList(deltas));
            }
        };
        this.accumulatedTeamDeltas.clear();
        subscriber.addListener(this.listener);
        return this.listener;
    }

    protected void assertProjectRemoved(Subscriber subscriber, IProject project) throws TeamException {
        this.getSyncInfoSource().assertProjectRemoved(subscriber, project);
    }

    protected void markAsMerged(CVSSyncTreeSubscriber subscriber, IProject project, String[] resourcePaths) throws CoreException, TeamException, InvocationTargetException, InterruptedException {
        IResource[] resources = this.getResources((IContainer)project, resourcePaths);
        this.getSyncInfoSource().markAsMerged((Subscriber)subscriber, resources);
    }

    protected void assertIsBinary(IFile local) throws CVSException {
        ICVSFile file = CVSWorkspaceRoot.getCVSFileFor((IFile)local);
        byte[] syncBytes = file.getSyncBytes();
        if (syncBytes != null) {
            CVSSyncSubscriberTest.assertTrue((boolean)ResourceSyncInfo.isBinary((byte[])syncBytes));
        }
    }

    public static class ResourceCondition {
        public boolean matches(IResource resource) throws CoreException, TeamException {
            return true;
        }
    }
}

