/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.ui.benchmark;

import junit.framework.Test;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.tests.ccvs.core.subscriber.SyncInfoSource;
import org.eclipse.team.tests.ccvs.ui.benchmark.BenchmarkTest;
import org.eclipse.team.tests.ccvs.ui.benchmark.BenchmarkTestSetup;
import org.eclipse.team.tests.ccvs.ui.benchmark.BenchmarkUtils;
import org.eclipse.team.tests.ccvs.ui.benchmark.SequenceGenerator;

public class SyncTests
extends BenchmarkTest {
    private static final int FILE_SIZE_MEAN = 16384;
    private static final int FILE_SIZE_VARIANCE = 0;
    private static final int PROB_BINARY = 0;
    private static final String ADDED_GROUP_SUFFIX = "AddedFiles";
    private static final String REMOVED_GROUP_SUFFIX = "RemovedFiles";
    private static final String MODIFIED_GROUP_SUFFIX = "ModifiedFiles";
    private static final String[] PERFORMANCE_GROUPS = new String[]{"AddedFiles", "ModifiedFiles", "RemovedFiles"};

    public SyncTests() {
    }

    public SyncTests(String name) {
        super(name);
    }

    public static Test suite() {
        return SyncTests.suite(SyncTests.class);
    }

    public void testSync100NoUI() throws Exception {
        this.runTestSync(100, "CVS Synchronize No UI", false, new SyncInfoSource());
    }

    protected IProject setupOutProject() throws Exception {
        IProject project = this.createUniqueProject(BenchmarkTestSetup.SMALL_ZIP_FILE);
        this.shareProject(project);
        return project;
    }

    protected void runTestSync(int size, String globalName, boolean global, SyncInfoSource source) throws Exception {
        this.openEmptyPerspective();
        this.setupGroups(PERFORMANCE_GROUPS, globalName, global);
        int i = 0;
        while (i < BenchmarkTestSetup.LOOP_COUNT) {
            SequenceGenerator gen = new SequenceGenerator();
            IProject outProject = this.setupOutProject();
            String moduleName = outProject.getName();
            BenchmarkUtils.renameResource((IResource)outProject, String.valueOf(moduleName) + "out");
            outProject = BenchmarkUtils.getProject(String.valueOf(moduleName) + "out");
            IProject inProject = BenchmarkUtils.getProject(moduleName);
            this.checkoutProject(inProject, moduleName, null);
            this.startGroup(ADDED_GROUP_SUFFIX);
            BenchmarkUtils.createRandomDeepFiles(gen, (IContainer)outProject, size, 16384, 0, 0);
            this.syncCommitResources(source, new IResource[]{outProject}, "");
            this.syncUpdateResources(source, new IResource[]{inProject});
            this.endGroup();
            this.startGroup(MODIFIED_GROUP_SUFFIX);
            BenchmarkUtils.modifyRandomDeepFiles(gen, (IContainer)outProject, size);
            this.syncCommitResources(source, new IResource[]{outProject}, "");
            this.syncUpdateResources(source, new IResource[]{inProject});
            this.endGroup();
            this.startGroup(REMOVED_GROUP_SUFFIX);
            BenchmarkUtils.deleteRandomDeepFiles(gen, (IContainer)outProject, size);
            this.syncCommitResources(source, new IResource[]{outProject}, "");
            this.syncUpdateResources(source, new IResource[]{inProject});
            this.endGroup();
            ++i;
        }
        this.commitGroups(global);
    }
}

