/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal;

import java.awt.AWTException;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import javax.imageio.ImageIO;

public class AwtScreenshot {
    private static final int TIMEOUT_SECONDS = 15;

    public static void main(String[] args) {
        try {
            System.setProperty("java.awt.headless", "false");
            Robot robot = new Robot();
            Rectangle rect = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
            BufferedImage image = robot.createScreenCapture(rect);
            File file = new File(args[0]);
            ImageIO.write((RenderedImage)image, "png", file);
            System.out.println("AWT screenshot saved to: " + file.getAbsolutePath());
        }
        catch (HeadlessException e) {
            e.printStackTrace();
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void dumpAwtScreenshot(String screenshotFile) {
        try {
            URL location = AwtScreenshot.class.getProtectionDomain().getCodeSource().getLocation();
            String cp = location.toURI().getPath();
            String javaHome = System.getProperty("java.home");
            String javaExe = String.valueOf(javaHome) + File.separatorChar + "bin" + File.separatorChar + "java";
            if (File.separatorChar == '\\') {
                javaExe = String.valueOf(javaExe) + ".exe";
            }
            String[] args = new String[]{javaExe, "-cp", cp, AwtScreenshot.class.getName(), screenshotFile};
            ProcessBuilder processBuilder = new ProcessBuilder(args);
            if ("Mac OS X".equals(System.getProperty("os.name"))) {
                processBuilder.environment().put("AWT_TOOLKIT", "CToolkit");
            }
            Process process = processBuilder.start();
            new StreamForwarder(process.getErrorStream(), System.out).start();
            new StreamForwarder(process.getInputStream(), System.out).start();
            long end = System.currentTimeMillis() + 15000L;
            boolean done = false;
            do {
                try {
                    process.exitValue();
                    done = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } while (!done && System.currentTimeMillis() < end);
            if (done) {
                int exitCode = process.exitValue();
                if (exitCode != 0) {
                    System.out.println("AwtScreenshot VM finished with exit code " + exitCode + ".");
                }
            } else {
                process.destroy();
                System.out.println("Killed AwtScreenshot VM after 15 seconds.");
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class StreamForwarder
    extends Thread {
        private InputStream fProcessOutput;
        private PrintStream fStream;

        public StreamForwarder(InputStream processOutput, PrintStream stream) {
            this.fProcessOutput = processOutput;
            this.fStream = stream;
        }

        @Override
        public void run() {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.fProcessOutput));){
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        this.fStream.println(line);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

