/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.db;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.db.DB;
import org.eclipse.test.internal.performance.db.Scenario;
import org.eclipse.test.internal.performance.db.SummaryEntry;
import org.eclipse.test.internal.performance.db.Variations;

public class DBHelpers {
    private Connection fConnection = DB.getConnection();

    public static void main(String[] args) throws SQLException {
        DBHelpers db = new DBHelpers();
        long start = System.currentTimeMillis();
        db.dumpSizes(System.out);
        System.out.println("time: " + (double)(System.currentTimeMillis() - start) / 1000.0);
    }

    void renameVariation(String oldName, String newName) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement update = this.fConnection.prepareStatement("update VARIATION set KEYVALPAIRS = ? where KEYVALPAIRS = ? ");){
            update.setString(1, newName);
            update.setString(2, oldName);
            update.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    void dumpSummaries(Variations variations, String scenarioPattern) {
        SummaryEntry[] summries = DB.querySummaries(variations, scenarioPattern);
        int i = 0;
        while (i < summries.length) {
            System.out.println(summries[i]);
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void count(PrintStream ps) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            PreparedStatement stmt = this.fConnection.prepareStatement("select count(*) from SCALAR where DATAPOINT_ID not in (select DATAPOINT.ID from DATAPOINT)");
            try {
                try (ResultSet set = stmt.executeQuery();){
                    if (set.next()) {
                        ps.println("count: " + set.getInt(1));
                    }
                }
                if (stmt == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    void countDimension(PrintStream ps, Dim dim) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement stmt = this.fConnection.prepareStatement("select count(*) from SCALAR where DIM_ID = ?");){
            stmt.setInt(1, dim.getId());
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (ResultSet set = stmt.executeQuery();){
                if (set.next()) {
                    ps.println("dimension " + dim + ": " + set.getInt(1));
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void countAllDimensions(PrintStream ps) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            PreparedStatement stmt = this.fConnection.prepareStatement("select distinct DIM_ID from SCALAR");
            try {
                try (ResultSet set = stmt.executeQuery();){
                    while (set.next()) {
                        Dim dimension = Dim.getDimension(set.getInt(1));
                        if (dimension == null) continue;
                        this.countDimension(ps, dimension);
                    }
                }
                if (stmt == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    int countSamples(PrintStream ps, Variations v) throws SQLException {
        PreparedStatement stmt = this.fConnection.prepareStatement("select count(*) from SAMPLE, VARIATION where VARIATION.KEYVALPAIRS = ? and SAMPLE.VARIATION_ID = VARIATION.ID");
        stmt.setString(1, v.toExactMatchString());
        Throwable throwable = null;
        Object var5_6 = null;
        try (ResultSet set = stmt.executeQuery();){
            int n = 0;
            if (set.next()) {
                n = set.getInt(1);
            }
            ps.println("samples with variation " + v + ": " + n);
            return n;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    void countDatapoints(PrintStream ps, Variations v) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement stmt = this.fConnection.prepareStatement("select count(*) from DATAPOINT, SAMPLE, VARIATION where VARIATION.KEYVALPAIRS = ? and SAMPLE.VARIATION_ID = VARIATION.ID and DATAPOINT.SAMPLE_ID= SAMPLE.ID");){
            stmt.setString(1, v.toExactMatchString());
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (ResultSet set = stmt.executeQuery();){
                if (set.next()) {
                    ps.println("datapoints with variation " + v + ": " + set.getInt(1));
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    void countScalars(PrintStream ps, Variations v) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement stmt = this.fConnection.prepareStatement("select count(*) from SCALAR, DATAPOINT, SAMPLE, VARIATION where VARIATION.KEYVALPAIRS = ? and SAMPLE.VARIATION_ID = VARIATION.ID and DATAPOINT.SAMPLE_ID= SAMPLE.ID and DATAPOINT.ID = SCALAR.DATAPOINT_ID");){
            stmt.setString(1, v.toExactMatchString());
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (ResultSet set = stmt.executeQuery();){
                if (set.next()) {
                    ps.println("scalars with variation " + v + ": " + set.getInt(1));
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeSamples(Variations v) throws SQLException {
        boolean delete = true;
        int n = this.countSamples(System.out, v);
        int variation_id = 0;
        Throwable throwable = null;
        Object var6_8 = null;
        try (PreparedStatement stmt = this.fConnection.prepareStatement("select ID from VARIATION where KEYVALPAIRS = ?");){
            stmt.setString(1, v.toExactMatchString());
            Throwable throwable2 = null;
            Object var9_19 = null;
            try (ResultSet set = stmt.executeQuery();){
                if (set.next()) {
                    variation_id = set.getInt(1);
                    System.err.println("variation_id: " + variation_id);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                    throw throwable2;
                }
                if (throwable2 == throwable3) throw throwable2;
                throwable2.addSuppressed(throwable3);
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
        if (variation_id <= 0) {
            System.err.println("nothing found for variation " + v);
            return;
        }
        throwable = null;
        var6_8 = null;
        try {
            PreparedStatement iterSamples = this.fConnection.prepareStatement("select SAMPLE.ID, SAMPLE.SCENARIO_ID from SAMPLE where SAMPLE.VARIATION_ID = ?");
            try {
                block97: {
                    PreparedStatement iterDatapoints = this.fConnection.prepareStatement("select DATAPOINT.ID from DATAPOINT where DATAPOINT.SAMPLE_ID = ?");
                    try {
                        block96: {
                            PreparedStatement deleteScalars = this.fConnection.prepareStatement("delete from SCALAR where DATAPOINT_ID = ?");
                            try {
                                block95: {
                                    PreparedStatement deleteDatapoints = this.fConnection.prepareStatement("delete from DATAPOINT where SAMPLE_ID = ?");
                                    try {
                                        block94: {
                                            PreparedStatement deleteSamples = this.fConnection.prepareStatement("delete from SAMPLE where SAMPLE.ID = ?");
                                            try {
                                                block92: {
                                                    try (PreparedStatement deleteScenario = this.fConnection.prepareStatement("delete from SCENARIO where SCENARIO.ID = ?");){
                                                        iterSamples.setInt(1, variation_id);
                                                        Throwable throwable5 = null;
                                                        Object var14_28 = null;
                                                        try (ResultSet samples = iterSamples.executeQuery();){
                                                            while (samples.next()) {
                                                                int sample_id = samples.getInt(1);
                                                                int scenario_id = samples.getInt(2);
                                                                System.out.print(String.valueOf(n) + ": sample(" + sample_id + "):");
                                                                iterDatapoints.setInt(1, sample_id);
                                                                int dps = 0;
                                                                Throwable throwable6 = null;
                                                                Object var20_41 = null;
                                                                try (ResultSet datapoints = iterDatapoints.executeQuery();){
                                                                    while (datapoints.next()) {
                                                                        int dp_id = datapoints.getInt(1);
                                                                        if (!delete) continue;
                                                                        deleteScalars.setInt(1, dp_id);
                                                                        try {
                                                                            deleteScalars.executeUpdate();
                                                                            this.fConnection.commit();
                                                                            ++dps;
                                                                        }
                                                                        catch (SQLException e) {
                                                                            System.err.println("removing scalars: " + e);
                                                                        }
                                                                    }
                                                                }
                                                                catch (Throwable throwable7) {
                                                                    if (throwable6 == null) {
                                                                        throwable6 = throwable7;
                                                                        throw throwable6;
                                                                    }
                                                                    if (throwable6 == throwable7) throw throwable6;
                                                                    throwable6.addSuppressed(throwable7);
                                                                    throw throwable6;
                                                                }
                                                                System.out.println(" dps: " + dps);
                                                                if (delete) {
                                                                    deleteDatapoints.setInt(1, sample_id);
                                                                    try {
                                                                        deleteDatapoints.executeUpdate();
                                                                        this.fConnection.commit();
                                                                    }
                                                                    catch (SQLException e1) {
                                                                        System.err.println("removing datapoints: " + e1);
                                                                    }
                                                                    deleteSamples.setInt(1, sample_id);
                                                                    try {
                                                                        deleteSamples.executeUpdate();
                                                                        this.fConnection.commit();
                                                                    }
                                                                    catch (SQLException e) {
                                                                        System.err.println("removing sample: " + e);
                                                                    }
                                                                    deleteScenario.setInt(1, scenario_id);
                                                                    try {
                                                                        deleteScenario.executeUpdate();
                                                                        this.fConnection.commit();
                                                                    }
                                                                    catch (SQLException sQLException) {}
                                                                }
                                                                --n;
                                                            }
                                                        }
                                                        catch (Throwable throwable8) {
                                                            if (throwable5 == null) {
                                                                throwable5 = throwable8;
                                                                throw throwable5;
                                                            }
                                                            if (throwable5 == throwable8) throw throwable5;
                                                            throwable5.addSuppressed(throwable8);
                                                            throw throwable5;
                                                        }
                                                        if (!delete) break block92;
                                                        throwable5 = null;
                                                        var14_28 = null;
                                                        try (PreparedStatement deleteSummaries = this.fConnection.prepareStatement("delete from SUMMARYENTRY where VARIATION_ID = ?");){
                                                            deleteSummaries.setInt(1, variation_id);
                                                            deleteSummaries.executeUpdate();
                                                        }
                                                        catch (Throwable throwable9) {
                                                            if (throwable5 == null) {
                                                                throwable5 = throwable9;
                                                                throw throwable5;
                                                            }
                                                            if (throwable5 == throwable9) throw throwable5;
                                                            throwable5.addSuppressed(throwable9);
                                                            throw throwable5;
                                                        }
                                                        throwable5 = null;
                                                        var14_28 = null;
                                                        try (PreparedStatement deleteVariation = this.fConnection.prepareStatement("delete from VARIATION where ID = ?");){
                                                            deleteVariation.setInt(1, variation_id);
                                                            try {
                                                                deleteVariation.executeUpdate();
                                                            }
                                                            catch (SQLException e) {
                                                                System.err.println("removing variation: " + e);
                                                            }
                                                        }
                                                        catch (Throwable throwable10) {
                                                            if (throwable5 == null) {
                                                                throwable5 = throwable10;
                                                                throw throwable5;
                                                            }
                                                            if (throwable5 == throwable10) throw throwable5;
                                                            throwable5.addSuppressed(throwable10);
                                                            throw throwable5;
                                                        }
                                                    }
                                                }
                                                if (deleteSamples == null) break block94;
                                            }
                                            catch (Throwable throwable11) {
                                                if (throwable == null) {
                                                    throwable = throwable11;
                                                } else if (throwable != throwable11) {
                                                    throwable.addSuppressed(throwable11);
                                                }
                                                if (deleteSamples == null) throw throwable;
                                                deleteSamples.close();
                                                throw throwable;
                                            }
                                            deleteSamples.close();
                                        }
                                        if (deleteDatapoints == null) break block95;
                                    }
                                    catch (Throwable throwable12) {
                                        if (throwable == null) {
                                            throwable = throwable12;
                                        } else if (throwable != throwable12) {
                                            throwable.addSuppressed(throwable12);
                                        }
                                        if (deleteDatapoints == null) throw throwable;
                                        deleteDatapoints.close();
                                        throw throwable;
                                    }
                                    deleteDatapoints.close();
                                }
                                if (deleteScalars == null) break block96;
                            }
                            catch (Throwable throwable13) {
                                if (throwable == null) {
                                    throwable = throwable13;
                                } else if (throwable != throwable13) {
                                    throwable.addSuppressed(throwable13);
                                }
                                if (deleteScalars == null) throw throwable;
                                deleteScalars.close();
                                throw throwable;
                            }
                            deleteScalars.close();
                        }
                        if (iterDatapoints == null) break block97;
                    }
                    catch (Throwable throwable14) {
                        if (throwable == null) {
                            throwable = throwable14;
                        } else if (throwable != throwable14) {
                            throwable.addSuppressed(throwable14);
                        }
                        if (iterDatapoints == null) throw throwable;
                        iterDatapoints.close();
                        throw throwable;
                    }
                    iterDatapoints.close();
                }
                if (iterSamples == null) return;
            }
            catch (Throwable throwable15) {
                if (throwable == null) {
                    throwable = throwable15;
                } else if (throwable != throwable15) {
                    throwable.addSuppressed(throwable15);
                }
                if (iterSamples == null) throw throwable;
                iterSamples.close();
                throw throwable;
            }
            iterSamples.close();
            return;
        }
        catch (Throwable throwable16) {
            if (throwable == null) {
                throwable = throwable16;
                throw throwable;
            }
            if (throwable == throwable16) throw throwable;
            throwable.addSuppressed(throwable16);
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void countSamplesWithNullVariations() throws SQLException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            Statement stmt = this.fConnection.createStatement();
            try {
                try (ResultSet rs = stmt.executeQuery("select count(*) from SAMPLE where SAMPLE.VARIATION_ID is null");){
                    while (rs.next()) {
                        int config_id = rs.getInt(1);
                        System.out.println("samples with NULL variation: " + config_id);
                    }
                }
                if (stmt == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    void removeDimension(Dim dim) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (PreparedStatement q = this.fConnection.prepareStatement("delete from SCALAR where SCALAR.DIM_ID = ?");){
            q.setInt(1, dim.getId());
            q.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    void dumpScenarios(PrintStream ps, String pattern) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement stmt = this.fConnection.prepareStatement("select NAME from SCENARIO where NAME like ? order by NAME");){
            stmt.setString(1, pattern);
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    ps.println(rs.getString(1));
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void dumpSizes(PrintStream ps) throws SQLException {
        if (this.fConnection == null) {
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Statement stmt = this.fConnection.createStatement();
            try {
                try (ResultSet rs = stmt.executeQuery("SELECT sys.systables.tablename FROM sys.systables WHERE sys.systables.tablename NOT LIKE 'SYS%' ");){
                    while (rs.next()) {
                        this.dumpSize(ps, rs.getString(1));
                    }
                    rs.close();
                }
                if (stmt == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void dumpSize(PrintStream ps, String table) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            Statement stmt = this.fConnection.createStatement();
            try {
                try (ResultSet rs = stmt.executeQuery("select Count(*) from " + table);){
                    if (rs.next()) {
                        ps.println(String.valueOf(table) + ": " + rs.getInt(1));
                    }
                }
                if (stmt == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dumpAll(PrintStream ps, int maxRow) throws SQLException {
        if (this.fConnection == null) {
            return;
        }
        if (maxRow < 0) {
            maxRow = 1000000;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            Statement stmt = this.fConnection.createStatement();
            try {
                try (ResultSet rs = stmt.executeQuery("select SYS.SYSTABLES.TABLENAME from SYS.SYSTABLES where SYS.SYSTABLES.TABLENAME not like 'SYS%' ");){
                    while (rs.next()) {
                        this.dumpTable(ps, rs.getString(1), maxRow);
                        ps.println();
                    }
                }
                if (stmt == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void dumpTable(PrintStream ps, String tableName, int maxRow) throws SQLException {
        ps.print(String.valueOf(tableName) + '(');
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            Statement select = this.fConnection.createStatement();
            try {
                try (ResultSet result = select.executeQuery("select * from " + tableName);){
                    ResultSetMetaData metaData = result.getMetaData();
                    int n = metaData.getColumnCount();
                    int i = 0;
                    while (i < n) {
                        ps.print(metaData.getColumnLabel(i + 1));
                        if (i < n - 1) {
                            ps.print(", ");
                        }
                        ++i;
                    }
                    ps.println("):");
                    int r = 0;
                    while (result.next() && r < maxRow) {
                        int i2 = 0;
                        while (i2 < n) {
                            ps.print(String.valueOf(' ') + result.getString(i2 + 1));
                            ++i2;
                        }
                        ps.println();
                        ++r;
                    }
                }
                if (select == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (select == null) throw throwable;
                select.close();
                throw throwable;
            }
            select.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    void view(PrintStream ps, Variations v, String scenarioPattern) throws SQLException {
        Scenario[] scenarios = DB.queryScenarios(v, scenarioPattern, "build", null);
        ps.println(String.valueOf(scenarios.length) + " Scenarios");
        ps.println();
        int s = 0;
        while (s < scenarios.length) {
            scenarios[s].dump(ps, "build");
            ++s;
        }
    }
}

