/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.projection.ChildDocument;
import org.eclipse.jface.text.projection.ChildDocumentManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChildDocumentTest {
    private IDocument fDocument;
    private Document fParent;
    private ChildDocumentManager fManager;

    protected void checkPositions(Position[] positions) {
        try {
            Position[] v = this.fDocument.getPositions("__dflt_position_category");
            Assert.assertTrue((String)"invalid number of positions", (v.length == positions.length ? 1 : 0) != 0);
            int i = 0;
            while (i < positions.length) {
                Assert.assertEquals((String)(String.valueOf(this.print(v[i])) + " != " + this.print(positions[i])), (Object)positions[i], (Object)v[i]);
                ++i;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            Assert.assertTrue((String)"BadPositionCategoryException thrown", (boolean)false);
        }
    }

    protected void checkPositions(Position[] expected, Position[] actual) {
        Assert.assertTrue((String)"invalid number of positions", (expected.length == actual.length ? 1 : 0) != 0);
        int i = 0;
        while (i < expected.length) {
            Assert.assertEquals((String)(String.valueOf(this.print(actual[i])) + " != " + this.print(expected[i])), (Object)expected[i], (Object)actual[i]);
            ++i;
        }
    }

    protected String print(Position p) {
        return "[" + p.getOffset() + "," + p.getLength() + "]";
    }

    protected void checkLineInformationConsistency() {
        DefaultLineTracker textTracker = new DefaultLineTracker();
        textTracker.set(this.fDocument.get());
        int textLines = textTracker.getNumberOfLines();
        int trackerLines = this.fDocument.getNumberOfLines();
        Assert.assertEquals((String)"Child document store and child line tracker are inconsistent", (long)trackerLines, (long)textLines);
        int i = 0;
        while (i < trackerLines) {
            IRegion trackerLine = null;
            IRegion textLine = null;
            try {
                trackerLine = this.fDocument.getLineInformation(i);
                textLine = textTracker.getLineInformation(i);
            }
            catch (BadLocationException badLocationException) {
                Assert.assertTrue((String)"BadLocationException thrown", (boolean)false);
            }
            Assert.assertEquals((String)"Child document store and child line tracker are inconsistent", (long)trackerLine.getOffset(), (long)textLine.getOffset());
            Assert.assertEquals((String)"Child document store and child line tracker are inconsistent", (long)trackerLine.getLength(), (long)textLine.getLength());
            ++i;
        }
    }

    @Before
    public void setUp() {
        this.fParent = new Document();
        String text = "package TestPackage;\n/*\n* comment\n*/\n\tpublic class Class {\n\t\t// comment1\n\t\tpublic void method1() {\n\t\t}\n\t\t// comment2\n\t\tpublic void method2() {\n\t\t}\n\t}\n";
        this.fParent.set(text);
        this.fManager = new ChildDocumentManager();
        try {
            this.fDocument = this.fManager.createSlaveDocument((IDocument)this.fParent);
            if (this.fDocument instanceof ChildDocument) {
                ChildDocument child = (ChildDocument)this.fDocument;
                child.setParentDocumentRange(0, this.fParent.getLength());
            }
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        try {
            this.fDocument.addPosition(new Position(0, 20));
            this.fDocument.addPosition(new Position(21, 15));
            this.fDocument.addPosition(new Position(38, 111));
            this.fDocument.addPosition(new Position(61, 12));
            this.fDocument.addPosition(new Position(75, 27));
            this.fDocument.addPosition(new Position(105, 12));
            this.fDocument.addPosition(new Position(119, 27));
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"initilization failed", (boolean)false);
        }
    }

    @After
    public void tearDown() {
        this.fDocument = null;
    }

    @Test
    public void testDelete1() {
        try {
            this.fDocument.replace(21, 16, "");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"BadLocationException thrown", (boolean)false);
        }
        Position[] positions = new Position[]{new Position(0, 20), new Position(21, 0), new Position(22, 111), new Position(45, 12), new Position(59, 27), new Position(89, 12), new Position(103, 27)};
        this.checkPositions(positions);
    }

    @Test
    public void testEditScript1() {
        try {
            this.fDocument.replace(0, this.fDocument.getLength(), "");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"BadLocationException thrown", (boolean)false);
        }
        Position[] positions = new Position[]{new Position(0, 0)};
        this.checkPositions(positions);
        try {
            this.fDocument.replace(0, 0, "\t");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"BadLocationException thrown", (boolean)false);
        }
        positions = new Position[]{new Position(1, 0)};
        this.checkPositions(positions);
    }

    @Test
    public void testFindPositions() {
        try {
            this.fDocument.addPosition(new Position(21, 13));
            this.fDocument.addPosition(new Position(0, 19));
            this.fDocument.addPosition(new Position(21, 14));
            this.fDocument.addPosition(new Position(21, 16));
            this.fDocument.addPosition(new Position(0, 0));
            this.fDocument.addPosition(new Position(104, 1));
            this.fDocument.addPosition(new Position(120, 1));
            this.fDocument.addPosition(new Position(119, 1));
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"initilization failed", (boolean)false);
        }
        Position[] positions = new Position[]{new Position(0, 0), new Position(0, 19), new Position(0, 20), new Position(21, 16), new Position(21, 14), new Position(21, 13), new Position(21, 15), new Position(38, 111), new Position(61, 12), new Position(75, 27), new Position(104, 1), new Position(105, 12), new Position(119, 1), new Position(119, 27), new Position(120, 1)};
        this.checkPositions(positions);
    }

    @Test
    public void testInsert1() {
        try {
            this.fDocument.replace(0, 0, "//comment\n");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"BadLocationException thrown", (boolean)false);
        }
        Position[] positions = new Position[]{new Position(10, 20), new Position(31, 15), new Position(48, 111), new Position(71, 12), new Position(85, 27), new Position(115, 12), new Position(129, 27)};
        this.checkPositions(positions);
    }

    @Test
    public void testInsert2() {
        try {
            this.fDocument.replace(61, 0, "//comment\n");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"BadLocationException thrown", (boolean)false);
        }
        Position[] positions = new Position[]{new Position(0, 20), new Position(21, 15), new Position(38, 121), new Position(71, 12), new Position(85, 27), new Position(115, 12), new Position(129, 27)};
        this.checkPositions(positions);
    }

    @Test
    public void testInsert3() {
        try {
            this.fDocument.replace(101, 0, "//comment\n");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"BadLocationException thrown", (boolean)false);
        }
        Position[] positions = new Position[]{new Position(0, 20), new Position(21, 15), new Position(38, 121), new Position(61, 12), new Position(75, 37), new Position(115, 12), new Position(129, 27)};
        this.checkPositions(positions);
    }

    @Test
    public void testInsert4() {
        try {
            this.fDocument.replace(20, 0, "// comment");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"BadLocationException thrown", (boolean)false);
        }
        System.out.print(this.fDocument.get());
        Position[] positions = new Position[]{new Position(0, 20), new Position(31, 15), new Position(48, 111), new Position(71, 12), new Position(85, 27), new Position(115, 12), new Position(129, 27)};
        this.checkPositions(positions);
    }

    @Test
    public void testReplace1() {
        try {
            this.fDocument.replace(8, 11, "pkg1");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"BadLocationException thrown", (boolean)false);
        }
        Position[] positions = new Position[]{new Position(0, 13), new Position(14, 15), new Position(31, 111), new Position(54, 12), new Position(68, 27), new Position(98, 12), new Position(112, 27)};
        this.checkPositions(positions);
    }

    @Test
    public void testReplace2() {
        try {
            this.fDocument.replace(21, 16, "//comment\n");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"BadLocationException thrown", (boolean)false);
        }
        Position[] positions = new Position[]{new Position(0, 20), new Position(31, 0), new Position(32, 111), new Position(55, 12), new Position(69, 27), new Position(99, 12), new Position(113, 27)};
        this.checkPositions(positions);
    }

    @Test
    public void testReplace3() {
        Position[] actual = new Position[]{new Position(0, 150)};
        try {
            this.fDocument.addPosition(actual[0]);
            this.fDocument.replace(0, 150, "xxxxxxxxxx");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"BadLocationException thrown", (boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 10)};
        this.checkPositions(expected, actual);
    }

    @Test
    public void testReplace4() {
        try {
            int start = this.fParent.getLineOffset(5);
            int end = this.fParent.getLineOffset(8);
            ChildDocument child = (ChildDocument)this.fDocument;
            child.setParentDocumentRange(start, end - start);
            this.fParent.replace(end, 1, "x");
            this.checkLineInformationConsistency();
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"BadLocationException thrown", (boolean)false);
        }
    }

    @Test
    public void testAppend() {
        Position[] actual = new Position[]{new Position(0, 2)};
        try {
            this.fDocument.replace(0, 150, "");
            this.fDocument.replace(this.fDocument.getLength(), 0, "xx");
            this.fDocument.addPosition(actual[0]);
            this.fDocument.replace(this.fDocument.getLength(), 0, "xxxxxxxx");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"BadLocationException thrown", (boolean)false);
        }
        Position[] expected = new Position[]{new Position(0, 2)};
        this.checkPositions(expected, actual);
    }

    @Test
    public void testShiftLeft() {
        try {
            this.fDocument.replace(73, 1, "");
            this.fDocument.replace(98, 1, "");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"BadLocationException thrown", (boolean)false);
        }
        Position[] positions = new Position[]{new Position(0, 20), new Position(21, 15), new Position(38, 109), new Position(61, 12), new Position(74, 26), new Position(103, 12), new Position(117, 27)};
        this.checkPositions(positions);
    }

    @Test
    public void testShiftRight() {
        try {
            this.fDocument.replace(73, 0, "\t");
            this.fDocument.replace(100, 0, "\t");
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((String)"BadLocationException thrown", (boolean)false);
        }
        Position[] positions = new Position[]{new Position(0, 20), new Position(21, 15), new Position(38, 113), new Position(61, 12), new Position(76, 28), new Position(107, 12), new Position(121, 27)};
        this.checkPositions(positions);
    }
}

