/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import junit.framework.TestCase;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.undo.DocumentUndoManager;
import org.eclipse.text.undo.IDocumentUndoManager;

public class DocumentUndoManagerTest
extends TestCase {
    private static final int MAX_UNDO_LEVEL = 256;
    private static final String INITIAL_DOCUMENT_CONTENT = "+7cyg:/F!T4KnW;0+au$t1G%(`Z|u'7'_!-k?<c\"2Y.]CwsO.r";
    private static final String[] REPLACEMENTS = new String[]{">", "F", "M/r-*", "-", "bl", "", "}%/#", "", "k&", "f", "\\g", "c!x", "TLG-", "NPO", "Rp9u", "", "X", "W(", ")z", "oe", "", "h*", "t", "I", "X=N>", "2yt", "&Z", "2)W=", ":K", "P9S", "s8t8o", "", "", "5{7", "%", "", "v3", "Wz", "sH", "3c", "8", "ol", ",6$", "94[#", ".~", "n", ">", "9", "W", ",(FW", "Q", "^", "Bq", "$", "re", "", "9", "8[", "Mx", "4b", "$6", "F", "8s]", "o", "-", "E&6", "S\\", "/", "z.a", "4ai", "b", ")", "", "l", "VU", "7M+Ql", "xZ?x", "xx", "lc", "b", "A", "!", "4pSU", "", "{J", "H", "l>_", "n&9", "", "&`", ";igQxq", "", ">", ";\"", "k\\`]G", "o{?", "", "K", "_6", "="};
    private static final int[] POSITIONS;
    private static final boolean DEBUG = false;
    private IDocumentUndoManager fUndoManager;

    static {
        int[] nArray = new int[200];
        nArray[0] = 18;
        nArray[1] = 2;
        nArray[2] = 43;
        nArray[3] = 1;
        nArray[4] = 3;
        nArray[5] = 2;
        nArray[6] = 28;
        nArray[7] = 3;
        nArray[8] = 35;
        nArray[9] = 1;
        nArray[10] = 23;
        nArray[11] = 5;
        nArray[12] = 32;
        nArray[13] = 2;
        nArray[14] = 30;
        nArray[15] = 1;
        nArray[16] = 22;
        nArray[17] = 1;
        nArray[18] = 37;
        nArray[20] = 23;
        nArray[21] = 3;
        nArray[22] = 43;
        nArray[23] = 2;
        nArray[24] = 46;
        nArray[25] = 1;
        nArray[26] = 17;
        nArray[27] = 1;
        nArray[28] = 36;
        nArray[29] = 6;
        nArray[30] = 17;
        nArray[31] = 5;
        nArray[32] = 30;
        nArray[33] = 4;
        nArray[34] = 25;
        nArray[35] = 1;
        nArray[36] = 2;
        nArray[37] = 2;
        nArray[38] = 30;
        nArray[40] = 37;
        nArray[41] = 3;
        nArray[42] = 28;
        nArray[43] = 1;
        nArray[44] = 30;
        nArray[45] = 2;
        nArray[46] = 20;
        nArray[47] = 5;
        nArray[48] = 33;
        nArray[49] = 1;
        nArray[50] = 29;
        nArray[51] = 1;
        nArray[52] = 15;
        nArray[53] = 2;
        nArray[54] = 21;
        nArray[55] = 2;
        nArray[56] = 24;
        nArray[57] = 4;
        nArray[58] = 38;
        nArray[59] = 3;
        nArray[60] = 8;
        nArray[62] = 33;
        nArray[63] = 2;
        nArray[64] = 15;
        nArray[65] = 2;
        nArray[66] = 25;
        nArray[68] = 8;
        nArray[69] = 2;
        nArray[70] = 20;
        nArray[71] = 3;
        nArray[72] = 43;
        nArray[73] = 2;
        nArray[74] = 44;
        nArray[75] = 1;
        nArray[76] = 44;
        nArray[77] = 2;
        nArray[78] = 32;
        nArray[79] = 2;
        nArray[80] = 40;
        nArray[81] = 2;
        nArray[82] = 32;
        nArray[83] = 3;
        nArray[84] = 12;
        nArray[85] = 2;
        nArray[86] = 38;
        nArray[87] = 3;
        nArray[88] = 33;
        nArray[89] = 2;
        nArray[90] = 46;
        nArray[92] = 13;
        nArray[93] = 3;
        nArray[94] = 45;
        nArray[96] = 16;
        nArray[97] = 2;
        nArray[98] = 3;
        nArray[99] = 2;
        nArray[100] = 44;
        nArray[102] = 48;
        nArray[104] = 18;
        nArray[105] = 5;
        nArray[106] = 7;
        nArray[107] = 6;
        nArray[108] = 7;
        nArray[109] = 3;
        nArray[110] = 40;
        nArray[112] = 9;
        nArray[113] = 1;
        nArray[114] = 16;
        nArray[115] = 3;
        nArray[116] = 28;
        nArray[117] = 3;
        nArray[118] = 36;
        nArray[119] = 1;
        nArray[120] = 35;
        nArray[121] = 2;
        nArray[123] = 3;
        nArray[124] = 6;
        nArray[125] = 1;
        nArray[126] = 10;
        nArray[127] = 4;
        nArray[128] = 14;
        nArray[129] = 2;
        nArray[130] = 15;
        nArray[131] = 3;
        nArray[132] = 33;
        nArray[133] = 1;
        nArray[134] = 36;
        nArray[136] = 37;
        nArray[138] = 4;
        nArray[139] = 3;
        nArray[140] = 31;
        nArray[141] = 3;
        nArray[142] = 33;
        nArray[143] = 3;
        nArray[144] = 11;
        nArray[145] = 3;
        nArray[146] = 20;
        nArray[147] = 2;
        nArray[148] = 25;
        nArray[149] = 3;
        nArray[150] = 4;
        nArray[151] = 3;
        nArray[152] = 7;
        nArray[153] = 3;
        nArray[154] = 17;
        nArray[156] = 3;
        nArray[157] = 1;
        nArray[158] = 31;
        nArray[159] = 3;
        nArray[160] = 34;
        nArray[161] = 1;
        nArray[162] = 21;
        nArray[164] = 33;
        nArray[165] = 1;
        nArray[166] = 17;
        nArray[167] = 4;
        nArray[168] = 9;
        nArray[169] = 1;
        nArray[170] = 26;
        nArray[171] = 3;
        nArray[172] = 2;
        nArray[173] = 3;
        nArray[174] = 12;
        nArray[175] = 1;
        nArray[176] = 26;
        nArray[177] = 3;
        nArray[178] = 9;
        nArray[179] = 5;
        nArray[180] = 5;
        nArray[182] = 31;
        nArray[183] = 3;
        nArray[185] = 3;
        nArray[186] = 12;
        nArray[187] = 1;
        nArray[188] = 1;
        nArray[189] = 1;
        nArray[190] = 3;
        nArray[192] = 39;
        nArray[194] = 9;
        nArray[195] = 2;
        nArray[196] = 2;
        nArray[198] = 28;
        nArray[199] = 2;
        POSITIONS = nArray;
    }

    protected void setUp() {
        this.fUndoManager = null;
    }

    protected void tearDown() {
        this.fUndoManager.disconnect((Object)this);
        this.fUndoManager = null;
    }

    public void testConvertLineDelimiters() throws ExecutionException {
        Document document = new Document("a\r\nb\r\n");
        this.createUndoManager((IDocument)document);
        try {
            document.replace(1, 2, "\n");
            document.replace(3, 2, "\n");
        }
        catch (BadLocationException badLocationException) {
            DocumentUndoManagerTest.assertTrue((boolean)false);
        }
        DocumentUndoManagerTest.assertTrue((boolean)this.fUndoManager.undoable());
        this.fUndoManager.undo();
        DocumentUndoManagerTest.assertTrue((boolean)this.fUndoManager.undoable());
        this.fUndoManager.undo();
        String reverted = document.get();
        DocumentUndoManagerTest.assertEquals((String)"a\r\nb\r\n", (String)reverted);
    }

    private void createUndoManager(IDocument document) {
        this.fUndoManager = new DocumentUndoManager(document);
        this.fUndoManager.connect((Object)this);
        this.fUndoManager.setMaximalUndoLevel(256);
    }

    public void testRandomAccess() throws ExecutionException {
        DocumentUndoManagerTest.assertTrue((boolean)true);
        DocumentUndoManagerTest.assertTrue((boolean)true);
        String original = DocumentUndoManagerTest.createRandomString(50);
        Document document = new Document(original);
        this.createUndoManager((IDocument)document);
        this.doChange((IDocument)document, 100);
        DocumentUndoManagerTest.assertTrue((boolean)this.fUndoManager.undoable());
        while (this.fUndoManager.undoable()) {
            this.fUndoManager.undo();
        }
        String reverted = document.get();
        DocumentUndoManagerTest.assertEquals((String)original, (String)reverted);
    }

    private void doChange(IDocument document, int count) {
        try {
            String before = document.get();
            Position[] positions = new Position[count];
            String[] strings = new String[count];
            int i = 0;
            while (i < count) {
                Position position = DocumentUndoManagerTest.createRandomPositionPoisson(document.getLength());
                String string = DocumentUndoManagerTest.createRandomStringPoisson();
                document.replace(position.getOffset(), position.getLength(), string);
                positions[i] = position;
                strings[i] = string;
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {
            DocumentUndoManagerTest.assertTrue((boolean)false);
        }
    }

    private void doRepeatableChange(IDocument document) {
        DocumentUndoManagerTest.assertTrue((POSITIONS.length >= 2 * REPLACEMENTS.length ? 1 : 0) != 0);
        try {
            int i = 0;
            while (i < REPLACEMENTS.length) {
                int offset = POSITIONS[i * 2];
                int length = POSITIONS[i * 2 + 1];
                if (document.getLength() > offset + length) {
                    document.replace(offset, length, REPLACEMENTS[i]);
                } else {
                    document.replace(0, 0, REPLACEMENTS[i]);
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {
            DocumentUndoManagerTest.assertTrue((boolean)false);
        }
    }

    public void testCompoundTextEdit() throws ExecutionException, BadLocationException {
        DocumentUndoManagerTest.assertTrue((boolean)true);
        DocumentUndoManagerTest.assertTrue((boolean)true);
        String original = DocumentUndoManagerTest.createRandomString(50);
        Document document = new Document(original);
        this.createUndoManager((IDocument)document);
        MultiTextEdit fRoot = new MultiTextEdit();
        DeleteEdit e1 = new DeleteEdit(3, 1);
        fRoot.addChild((TextEdit)e1);
        fRoot.apply((IDocument)document);
        fRoot = new MultiTextEdit();
        DeleteEdit e2 = new DeleteEdit(3, 1);
        fRoot.addChild((TextEdit)e2);
        fRoot.apply((IDocument)document);
        DocumentUndoManagerTest.assertTrue((boolean)this.fUndoManager.undoable());
        this.fUndoManager.undo();
        DocumentUndoManagerTest.assertTrue((!this.fUndoManager.undoable() ? 1 : 0) != 0);
        String reverted = document.get();
        DocumentUndoManagerTest.assertEquals((String)original, (String)reverted);
    }

    public void testRandomAccessAsCompound() throws ExecutionException {
        DocumentUndoManagerTest.assertTrue((boolean)true);
        DocumentUndoManagerTest.assertTrue((boolean)true);
        String original = DocumentUndoManagerTest.createRandomString(50);
        Document document = new Document(original);
        this.createUndoManager((IDocument)document);
        this.fUndoManager.beginCompoundChange();
        this.doChange((IDocument)document, 100);
        this.fUndoManager.endCompoundChange();
        DocumentUndoManagerTest.assertTrue((boolean)this.fUndoManager.undoable());
        while (this.fUndoManager.undoable()) {
            this.fUndoManager.undo();
        }
        DocumentUndoManagerTest.assertTrue((!this.fUndoManager.undoable() ? 1 : 0) != 0);
        String reverted = document.get();
        DocumentUndoManagerTest.assertEquals((String)original, (String)reverted);
    }

    public void testRandomAccessAsUnclosedCompound() throws ExecutionException {
        DocumentUndoManagerTest.assertTrue((boolean)true);
        DocumentUndoManagerTest.assertTrue((boolean)true);
        String original = DocumentUndoManagerTest.createRandomString(50);
        Document document = new Document(original);
        this.createUndoManager((IDocument)document);
        this.fUndoManager.beginCompoundChange();
        this.doChange((IDocument)document, 100);
        DocumentUndoManagerTest.assertTrue((boolean)this.fUndoManager.undoable());
        while (this.fUndoManager.undoable()) {
            this.fUndoManager.undo();
        }
        DocumentUndoManagerTest.assertTrue((!this.fUndoManager.undoable() ? 1 : 0) != 0);
        String reverted = document.get();
        DocumentUndoManagerTest.assertEquals((String)original, (String)reverted);
    }

    public void testRandomAccessWithMixedCompound() throws ExecutionException {
        DocumentUndoManagerTest.assertTrue((boolean)true);
        DocumentUndoManagerTest.assertTrue((boolean)true);
        String original = DocumentUndoManagerTest.createRandomString(50);
        Document document = new Document(original);
        this.createUndoManager((IDocument)document);
        int i = 0;
        while (i < 5) {
            this.fUndoManager.beginCompoundChange();
            this.doChange((IDocument)document, 10);
            this.fUndoManager.endCompoundChange();
            DocumentUndoManagerTest.assertTrue((boolean)this.fUndoManager.undoable());
            int j = 0;
            while (j < 3) {
                this.doChange((IDocument)document, 10);
                DocumentUndoManagerTest.assertTrue((boolean)this.fUndoManager.undoable());
                ++j;
            }
            ++i;
        }
        DocumentUndoManagerTest.assertTrue((boolean)this.fUndoManager.undoable());
        while (this.fUndoManager.undoable()) {
            this.fUndoManager.undo();
        }
        DocumentUndoManagerTest.assertTrue((!this.fUndoManager.undoable() ? 1 : 0) != 0);
        String reverted = document.get();
        DocumentUndoManagerTest.assertEquals((String)original, (String)reverted);
    }

    public void testRepeatableAccess() throws ExecutionException {
        DocumentUndoManagerTest.assertTrue((REPLACEMENTS.length <= 256 ? 1 : 0) != 0);
        Document document = new Document(INITIAL_DOCUMENT_CONTENT);
        this.createUndoManager((IDocument)document);
        this.doRepeatableChange((IDocument)document);
        DocumentUndoManagerTest.assertTrue((boolean)this.fUndoManager.undoable());
        while (this.fUndoManager.undoable()) {
            this.fUndoManager.undo();
        }
        String reverted = document.get();
        DocumentUndoManagerTest.assertEquals((String)INITIAL_DOCUMENT_CONTENT, (String)reverted);
    }

    public void testRepeatableAccessAsCompound() throws ExecutionException {
        DocumentUndoManagerTest.assertTrue((REPLACEMENTS.length <= 256 ? 1 : 0) != 0);
        Document document = new Document(INITIAL_DOCUMENT_CONTENT);
        this.createUndoManager((IDocument)document);
        this.fUndoManager.beginCompoundChange();
        this.doRepeatableChange((IDocument)document);
        this.fUndoManager.endCompoundChange();
        DocumentUndoManagerTest.assertTrue((boolean)this.fUndoManager.undoable());
        this.fUndoManager.undo();
        DocumentUndoManagerTest.assertFalse((boolean)this.fUndoManager.undoable());
        String reverted = document.get();
        DocumentUndoManagerTest.assertEquals((String)INITIAL_DOCUMENT_CONTENT, (String)reverted);
    }

    public void testRepeatableAccessAsUnclosedCompound() throws ExecutionException {
        DocumentUndoManagerTest.assertTrue((REPLACEMENTS.length <= 256 ? 1 : 0) != 0);
        Document document = new Document(INITIAL_DOCUMENT_CONTENT);
        this.createUndoManager((IDocument)document);
        this.fUndoManager.beginCompoundChange();
        this.doRepeatableChange((IDocument)document);
        DocumentUndoManagerTest.assertTrue((boolean)this.fUndoManager.undoable());
        while (this.fUndoManager.undoable()) {
            this.fUndoManager.undo();
        }
        String reverted = document.get();
        DocumentUndoManagerTest.assertEquals((String)INITIAL_DOCUMENT_CONTENT, (String)reverted);
    }

    public void testDocumentStamp() throws ExecutionException {
        Document document = new Document(INITIAL_DOCUMENT_CONTENT);
        this.fUndoManager = new DocumentUndoManager((IDocument)document);
        this.fUndoManager.connect((Object)this);
        long stamp = document.getModificationStamp();
        this.doChange((IDocument)document, 1);
        this.fUndoManager.undo();
        DocumentUndoManagerTest.assertEquals((long)stamp, (long)document.getModificationStamp());
    }

    public void testDocumentStamp2() throws BadLocationException, ExecutionException {
        Document document = new Document("");
        this.fUndoManager = new DocumentUndoManager((IDocument)document);
        this.fUndoManager.connect((Object)this);
        document.replace(0, 0, DocumentUndoManagerTest.createRandomString(13));
        long stamp = document.getModificationStamp();
        this.fUndoManager.undo();
        document.replace(0, 0, DocumentUndoManagerTest.createRandomString(13));
        DocumentUndoManagerTest.assertFalse((stamp == document.getModificationStamp() ? 1 : 0) != 0);
    }

    private static String createRandomString(int length) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < length) {
            buffer.append(DocumentUndoManagerTest.getRandomCharacter());
            ++i;
        }
        return buffer.toString();
    }

    private static final char getRandomCharacter() {
        return (char)(32.0 + 95.0 * Math.random());
    }

    private static String createRandomStringPoisson() {
        int length = DocumentUndoManagerTest.getRandomPoissonValue(2);
        return DocumentUndoManagerTest.createRandomString(length);
    }

    private static Position createRandomPositionPoisson(int documentLength) {
        int length;
        float random = (float)Math.random();
        int offset = (int)(random * (float)(documentLength + 1));
        if (offset == documentLength + 1) {
            offset = documentLength;
        }
        if (offset + (length = DocumentUndoManagerTest.getRandomPoissonValue(2)) > documentLength) {
            length = documentLength - offset;
        }
        return new Position(offset, length);
    }

    private static int getRandomPoissonValue(int mean) {
        float random = (float)Math.random();
        float probability = 0.0f;
        int i = 0;
        while (probability < 1.0f && i < 10) {
            if (random <= (probability += DocumentUndoManagerTest.getPoissonDistribution(mean, i))) break;
            ++i;
        }
        return i;
    }

    private static float getPoissonDistribution(float lambda, int k) {
        return (float)(Math.exp(-lambda) * Math.pow(lambda, k) / (double)DocumentUndoManagerTest.faculty(k));
    }

    private static final int faculty(int k) {
        return k == 0 ? 1 : k * DocumentUndoManagerTest.faculty(k - 1);
    }
}

