/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import java.util.Arrays;
import java.util.Locale;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class FindReplaceDocumentAdapterTest {
    private static final boolean BUG_392594 = true;
    private Document fDocument;

    @Before
    public void setUp() {
        this.fDocument = new Document();
        String text = "package TestPackage;\n/*\n* comment\n*/\n\tpublic class Class {\n\t\t// comment1\n\t\tpublic void method1() {\n\t\t}\n\t\t// comment2\n\t\tpublic void method2() {\n\t\t}\n\t}\n// Gel\u00f6st";
        this.fDocument.set(text);
    }

    @After
    public void tearDown() {
        this.fDocument = null;
    }

    @Test
    public void testFind() {
        FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        try {
            Region result = new Region(8, 11);
            IRegion r = findReplaceDocumentAdapter.find(0, "TestPackage", true, true, false, false);
            Assert.assertEquals((Object)result, (Object)r);
            r = findReplaceDocumentAdapter.find(0, "testpackage", true, true, false, false);
            Assert.assertNull((Object)r);
            r = findReplaceDocumentAdapter.find(0, "TestPackage", true, false, false, false);
            Assert.assertEquals((Object)r, (Object)result);
            r = findReplaceDocumentAdapter.find(0, "testpackage", true, false, false, false);
            Assert.assertEquals((Object)r, (Object)result);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testFindCaretInMiddleOfWord() {
        FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        try {
            IRegion r = findReplaceDocumentAdapter.find(12, "TestPackage", true, false, false, false);
            Assert.assertNull((Object)r);
            r = findReplaceDocumentAdapter.find(12, "TestPackage", false, false, false, false);
            Assert.assertNull((Object)r);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testFindCaretAtWordStart() {
        FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        try {
            IRegion r = findReplaceDocumentAdapter.find(8, "TestPackage", true, false, false, false);
            Assert.assertEquals((Object)new Region(8, 11), (Object)r);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testFindCaretAtEndStart() {
        FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        try {
            IRegion r = findReplaceDocumentAdapter.find(19, "TestPackage", false, false, false, false);
            Assert.assertEquals((Object)new Region(8, 11), (Object)r);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testBug74993() {
        FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        try {
            IRegion r = findReplaceDocumentAdapter.find(12, "\\w+", false, false, false, true);
            Assert.assertEquals((Object)new Region(6, 1), (Object)r);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testBug386751() {
        FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        try {
            IRegion result = adapter.find(0, ".", true, false, true, false);
            Assert.assertNull((Object)result);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testUTF8Pattern() {
        FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        try {
            Region result = new Region(153, 6);
            IRegion r = findReplaceDocumentAdapter.find(0, "Gel\u00f6st", true, true, false, false);
            Assert.assertEquals((Object)result, (Object)r);
            r = findReplaceDocumentAdapter.find(0, "Gel\u00f6st", true, true, false, false);
            Assert.assertEquals((Object)result, (Object)r);
            r = findReplaceDocumentAdapter.find(0, "Gel\u00d6st", true, false, false, false);
            Assert.assertEquals((Object)result, (Object)r);
            r = findReplaceDocumentAdapter.find(0, "Gel\u00d6st", true, false, false, false);
            Assert.assertEquals((Object)result, (Object)r);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testReplace() {
        FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        try {
            findReplaceDocumentAdapter.find(0, "public", true, true, false, false);
            IRegion r = findReplaceDocumentAdapter.replace("private", false);
            Assert.assertNotNull((Object)r);
            findReplaceDocumentAdapter.find(0, "public", true, true, false, false);
            r = findReplaceDocumentAdapter.replace("private", false);
            Assert.assertNotNull((Object)r);
            findReplaceDocumentAdapter.find(0, "public", true, true, false, false);
            r = findReplaceDocumentAdapter.replace("private", false);
            Assert.assertNotNull((Object)r);
            findReplaceDocumentAdapter.find(0, "public", true, true, false, false);
            try {
                findReplaceDocumentAdapter.replace("private", false);
            }
            catch (IllegalStateException illegalStateException) {
                Assert.assertTrue((boolean)true);
            }
            String text = "package TestPackage;\n/*\n* comment\n*/\n\tprivate class Class {\n\t\t// comment1\n\t\tprivate void method1() {\n\t\t}\n\t\t// comment2\n\t\tprivate void method2() {\n\t\t}\n\t}\n// Gel\u00f6st";
            Assert.assertEquals((Object)text, (Object)this.fDocument.get());
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    @Ignore
    public void _testRegexReplace() throws Exception {
        this.fDocument.set("UnixWindowsMacInferred\nChars");
        FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        this.regexReplace("Unix", "$0\\n", findReplaceDocumentAdapter);
        this.regexReplace("(Windows)", "$1\\r\\n", findReplaceDocumentAdapter);
        this.regexReplace("(M)ac", "\\0\\r", findReplaceDocumentAdapter);
        this.regexReplace("(Inferred)", "\\1\\R", findReplaceDocumentAdapter);
        this.regexReplace("Chars", "\\\\, \\xF6, \\u00F6, \\t, \\n, \\r, \\f, \\a, \\e, \\cF", findReplaceDocumentAdapter);
        String text = "Unix\nWindows\r\nMac\rInferred\n\n\\, \u00f6, \u00f6, \t, \n, \r, \f, \u0007, \u001b, \u0006";
        Assert.assertEquals((Object)text, (Object)this.fDocument.get());
    }

    @Test
    public void testRegexReplace2() throws Exception {
        FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        this.fDocument.set("foo");
        this.regexReplace("foo", "\\00", findReplaceDocumentAdapter);
        Assert.assertEquals((Object)"foo0", (Object)this.fDocument.get());
        this.fDocument.set("foo");
        this.regexReplace("foo", "\\010", findReplaceDocumentAdapter);
        Assert.assertEquals((Object)"foo10", (Object)this.fDocument.get());
        this.fDocument.set("foo");
        this.regexReplace("foo", "$00", findReplaceDocumentAdapter);
        Assert.assertEquals((Object)"foo0", (Object)this.fDocument.get());
        this.fDocument.set("foo");
        this.regexReplace("foo", "$010", findReplaceDocumentAdapter);
        Assert.assertEquals((Object)"foo10", (Object)this.fDocument.get());
    }

    @Test
    public void testRegexReplace3() throws Exception {
        FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        this.fDocument.set("foo");
        this.regexReplace("(f)oo", "\\10", findReplaceDocumentAdapter);
        Assert.assertEquals((Object)"f0", (Object)this.fDocument.get());
        this.fDocument.set("foo");
        this.regexReplace("(f)oo", "$10", findReplaceDocumentAdapter);
        Assert.assertEquals((Object)"f0", (Object)this.fDocument.get());
    }

    @Test
    public void testRegexRetainCase() throws Exception {
        FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        this.fDocument.set("foo");
        this.regexReplace("foo", "xyz\\Cbar\\Cfar", findReplaceDocumentAdapter);
        Assert.assertEquals((Object)"xyzbarfar", (Object)this.fDocument.get());
        this.fDocument.set("FOO");
        this.regexReplace("FOO", "xyz\\Cbar\\Cfar", findReplaceDocumentAdapter);
        Assert.assertEquals((Object)"xyzBARFAR", (Object)this.fDocument.get());
        this.fDocument.set("Foo");
        this.regexReplace("Foo", "xyz\\Cbar\\Cfar", findReplaceDocumentAdapter);
        Assert.assertEquals((Object)"xyzBarFar", (Object)this.fDocument.get());
        this.fDocument.set("Foox");
        this.regexReplace("F(oo)x", "\\C$1", findReplaceDocumentAdapter);
        Assert.assertEquals((Object)"oo", (Object)this.fDocument.get());
        this.fDocument.set("Foo");
        this.regexReplace("Foo", "xyz\\Cna\\u00EFve\\xFF\\C\\xFF", findReplaceDocumentAdapter);
        Assert.assertEquals((Object)"xyzNa\u00efve\u00ff\u0178", (Object)this.fDocument.get());
        this.fDocument.set("FOO");
        this.regexReplace("FOO", "xyz\\Cna\\u00EFve\\xFF", findReplaceDocumentAdapter);
        Assert.assertEquals((Object)"xyzNA\u00cfVE\u0178", (Object)this.fDocument.get());
        this.fDocument.set("A");
        this.regexReplace("A", "\\Ci", findReplaceDocumentAdapter);
        Assert.assertEquals((Object)"I", (Object)this.fDocument.get());
        Locale currentLocale = Locale.getDefault();
        try {
            Locale.setDefault(new Locale("tr"));
            this.fDocument.set("A");
            this.regexReplace("A", "\\Ci", findReplaceDocumentAdapter);
            Assert.assertEquals((Object)"\u0130", (Object)this.fDocument.get());
            this.fDocument.set("a");
            this.regexReplace("a", "\\CI", findReplaceDocumentAdapter);
            Assert.assertEquals((Object)"\u0131", (Object)this.fDocument.get());
        }
        finally {
            Locale.setDefault(currentLocale);
        }
    }

    private void regexReplace(String find, String replace, FindReplaceDocumentAdapter findReplaceDocumentAdapter) throws BadLocationException {
        findReplaceDocumentAdapter.find(0, find, true, true, false, true);
        IRegion r = findReplaceDocumentAdapter.replace(replace, true);
        Assert.assertNotNull((Object)r);
    }

    @Test
    public void testRegexFindLinebreak() throws Exception {
        FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        String contents = "Unix\nWindows\r\nMac\rEnd";
        this.fDocument.set(contents);
        int n = contents.indexOf("\n");
        int rn = contents.indexOf("\r\n");
        int r = contents.indexOf("\rEnd");
        IRegion region = adapter.find(0, "\\R", true, false, false, true);
        Assert.assertEquals((Object)new Region(n, 1), (Object)region);
        region = adapter.find(n + 1, "\\R", true, false, false, true);
        Assert.assertEquals((Object)new Region(rn, 2), (Object)region);
        region = adapter.find(rn + 2, "\\R", true, false, false, true);
        Assert.assertEquals((Object)new Region(r, 1), (Object)region);
        region = adapter.find(r + 1, "\\R", true, false, false, true);
        Assert.assertNull((Object)region);
    }

    @Test
    public void testRegexFindLinebreak2_fail() throws Exception {
        FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        String contents = "Unix\n[\\R]\\R\r\n";
        this.fDocument.set(contents);
        int n = contents.indexOf("\n");
        int rn = contents.indexOf("\r\n");
        IRegion region = adapter.find(0, "[a-zA-Z\\t{\\\\R}]*\\{?\\R", true, false, false, true);
        Assert.assertEquals((Object)new Region(0, n + 1), (Object)region);
        region = adapter.find(n + 1, "\\Q[\\R]\\R\\E{0,1}(\\R)", true, false, false, true);
        Assert.assertEquals((Object)new Region(n + 1, rn + 2 - (n + 1)), (Object)region);
        try {
            adapter.replace("Win\\1$1", true);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return;
        }
        Assert.fail();
    }

    @Test
    @Ignore
    public void _testRegexFindLinebreak2() throws Exception {
        FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        String contents = "+[\\R]\\R\r\n";
        this.fDocument.set(contents);
        int n = contents.indexOf("[");
        int rn = contents.indexOf("\r\n");
        IRegion region = adapter.find(0, "[a-zA-Z\\t{\\\\R}]*\\{?\\R", true, false, false, true);
        Assert.assertEquals((Object)new Region(0, n - 1), (Object)region);
        region = adapter.find(n, "\\Q[\\R]\\R\\E{0,1}(\\R)", true, false, false, true);
        Assert.assertEquals((Object)new Region(n, rn + 2 - n), (Object)region);
        adapter.replace("Win\\1$1", true);
        Assert.assertEquals((Object)"+Win\r\n\r\n", (Object)this.fDocument.get());
    }

    @Test
    public void testRegexFindLinebreak3() throws Exception {
        FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        String contents = "One\r\nTwo\r\n\r\nEnd";
        this.fDocument.set(contents);
        int two = contents.indexOf("Two");
        int end = contents.indexOf("End");
        IRegion region = adapter.find(0, "[a-zA-Z]+\\R", true, false, false, true);
        Assert.assertEquals((Object)new Region(0, two), (Object)region);
        region = adapter.find(two, "[a-zA-Z]+\\R", true, false, false, true);
        Assert.assertEquals((Object)new Region(two, 5), (Object)region);
        region = adapter.find(0, "[a-zA-Z]+\\R{2}", true, false, false, true);
        Assert.assertEquals((Object)new Region(two, end - two), (Object)region);
    }

    @Test
    public void testRegexFindLinebreakIllegal() throws Exception {
        FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        this.fDocument.set("\n");
        IRegion region = null;
        try {
            region = adapter.find(0, "[\\R]", true, false, false, true);
        }
        catch (PatternSyntaxException patternSyntaxException) {}
        Assert.assertNull(region);
        try {
            region = adapter.find(0, "[\\s&&[^\\R]]", true, false, false, true);
        }
        catch (PatternSyntaxException patternSyntaxException) {}
        Assert.assertNull((Object)region);
        try {
            region = adapter.find(0, "\\p{\\R}", true, false, false, true);
        }
        catch (PatternSyntaxException patternSyntaxException) {}
        Assert.assertNull((Object)region);
    }

    @Test
    public void testIllegalState() {
        FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        try {
            findReplaceDocumentAdapter.replace("TestPackage", false);
        }
        catch (IllegalStateException illegalStateException) {
            Assert.assertTrue((boolean)true);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        findReplaceDocumentAdapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        try {
            findReplaceDocumentAdapter.replace("TestPackage", true);
        }
        catch (IllegalStateException illegalStateException) {
            Assert.assertTrue((boolean)true);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testRegexFindStackOverflow_fail() throws Exception {
        if (System.getProperty("os.name").indexOf("Mac") != -1) {
            return;
        }
        FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter((IDocument)this.fDocument);
        int len = 100000;
        char[] chars = new char[len];
        Arrays.fill(chars, '\n');
        chars[0] = 123;
        chars[len - 1] = 125;
        this.fDocument.set(new String(chars));
        try {
            adapter.find(0, "\\{(.|[\\r\\n])*\\}", true, false, false, true);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return;
        }
        Assert.fail();
    }
}

