/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ConfigurableLineTracker;
import org.eclipse.jface.text.GapTextStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.tests.AbstractLineTrackerTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LineTrackerTest3
extends AbstractLineTrackerTest {
    @Before
    public void setUp() {
        this.fText = new GapTextStore();
        this.fTracker = new ConfigurableLineTracker(new String[]{"\n"});
        this.set("x\nx\nx\nx\nx\n");
    }

    @After
    public void tearDown() {
        this.fTracker = null;
        this.fText = null;
    }

    @Override
    protected int getLineOffset(int line, int[] lines) {
        int offset = 0;
        int i = 0;
        while (i < line) {
            offset += lines[i] + 1;
            ++i;
        }
        return offset;
    }

    @Test
    public void testEditScript1() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        this.replace(0, this.fText.getLength(), "x");
        this.checkLines(new int[]{1});
        this.replace(1, 0, "y");
        this.checkLines(new int[]{2});
        this.replace(2, 0, "z");
        this.checkLines(new int[]{3});
        this.replace(3, 0, "\n");
        int[] nArray2 = new int[2];
        nArray2[0] = 3;
        this.checkLines(nArray2);
        this.replace(4, 0, "x");
        this.checkLines(new int[]{3, 1});
    }

    @Test
    public void testEmptyLines() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        this.replace(0, 10, null);
        this.checkLines(new int[1]);
        this.replace(0, 0, "\n\n\n\n\n");
        this.checkLines(new int[6]);
        int i = 0;
        while (i < 6) {
            int no = this.fTracker.getLineNumberOfOffset(i);
            Assert.assertTrue((String)("invalid line number " + no + " reported instead of " + i), (no == i ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testInsert1() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        this.replace(3, 0, "yyyy");
        int[] nArray2 = new int[6];
        nArray2[0] = 1;
        nArray2[1] = 5;
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        this.checkLines(nArray2);
        this.replace(9, 0, "y\n");
        int[] nArray3 = new int[7];
        nArray3[0] = 1;
        nArray3[1] = 5;
        nArray3[2] = 2;
        nArray3[4] = 1;
        nArray3[5] = 1;
        this.checkLines(nArray3);
        this.replace(11, 0, "y\n");
        int[] nArray4 = new int[8];
        nArray4[0] = 1;
        nArray4[1] = 5;
        nArray4[2] = 2;
        nArray4[3] = 1;
        nArray4[5] = 1;
        nArray4[6] = 1;
        this.checkLines(nArray4);
        this.replace(13, 0, "y");
        int[] nArray5 = new int[8];
        nArray5[0] = 1;
        nArray5[1] = 5;
        nArray5[2] = 2;
        nArray5[3] = 1;
        nArray5[4] = 1;
        nArray5[5] = 1;
        nArray5[6] = 1;
        this.checkLines(nArray5);
    }

    @Test
    public void testInsert2() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        this.replace(3, 0, "yyyy");
        int[] nArray2 = new int[6];
        nArray2[0] = 1;
        nArray2[1] = 5;
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        this.checkLines(nArray2);
        this.replace(9, 0, "y\ny\ny");
        int[] nArray3 = new int[8];
        nArray3[0] = 1;
        nArray3[1] = 5;
        nArray3[2] = 2;
        nArray3[3] = 1;
        nArray3[4] = 1;
        nArray3[5] = 1;
        nArray3[6] = 1;
        this.checkLines(nArray3);
    }

    @Test
    public void testLinesNumbers() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        this.replace(0, 10, "\na\nbb\nccc\ndddd\neeeee\n");
        int[] nArray2 = new int[7];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 5;
        this.checkLines(nArray2);
        int offset = 0;
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < i) {
                int no = this.fTracker.getLineNumberOfOffset(offset + j);
                Assert.assertTrue((String)("invalid line number " + no + " reported instead of " + i), (no == i ? 1 : 0) != 0);
                ++j;
            }
            offset += i + 1;
            ++i;
        }
    }

    @Test
    public void testOffsets() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        int i = 0;
        while (i < 5) {
            IRegion line = this.fTracker.getLineInformation(i);
            int pos = line.getOffset() + line.getLength();
            int offset = 2 * i + 1;
            Assert.assertTrue((String)("invalid line end offset " + pos + " for line " + i + " should be " + offset), (offset == pos ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < 5) {
            int pos = this.fTracker.getLineOffset(i);
            int offset = 2 * i;
            Assert.assertTrue((String)("invalid line start offset " + pos + " for line " + i + " should be " + offset), (pos == offset ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < 10) {
            int line = this.fTracker.getLineNumberOfOffset(i);
            double l = Math.floor(i / 2);
            Assert.assertTrue((String)("invalid line number " + line + " for position " + i + " should be " + l), (l == (double)line ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testRemove() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        this.replace(3, 1, null);
        int[] nArray2 = new int[5];
        nArray2[0] = 1;
        nArray2[1] = 2;
        nArray2[2] = 1;
        nArray2[3] = 1;
        this.checkLines(nArray2);
        this.replace(6, 1, null);
        int[] nArray3 = new int[4];
        nArray3[0] = 1;
        nArray3[1] = 2;
        nArray3[2] = 2;
        this.checkLines(nArray3);
        this.replace(3, 5, null);
        this.checkLines(new int[]{1, 1});
        this.replace(0, 3, null);
        this.checkLines(new int[1]);
    }

    @Test
    public void testReplace() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        this.replace(0, this.fText.getLength(), "\tx\n\tx\n\tx\n\tx\n\tx\n");
        int[] nArray2 = new int[6];
        nArray2[0] = 2;
        nArray2[1] = 2;
        nArray2[2] = 2;
        nArray2[3] = 2;
        nArray2[4] = 2;
        this.checkLines(nArray2);
    }

    @Test
    public void testReplace2() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        this.replace(0, this.fText.getLength(), "x");
        this.checkLines(new int[]{1});
        this.replace(0, this.fText.getLength(), "x\nx\nx\n");
        int[] nArray2 = new int[4];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[2] = 1;
        this.checkLines(nArray2);
    }

    @Test
    public void testReplace3() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        this.replace(1, 1, "\n");
        int[] nArray2 = new int[6];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        this.checkLines(nArray2);
    }

    @Test
    public void testReplace4() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        int lines = this.fTracker.getNumberOfLines();
        IRegion previous = this.fTracker.getLineInformation(0);
        int i = 1;
        while (i < lines) {
            int lastLineEnd = previous.getOffset() + previous.getLength();
            int lineStart = this.fTracker.getLineInformation(i).getOffset();
            this.replace(lastLineEnd, lineStart - lastLineEnd, "\n");
            int[] nArray2 = new int[6];
            nArray2[0] = 1;
            nArray2[1] = 1;
            nArray2[2] = 1;
            nArray2[3] = 1;
            nArray2[4] = 1;
            this.checkLines(nArray2);
            previous = this.fTracker.getLineInformation(i);
            ++i;
        }
    }

    @Test
    public void testShiftLeft() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        this.replace(0, this.fText.getLength(), "\tx\n\tx\n\tx\n\tx\n\tx\n");
        int[] nArray2 = new int[6];
        nArray2[0] = 2;
        nArray2[1] = 2;
        nArray2[2] = 2;
        nArray2[3] = 2;
        nArray2[4] = 2;
        this.checkLines(nArray2);
        int i = 0;
        while (i < 5) {
            int pos = this.fTracker.getLineOffset(i);
            this.replace(pos, 1, null);
            ++i;
        }
        String txt = this.fText.get(0, this.fText.getLength());
        Assert.assertEquals((String)"invalid text", (Object)"x\nx\nx\nx\nx\n", (Object)txt);
    }

    @Test
    public void testShiftRight() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkLines(nArray);
        int i = 0;
        while (i < 5) {
            int pos = this.fTracker.getLineOffset(i);
            this.replace(pos, 0, "\t");
            ++i;
        }
        int[] nArray2 = new int[6];
        nArray2[0] = 2;
        nArray2[1] = 2;
        nArray2[2] = 2;
        nArray2[3] = 2;
        nArray2[4] = 2;
        this.checkLines(nArray2);
        String txt = this.fText.get(0, this.fText.getLength());
        Assert.assertEquals((String)"invalid text", (Object)"\tx\n\tx\n\tx\n\tx\n\tx\n", (Object)txt);
    }

    @Test
    public void testMultipleNewlines() throws Exception {
        this.fText = new GapTextStore();
        this.fTracker = new ConfigurableLineTracker(new String[]{"\n"});
        this.set("x\n\nx\nx\n\nx\nx\n");
        int[] nArray = new int[8];
        nArray[0] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        this.checkLines(nArray);
        int line = this.fTracker.getLineNumberOfOffset(8);
        Assert.assertTrue((line == 5 ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteEmptyLine() throws Exception {
        this.set("x\nx\n\nx\n\n");
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[3] = 1;
        int[] lengths = nArray;
        this.checkLines(lengths);
        int line = lengths.length - 1;
        while (line >= 0) {
            this.fTracker.replace(this.fTracker.getLineOffset(line), this.fTracker.getLineLength(line), null);
            --line;
        }
    }

    @Test
    public void testDeleteLinesFromEnd() throws Exception {
        this.set("x\nx\n\nx\n\n");
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[3] = 1;
        int[] lengths = nArray;
        this.checkLines(lengths);
        int line = lengths.length - 1;
        while (line >= 0) {
            this.fTracker.replace(this.fTracker.getLineOffset(line), this.fTracker.getLineLength(line), null);
            --line;
        }
    }

    @Test
    public void testDeleteLines() throws Exception {
        int line;
        int lines;
        String content = "";
        int i = 0;
        while (i < 50) {
            this.fTracker.set(String.valueOf(content) + "x\nx\n\nx\n\n");
            lines = this.fTracker.getNumberOfLines();
            line = 0;
            while (line < lines) {
                this.fTracker.replace(this.fTracker.getLineOffset(0), this.fTracker.getLineLength(0), null);
                ++line;
            }
            ++i;
        }
        content = "";
        i = 0;
        while (i < 50) {
            this.fTracker.set(String.valueOf(content) + "x\nx\n\nx\n\n");
            lines = this.fTracker.getNumberOfLines();
            line = lines - 1;
            while (line >= 0) {
                this.fTracker.replace(this.fTracker.getLineOffset(line), this.fTracker.getLineLength(line), null);
                --line;
            }
            ++i;
        }
    }

    @Test
    public void testSet() throws Exception {
        String content = "";
        int i = 0;
        while (i < 35) {
            int[] lenghts = new int[i + 1];
            int j = 0;
            while (j < i + 1) {
                lenghts[j] = j;
                ++j;
            }
            j = 0;
            while (j < i) {
                content = String.valueOf(content) + "x";
                ++j;
            }
            this.set(content);
            this.checkLines(lenghts);
            content = String.valueOf(content) + "\n";
            ++i;
        }
    }

    @Test
    public void testFunnyLastLineCompatibility() throws Exception {
        IRegion line;
        this.set("x\n");
        int[] nArray = new int[2];
        nArray[1] = 2;
        int[] offsets = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 1;
        int[] lengths = nArray2;
        Assert.assertEquals((String)"invalid number of lines, ", (long)lengths.length, (long)this.fTracker.getNumberOfLines());
        Assert.assertEquals((String)"invalid number of lines, ", (long)lengths.length, (long)this.fTracker.getNumberOfLines(0, this.fText.getLength()));
        int i = 0;
        while (i < lengths.length) {
            line = this.fTracker.getLineInformation(i);
            Assert.assertEquals((String)("line: " + i), (long)lengths[i], (long)line.getLength());
            Assert.assertEquals((String)("line: " + i), (long)offsets[i], (long)line.getOffset());
            ++i;
        }
        try {
            this.fTracker.getLineInformation(lengths.length);
            Assert.fail();
        }
        catch (Exception exception) {}
        try {
            this.fTracker.getLineInformationOfOffset(offsets[offsets.length] + 1);
            Assert.fail();
        }
        catch (Exception exception) {}
        this.set("x\nx");
        int[] nArray3 = new int[3];
        nArray3[1] = 2;
        nArray3[2] = 3;
        offsets = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = 1;
        nArray4[1] = 1;
        lengths = nArray4;
        Assert.assertEquals((String)"invalid number of lines, ", (long)(lengths.length - 1), (long)this.fTracker.getNumberOfLines());
        Assert.assertEquals((String)"invalid number of lines, ", (long)(lengths.length - 1), (long)this.fTracker.getNumberOfLines(0, this.fText.getLength()));
        i = 0;
        while (i < lengths.length) {
            line = this.fTracker.getLineInformation(i);
            int len = lengths[i];
            int offset = offsets[i];
            Assert.assertEquals((String)("length of line: " + i), (long)len, (long)line.getLength());
            Assert.assertEquals((String)("offset of line: " + i), (long)offset, (long)line.getOffset());
            line = this.fTracker.getLineInformationOfOffset(offset);
            if (i == lengths.length - 1) {
                len = lengths[i - 1];
                offset = offsets[i - 1];
            }
            Assert.assertEquals((String)("length of line: " + i), (long)len, (long)line.getLength());
            Assert.assertEquals((String)("offset of line: " + i), (long)offset, (long)line.getOffset());
            ++i;
        }
        try {
            this.fTracker.getLineInformation(lengths.length);
            Assert.fail();
        }
        catch (Exception exception) {}
        try {
            this.fTracker.getLineInformationOfOffset(offsets[offsets.length] + 1);
            Assert.fail();
        }
        catch (Exception exception) {}
    }

    @Test
    public void testNoDelimiterLine() throws Exception {
        this.set("abcef");
        this.checkLines(new int[]{5});
        this.replace(0, 0, "");
        this.checkLines(new int[]{5});
    }

    @Test
    public void testFunnyLastLineCompatibility2() throws Exception {
        IRegion line;
        this.set("x\n");
        this.replace(0, 2, "x\n");
        int[] nArray = new int[2];
        nArray[1] = 2;
        int[] offsets = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 1;
        int[] lengths = nArray2;
        Assert.assertEquals((String)"invalid number of lines, ", (long)lengths.length, (long)this.fTracker.getNumberOfLines());
        Assert.assertEquals((String)"invalid number of lines, ", (long)lengths.length, (long)this.fTracker.getNumberOfLines(0, this.fText.getLength()));
        int i = 0;
        while (i < lengths.length) {
            line = this.fTracker.getLineInformation(i);
            Assert.assertEquals((String)("line: " + i), (long)lengths[i], (long)line.getLength());
            Assert.assertEquals((String)("line: " + i), (long)offsets[i], (long)line.getOffset());
            ++i;
        }
        try {
            this.fTracker.getLineInformation(lengths.length);
            Assert.fail();
        }
        catch (Exception exception) {}
        try {
            this.fTracker.getLineInformationOfOffset(offsets[offsets.length] + 1);
            Assert.fail();
        }
        catch (Exception exception) {}
        this.set("x\nx");
        int[] nArray3 = new int[3];
        nArray3[1] = 2;
        nArray3[2] = 3;
        offsets = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = 1;
        nArray4[1] = 1;
        lengths = nArray4;
        Assert.assertEquals((String)"invalid number of lines, ", (long)(lengths.length - 1), (long)this.fTracker.getNumberOfLines());
        Assert.assertEquals((String)"invalid number of lines, ", (long)(lengths.length - 1), (long)this.fTracker.getNumberOfLines(0, this.fText.getLength()));
        i = 0;
        while (i < lengths.length) {
            line = this.fTracker.getLineInformation(i);
            int len = lengths[i];
            int offset = offsets[i];
            Assert.assertEquals((String)("length of line: " + i), (long)len, (long)line.getLength());
            Assert.assertEquals((String)("offset of line: " + i), (long)offset, (long)line.getOffset());
            line = this.fTracker.getLineInformationOfOffset(offset);
            if (i == lengths.length - 1) {
                len = lengths[i - 1];
                offset = offsets[i - 1];
            }
            Assert.assertEquals((String)("length of line: " + i), (long)len, (long)line.getLength());
            Assert.assertEquals((String)("offset of line: " + i), (long)offset, (long)line.getOffset());
            ++i;
        }
        try {
            this.fTracker.getLineInformation(lengths.length);
            Assert.fail();
        }
        catch (Exception exception) {}
        try {
            this.fTracker.getLineInformationOfOffset(offsets[offsets.length] + 1);
            Assert.fail();
        }
        catch (Exception exception) {}
    }

    @Test
    public void testNegativeOffset() throws Exception {
        try {
            Assert.assertEquals((long)-1L, (long)this.fTracker.getLineNumberOfOffset(-1));
            Assert.fail();
        }
        catch (BadLocationException badLocationException) {}
        try {
            this.fTracker.getLineInformationOfOffset(-1);
            Assert.fail();
        }
        catch (BadLocationException badLocationException) {}
        try {
            Assert.assertEquals((long)-1L, (long)this.fTracker.getLineNumberOfOffset(-1000));
            Assert.fail();
        }
        catch (BadLocationException badLocationException) {}
        try {
            this.fTracker.getLineInformationOfOffset(-1000);
            Assert.fail();
        }
        catch (BadLocationException badLocationException) {}
        try {
            this.fTracker.getLineInformationOfOffset(1000);
            Assert.fail();
        }
        catch (BadLocationException badLocationException) {}
        try {
            this.fTracker.getLineNumberOfOffset(1000);
            Assert.fail();
        }
        catch (BadLocationException badLocationException) {}
        try {
            this.fTracker.getLineOffset(-1000);
            Assert.fail();
        }
        catch (BadLocationException badLocationException) {}
        try {
            this.fTracker.getLineInformation(-1000);
            Assert.fail();
        }
        catch (BadLocationException badLocationException) {}
    }

    public void testNegativeOffset2() throws Exception {
        this.replace(0, 0, "x");
        try {
            Assert.assertEquals((long)-1L, (long)this.fTracker.getLineNumberOfOffset(-1));
            Assert.fail();
        }
        catch (BadLocationException badLocationException) {}
        try {
            this.fTracker.getLineInformationOfOffset(-1);
            Assert.fail();
        }
        catch (BadLocationException badLocationException) {}
        try {
            Assert.assertEquals((long)-1L, (long)this.fTracker.getLineNumberOfOffset(-1000));
            Assert.fail();
        }
        catch (BadLocationException badLocationException) {}
        try {
            this.fTracker.getLineInformationOfOffset(-1000);
            Assert.fail();
        }
        catch (BadLocationException badLocationException) {}
        try {
            this.fTracker.getLineInformationOfOffset(1000);
            Assert.fail();
        }
        catch (BadLocationException badLocationException) {}
        try {
            this.fTracker.getLineNumberOfOffset(1000);
            Assert.fail();
        }
        catch (BadLocationException badLocationException) {}
        try {
            this.fTracker.getLineOffset(-1000);
            Assert.fail();
        }
        catch (BadLocationException badLocationException) {}
        try {
            this.fTracker.getLineInformation(-1000);
            Assert.fail();
        }
        catch (BadLocationException badLocationException) {}
    }
}

