/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests.link;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LinkedModeModelTest {
    private List<LinkedPosition> fPositions = new LinkedList<LinkedPosition>();
    private List<IDocument[]> fDocumentMap = new ArrayList<IDocument[]>();
    private static final String GARTEN1 = "\tMARGARETE:\n\tVersprich mir, Heinrich!\n\t \n\tFAUST:\n\tWas ich kann!\n\t \n\tMARGARETE:\n\tNun sag, wie hast du's mit der Religion?\n\tDu bist ein herzlich guter Mann,\n\tAllein ich glaub, du haltst nicht viel davon.\n\t \n\tFAUST:\n\tLas das, mein Kind! Du fuhlst, ich bin dir gut;\n\tFur meine Lieben lies' ich Leib und Blut,\n\tWill niemand sein Gefuhl und seine Kirche rauben.\n\t \n\tMARGARETE:\n\tDas ist nicht recht, man mus dran glauben.\n\t \n\tFAUST:\n\tMus man?\n\t \n\tMARGARETE:\n\tAch! wenn ich etwas auf dich konnte! Du ehrst auch nicht die heil'gen Sakramente.\n\t \n\tFAUST:\n\tIch ehre sie.\n\t \n\tMARGARETE:\n\tDoch ohne Verlangen. Zur Messe, zur Beichte bist du lange nicht gegangen.\n\tGlaubst du an Gott?\n\t \n\tFAUST:\n\tMein Liebchen, wer darf sagen: Ich glaub an Gott?\n\tMagst Priester oder Weise fragen,\n\tUnd ihre Antwort scheint nur Spott\n\tuber den Frager zu sein.\n\t \n\tMARGARETE:\n\tSo glaubst du nicht?\n\t \n\tFAUST:\n\tMishor mich nicht, du holdes Angesicht!\n\tWer darf ihn nennen?\n\tUnd wer bekennen:\n\t\"Ich glaub ihn!\"?\n\tWer empfinden,\n\tUnd sich unterwinden\n\tZu sagen: \"Ich glaub ihn nicht!\"?\n\tDer Allumfasser,\n\tDer Allerhalter,\n\tFast und erhalt er nicht\n\tDich, mich, sich selbst?\n\tWolbt sich der Himmel nicht da droben?\n\tLiegt die Erde nicht hier unten fest?\n\tUnd steigen freundlich blickend\n\tEwige Sterne nicht herauf?\n\tSchau ich nicht Aug in Auge dir,\n\tUnd drangt nicht alles\n\tNach Haupt und Herzen dir,\n\tUnd webt in ewigem Geheimnis\n\tUnsichtbar sichtbar neben dir?\n\tErfull davon dein Herz, so gros es ist,\n\tUnd wenn du ganz in dem Gefuhle selig bist,\n\tNenn es dann, wie du willst,\n\tNenn's Gluck! Herz! Liebe! Gott\n\tIch habe keinen Namen\n\tDafur! Gefuhl ist alles;\n\tName ist Schall und Rauch,\n\tUmnebelnd Himmelsglut.\n";
    private static final String GARTEN2 = "\tMARGARETE:\n\tDas ist alles recht schon und gut;\n\tUngefahr sagt das der Pfarrer auch,\n\tNur mit ein bischen andern Worten.\n\t \n\tFAUST:\n\tEs sagen's allerorten\n\tAlle Herzen unter dem himmlischen Tage,\n\tJedes in seiner Sprache;\n\tWarum nicht ich in der meinen?\n\t \n\tMARGARETE:\n\tWenn man's so hort, mocht's leidlich scheinen,\n\tSteht aber doch immer schief darum;\n\tDenn du hast kein Christentum.\n\t \n\tFAUST:\n\tLiebs Kind!\n\t \n\tMARGARETE:\n\tEs tut mir lange schon weh, Das ich dich in der Gesellschaft seh.\n\t \n\tFAUST:\n\tWieso?\n\t \n\tMARGARETE:\n\tDer Mensch, den du da bei dir hast, Ist mir in tiefer innrer Seele verhast;\n\tEs hat mir in meinem Leben\n\tSo nichts einen Stich ins Herz gegeben\n\tAls des Menschen widrig Gesicht.\n\t \n\tFAUST:\n\tLiebe Puppe, furcht ihn nicht!\n\t \n\tMARGARETE:\n\tSeine Gegenwart bewegt mir das Blut.\n\tIch bin sonst allen Menschen gut;\n\tAber wie ich mich sehne, dich zu schauen,\n\tHab ich vor dem Menschen ein heimlich Grauen,\n\tUnd halt ihn fur einen Schelm dazu!\n\tGott verzeih mir's, wenn ich ihm unrecht tu!\n\t \n\tFAUST:\n\tEs mus auch solche Kauze geben.\n\t \n\tMARGARETE:\n\tWollte nicht mit seinesgleichen leben!\n\tKommt er einmal zur Tur herein,\n\tSieht er immer so spottisch drein\n\tUnd halb ergrimmt;\n\tMan sieht, das er an nichts keinen Anteil nimmt;\n\tEs steht ihm an der Stirn geschrieben,\n\tDas er nicht mag eine Seele lieben.\n\tMir wird's so wohl in deinem Arm,\n\tSo frei, so hingegeben warm,\n\tUnd seine Gegenwart schnurt mir das Innre zu.\n\t \n\tFAUST:\n\tDu ahnungsvoller Engel du!\n\t \n\tMARGARETE:\n\tDas ubermannt mich so sehr,\n\tDas, wo er nur mag zu uns treten,\n\tMein ich sogar, ich liebte dich nicht mehr.\n\tAuch, wenn er da ist, konnt ich nimmer beten,\n\tUnd das frist mir ins Herz hinein;\n\tDir, Heinrich, mus es auch so sein.\n\t \n\tFAUST:\n\tDu hast nun die Antipathie!\n\t \n\tMARGARETE:\n\tIch mus nun fort.\n\t \n\tFAUST:\n\tAch kann ich nie Ein Stundchen ruhig dir am Busen hangen\n\tUnd Brust an Brust und Seel in Seele drangen?\n\t \n\tMARGARETE:\n\tAch wenn ich nur alleine schlief!\n\tIch lies dir gern heut nacht den Riegel offen;\n\tDoch meine Mutter schlaft nicht tief,\n\tUnd wurden wir von ihr betroffen,\n\tIch war gleich auf der Stelle tot!\n\t \n\tFAUST:\n\tDu Engel, das hat keine Not.\n\tHier ist ein Flaschchen!\n\tDrei Tropfen nur In ihren Trank umhullen\n\tMit tiefem Schlaf gefallig die Natur.\n\t \n\tMARGARETE:\n\tWas tu ich nicht um deinetwillen?\n\tEs wird ihr hoffentlich nicht schaden!\n\t \n\tFAUST:\n\tWurd ich sonst, Liebchen, dir es raten?\n\t \n\tMARGARETE:\n\tSeh ich dich, bester Mann, nur an,\n\tWeis nicht, was mich nach deinem Willen treibt,\n\tIch habe schon so viel fur dich getan,\n\tDas mir zu tun fast nichts mehr ubrigbleibt.";

    @Test
    public void testUpdate() throws BadLocationException {
        Document doc1 = new Document(GARTEN1);
        LinkedPositionGroup group1 = new LinkedPositionGroup();
        this.createLinkedPositions(group1, (IDocument)doc1, "MARGARETE");
        LinkedModeModel env = new LinkedModeModel();
        env.addGroup(group1);
        env.forceInstall();
        doc1.replace(1, 9, "GRETCHEN");
        this.assertEquals(group1, "GRETCHEN");
        this.assertUnchanged(group1);
    }

    @Test
    public void testUpdateUnequalContent() throws BadLocationException {
        Document doc1 = new Document(GARTEN1);
        LinkedPositionGroup group1 = new LinkedPositionGroup();
        this.createLinkedPositions(group1, (IDocument)doc1, "Allumfasser");
        this.createLinkedPositions(group1, (IDocument)doc1, "Gott");
        LinkedModeModel env = new LinkedModeModel();
        env.addGroup(group1);
        env.forceInstall();
        doc1.replace(GARTEN1.indexOf("Gott"), 4, "SUPERMAN");
        this.assertEquals(group1, "SUPERMAN");
        this.assertUnchanged(group1);
    }

    @Test
    public void testUpdateTwoGroups() throws BadLocationException {
        Document doc1 = new Document(GARTEN1);
        LinkedPositionGroup group1 = new LinkedPositionGroup();
        this.createLinkedPositions(group1, (IDocument)doc1, "MARGARETE");
        LinkedPositionGroup group2 = new LinkedPositionGroup();
        this.createLinkedPositions(group2, (IDocument)doc1, "FAUST");
        LinkedModeModel env = new LinkedModeModel();
        env.addGroup(group1);
        env.addGroup(group2);
        env.forceInstall();
        doc1.replace(7, 3, "INE");
        this.assertEquals(group1, "MARGARINE");
        this.assertEquals(group2, "FAUST");
        this.assertUnchanged(group1, group2);
    }

    @Test
    public void testUpdateMultipleGroups() throws BadLocationException {
        Document doc1 = new Document(GARTEN1);
        LinkedPositionGroup group1 = new LinkedPositionGroup();
        this.createLinkedPositions(group1, (IDocument)doc1, "MARGARETE");
        LinkedPositionGroup group2 = new LinkedPositionGroup();
        this.createLinkedPositions(group2, (IDocument)doc1, "FAUST");
        LinkedModeModel env = new LinkedModeModel();
        env.addGroup(group1);
        env.addGroup(group2);
        env.forceInstall();
        doc1.replace(7, 3, "INE");
        doc1.replace(42, 1, "");
        doc1.replace(44, 2, "GE");
        this.assertEquals(group1, "MARGARINE");
        this.assertEquals(group2, "AUGE");
        this.assertUnchanged(group1, group2);
    }

    @Test
    public void testUpdateMultiDocument() throws BadLocationException {
        Document doc1 = new Document(GARTEN1);
        Document doc2 = new Document(GARTEN2);
        LinkedPositionGroup group1 = new LinkedPositionGroup();
        this.createLinkedPositions(group1, (IDocument)doc1, "MARGARETE");
        this.createLinkedPositions(group1, (IDocument)doc2, "MARGARETE");
        LinkedPositionGroup group2 = new LinkedPositionGroup();
        this.createLinkedPositions(group2, (IDocument)doc1, "FAUST");
        this.createLinkedPositions(group2, (IDocument)doc2, "FAUST");
        LinkedModeModel env = new LinkedModeModel();
        env.addGroup(group1);
        env.addGroup(group2);
        env.forceInstall();
        doc1.replace(7, 3, "INE");
        doc1.replace(42, 1, "");
        doc1.replace(44, 2, "GE");
        this.assertEquals(group1, "MARGARINE");
        this.assertEquals(group2, "AUGE");
        this.assertUnchanged(group1, group2);
    }

    @Test
    public void testAddCompatibleGroups() throws BadLocationException {
        Document doc1 = new Document(GARTEN1);
        LinkedPositionGroup group1 = new LinkedPositionGroup();
        this.createLinkedPositions(group1, (IDocument)doc1, "MARGARETE");
        LinkedPositionGroup group2 = new LinkedPositionGroup();
        this.createLinkedPositions(group2, (IDocument)doc1, "FAUST");
        LinkedModeModel env = new LinkedModeModel();
        try {
            env.addGroup(group1);
            env.addGroup(group2);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertFalse((boolean)true);
        }
        this.assertUnchanged(group1, group2);
    }

    @Test
    public void testAddIncompatibleGroups() throws BadLocationException {
        Document doc1 = new Document(GARTEN1);
        LinkedPositionGroup group1 = new LinkedPositionGroup();
        this.createLinkedPositions(group1, (IDocument)doc1, "MARGARETE");
        LinkedPositionGroup group2 = new LinkedPositionGroup();
        this.createLinkedPositions(group2, (IDocument)doc1, "MARGA");
        LinkedModeModel env = new LinkedModeModel();
        try {
            env.addGroup(group1);
            env.addGroup(group2);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        Assert.assertFalse((boolean)true);
    }

    @Test
    public void testAddNullGroup() throws BadLocationException {
        LinkedModeModel env = new LinkedModeModel();
        try {
            env.addGroup(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        Assert.assertFalse((boolean)true);
    }

    @Test
    public void testAddGroupWhenSealed() throws BadLocationException {
        Document doc1 = new Document(GARTEN1);
        LinkedPositionGroup group1 = new LinkedPositionGroup();
        this.createLinkedPositions(group1, (IDocument)doc1, "MARGARETE");
        LinkedModeModel env = new LinkedModeModel();
        env.addGroup(group1);
        env.forceInstall();
        LinkedPositionGroup group2 = new LinkedPositionGroup();
        this.createLinkedPositions(group2, (IDocument)doc1, "FAUST");
        try {
            env.addGroup(group2);
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        Assert.assertFalse((boolean)true);
    }

    @Test
    public void testDoubleInstall() throws BadLocationException {
        Document doc1 = new Document(GARTEN1);
        LinkedPositionGroup group1 = new LinkedPositionGroup();
        this.createLinkedPositions(group1, (IDocument)doc1, "MARGARETE");
        LinkedModeModel env = new LinkedModeModel();
        env.addGroup(group1);
        env.forceInstall();
        try {
            env.forceInstall();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        Assert.assertFalse((boolean)true);
    }

    @Test
    public void testEmptyInstall() throws BadLocationException {
        LinkedModeModel env = new LinkedModeModel();
        try {
            env.forceInstall();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        Assert.assertFalse((boolean)true);
    }

    @Test
    public void testNestedUpdate() throws BadLocationException {
        Document doc1 = new Document(GARTEN1);
        LinkedPositionGroup group1 = new LinkedPositionGroup();
        this.createLinkedPositions(group1, (IDocument)doc1, "MARGARETE");
        LinkedPositionGroup group2 = new LinkedPositionGroup();
        this.createLinkedPositions(group2, (IDocument)doc1, "FAUST");
        LinkedModeModel env = new LinkedModeModel();
        env.addGroup(group1);
        env.addGroup(group2);
        env.forceInstall();
        LinkedPositionGroup group1_2 = new LinkedPositionGroup();
        group1_2.addPosition(new LinkedPosition((IDocument)doc1, 7, 3, -1));
        LinkedModeModel childEnv = new LinkedModeModel();
        childEnv.addGroup(group1_2);
        childEnv.forceInstall();
        Assert.assertTrue((boolean)childEnv.isNested());
        Assert.assertFalse((boolean)env.isNested());
        doc1.replace(7, 3, "INE");
        this.assertEquals(group1_2, "INE");
        this.assertEquals(group1, "MARGARINE");
        this.assertEquals(group2, "FAUST");
        this.assertUnchanged(group1, group2);
    }

    @Test
    public void testNestedForceInstall() throws BadLocationException {
        Document doc1 = new Document(GARTEN1);
        LinkedPositionGroup group1 = new LinkedPositionGroup();
        this.createLinkedPositions(group1, (IDocument)doc1, "MARGARETE");
        LinkedPositionGroup group2 = new LinkedPositionGroup();
        this.createLinkedPositions(group2, (IDocument)doc1, "FAUST");
        LinkedModeModel env = new LinkedModeModel();
        env.addGroup(group1);
        env.addGroup(group2);
        final boolean[] isExit = new boolean[1];
        env.addLinkingListener((ILinkedModeListener)new LinkedAdapter(this){

            @Override
            public void left(LinkedModeModel environment, int flags) {
                isExit[0] = true;
            }
        });
        env.forceInstall();
        LinkedPositionGroup group1_2 = new LinkedPositionGroup();
        group1_2.addPosition(new LinkedPosition((IDocument)doc1, 12, 3, -1));
        LinkedModeModel childEnv = new LinkedModeModel();
        childEnv.addGroup(group1_2);
        childEnv.forceInstall();
        Assert.assertFalse((boolean)childEnv.isNested());
        Assert.assertTrue((boolean)isExit[0]);
        doc1.replace(12, 3, "INE");
        this.assertEquals(group1_2, "INE");
    }

    @Test
    public void testNestedTryInstall() throws BadLocationException {
        Document doc1 = new Document(GARTEN1);
        LinkedPositionGroup group1 = new LinkedPositionGroup();
        this.createLinkedPositions(group1, (IDocument)doc1, "MARGARETE");
        LinkedPositionGroup group2 = new LinkedPositionGroup();
        this.createLinkedPositions(group2, (IDocument)doc1, "FAUST");
        LinkedModeModel env = new LinkedModeModel();
        env.addGroup(group1);
        env.addGroup(group2);
        env.forceInstall();
        LinkedPositionGroup group1_2 = new LinkedPositionGroup();
        group1_2.addPosition(new LinkedPosition((IDocument)doc1, 12, 3, -1));
        LinkedModeModel childEnv = new LinkedModeModel();
        childEnv.addGroup(group1_2);
        final boolean[] isExit = new boolean[1];
        env.addLinkingListener((ILinkedModeListener)new LinkedAdapter(this){

            @Override
            public void left(LinkedModeModel environment, int flags) {
                isExit[0] = true;
            }
        });
        Assert.assertFalse((boolean)childEnv.tryInstall());
        Assert.assertFalse((boolean)childEnv.isNested());
        doc1.replace(7, 3, "INE");
        this.assertEquals(group1, "MARGARINE");
        this.assertUnchanged(group1, group2);
    }

    @Test
    public void testOutsideUpdate() throws BadLocationException {
        Document doc1 = new Document(GARTEN1);
        LinkedPositionGroup group1 = new LinkedPositionGroup();
        this.createLinkedPositions(group1, (IDocument)doc1, "MARGARETE");
        LinkedModeModel env = new LinkedModeModel();
        final boolean[] isExit = new boolean[1];
        env.addLinkingListener((ILinkedModeListener)new LinkedAdapter(this){

            @Override
            public void left(LinkedModeModel environment, int flags) {
                isExit[0] = true;
            }
        });
        env.addGroup(group1);
        env.forceInstall();
        doc1.replace(16, 2, "b");
        this.assertEquals(group1, "MARGARETE");
        Assert.assertFalse((boolean)isExit[0]);
        Assert.assertEquals((Object)"\tMARGARETE:\n\tVerbrich mir, Heinrich!", (Object)doc1.get(0, 36));
    }

    @Test
    public void testOverlappingUpdate() throws BadLocationException {
        Document doc1 = new Document(GARTEN1);
        LinkedPositionGroup group1 = new LinkedPositionGroup();
        this.createLinkedPositions(group1, (IDocument)doc1, "MARGARETE");
        LinkedModeModel env = new LinkedModeModel();
        final boolean[] isExit = new boolean[1];
        env.addLinkingListener((ILinkedModeListener)new LinkedAdapter(this){

            @Override
            public void left(LinkedModeModel environment, int flags) {
                isExit[0] = true;
            }
        });
        env.addGroup(group1);
        env.forceInstall();
        doc1.replace(7, 6, "INE-PLANTA");
        this.assertEquals(group1, "MARGARINE-PLANTA");
        Assert.assertFalse((boolean)isExit[0]);
        Assert.assertEquals((Object)"\tMARGARINE-PLANTAVersprich mir, Heinrich!", (Object)doc1.get(0, 41));
    }

    @Test
    public void testOverlappingDelete() throws BadLocationException {
        Document doc1 = new Document(GARTEN1);
        LinkedPositionGroup group1 = new LinkedPositionGroup();
        this.createLinkedPositions(group1, (IDocument)doc1, "MARGARETE");
        LinkedModeModel env = new LinkedModeModel();
        final boolean[] isExit = new boolean[1];
        env.addLinkingListener((ILinkedModeListener)new LinkedAdapter(this){

            @Override
            public void left(LinkedModeModel environment, int flags) {
                isExit[0] = true;
            }
        });
        env.addGroup(group1);
        env.forceInstall();
        doc1.replace(7, 6, "");
        this.assertEquals(group1, "MARGAR");
        Assert.assertFalse((boolean)isExit[0]);
        Assert.assertEquals((Object)"\tMARGARVersprich mir, Heinrich!", (Object)doc1.get(0, 31));
    }

    @Test
    public void testIllegalChange1() throws BadLocationException {
        Document doc1 = new Document(GARTEN1);
        LinkedPositionGroup group1 = new LinkedPositionGroup();
        this.createLinkedPositions(group1, (IDocument)doc1, "MARGARETE");
        LinkedModeModel env = new LinkedModeModel();
        final boolean[] isExit = new boolean[1];
        env.addLinkingListener((ILinkedModeListener)new LinkedAdapter(this){

            @Override
            public void left(LinkedModeModel environment, int flags) {
                isExit[0] = true;
            }
        });
        env.addGroup(group1);
        env.forceInstall();
        doc1.replace(1, 73, "");
        Assert.assertTrue((boolean)isExit[0]);
    }

    @Test
    public void testIllegalChange2() throws BadLocationException {
        Document doc1 = new Document(GARTEN1);
        LinkedPositionGroup group1 = new LinkedPositionGroup();
        this.createLinkedPositions(group1, (IDocument)doc1, "MARGARETE");
        LinkedPositionGroup group2 = new LinkedPositionGroup();
        this.createLinkedPositions(group2, (IDocument)doc1, "FAUST");
        LinkedModeModel env = new LinkedModeModel();
        final boolean[] isExit = new boolean[1];
        env.addLinkingListener((ILinkedModeListener)new LinkedAdapter(this){

            @Override
            public void left(LinkedModeModel environment, int flags) {
                isExit[0] = true;
            }
        });
        env.addGroup(group1);
        env.addGroup(group2);
        env.forceInstall();
        doc1.replace(9, 35, "");
        Assert.assertTrue((boolean)isExit[0]);
    }

    private void assertEquals(LinkedPositionGroup group, String expected) throws BadLocationException {
        LinkedPosition[] positions = group.getPositions();
        int i = 0;
        while (i < positions.length) {
            LinkedPosition pos = positions[i];
            if (!pos.isDeleted()) {
                Assert.assertEquals((Object)expected, (Object)pos.getContent());
            }
            ++i;
        }
    }

    private void assertUnchanged(LinkedPositionGroup actual1) throws BadLocationException {
        this.assertUnchanged(actual1, new LinkedPositionGroup());
    }

    private void assertUnchanged(LinkedPositionGroup actual1, LinkedPositionGroup actual2) throws BadLocationException {
        LinkedPosition[] exp = this.fPositions.toArray(new LinkedPosition[0]);
        LinkedPosition[] act1 = actual1.getPositions();
        LinkedPosition[] act2 = actual2.getPositions();
        LinkedPosition[] act = new LinkedPosition[act1.length + act2.length];
        System.arraycopy(act1, 0, act, 0, act1.length);
        System.arraycopy(act2, 0, act, act1.length, act2.length);
        Arrays.sort(act, new PositionComparator());
        Arrays.sort(exp, new PositionComparator());
        Assert.assertEquals((long)exp.length, (long)act.length);
        LinkedPosition e_prev = null;
        LinkedPosition a_prev = null;
        int i = 0;
        while (i <= exp.length) {
            IDocument e_doc;
            LinkedPosition e_next = i == exp.length ? null : exp[i];
            LinkedPosition a_next = i == exp.length ? null : act[i];
            IDocument iDocument = e_doc = e_prev != null ? e_prev.getDocument() : e_next.getDocument();
            if (e_next != null && e_next.getDocument() != e_doc) {
                Assert.assertEquals((Object)this.getContentBetweenPositions(e_prev, null), (Object)this.getContentBetweenPositions(a_prev, null));
                Assert.assertEquals((Object)this.getContentBetweenPositions(null, e_next), (Object)this.getContentBetweenPositions(null, a_next));
            } else {
                Assert.assertEquals((Object)this.getContentBetweenPositions(e_prev, e_next), (Object)this.getContentBetweenPositions(a_prev, a_next));
            }
            e_prev = e_next;
            a_prev = a_next;
            ++i;
        }
    }

    private String getContentBetweenPositions(LinkedPosition p1, LinkedPosition p2) throws BadLocationException {
        if (p1 == null && p2 == null) {
            return null;
        }
        if (p1 == null) {
            p1 = new LinkedPosition(p2.getDocument(), 0, 0);
        }
        if (p2 == null) {
            p2 = new LinkedPosition(p1.getDocument(), p1.getDocument().getLength(), 0);
        }
        IDocument document = p1.getDocument();
        int offset = p1.getOffset() + p1.getLength();
        int length = p2.getOffset() - offset;
        return document.get(offset, length);
    }

    @Before
    public void setUp() {
        this.fPositions.clear();
        this.fDocumentMap.clear();
    }

    private void createLinkedPositions(LinkedPositionGroup group, IDocument doc, String substring) throws BadLocationException {
        String text = doc.get();
        IDocument original = this.getOriginal(doc);
        if (original == null) {
            original = new Document(text);
            this.putOriginal(doc, original);
        }
        int offset = text.indexOf(substring);
        while (offset != -1) {
            group.addPosition(new LinkedPosition(doc, offset, substring.length(), -1));
            this.fPositions.add(new LinkedPosition(original, offset, substring.length()));
            offset = text.indexOf(substring, offset + 1);
        }
    }

    private void putOriginal(IDocument doc, IDocument original) {
        this.fDocumentMap.add(new IDocument[]{doc, original});
    }

    private IDocument getOriginal(IDocument doc) {
        for (IDocument[] docs : this.fDocumentMap) {
            if (docs[0] != doc) continue;
            return docs[1];
        }
        return null;
    }

    private class LinkedAdapter
    implements ILinkedModeListener {
        private LinkedAdapter() {
        }

        public void left(LinkedModeModel environment, int flags) {
        }

        public void suspend(LinkedModeModel environment) {
        }

        public void resume(LinkedModeModel environment, int flags) {
        }
    }

    public class PositionComparator
    implements Comparator<LinkedPosition> {
        @Override
        public int compare(LinkedPosition p1, LinkedPosition p2) {
            IDocument d2;
            IDocument d1 = p1.getDocument();
            if (d1 == (d2 = p2.getDocument())) {
                return p1.getOffset() - p2.getOffset();
            }
            return this.getIndex(d1) - this.getIndex(d2);
        }

        private int getIndex(IDocument doc) {
            int i = 0;
            for (IDocument[] docs : LinkedModeModelTest.this.fDocumentMap) {
                if (docs[0] == doc || docs[1] == doc) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }
}

