/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests.link;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.LinkedPosition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LinkedPositionTest {
    private static final String GARTEN1 = "\tMARGARETE:\n\tVersprich mir, Heinrich!\n\t \n\tFAUST:\n\tWas ich kann!\n\t \n\tMARGARETE:\n\tNun sag, wie hast du's mit der Religion?\n\tDu bist ein herzlich guter Mann,\n\tAllein ich glaub, du haltst nicht viel davon.\n\t \n\tFAUST:\n\tLas das, mein Kind! Du fuhlst, ich bin dir gut;\n\tFur meine Lieben lies' ich Leib und Blut,\n\tWill niemand sein Gefuhl und seine Kirche rauben.\n\t \n\tMARGARETE:\n\tDas ist nicht recht, man mus dran glauben.\n\t \n\tFAUST:\n\tMus man?\n\t \n\tMARGARETE:\n\tAch! wenn ich etwas auf dich konnte! Du ehrst auch nicht die heil'gen Sakramente.\n\t \n\tFAUST:\n\tIch ehre sie.\n\t \n\tMARGARETE:\n\tDoch ohne Verlangen. Zur Messe, zur Beichte bist du lange nicht gegangen.\n\tGlaubst du an Gott?\n\t \n\tFAUST:\n\tMein Liebchen, wer darf sagen: Ich glaub an Gott?\n\tMagst Priester oder Weise fragen,\n\tUnd ihre Antwort scheint nur Spott\n\tuber den Frager zu sein.\n\t \n\tMARGARETE:\n\tSo glaubst du nicht?\n\t \n\tFAUST:\n\tMishor mich nicht, du holdes Angesicht!\n\tWer darf ihn nennen?\n\tUnd wer bekennen:\n\t\"Ich glaub ihn!\"?\n\tWer empfinden,\n\tUnd sich unterwinden\n\tZu sagen: \"Ich glaub ihn nicht!\"?\n\tDer Allumfasser,\n\tDer Allerhalter,\n\tFast und erhalt er nicht\n\tDich, mich, sich selbst?\n\tWolbt sich der Himmel nicht da droben?\n\tLiegt die Erde nicht hier unten fest?\n\tUnd steigen freundlich blickend\n\tEwige Sterne nicht herauf?\n\tSchau ich nicht Aug in Auge dir,\n\tUnd drangt nicht alles\n\tNach Haupt und Herzen dir,\n\tUnd webt in ewigem Geheimnis\n\tUnsichtbar sichtbar neben dir?\n\tErfull davon dein Herz, so gros es ist,\n\tUnd wenn du ganz in dem Gefuhle selig bist,\n\tNenn es dann, wie du willst,\n\tNenn's Gluck! Herz! Liebe! Gott\n\tIch habe keinen Namen\n\tDafur! Gefuhl ist alles;\n\tName ist Schall und Rauch,\n\tUmnebelnd Himmelsglut.\n";
    private IDocument fDoc;
    private LinkedPosition fPos;

    @Before
    public void setUp() {
        this.fDoc = new Document(GARTEN1);
        this.fPos = new LinkedPosition(this.fDoc, 3, 10);
    }

    @Test
    public void testCreate() {
        new LinkedPosition(this.fDoc, 1, 9);
        new LinkedPosition((IDocument)new Document(), 123, 234);
    }

    @Test
    public void testNullCreate() {
        try {
            new LinkedPosition(null, 1, 9);
        }
        catch (Throwable throwable) {
            return;
        }
        Assert.assertFalse((boolean)true);
    }

    @Test
    public void testIncludesint() {
        Assert.assertEquals((Object)true, (Object)this.fPos.includes(3));
        Assert.assertEquals((Object)true, (Object)this.fPos.includes(6));
        Assert.assertEquals((Object)true, (Object)this.fPos.includes(13));
        Assert.assertEquals((Object)false, (Object)this.fPos.includes(2));
        Assert.assertEquals((Object)false, (Object)this.fPos.includes(15));
    }

    @Test
    public void testGetDocument() {
        Assert.assertEquals((Object)this.fDoc, (Object)this.fPos.getDocument());
    }

    @Test
    public void testOverlapsWithLinkedPosition() {
        LinkedPosition pos = new LinkedPosition(this.fDoc, 0, 2);
        Assert.assertEquals((Object)false, (Object)this.fPos.overlapsWith(pos));
        pos = new LinkedPosition(this.fDoc, 0, 3);
        Assert.assertEquals((Object)false, (Object)this.fPos.overlapsWith(pos));
        pos = new LinkedPosition(this.fDoc, 1, 4);
        Assert.assertEquals((Object)true, (Object)this.fPos.overlapsWith(pos));
        pos = new LinkedPosition(this.fDoc, 3, 5);
        Assert.assertEquals((Object)true, (Object)this.fPos.overlapsWith(pos));
        pos = new LinkedPosition(this.fDoc, 5, 7);
        Assert.assertEquals((Object)true, (Object)this.fPos.overlapsWith(pos));
        pos = new LinkedPosition(this.fDoc, 7, 6);
        Assert.assertEquals((Object)true, (Object)this.fPos.overlapsWith(pos));
        pos = new LinkedPosition(this.fDoc, 7, 7);
        Assert.assertEquals((Object)true, (Object)this.fPos.overlapsWith(pos));
        pos = new LinkedPosition(this.fDoc, 13, 1);
        Assert.assertEquals((Object)false, (Object)this.fPos.overlapsWith(pos));
        pos = new LinkedPosition(this.fDoc, 14, 4);
        Assert.assertEquals((Object)false, (Object)this.fPos.overlapsWith(pos));
    }

    @Test
    public void testIncludesDocumentEvent() {
        DocumentEvent de = new DocumentEvent(this.fDoc, 0, 2, "ignore");
        Assert.assertEquals((Object)false, (Object)this.fPos.includes(de));
        de = new DocumentEvent(this.fDoc, 0, 3, "ignore");
        Assert.assertEquals((Object)false, (Object)this.fPos.includes(de));
        de = new DocumentEvent(this.fDoc, 1, 4, "ignore");
        Assert.assertEquals((Object)false, (Object)this.fPos.includes(de));
        de = new DocumentEvent(this.fDoc, 3, 5, "ignore");
        Assert.assertEquals((Object)true, (Object)this.fPos.includes(de));
        de = new DocumentEvent(this.fDoc, 5, 7, "ignore");
        Assert.assertEquals((Object)true, (Object)this.fPos.includes(de));
        de = new DocumentEvent(this.fDoc, 7, 6, "ignore");
        Assert.assertEquals((Object)true, (Object)this.fPos.includes(de));
        de = new DocumentEvent(this.fDoc, 7, 7, "ignore");
        Assert.assertEquals((Object)false, (Object)this.fPos.includes(de));
        de = new DocumentEvent(this.fDoc, 13, 1, "ignore");
        Assert.assertEquals((Object)false, (Object)this.fPos.includes(de));
        de = new DocumentEvent(this.fDoc, 14, 4, "ignore");
        Assert.assertEquals((Object)false, (Object)this.fPos.includes(de));
    }

    @Test
    public void testIncludesLinkedPosition() {
        LinkedPosition pos = new LinkedPosition(this.fDoc, 0, 2);
        Assert.assertEquals((Object)false, (Object)this.fPos.includes(pos));
        pos = new LinkedPosition(this.fDoc, 0, 3);
        Assert.assertEquals((Object)false, (Object)this.fPos.includes(pos));
        pos = new LinkedPosition(this.fDoc, 1, 4);
        Assert.assertEquals((Object)false, (Object)this.fPos.includes(pos));
        pos = new LinkedPosition(this.fDoc, 3, 5);
        Assert.assertEquals((Object)true, (Object)this.fPos.includes(pos));
        pos = new LinkedPosition(this.fDoc, 5, 7);
        Assert.assertEquals((Object)true, (Object)this.fPos.includes(pos));
        pos = new LinkedPosition(this.fDoc, 7, 6);
        Assert.assertEquals((Object)true, (Object)this.fPos.includes(pos));
        pos = new LinkedPosition(this.fDoc, 7, 7);
        Assert.assertEquals((Object)false, (Object)this.fPos.includes(pos));
        pos = new LinkedPosition(this.fDoc, 13, 1);
        Assert.assertEquals((Object)false, (Object)this.fPos.includes(pos));
        pos = new LinkedPosition(this.fDoc, 14, 4);
        Assert.assertEquals((Object)false, (Object)this.fPos.includes(pos));
    }

    @Test
    public void testGetContent() throws BadLocationException {
        LinkedPosition p = new LinkedPosition(this.fDoc, 1, 9);
        Assert.assertEquals((Object)"MARGARETE", (Object)p.getContent());
        p = new LinkedPosition(this.fDoc, 42, 5);
        Assert.assertEquals((Object)"FAUST", (Object)p.getContent());
        this.fDoc.replace(42, 2, "");
        Assert.assertEquals((Object)"UST:\n", (Object)p.getContent());
        this.fDoc.set(GARTEN1);
        Assert.assertEquals((Object)"FAUST", (Object)p.getContent());
    }

    @Test
    public void testBadLocationContent() {
        LinkedPosition p = new LinkedPosition((IDocument)new Document(), 23, 3);
        try {
            p.getContent();
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        Assert.assertFalse((boolean)true);
        p = new LinkedPosition(this.fDoc, 23, 3);
        this.fDoc.set("");
        try {
            p.getContent();
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        Assert.assertFalse((boolean)true);
    }

    @Test
    public void testGetSequenceNumber() {
        LinkedPosition p = new LinkedPosition(this.fDoc, 1, 9);
        Assert.assertEquals((long)-1L, (long)p.getSequenceNumber());
        p = new LinkedPosition(this.fDoc, 1, 9, 18);
        Assert.assertEquals((long)18L, (long)p.getSequenceNumber());
    }

    @Test
    public void testSetSequenceNumber() {
        this.fPos.setSequenceNumber(28);
        Assert.assertEquals((long)28L, (long)this.fPos.getSequenceNumber());
    }

    @Test
    public void testEquals() {
        LinkedPosition p1 = new LinkedPosition(this.fDoc, 1, 9);
        LinkedPosition p2 = new LinkedPosition(this.fDoc, 1, 9);
        Assert.assertEquals((Object)p1, (Object)p2);
    }

    @Test
    public void testNotEquals() {
        LinkedPosition p1 = new LinkedPosition(this.fDoc, 1, 9);
        LinkedPosition p2 = new LinkedPosition(this.fDoc, 1, 10);
        Assert.assertFalse((boolean)p1.equals((Object)p2));
    }

    @Test
    public void testNotEqualsPosition() {
        LinkedPosition p1 = new LinkedPosition(this.fDoc, 1, 9);
        Position p2 = new Position(1, 9);
        Assert.assertFalse((boolean)p1.equals((Object)p2));
    }

    @Test
    public void testNotEqualsDifferentDoc() {
        LinkedPosition p1 = new LinkedPosition(this.fDoc, 1, 9);
        Document doc = new Document();
        LinkedPosition p2 = new LinkedPosition((IDocument)doc, 1, 9);
        Assert.assertFalse((boolean)p1.equals((Object)p2));
    }
}

