/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.tests.templates;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TemplateVariablesWordSelectionTest {
    private TemplateTranslator fTranslator;
    private DocumentTemplateContext fContext;
    private TemplateContextType fType;

    @Before
    public void setUp() {
        this.fTranslator = new TemplateTranslator();
        this.fType = new TemplateContextType();
        this.fType.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.WordSelection());
        this.fContext = new DocumentTemplateContext(this.fType, (IDocument)new Document(), 0, 0);
    }

    @Test
    public void testWithoutParameter() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("Selected word is ${word_selection}!");
        this.fType.resolve(buffer, (TemplateContext)this.fContext);
        StringBuffer expected = new StringBuffer();
        expected.append("Selected word is !");
        TemplateVariablesWordSelectionTest.assertBufferStringAndVariables(expected.toString(), buffer);
    }

    @Test
    public void testWithParameter() throws Exception {
        TemplateBuffer buffer = this.fTranslator.translate("No selection results in the ${w:word_selection('default')} text.");
        this.fType.resolve(buffer, (TemplateContext)this.fContext);
        StringBuffer expected = new StringBuffer();
        expected.append("No selection results in the default text.");
        TemplateVariablesWordSelectionTest.assertBufferStringAndVariables(expected.toString(), buffer);
    }

    private static void assertBufferStringAndVariables(String expected, TemplateBuffer buffer) {
        Assert.assertEquals((Object)expected, (Object)buffer.getString());
        TemplateVariable[] templateVariableArray = buffer.getVariables();
        int n = templateVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable v = templateVariableArray[n2];
            Assert.assertTrue((boolean)v.isResolved());
            Assert.assertTrue((boolean)v.isUnambiguous());
            ++n2;
        }
    }
}

