/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.tests;

import org.eclipse.core.filebuffers.tests.ResourceHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.text.tests.Accessor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.GotoLineAction;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GotoLineTest {
    private static final String ORIGINAL_CONTENT = "line1\nline2\nline3";
    private IFile fFile;

    private String getOriginalContent() {
        return ORIGINAL_CONTENT;
    }

    @Before
    public void setUp() throws Exception {
        IFolder folder = ResourceHelper.createFolder((String)"GoToLineTestProject/goToLineTests/");
        this.fFile = ResourceHelper.createFile((IFolder)folder, (String)"file.txt", (String)this.getOriginalContent());
    }

    @After
    public void tearDown() throws Exception {
        ResourceHelper.deleteProject((String)"GoToLineTestProject");
        this.fFile = null;
        TestUtil.cleanUp();
    }

    @Test
    public void testGoToFirstLine() {
        this.goToLine(0, 0);
    }

    @Test
    public void testGoToLastLine() {
        this.goToLine(2, 2);
    }

    @Test
    public void testGoToInvalidLine() {
        this.goToLine(1, 1);
        this.goToLine(-1, 1);
        this.goToLine(3, 1);
    }

    private void goToLine(int line, int expectedResult) {
        block6: {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
            try {
                IEditorPart part = IDE.openEditor((IWorkbenchPage)page, (IFile)this.fFile);
                if (part instanceof ITextEditor) {
                    ITextEditor editor = (ITextEditor)part;
                    IAction action = editor.getAction("GotoLine");
                    Accessor accessor = new Accessor((Object)action, GotoLineAction.class);
                    accessor.invoke("gotoLine", new Class[]{Integer.TYPE}, (Object[])new Integer[]{line});
                    Control control = (Control)part.getAdapter(Control.class);
                    if (control instanceof StyledText) {
                        int caretLine = -1;
                        StyledText styledText = (StyledText)control;
                        int caret = styledText.getCaretOffset();
                        try {
                            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                            caretLine = document.getLineOfOffset(caret);
                        }
                        catch (BadLocationException badLocationException) {
                            Assert.fail();
                        }
                        Assert.assertEquals((long)expectedResult, (long)caretLine);
                        break block6;
                    }
                    Assert.fail();
                    break block6;
                }
                Assert.fail();
            }
            catch (PartInitException partInitException) {
                Assert.fail();
            }
        }
    }
}

