/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.tests;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.editors.tests.FileDocumentProviderTest;

class LockJob
extends WorkspaceJob {
    private final IResource resource;
    private AtomicBoolean stopFlag;
    private AtomicBoolean stoppedByTest;

    public LockJob(String name, IResource resource, AtomicBoolean stopFlag, AtomicBoolean stoppedByTest) {
        super(name);
        this.stopFlag = stopFlag;
        this.stoppedByTest = stoppedByTest;
        this.setUser(true);
        this.setSystem(true);
        this.resource = resource;
    }

    public IStatus run2(IProgressMonitor monitor) {
        long startTime = System.currentTimeMillis();
        int maxWaitTime = 300000;
        long stopTime = startTime + (long)maxWaitTime;
        System.out.println("Starting the busy wait while holding lock on: " + this.resource.getFullPath());
        try {
            while (!this.stopFlag.get()) {
                block9: {
                    try {
                        if (System.currentTimeMillis() <= stopTime) break block9;
                        FileDocumentProviderTest.logError("Tiemout occured while waiting on test to finish", new IllegalStateException());
                        this.stoppedByTest.set(true);
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    catch (InterruptedException e) {
                        this.stoppedByTest.set(true);
                        FileDocumentProviderTest.logError("Lock job was interrupted while waiting on test to finish", e);
                        e.printStackTrace();
                        IStatus iStatus = Status.CANCEL_STATUS;
                        System.out.println("Lock task terminated");
                        return iStatus;
                    }
                }
                Thread.sleep(100L);
            }
        }
        finally {
            System.out.println("Lock task terminated");
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return super.belongsTo(family) || LockJob.class == family;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " on " + this.resource;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                try {
                    LockJob.this.run2(pm);
                }
                catch (Exception e) {
                    throw new OperationCanceledException(e.getMessage());
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)this.resource, 0, monitor);
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }
}

