/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.editors.tests.TestUtil;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ZoomTest {
    private static IProject project;
    private static IFile file;
    private StyledText text;
    private AbstractTextEditor editor;
    private int initialFontSize;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("test");
        project.create((IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
        file = project.getFile("foo.txt");
        file.create((InputStream)new ByteArrayInputStream("bar".getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        file.delete(true, (IProgressMonitor)new NullProgressMonitor());
        project.delete(true, (IProgressMonitor)new NullProgressMonitor());
        TestUtil.cleanUp();
    }

    @Before
    public void setUp() throws Exception {
        IIntroPart intro = PlatformUI.getWorkbench().getIntroManager().getIntro();
        if (intro != null) {
            PlatformUI.getWorkbench().getIntroManager().closeIntro(intro);
        }
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        this.editor = (AbstractTextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
        this.editor.setFocus();
        this.text = (StyledText)this.editor.getAdapter(Control.class);
        this.initialFontSize = this.text.getFont().getFontData()[0].getHeight();
    }

    @After
    public void tearDown() throws Exception {
        this.editor.close(false);
        this.editor = null;
    }

    @Test
    public void testZoomCommand() throws Exception {
        int times = 6;
        Command zoomInCommand = ((ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class)).getCommand("org.eclipse.ui.edit.text.zoomIn");
        int i = 0;
        while (i < times) {
            zoomInCommand.executeWithChecks(new ExecutionEvent(zoomInCommand, Collections.EMPTY_MAP, null, null));
            ++i;
        }
        Assert.assertEquals((long)(this.initialFontSize + 12), (long)this.text.getFont().getFontData()[0].getHeight());
        Command zoomOutCommand = ((ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class)).getCommand("org.eclipse.ui.edit.text.zoomOut");
        i = 0;
        while (i < times) {
            zoomOutCommand.executeWithChecks(new ExecutionEvent(zoomOutCommand, Collections.EMPTY_MAP, null, null));
            ++i;
        }
        Assert.assertEquals((long)this.initialFontSize, (long)this.text.getFont().getFontData()[0].getHeight());
    }
}

