/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.fieldassist;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.examples.fieldassist.FieldAssistPlugin;
import org.eclipse.ui.examples.fieldassist.TaskAssistExampleMessages;

public class FieldAssistTestDialog
extends StatusDialog {
    String[] validUsers = new String[]{"tom", "dick", "harry", "ferdinand", "tim", "teresa", "tori", "daniela", "aaron", "kevin", "tod", "mike", "kim", "eric", "paul", "todd"};
    String triggerKey;
    String username;
    boolean showErrorDecoration;
    boolean showErrorMessage;
    boolean showWarningDecoration;
    boolean showRequiredFieldDecoration;
    boolean showRequiredFieldLabelIndicator;
    boolean showSecondaryPopup;
    boolean showContentAssist;
    int marginWidth;
    UserField textField;
    UserField comboField;

    public FieldAssistTestDialog(Shell parent, String username) {
        super(parent);
        this.setTitle(TaskAssistExampleMessages.ExampleDialog_Title);
        this.username = username;
        this.getPreferenceValues();
    }

    protected Control createDialogArea(Composite parent) {
        Composite outer = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)outer);
        this.createSecurityGroup(outer);
        Group autoComplete = new Group(outer, 0);
        autoComplete.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        autoComplete.setLayout((Layout)layout);
        autoComplete.setText(TaskAssistExampleMessages.ExampleDialog_AutoCompleteGroup);
        Label label = new Label((Composite)autoComplete, 16384);
        label.setText(TaskAssistExampleMessages.ExampleDialog_UserName);
        Text text = new Text((Composite)autoComplete, 2048);
        text.setLayoutData((Object)this.getFieldGridData());
        new AutoCompleteField((Control)text, (IControlContentAdapter)new TextContentAdapter(), this.validUsers);
        label = new Label((Composite)autoComplete, 16384);
        label.setText(TaskAssistExampleMessages.ExampleDialog_ComboUserName);
        Combo combo = new Combo((Composite)autoComplete, 2052);
        combo.setText(this.username);
        combo.setItems(this.validUsers);
        combo.setLayoutData((Object)this.getFieldGridData());
        new AutoCompleteField((Control)combo, (IControlContentAdapter)new ComboContentAdapter(), this.validUsers);
        Dialog.applyDialogFont((Control)outer);
        return outer;
    }

    private void getPreferenceValues() {
        IPreferenceStore store = FieldAssistPlugin.getDefault().getPreferenceStore();
        this.showErrorMessage = store.getBoolean("prefShowErrorMessage");
        this.showErrorDecoration = store.getBoolean("prefShowErrorDecoration");
        this.showWarningDecoration = store.getBoolean("prefShowWarningDecoration");
        this.showRequiredFieldDecoration = store.getBoolean("prefShowRequiredFieldDecoration");
        this.showRequiredFieldLabelIndicator = store.getBoolean("prefShowRequiredFieldLabelIndicator");
        this.showSecondaryPopup = store.getBoolean("prefShowSecondaryPopup");
        this.showContentAssist = store.getBoolean("prefShowContentProposalCue");
        this.triggerKey = store.getString("prefContentAssistKey");
        this.marginWidth = store.getInt("prefDecoratorMarginWidth");
    }

    FieldDecoration getCueDecoration() {
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        FieldDecoration dec = registry.getFieldDecoration(FieldAssistPlugin.DEC_CONTENTASSIST);
        if (dec == null) {
            FieldDecoration standardDecoration = registry.getFieldDecoration("DEC_CONTENT_PROPOSAL");
            registry.registerFieldDecoration(FieldAssistPlugin.DEC_CONTENTASSIST, NLS.bind((String)TaskAssistExampleMessages.Decorator_ContentAssist, (Object)this.triggerKey), standardDecoration.getImage());
            dec = registry.getFieldDecoration(FieldAssistPlugin.DEC_CONTENTASSIST);
        }
        return dec;
    }

    FieldDecoration getWarningDecoration() {
        return FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
    }

    void handleModify(SmartField smartField) {
        if (!smartField.isValid()) {
            this.showError(smartField);
        } else {
            this.hideError(smartField);
            if (smartField.isWarning()) {
                this.showWarning(smartField);
            } else {
                this.hideWarning(smartField);
                if (this.showContentAssist && smartField.hasContentAssist()) {
                    this.showContentAssistDecoration(smartField, true);
                } else {
                    this.showContentAssistDecoration(smartField, false);
                    this.showRequiredFieldDecoration(smartField, this.showRequiredFieldDecoration);
                }
            }
        }
    }

    GridData getFieldGridData() {
        int margin = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.widthHint = 200 + margin;
        data.horizontalIndent = margin;
        data.grabExcessHorizontalSpace = true;
        return data;
    }

    GridData getMultiLineTextFieldGridData() {
        int margin = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.widthHint = 200 + margin;
        data.heightHint = JFaceResources.getDialogFont().getFontData()[0].getHeight() * 5;
        data.horizontalIndent = margin;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        return data;
    }

    void showError(SmartField smartField) {
        FieldDecoration dec = smartField.getErrorDecoration();
        if (this.showErrorMessage) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.examples.contentassist", 0, dec.getDescription(), null));
        }
        if (this.showErrorDecoration) {
            this.showErrorDecoration(smartField, true);
        }
    }

    void hideError(SmartField smartField) {
        if (this.showErrorMessage) {
            this.updateStatus(Status.OK_STATUS);
        }
        if (this.showErrorDecoration) {
            this.showErrorDecoration(smartField, false);
        }
    }

    void showWarning(SmartField smartField) {
        if (this.showWarningDecoration) {
            this.showWarningDecoration(smartField, true);
        }
    }

    void hideWarning(SmartField smartField) {
        if (this.showWarningDecoration) {
            this.showWarningDecoration(smartField, false);
        }
    }

    void installContentProposalAdapter(Control control, IControlContentAdapter contentAdapter) {
        KeyStroke keyStroke;
        IPreferenceStore store = FieldAssistPlugin.getDefault().getPreferenceStore();
        boolean propagate = store.getBoolean("prefContentAssistKeyPropagate");
        char[] autoActivationCharacters = null;
        int autoActivationDelay = store.getInt("prefContentAssistDelay");
        if (this.triggerKey.equals("Alphanumeric key (on auto-activate delay)")) {
            keyStroke = null;
        } else if (this.triggerKey.equals("t, d (on auto-activate delay)")) {
            keyStroke = null;
            autoActivationCharacters = new char[]{'t', 'd'};
        } else {
            try {
                keyStroke = KeyStroke.getInstance((String)this.triggerKey);
            }
            catch (ParseException parseException) {
                keyStroke = KeyStroke.getInstance((int)0x1000013);
            }
        }
        ContentProposalAdapter adapter = new ContentProposalAdapter(control, contentAdapter, this.getContentProposalProvider(), keyStroke, autoActivationCharacters);
        adapter.setAutoActivationDelay(autoActivationDelay);
        adapter.setPropagateKeys(propagate);
        adapter.setFilterStyle(this.getContentAssistFilterStyle());
        adapter.setProposalAcceptanceStyle(this.getContentAssistAcceptance());
    }

    private IContentProposalProvider getContentProposalProvider() {
        return new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                IContentProposal[] proposals = new IContentProposal[FieldAssistTestDialog.this.validUsers.length];
                int i = 0;
                while (i < FieldAssistTestDialog.this.validUsers.length) {
                    final String user = FieldAssistTestDialog.this.validUsers[i];
                    proposals[i] = new IContentProposal(){

                        public String getContent() {
                            return user;
                        }

                        public String getLabel() {
                            return user;
                        }

                        public String getDescription() {
                            if ((this).FieldAssistTestDialog.this.showSecondaryPopup && !user.equals("tori")) {
                                return MessageFormat.format(TaskAssistExampleMessages.ExampleDialog_ProposalDescription, user);
                            }
                            return null;
                        }

                        public int getCursorPosition() {
                            return user.length();
                        }
                    };
                    ++i;
                }
                return proposals;
            }
        };
    }

    private int getContentAssistAcceptance() {
        IPreferenceStore store = FieldAssistPlugin.getDefault().getPreferenceStore();
        String acceptanceStyle = store.getString("prefContentResult");
        if (acceptanceStyle.equals("insert")) {
            return 1;
        }
        if (acceptanceStyle.equals("replace")) {
            return 2;
        }
        return 3;
    }

    private int getContentAssistFilterStyle() {
        IPreferenceStore store = FieldAssistPlugin.getDefault().getPreferenceStore();
        String acceptanceStyle = store.getString("prefContentAssistFilter");
        if (acceptanceStyle.equals("character filter")) {
            return 2;
        }
        if (acceptanceStyle.equals("cumulative filter")) {
            return 3;
        }
        return 1;
    }

    void addRequiredFieldIndicator(Label label) {
        String text = label.getText();
        text = text.concat("*");
        label.setText(text);
    }

    FieldDecoration getRequiredFieldDecoration() {
        return FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED");
    }

    int getDecorationLocationBits() {
        IPreferenceStore store = FieldAssistPlugin.getDefault().getPreferenceStore();
        int bits = 0;
        String vert = store.getString("prefDecoratorVerticalLocation");
        bits = vert.equals("prefDecoratorVerticalBottom") ? 1024 : (vert.equals("prefDecoratorVerticalCenter") ? 0x1000000 : 128);
        String horz = store.getString("prefDecoratorHorizontalLocation");
        bits = horz.equals("prefDecoratorHorizontalRight") ? (bits |= 0x20000) : (bits |= 0x4000);
        return bits;
    }

    void createSecurityGroup(Composite parent) {
        Group main = new Group(parent, 0);
        main.setLayoutData((Object)new GridData(1808));
        main.setText(TaskAssistExampleMessages.ExampleDialog_SecurityGroup);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        main.setLayout((Layout)layout);
        Label label = new Label((Composite)main, 16384);
        label.setText(TaskAssistExampleMessages.ExampleDialog_UserName);
        Text text = new Text((Composite)main, 2048);
        ControlDecoration dec = new ControlDecoration((Control)text, this.getDecorationLocationBits());
        dec.setMarginWidth(this.marginWidth);
        dec.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                MessageDialog.openInformation((Shell)FieldAssistTestDialog.this.getShell(), (String)TaskAssistExampleMessages.ExampleDialog_SelectionTitle, (String)TaskAssistExampleMessages.ExampleDialog_SelectionMessage);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.textField = new UserField(dec, (Control)text, (IControlContentAdapter)new TextContentAdapter());
        dec.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                if (FieldAssistTestDialog.this.textField.isValid()) {
                    return;
                }
                if (FieldAssistTestDialog.this.textField.quickFixMenu == null) {
                    FieldAssistTestDialog.this.textField.quickFixMenu = FieldAssistTestDialog.this.createQuickFixMenu(FieldAssistTestDialog.this.textField);
                }
                FieldAssistTestDialog.this.textField.quickFixMenu.setLocation(event.x, event.y);
                FieldAssistTestDialog.this.textField.quickFixMenu.setVisible(true);
            }
        });
        if (this.showRequiredFieldLabelIndicator && this.textField.isRequiredField()) {
            this.addRequiredFieldIndicator(label);
        }
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                FieldAssistTestDialog.this.handleModify(FieldAssistTestDialog.this.textField);
            }
        });
        text.setText(this.username);
        this.installContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter());
        text.setLayoutData((Object)this.getFieldGridData());
        label = new Label((Composite)main, 16384);
        label.setText(TaskAssistExampleMessages.ExampleDialog_ComboUserName);
        Combo combo = new Combo((Composite)main, 2052);
        dec = new ControlDecoration((Control)combo, this.getDecorationLocationBits());
        dec.setMarginWidth(this.marginWidth);
        this.comboField = new UserField(dec, (Control)combo, (IControlContentAdapter)new ComboContentAdapter());
        dec.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                if (FieldAssistTestDialog.this.comboField.isValid()) {
                    return;
                }
                if (FieldAssistTestDialog.this.comboField.quickFixMenu == null) {
                    FieldAssistTestDialog.this.comboField.quickFixMenu = FieldAssistTestDialog.this.createQuickFixMenu(FieldAssistTestDialog.this.comboField);
                }
                FieldAssistTestDialog.this.comboField.quickFixMenu.setLocation(event.x, event.y);
                FieldAssistTestDialog.this.comboField.quickFixMenu.setVisible(true);
            }
        });
        dec.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                MessageDialog.openInformation((Shell)FieldAssistTestDialog.this.getShell(), (String)TaskAssistExampleMessages.ExampleDialog_DefaultSelectionTitle, (String)TaskAssistExampleMessages.ExampleDialog_DefaultSelectionMessage);
            }

            public void widgetSelected(SelectionEvent e) {
            }
        });
        if (this.showRequiredFieldLabelIndicator) {
            this.addRequiredFieldIndicator(label);
        }
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                FieldAssistTestDialog.this.handleModify(FieldAssistTestDialog.this.comboField);
            }
        });
        combo.setText(this.username);
        combo.setItems(this.validUsers);
        combo.setLayoutData((Object)this.getFieldGridData());
        this.installContentProposalAdapter((Control)combo, (IControlContentAdapter)new ComboContentAdapter());
        label = new Label((Composite)main, 16384);
        label.setText(TaskAssistExampleMessages.ExampleDialog_Age);
        Spinner spinner = new Spinner((Composite)main, 2048);
        dec = new ControlDecoration((Control)spinner, this.getDecorationLocationBits());
        dec.setMarginWidth(this.marginWidth);
        if (this.showRequiredFieldLabelIndicator) {
            this.addRequiredFieldIndicator(label);
        }
        final AgeField spinnerField = new AgeField(dec, (Control)spinner, new SpinnerContentAdapter());
        spinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                FieldAssistTestDialog.this.handleModify(spinnerField);
            }
        });
        spinner.setSelection(40);
        spinner.setLayoutData((Object)this.getFieldGridData());
        label = new Label((Composite)main, 16384);
        label.setText(TaskAssistExampleMessages.ExampleDialog_Password);
        text = new Text((Composite)main, 0x400800);
        text.setText("******");
        text.setLayoutData((Object)this.getFieldGridData());
        if (this.showRequiredFieldLabelIndicator) {
            this.addRequiredFieldIndicator(label);
        }
        label = new Label((Composite)main, 16384);
        label.setText(TaskAssistExampleMessages.FieldAssistTestDialog_Comments);
        text = new Text((Composite)main, 2114);
        text.setText(TaskAssistExampleMessages.FieldAssistTestDialog_CommentsDefaultContent);
        text.setLayoutData((Object)this.getMultiLineTextFieldGridData());
        if (this.showRequiredFieldLabelIndicator) {
            this.addRequiredFieldIndicator(label);
        }
        this.installContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter());
    }

    Menu createQuickFixMenu(final SmartField field) {
        Menu newMenu = new Menu(field.control);
        MenuItem item = new MenuItem(newMenu, 8);
        item.setText(TaskAssistExampleMessages.ExampleDialog_DecorationMenuItem);
        item.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                field.quickFix();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        return newMenu;
    }

    void showErrorDecoration(SmartField smartField, boolean show) {
        FieldDecoration dec = smartField.getErrorDecoration();
        ControlDecoration cd = smartField.controlDecoration;
        if (show) {
            cd.setImage(dec.getImage());
            cd.setDescriptionText(dec.getDescription());
            cd.setShowOnlyOnFocus(false);
            cd.show();
        } else {
            cd.hide();
        }
    }

    void showWarningDecoration(SmartField smartField, boolean show) {
        FieldDecoration dec = smartField.getWarningDecoration();
        ControlDecoration cd = smartField.controlDecoration;
        if (show) {
            cd.setImage(dec.getImage());
            cd.setDescriptionText(dec.getDescription());
            cd.setShowOnlyOnFocus(false);
            cd.show();
        } else {
            cd.hide();
        }
    }

    void showRequiredFieldDecoration(SmartField smartField, boolean show) {
        FieldDecoration dec = this.getRequiredFieldDecoration();
        ControlDecoration cd = smartField.controlDecoration;
        if (show) {
            cd.setImage(dec.getImage());
            cd.setDescriptionText(dec.getDescription());
            cd.setShowOnlyOnFocus(false);
            cd.show();
        } else {
            cd.hide();
        }
    }

    void showContentAssistDecoration(SmartField smartField, boolean show) {
        FieldDecoration dec = this.getCueDecoration();
        ControlDecoration cd = smartField.controlDecoration;
        if (show) {
            cd.setImage(dec.getImage());
            cd.setDescriptionText(dec.getDescription());
            cd.setShowOnlyOnFocus(true);
            cd.show();
        } else {
            cd.hide();
        }
    }

    public boolean close() {
        this.textField.dispose();
        this.comboField.dispose();
        return super.close();
    }

    protected boolean isResizable() {
        return true;
    }

    class AgeField
    extends SmartField {
        AgeField(ControlDecoration dec, Control control, IControlContentAdapter adapter) {
            super(dec, control, adapter);
        }

        @Override
        boolean isValid() {
            return true;
        }

        @Override
        boolean isWarning() {
            Spinner spinner = (Spinner)this.control;
            return spinner.getSelection() > 65;
        }

        @Override
        String getWarningMessage() {
            return TaskAssistExampleMessages.ExampleDialog_AgeWarning;
        }
    }

    abstract class SmartField {
        ControlDecoration controlDecoration;
        Control control;
        IControlContentAdapter contentAdapter;
        FieldDecoration errorDecoration;
        FieldDecoration warningDecoration;

        SmartField(ControlDecoration dec, Control control, IControlContentAdapter adapter) {
            this.controlDecoration = dec;
            this.contentAdapter = adapter;
            this.control = control;
        }

        boolean isRequiredField() {
            return true;
        }

        boolean hasQuickFix() {
            return false;
        }

        void quickFix() {
        }

        boolean hasContentAssist() {
            return false;
        }

        void dispose() {
        }

        FieldDecoration getErrorDecoration() {
            if (this.errorDecoration == null) {
                FieldDecoration standardError = this.hasQuickFix() ? FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERRORQUICKFIX") : FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
                this.errorDecoration = this.getErrorMessage() == null ? standardError : new FieldDecoration(standardError.getImage(), this.getErrorMessage());
            }
            return this.errorDecoration;
        }

        FieldDecoration getWarningDecoration() {
            if (this.warningDecoration == null) {
                FieldDecoration standardWarning = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
                this.warningDecoration = this.getWarningMessage() == null ? standardWarning : new FieldDecoration(standardWarning.getImage(), this.getWarningMessage());
            }
            return this.warningDecoration;
        }

        String getContents() {
            return this.contentAdapter.getControlContents(this.control);
        }

        void setContents(String contents) {
            this.contentAdapter.setControlContents(this.control, contents, contents.length());
        }

        abstract boolean isValid();

        abstract boolean isWarning();

        String getErrorMessage() {
            return null;
        }

        String getWarningMessage() {
            return null;
        }
    }

    class SpinnerContentAdapter
    implements IControlContentAdapter {
        SpinnerContentAdapter() {
        }

        public String getControlContents(Control control) {
            return Integer.valueOf(((Spinner)control).getSelection()).toString();
        }

        public void setControlContents(Control control, String text, int cursorPosition) {
        }

        public void insertControlContents(Control control, String text, int cursorPosition) {
        }

        public int getCursorPosition(Control control) {
            return 0;
        }

        public Rectangle getInsertionBounds(Control control) {
            return control.getBounds();
        }

        public void setCursorPosition(Control control, int index) {
        }
    }

    class UserField
    extends SmartField {
        Menu quickFixMenu;

        UserField(ControlDecoration dec, Control control, IControlContentAdapter adapter) {
            super(dec, control, adapter);
        }

        @Override
        boolean isValid() {
            String contents = this.getContents();
            int i = 0;
            while (i < contents.length()) {
                if (!Character.isLetter(contents.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        String getErrorMessage() {
            return TaskAssistExampleMessages.ExampleDialog_UserError;
        }

        @Override
        boolean isWarning() {
            return this.getContents().equals(TaskAssistExampleMessages.ExampleDialog_WarningName);
        }

        @Override
        String getWarningMessage() {
            return TaskAssistExampleMessages.ExampleDialog_UserWarning;
        }

        @Override
        boolean hasContentAssist() {
            return true;
        }

        @Override
        boolean hasQuickFix() {
            return true;
        }

        @Override
        void quickFix() {
            String contents = this.getContents();
            StringBuffer lettersOnly = new StringBuffer();
            int length = contents.length();
            int i = 0;
            while (i < length) {
                char ch;
                if (!Character.isLetter(ch = contents.charAt(i++))) continue;
                lettersOnly.append(ch);
            }
            this.setContents(lettersOnly.toString());
        }

        @Override
        void dispose() {
            if (this.quickFixMenu != null) {
                this.quickFixMenu.dispose();
                this.quickFixMenu = null;
            }
        }
    }
}

