/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.propertysheet;

import java.util.Vector;
import org.eclipse.ui.examples.propertysheet.MessageUtil;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class EmailAddress
implements IPropertySource {
    private String userid;
    private String domain;
    private static final String USERID_DEFAULT = MessageUtil.getString("unknownUser");
    private static final String DOMAIN_DEFAULT = MessageUtil.getString("unknownDomain");
    public static final String P_ID_USERID = "EmailAddress.userid";
    public static final String P_ID_DOMAIN = "EmailAddress.domain";
    public static final String P_USERID = MessageUtil.getString("userid");
    public static final String P_DOMAIN = MessageUtil.getString("domain");
    private static Vector<PropertyDescriptor> descriptors = new Vector(2, 2);

    static {
        descriptors.addElement(new PropertyDescriptor((Object)P_ID_USERID, P_USERID));
        descriptors.addElement(new PropertyDescriptor((Object)P_ID_DOMAIN, P_DOMAIN));
    }

    public EmailAddress() {
    }

    public EmailAddress(String emailAddress) throws IllegalArgumentException {
        this.setEmailAddress(emailAddress);
    }

    private static Vector<PropertyDescriptor> getDescriptors() {
        return descriptors;
    }

    private String getDomain() {
        if (this.domain == null) {
            this.domain = DOMAIN_DEFAULT;
        }
        return this.domain;
    }

    public Object getEditableValue() {
        return this.toString();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return EmailAddress.getDescriptors().toArray(new IPropertyDescriptor[EmailAddress.getDescriptors().size()]);
    }

    public Object getPropertyValue(Object propKey) {
        if (propKey.equals(P_ID_USERID)) {
            return this.getUserid();
        }
        if (propKey.equals(P_ID_DOMAIN)) {
            return this.getDomain();
        }
        return null;
    }

    private String getUserid() {
        if (this.userid == null) {
            this.userid = USERID_DEFAULT;
        }
        return this.userid;
    }

    public boolean isPropertySet(Object property) {
        return false;
    }

    public void resetPropertyValue(Object property) {
    }

    private void setDomain(String newDomain) {
        this.domain = newDomain;
    }

    private void setEmailAddress(String emailAddress) throws IllegalArgumentException {
        if (emailAddress == null) {
            throw new IllegalArgumentException(MessageUtil.getString("emailaddress_cannot_be_set_to_null"));
        }
        int index = emailAddress.indexOf(64);
        int length = emailAddress.length();
        if (index > 0 && index < length) {
            this.setUserid(emailAddress.substring(0, index));
            this.setDomain(emailAddress.substring(index + 1));
            return;
        }
        throw new IllegalArgumentException(MessageUtil.getString("invalid_email_address_format_should_have_been_validated"));
    }

    public void setPropertyValue(Object name, Object value) {
        if (name.equals(P_ID_USERID)) {
            this.setUserid((String)value);
            return;
        }
        if (name.equals(P_ID_DOMAIN)) {
            this.setDomain((String)value);
            return;
        }
    }

    private void setUserid(String newUserid) {
        this.userid = newUserid;
    }

    public String toString() {
        StringBuffer strbuffer = new StringBuffer(this.getUserid());
        strbuffer.append('@');
        strbuffer.append(this.getDomain());
        return strbuffer.toString();
    }
}

