/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.propertysheet;

import java.util.Vector;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.examples.propertysheet.OrganizationElement;
import org.eclipse.ui.examples.propertysheet.UserElement;

public class GroupElement
extends OrganizationElement {
    public static String P_USERS = "users";
    public static String P_SUBGROUPS = "subgroups";
    public static String P_CONTENTS = "contents";
    private Vector<OrganizationElement> subGroups;
    private Vector<OrganizationElement> users;
    private Vector<OrganizationElement> contents;

    public GroupElement(String name, GroupElement parent) {
        super(name, parent);
    }

    public void add(OrganizationElement userGroup) {
        if (userGroup.isUser() || userGroup.isGroup()) {
            this.getContents().add(userGroup);
        }
        if (userGroup.isGroup()) {
            this.getSubGroups().add(userGroup);
            userGroup.setParent(this);
        }
        if (userGroup.isUser()) {
            this.getUsers().add(userGroup);
            userGroup.setParent(this);
        }
    }

    public GroupElement createSubGroup(String name) {
        GroupElement newGroup = new GroupElement(name, this);
        this.add(newGroup);
        return newGroup;
    }

    public UserElement createUser(String name) {
        UserElement newUser = new UserElement(name, this);
        this.add(newUser);
        return newUser;
    }

    public void delete(OrganizationElement userGroup) {
        if (userGroup.isUser() || userGroup.isGroup()) {
            this.getContents().remove(userGroup);
        }
        if (userGroup.isGroup()) {
            this.getSubGroups().remove(userGroup);
        }
        if (userGroup.isUser()) {
            this.getUsers().remove(userGroup);
        }
    }

    public Object[] getChildren(Object o) {
        return this.getContents().toArray();
    }

    private Vector<OrganizationElement> getContents() {
        if (this.contents == null) {
            this.contents = new Vector();
        }
        return this.contents;
    }

    @Override
    public Object getEditableValue() {
        return this.toString();
    }

    public String getErrorMessage() {
        return null;
    }

    private Vector<OrganizationElement> getSubGroups() {
        if (this.subGroups == null) {
            this.subGroups = new Vector();
        }
        return this.subGroups;
    }

    private Vector<OrganizationElement> getUsers() {
        if (this.users == null) {
            this.users = new Vector();
        }
        return this.users;
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    public RGB getForeground(Object element) {
        return null;
    }

    public RGB getBackground(Object element) {
        return null;
    }
}

