/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.propertysheet;

import java.util.Vector;
import org.eclipse.ui.examples.propertysheet.MessageUtil;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class StreetAddress
implements IPropertySource {
    private Integer buildNo;
    private String aptBox;
    private String streetName;
    private static final Integer BUILD_NO_DEFAULT = 0;
    private static final String APTBOX_DEFAULT = MessageUtil.getString("unspecified");
    private static final String STREETNAME_DEFAULT = MessageUtil.getString("unspecified");
    public static final String P_ID_BUILD_NO = "Street.buildingNo";
    public static final String P_ID_APTBOX = "Street.aptNo";
    public static final String P_ID_STREET = "Street.street";
    public static final String P_BUILD_NO = MessageUtil.getString("building_number");
    public static final String P_APTBOX = MessageUtil.getString("apt.no_or_box.no");
    public static final String P_STREET = MessageUtil.getString("street");
    private static Vector<TextPropertyDescriptor> descriptors = new Vector();

    static {
        descriptors.addElement(new TextPropertyDescriptor((Object)P_ID_BUILD_NO, P_BUILD_NO));
        descriptors.addElement(new TextPropertyDescriptor((Object)P_ID_APTBOX, P_APTBOX));
        descriptors.addElement(new TextPropertyDescriptor((Object)P_ID_STREET, P_STREET));
    }

    public StreetAddress() {
    }

    public StreetAddress(int buildNo, String streetName) {
        this.setBuildNo(buildNo);
        this.setStreetName(streetName);
    }

    public StreetAddress(int buildNo, String aptBox, String streetName) {
        this.setBuildNo(buildNo);
        this.setAptBox(aptBox);
        this.setStreetName(streetName);
    }

    public boolean equals(Object ob) {
        return this.toString().equals(ob.toString());
    }

    private String getAptBox() {
        if (this.aptBox == null) {
            this.aptBox = APTBOX_DEFAULT;
        }
        return this.aptBox;
    }

    private Integer getBuildNo() {
        if (this.buildNo == null) {
            this.buildNo = BUILD_NO_DEFAULT;
        }
        return this.buildNo;
    }

    private static Vector<TextPropertyDescriptor> getDescriptors() {
        return descriptors;
    }

    public Object getEditableValue() {
        return this.toString();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return StreetAddress.getDescriptors().toArray(new IPropertyDescriptor[StreetAddress.getDescriptors().size()]);
    }

    public Object getPropertyValue(Object propKey) {
        if (propKey.equals(P_ID_BUILD_NO)) {
            return this.getBuildNo().toString();
        }
        if (propKey.equals(P_ID_APTBOX)) {
            return this.getAptBox();
        }
        if (propKey.equals(P_ID_STREET)) {
            return this.getStreetName();
        }
        return null;
    }

    private String getStreetName() {
        if (this.streetName == null) {
            this.streetName = STREETNAME_DEFAULT;
        }
        return this.streetName;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isPropertySet(Object property) {
        if (property.equals(P_ID_BUILD_NO)) {
            return this.getBuildNo() != BUILD_NO_DEFAULT;
        }
        if (property.equals(P_ID_APTBOX)) {
            return this.getAptBox() != APTBOX_DEFAULT;
        }
        if (property.equals(P_ID_STREET)) {
            return this.getStreetName() != STREETNAME_DEFAULT;
        }
        return false;
    }

    public void resetPropertyValue(Object property) {
        if (property.equals(P_ID_BUILD_NO)) {
            this.setBuildNo(BUILD_NO_DEFAULT);
            return;
        }
        if (property.equals(P_ID_APTBOX)) {
            this.setAptBox(APTBOX_DEFAULT);
            return;
        }
        if (property.equals(P_ID_STREET)) {
            this.setStreetName(STREETNAME_DEFAULT);
            return;
        }
    }

    private void setAptBox(String newAptBox) {
        this.aptBox = newAptBox;
    }

    private void setBuildNo(Integer newBuildNo) {
        this.buildNo = newBuildNo;
    }

    public void setPropertyValue(Object name, Object value) {
        if (name.equals(P_ID_BUILD_NO)) {
            try {
                this.setBuildNo(Integer.parseInt((String)value));
            }
            catch (NumberFormatException numberFormatException) {
                this.setBuildNo(BUILD_NO_DEFAULT);
            }
            return;
        }
        if (name.equals(P_ID_APTBOX)) {
            this.setAptBox((String)value);
            return;
        }
        if (name.equals(P_ID_STREET)) {
            this.setStreetName((String)value);
            return;
        }
    }

    private void setStreetName(String newStreetName) {
        this.streetName = newStreetName;
    }

    public String toString() {
        StringBuffer outStringBuffer = new StringBuffer();
        if (!this.getAptBox().equals(APTBOX_DEFAULT)) {
            outStringBuffer.append(this.getAptBox());
            outStringBuffer.append(", ");
        }
        if (!this.getBuildNo().equals(BUILD_NO_DEFAULT)) {
            outStringBuffer.append(this.getBuildNo());
            outStringBuffer.append(" ");
        }
        if (!this.getStreetName().equals(STREETNAME_DEFAULT)) {
            outStringBuffer.append(this.getStreetName());
        }
        return outStringBuffer.toString();
    }
}

