/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.tests.util.DisplayHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.genericeditor.tests.AbstratGenericEditorTest;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.junit.Assert;
import org.junit.Test;

public class CompletionTest
extends AbstratGenericEditorTest {
    @Test
    public void testCompletion() throws Exception {
        HashSet<Shell> beforeShell = new HashSet<Shell>(Arrays.asList(Display.getDefault().getShells()));
        this.editor.selectAndReveal(3, 0);
        ContentAssistAction action = (ContentAssistAction)this.editor.getAction("ContentAssistProposal");
        action.update();
        action.run();
        CompletionTest.waitAndDispatch(100L);
        HashSet<Shell> afterShell = new HashSet<Shell>(Arrays.asList(Display.getDefault().getShells()));
        afterShell.removeAll(beforeShell);
        Assert.assertEquals((String)"No completion", (long)1L, (long)afterShell.size());
        Shell completionShell = (Shell)afterShell.iterator().next();
        final Table completionProposalList = this.findCompletionSelectionControl((Widget)completionShell);
        new DisplayHelper(){

            protected boolean condition() {
                return completionProposalList.getItemCount() == 2;
            }
        }.waitForCondition(completionShell.getDisplay(), 200L);
        Assert.assertEquals((long)2L, (long)completionProposalList.getItemCount());
        final TableItem computingItem = completionProposalList.getItem(0);
        Assert.assertTrue((String)"Missing computing info entry", (boolean)computingItem.getText().contains("Computing"));
        TableItem completionProposalItem = completionProposalList.getItem(1);
        ICompletionProposal completionProposal = (ICompletionProposal)completionProposalItem.getData();
        Assert.assertEquals((Object)"s are good for a beer.", (Object)completionProposal.getDisplayString());
        completionProposalList.setSelection(completionProposalItem);
        new DisplayHelper(){

            protected boolean condition() {
                return completionProposalList.getItem(0) != computingItem;
            }
        }.waitForCondition(completionShell.getDisplay(), 2200L);
        Assert.assertEquals((long)2L, (long)completionProposalList.getItemCount());
        completionProposalItem = completionProposalList.getItem(0);
        Assert.assertEquals((Object)"s are good for a beer.", (Object)((ICompletionProposal)completionProposalItem.getData()).getDisplayString());
        TableItem otherProposalItem = completionProposalList.getItem(1);
        Assert.assertEquals((Object)"s are also good for soft drink cocktails.", (Object)((ICompletionProposal)otherProposalItem.getData()).getDisplayString());
        Assert.assertEquals((String)"Addition of completion proposal should keep selection", (Object)completionProposal, (Object)completionProposalList.getSelection()[0].getData());
        completionShell.close();
    }

    private Table findCompletionSelectionControl(Widget control) {
        if (control instanceof Table) {
            return (Table)control;
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                Table res = this.findCompletionSelectionControl((Widget)child);
                if (res != null) {
                    return res;
                }
                ++n2;
            }
        }
        return null;
    }
}

