/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import java.io.PrintStream;
import java.util.Collections;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.tests.util.DisplayHelper;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.text.tests.Accessor;
import org.eclipse.ui.genericeditor.tests.AbstratGenericEditorTest;
import org.eclipse.ui.genericeditor.tests.contributions.MarkerResolutionGenerator;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.workbench.texteditor.tests.ScreenshotTest;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class HoverTest
extends AbstratGenericEditorTest {
    @Rule
    public TestName testName = new TestName();

    @Before
    public void skipOnWindows() {
        Assume.assumeFalse((String)"This test currently always fail on Windows (bug 505842), skipping", (boolean)"win32".equals(Platform.getOS()));
    }

    @Test
    public void testHover() throws Exception {
        Shell shell = this.getHoverShell(this.triggerCompletionAndRetrieveInformationControlManager());
        Assert.assertNotNull((Object)this.findControl((Control)shell, StyledText.class, "Alrighty!"));
    }

    @Test
    public void testProblemHover() throws Exception {
        String problemMessage = "Huston...";
        IMarker marker = null;
        try {
            marker = this.file.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("lineNumber", 1);
            marker.setAttribute("severity", 2);
            marker.setAttribute("charStart", 0);
            marker.setAttribute("charEnd", 5);
            marker.setAttribute("message", (Object)problemMessage);
            marker.setAttribute(MarkerResolutionGenerator.FIXME, true);
            AbstractInformationControlManager manager = this.triggerCompletionAndRetrieveInformationControlManager();
            Assert.assertEquals(Collections.singletonList(marker), (Object)this.getHoverData(manager));
            Shell shell = this.getHoverShell(manager);
            Assert.assertNotNull((Object)this.findControl((Control)shell, Label.class, marker.getAttribute("message", "NONE")));
            Link link = this.findControl((Control)shell, Link.class, MarkerResolutionGenerator.FIXME);
            Assert.assertNotNull((Object)link);
            Event event = new Event();
            event.widget = link;
            event.display = link.getDisplay();
            event.doit = true;
            event.type = 13;
            link.notifyListeners(13, event);
            final IMarker m = marker;
            new DisplayHelper(){

                protected boolean condition() {
                    return !m.exists();
                }
            }.waitForCondition(event.display, 1000L);
            Assert.assertFalse((boolean)marker.exists());
        }
        finally {
            if (marker != null && marker.exists()) {
                marker.delete();
            }
        }
    }

    private Shell getHoverShell(final AbstractInformationControlManager manager) {
        final AbstractInformationControl[] control = new AbstractInformationControl[1];
        new DisplayHelper(){

            protected boolean condition() {
                control[0] = (AbstractInformationControl)new Accessor((Object)manager, AbstractInformationControlManager.class).get("fInformationControl");
                return control[0] != null;
            }
        }.waitForCondition(this.editor.getSite().getShell().getDisplay(), 5000L);
        if (control[0] == null) {
            ScreenshotTest.takeScreenshot(this.getClass(), (String)this.testName.getMethodName(), (PrintStream)System.out);
            Assert.fail();
        }
        Shell shell = (Shell)new Accessor((Object)control[0], AbstractInformationControl.class).get("fShell");
        Assert.assertTrue((boolean)shell.isVisible());
        return shell;
    }

    private <T extends Control> T findControl(Control control, Class<T> controlType, String label) {
        if (control.getClass() == controlType) {
            Control res = control;
            if (label == null) {
                return (T)res;
            }
            String controlLabel = null;
            if (control instanceof Label) {
                controlLabel = ((Label)control).getText();
            } else if (control instanceof Link) {
                controlLabel = ((Link)control).getText();
            } else if (control instanceof Text) {
                controlLabel = ((Text)control).getText();
            } else if (control instanceof StyledText) {
                controlLabel = ((StyledText)control).getText();
            }
            if (controlLabel != null && controlLabel.contains(label)) {
                return (T)res;
            }
        } else if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                T res = this.findControl(child, controlType, label);
                if (res != null) {
                    return res;
                }
                ++n2;
            }
        }
        return null;
    }

    private Object getHoverData(AbstractInformationControlManager manager) throws Exception {
        Object hoverData = new Accessor((Object)manager, AbstractInformationControlManager.class).get("fInformation");
        return hoverData;
    }

    private AbstractInformationControlManager triggerCompletionAndRetrieveInformationControlManager() {
        this.editor.selectAndReveal(2, 0);
        final StyledText editorTextWidget = (StyledText)this.editor.getAdapter(Control.class);
        new DisplayHelper(){

            protected boolean condition() {
                return editorTextWidget.isFocusControl() && editorTextWidget.getSelection().x == 2;
            }
        }.waitForCondition(editorTextWidget.getDisplay(), 1000L);
        editorTextWidget.getShell().forceActive();
        editorTextWidget.getShell().setActive();
        editorTextWidget.getShell().setFocus();
        editorTextWidget.getShell().getDisplay().wake();
        Event hoverEvent = new Event();
        hoverEvent.widget = editorTextWidget;
        hoverEvent.type = 32;
        hoverEvent.x = editorTextWidget.getClientArea().x + 5;
        hoverEvent.y = editorTextWidget.getClientArea().y + 5;
        hoverEvent.display = editorTextWidget.getDisplay();
        hoverEvent.doit = true;
        editorTextWidget.getDisplay().setCursorLocation(editorTextWidget.toDisplay(hoverEvent.x, hoverEvent.y));
        editorTextWidget.notifyListeners(32, hoverEvent);
        DisplayHelper.sleep((Display)editorTextWidget.getDisplay(), (long)1000L);
        ITextViewer viewer = (ITextViewer)new Accessor((Object)this.editor, AbstractTextEditor.class).invoke("getSourceViewer", new Object[0]);
        AbstractInformationControlManager textHoverManager = (AbstractInformationControlManager)new Accessor((Object)viewer, TextViewer.class).get("fTextHoverManager");
        return textHoverManager;
    }
}

