/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.forms.util;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.forms.widgets.FormFonts;
import org.junit.Assert;
import org.junit.Test;

public class FormFontsTest {
    @Test
    public void testSingleton() {
        Display display = Display.getCurrent();
        FormFonts instance = FormFonts.getInstance();
        Assert.assertTrue((String)"getInstance() returned a different FormFonts instance", (boolean)instance.equals(FormFonts.getInstance()));
        Font boldSystemFont = instance.getBoldFont(display, display.getSystemFont());
        instance.markFinished(boldSystemFont, display);
        Assert.assertTrue((String)"getInstance() returned a different FormFonts instance after creation and disposal of one bold font", (boolean)instance.equals(FormFonts.getInstance()));
    }

    @Test
    public void testDisposeOne() {
        Display display = Display.getCurrent();
        Font boldSystemFont = FormFonts.getInstance().getBoldFont(display, display.getSystemFont());
        FormFonts.getInstance().markFinished(boldSystemFont, display);
        Assert.assertTrue((String)"markFinished(...) did not dispose a font after a single getBoldFont()", (boolean)boldSystemFont.isDisposed());
    }

    @Test
    public void testMultipleInstances() {
        Display display = Display.getCurrent();
        Font boldSystemFont = FormFonts.getInstance().getBoldFont(display, display.getSystemFont());
        int count = 1;
        while (count < 20) {
            Assert.assertEquals((String)("getBoldFont(...) returned a different font for the same params on iteration " + count), (Object)boldSystemFont, (Object)FormFonts.getInstance().getBoldFont(display, display.getSystemFont()));
            ++count;
        }
        while (count > 0) {
            FormFonts.getInstance().markFinished(boldSystemFont, display);
            if (count != 1) {
                Assert.assertFalse((String)("markFinished(...) disposed a shared font early on iteration " + count), (boolean)boldSystemFont.isDisposed());
            } else {
                Assert.assertTrue((String)"markFinished(...) did not dispose a shared font on the last call", (boolean)boldSystemFont.isDisposed());
            }
            --count;
        }
    }

    @Test
    public void testMultipleFonts() {
        Display display = Display.getCurrent();
        Font veranda = new Font((Device)display, "Veranda", 12, 0);
        Font arial = new Font((Device)display, "Arial", 12, 0);
        Font boldVeranda = FormFonts.getInstance().getBoldFont(display, veranda);
        Font boldArial = FormFonts.getInstance().getBoldFont(display, arial);
        Assert.assertFalse((boolean)boldVeranda.equals((Object)boldArial));
        FormFonts.getInstance().markFinished(boldVeranda, display);
        Assert.assertTrue((boolean)boldVeranda.isDisposed());
        Assert.assertFalse((boolean)boldArial.isDisposed());
        FormFonts.getInstance().markFinished(boldArial, display);
        Assert.assertTrue((boolean)boldArial.isDisposed());
        veranda.dispose();
        arial.dispose();
    }

    @Test
    public void testDisposeUnknown() {
        Display display = Display.getCurrent();
        Font system = new Font((Device)display, display.getSystemFont().getFontData());
        FormFonts.getInstance().markFinished(system, display);
        Assert.assertTrue((String)"markFinished(...) did not dispose of an unknown font", (boolean)system.isDisposed());
    }
}

