/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.forms.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.forms.widgets.FormImages;
import org.junit.Assert;
import org.junit.Test;

public class FormImagesTest {
    private static FormImages instance;

    @Test
    public void testSingleton() throws Exception {
        Display display = Display.getCurrent();
        FormImages instance = FormImages.getInstance();
        Assert.assertTrue((String)"getInstance() returned a different FormImages instance", (boolean)instance.equals(FormImages.getInstance()));
        Image gradient = instance.getGradient(new Color((Device)display, 1, 1, 1), new Color((Device)display, 7, 7, 7), 21, 21, 0, display);
        instance.markFinished(gradient, display);
        Assert.assertTrue((String)"getInstance() returned a different FormImages instance after creation and disposal of one image", (boolean)instance.equals(FormImages.getInstance()));
    }

    @Test
    public void testDisposeOne() throws Exception {
        Display display = Display.getCurrent();
        Image gradient = FormImagesTest.getFormImagesInstance().getGradient(new Color((Device)display, 255, 255, 255), new Color((Device)display, 0, 0, 0), 21, 21, 0, display);
        FormImagesTest.getFormImagesInstance().markFinished(gradient, display);
        Assert.assertTrue((String)"markFinished(...) did not dispose an image after a single getGradient()", (boolean)gradient.isDisposed());
        Assert.assertNull((String)"descriptors map", FormImagesTest.getDescriptors(FormImagesTest.getFormImagesInstance()));
    }

    @Test
    public void testMultipleSimpleInstances() throws Exception {
        Display display = Display.getCurrent();
        Image gradient = FormImagesTest.getFormImagesInstance().getGradient(new Color((Device)display, 200, 200, 200), new Color((Device)display, 0, 0, 0), 30, 16, 3, display);
        int count = 1;
        while (count < 20) {
            Assert.assertEquals((String)("getGradient(...) returned a different image for the same params on iteration " + count), (Object)gradient, (Object)FormImagesTest.getFormImagesInstance().getGradient(new Color((Device)display, 200, 200, 200), new Color((Device)display, 0, 0, 0), 30, 16, 3, display));
            ++count;
        }
        while (count > 0) {
            FormImagesTest.getFormImagesInstance().markFinished(gradient, display);
            if (count != 1) {
                Assert.assertFalse((String)("markFinished(...) disposed a shared image early on iteration " + count), (boolean)gradient.isDisposed());
            } else {
                Assert.assertTrue((String)"markFinished(...) did not dispose a shared image on the last call", (boolean)gradient.isDisposed());
            }
            --count;
        }
        Assert.assertNull((String)"descriptors map", FormImagesTest.getDescriptors(FormImagesTest.getFormImagesInstance()));
    }

    @Test
    public void testMultipleSectionGradientInstances() throws Exception {
        Display display = Display.getCurrent();
        Image gradient = FormImagesTest.getFormImagesInstance().getSectionGradientImage(new Color((Device)display, 200, 200, 200), new Color((Device)display, 0, 0, 0), 30, 16, 3, display);
        int count = 1;
        while (count < 20) {
            Assert.assertEquals((String)("getSectionGradientImage(...) returned a different image for the same params on iteration " + count), (Object)gradient, (Object)FormImagesTest.getFormImagesInstance().getSectionGradientImage(new Color((Device)display, 200, 200, 200), new Color((Device)display, 0, 0, 0), 30, 16, 3, display));
            ++count;
        }
        while (count > 0) {
            FormImagesTest.getFormImagesInstance().markFinished(gradient, display);
            if (count != 1) {
                Assert.assertFalse((String)("markFinished(...) disposed a shared image early on iteration " + count), (boolean)gradient.isDisposed());
            } else {
                Assert.assertTrue((String)"markFinished(...) did not dispose a shared image on the last call", (boolean)gradient.isDisposed());
            }
            --count;
        }
        Assert.assertNull((String)"descriptors map", FormImagesTest.getDescriptors(FormImagesTest.getFormImagesInstance()));
    }

    @Test
    public void testMultipleComplexInstances() throws Exception {
        Display display = Display.getCurrent();
        Image gradient = FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 200, 200, 200), new Color((Device)display, 0, 0, 0)}, new int[]{100}, 31, true, null, display);
        int count = 1;
        while (count < 20) {
            Assert.assertEquals((String)("getGradient(...) returned a different image for the same params on iteration " + count), (Object)gradient, (Object)FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 200, 200, 200), new Color((Device)display, 0, 0, 0)}, new int[]{100}, 31, true, null, display));
            ++count;
        }
        while (count > 0) {
            FormImagesTest.getFormImagesInstance().markFinished(gradient, display);
            if (count != 1) {
                Assert.assertFalse((String)("markFinished(...) disposed a shared image early on iteration " + count), (boolean)gradient.isDisposed());
            } else {
                Assert.assertTrue((String)"markFinished(...) did not dispose a shared image on the last call", (boolean)gradient.isDisposed());
            }
            --count;
        }
        Assert.assertNull((String)"descriptors map", FormImagesTest.getDescriptors(FormImagesTest.getFormImagesInstance()));
    }

    @Test
    public void testMultipleUniqueInstances() throws Exception {
        Display display = Display.getCurrent();
        Image[] images = new Image[]{FormImagesTest.getFormImagesInstance().getGradient(new Color((Device)display, 1, 0, 0), new Color((Device)display, 100, 100, 100), 25, 23, 1, display), FormImagesTest.getFormImagesInstance().getGradient(new Color((Device)display, 0, 1, 0), new Color((Device)display, 100, 100, 100), 25, 23, 1, display), FormImagesTest.getFormImagesInstance().getGradient(new Color((Device)display, 0, 0, 1), new Color((Device)display, 100, 100, 100), 25, 23, 1, display), FormImagesTest.getFormImagesInstance().getGradient(new Color((Device)display, 0, 0, 0), new Color((Device)display, 101, 100, 100), 25, 23, 1, display), FormImagesTest.getFormImagesInstance().getGradient(new Color((Device)display, 0, 0, 0), new Color((Device)display, 100, 101, 100), 25, 23, 1, display), FormImagesTest.getFormImagesInstance().getGradient(new Color((Device)display, 0, 0, 0), new Color((Device)display, 100, 100, 101), 25, 23, 1, display), FormImagesTest.getFormImagesInstance().getGradient(new Color((Device)display, 0, 0, 0), new Color((Device)display, 100, 100, 100), 20, 23, 1, display), FormImagesTest.getFormImagesInstance().getGradient(new Color((Device)display, 0, 0, 0), new Color((Device)display, 100, 100, 100), 25, 10, 1, display), FormImagesTest.getFormImagesInstance().getGradient(new Color((Device)display, 0, 0, 0), new Color((Device)display, 100, 100, 100), 25, 23, 2, display), FormImagesTest.getFormImagesInstance().getGradient(new Color((Device)display, 1, 1, 1), new Color((Device)display, 101, 101, 101), 20, 10, 2, display), FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 0, 0, 0)}, new int[0], 31, true, null, display), FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 0, 0, 0), new Color((Device)display, 1, 1, 1)}, new int[]{80}, 31, true, new Color((Device)display, 255, 255, 255), display), FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 0, 0, 0), new Color((Device)display, 1, 1, 1)}, new int[]{80}, 31, true, new Color((Device)display, 0, 0, 0), display), FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 0, 0, 0), new Color((Device)display, 100, 100, 100)}, new int[]{100}, 31, true, null, display), FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 1, 0, 0), new Color((Device)display, 100, 100, 100)}, new int[]{100}, 31, true, null, display), FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 0, 1, 0), new Color((Device)display, 100, 100, 100)}, new int[]{100}, 31, true, null, display), FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 0, 0, 1), new Color((Device)display, 100, 100, 100)}, new int[]{100}, 31, true, null, display), FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 0, 0, 0), new Color((Device)display, 101, 100, 100)}, new int[]{100}, 31, true, null, display), FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 0, 0, 0), new Color((Device)display, 100, 101, 100)}, new int[]{100}, 31, true, null, display), FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 0, 0, 0), new Color((Device)display, 100, 100, 101)}, new int[]{100}, 31, true, null, display), FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 0, 0, 0), new Color((Device)display, 100, 100, 100)}, new int[]{100}, 20, true, null, display), FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 0, 0, 0), new Color((Device)display, 100, 100, 100)}, new int[]{100}, 31, false, null, display), FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 0, 0, 0), new Color((Device)display, 100, 100, 100)}, new int[]{50}, 31, true, new Color((Device)display, 1, 1, 1), display), FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 1, 1, 1), new Color((Device)display, 101, 101, 101)}, new int[]{50}, 20, false, new Color((Device)display, 1, 1, 1), display)};
        int i = 0;
        while (i < images.length - 1) {
            int j = i + 1;
            while (j < images.length) {
                Assert.assertNotSame((String)("getGradient(...) returned the same image for different parameters: i = " + i + "; j = " + j), (Object)images[i], (Object)images[j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < images.length) {
            FormImagesTest.getFormImagesInstance().markFinished(images[i], display);
            Assert.assertTrue((String)("markFinished(...) did not dispose an image that was only requested once: i = " + i), (boolean)images[i].isDisposed());
            ++i;
        }
        Assert.assertNull((String)"descriptors map", FormImagesTest.getDescriptors(FormImagesTest.getFormImagesInstance()));
    }

    @Test
    public void testComplexEquality() throws Exception {
        Display display = Display.getCurrent();
        Image image1 = FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 0, 0, 0), new Color((Device)display, 255, 255, 255)}, new int[]{100}, 20, true, new Color((Device)display, 100, 100, 100), display);
        Image image2 = FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 0, 0, 0), new Color((Device)display, 255, 255, 255)}, new int[]{100}, 20, true, new Color((Device)display, 0, 0, 0), display);
        Assert.assertEquals((String)"different images were created with only the background color differing when that difference is irrelevant", (Object)image1, (Object)image2);
        FormImagesTest.getFormImagesInstance().markFinished(image1, display);
        FormImagesTest.getFormImagesInstance().markFinished(image2, display);
        image1 = FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 0, 0, 0), new Color((Device)display, 255, 255, 255)}, new int[]{80}, 20, true, new Color((Device)display, 100, 100, 100), display);
        image2 = FormImagesTest.getFormImagesInstance().getGradient(new Color[]{new Color((Device)display, 0, 0, 0), new Color((Device)display, 255, 255, 255)}, new int[]{80}, 20, true, new Color((Device)display, 0, 0, 0), display);
        Assert.assertNotSame((String)"the same image was used when different background colors were specified", (Object)image1, (Object)image2);
        FormImagesTest.getFormImagesInstance().markFinished(image1, display);
        FormImagesTest.getFormImagesInstance().markFinished(image2, display);
        Assert.assertNull((String)"descriptors map", FormImagesTest.getDescriptors(FormImagesTest.getFormImagesInstance()));
    }

    @Test
    public void testToolkitColors() throws Exception {
        String blueKey = "blue";
        String redKey = "red";
        Display display = Display.getCurrent();
        FormToolkit kit1 = new FormToolkit(display);
        kit1.getColors().createColor(blueKey, new RGB(0, 0, 255));
        kit1.getColors().createColor(redKey, new RGB(255, 0, 0));
        FormToolkit kit2 = new FormToolkit(display);
        kit2.getColors().createColor(blueKey, new RGB(0, 0, 255));
        kit2.getColors().createColor(redKey, new RGB(255, 0, 0));
        Image image1 = FormImagesTest.getFormImagesInstance().getGradient(kit1.getColors().getColor(blueKey), kit1.getColors().getColor(redKey), 21, 21, 0, display);
        Image image2 = FormImagesTest.getFormImagesInstance().getGradient(kit2.getColors().getColor(blueKey), kit2.getColors().getColor(redKey), 21, 21, 0, display);
        Assert.assertEquals((String)"different images were created for the same RGBs with different Color instances", (Object)image1, (Object)image2);
        Image image3 = FormImagesTest.getFormImagesInstance().getGradient(new Color((Device)display, 0, 0, 255), new Color((Device)display, 255, 0, 0), 21, 21, 0, display);
        Assert.assertEquals((String)"different images were created for the same RGBs with different Color instances", (Object)image1, (Object)image3);
        kit1.dispose();
        Assert.assertFalse((String)"image was disposed after toolkits were disposed", (boolean)image1.isDisposed());
        kit2.dispose();
        Assert.assertFalse((String)"image was disposed after toolkits were disposed", (boolean)image2.isDisposed());
        FormImagesTest.getFormImagesInstance().markFinished(image1, display);
        Assert.assertFalse((String)"image was disposed early", (boolean)image1.isDisposed());
        FormImagesTest.getFormImagesInstance().markFinished(image2, display);
        Assert.assertFalse((String)"image was disposed early", (boolean)image2.isDisposed());
        FormImagesTest.getFormImagesInstance().markFinished(image3, display);
        Assert.assertTrue((String)"image was not disposed", (boolean)image3.isDisposed());
        Assert.assertNull((String)"descriptors map", FormImagesTest.getDescriptors(FormImagesTest.getFormImagesInstance()));
    }

    @Test
    public void testDisposeUnknown() throws Exception {
        Display display = Display.getCurrent();
        Image image = new Image((Device)display, 10, 10);
        FormImagesTest.getFormImagesInstance().markFinished(image, display);
        Assert.assertTrue((String)"markFinished(...) did not dispose of an unknown image", (boolean)image.isDisposed());
        Assert.assertNull((String)"descriptors map", FormImagesTest.getDescriptors(FormImagesTest.getFormImagesInstance()));
    }

    private static HashMap<?, ?> getDescriptors(FormImages formImages) throws Exception {
        Field field = formImages.getClass().getDeclaredField("descriptors");
        field.setAccessible(true);
        return (HashMap)field.get(formImages);
    }

    private static FormImages getFormImagesInstance() throws Exception {
        if (instance == null) {
            Constructor constructor = FormImages.class.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            instance = (FormImages)constructor.newInstance(new Object[0]);
        }
        return instance;
    }
}

