/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.forms.util;

import java.lang.reflect.Field;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.internal.forms.widgets.FormImages;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImageHyperlinkTest {
    private Display display;
    private Shell shell;
    private GC gc;
    private TestImageHyperlink imageHyperlink;

    @Before
    public void setUp() throws Exception {
        this.display = PlatformUI.getWorkbench().getDisplay();
        this.shell = new Shell(this.display);
        this.shell.setSize(400, 300);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.open();
        Composite composite = new Composite((Composite)this.shell, 512);
        this.imageHyperlink = new TestImageHyperlink(composite, 0);
        this.gc = new GC((Drawable)this.display);
    }

    @After
    public void tearDown() throws Exception {
        this.shell.dispose();
        this.gc.dispose();
    }

    @Test
    public void testNoImageOnCreation() throws Exception {
        Assert.assertNull((Object)this.imageHyperlink.getImage());
        Assert.assertNull((Object)ImageHyperlinkTest.getDisabledImage(this.imageHyperlink));
    }

    @Test
    public void testSetImageDoesNotCreateDisabledImage() throws Exception {
        Image image = this.createGradient();
        this.imageHyperlink.setImage(image);
        Assert.assertNotNull((Object)this.imageHyperlink.getImage());
        Assert.assertNull((Object)ImageHyperlinkTest.getDisabledImage(this.imageHyperlink));
    }

    @Test
    public void testCreateDisabledImageOnPaint() throws Exception {
        Image image = this.createGradient();
        this.imageHyperlink.setImage(image);
        this.imageHyperlink.paintHyperlink(this.gc);
        Assert.assertNotNull((Object)this.imageHyperlink.getImage());
        Assert.assertNull((Object)ImageHyperlinkTest.getDisabledImage(this.imageHyperlink));
    }

    @Test
    public void testCreateDisabledImageOnPaintWhenDisabled() throws Exception {
        Image image = this.createGradient();
        this.imageHyperlink.setImage(image);
        this.imageHyperlink.setEnabled(false);
        this.imageHyperlink.paintHyperlink(this.gc);
        Assert.assertNotNull((Object)this.imageHyperlink.getImage());
        Assert.assertNotNull((Object)ImageHyperlinkTest.getDisabledImage(this.imageHyperlink));
    }

    @Test
    public void testSetImageDisposesPreviousDisabledImage() throws Exception {
        Image prevImage = this.createGradient();
        this.imageHyperlink.setImage(prevImage);
        this.imageHyperlink.setEnabled(false);
        this.imageHyperlink.paintHyperlink(this.gc);
        Image prevDisabledImage = ImageHyperlinkTest.getDisabledImage(this.imageHyperlink);
        Assert.assertFalse((boolean)prevDisabledImage.isDisposed());
        Image image = this.createGradient();
        this.imageHyperlink.setImage(image);
        Assert.assertTrue((boolean)prevDisabledImage.isDisposed());
    }

    @Test
    public void testPaintHyperlinkDoesNotLeakDisabledImage() throws Exception {
        Image prevImage = this.createGradient();
        this.imageHyperlink.setImage(prevImage);
        this.imageHyperlink.setEnabled(false);
        this.imageHyperlink.paintHyperlink(this.gc);
        Image prevDisabledImage = ImageHyperlinkTest.getDisabledImage(this.imageHyperlink);
        this.imageHyperlink.paintHyperlink(this.gc);
        Assert.assertSame((Object)prevDisabledImage, (Object)ImageHyperlinkTest.getDisabledImage(this.imageHyperlink));
    }

    @Test
    public void testSetImageNullClearsDisabledImage() throws Exception {
        Image image = this.createGradient();
        this.imageHyperlink.setImage(image);
        this.imageHyperlink.setEnabled(false);
        this.imageHyperlink.paintHyperlink(this.gc);
        Assert.assertNotNull((Object)ImageHyperlinkTest.getDisabledImage(this.imageHyperlink));
        this.imageHyperlink.setImage(null);
        Assert.assertNull((Object)ImageHyperlinkTest.getDisabledImage(this.imageHyperlink));
    }

    private Image createGradient() {
        return FormImages.getInstance().getGradient(new Color((Device)this.display, 0, 0, 0), new Color((Device)this.display, 100, 100, 100), 1, 1, 1, this.display);
    }

    private static Image getDisabledImage(ImageHyperlink link) throws Exception {
        Field f = ImageHyperlink.class.getDeclaredField("disabledImage");
        f.setAccessible(true);
        return (Image)f.get(link);
    }

    private class TestImageHyperlink
    extends ImageHyperlink {
        public TestImageHyperlink(Composite parent, int style) {
            super(parent, style);
        }

        public void paintHyperlink(GC gc) {
            super.paintHyperlink(gc);
        }
    }
}

