/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.forms.widgets;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.SizeCache;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SizeCacheTest {
    private static Display display;
    private Shell shell;
    private static final String SHORT_TEXT = "Hedgehog";
    private static final String LONG_TEXT = "A hedgehog is any of the spiny mammals of the subfamily Erinaceinae, in the order Erinaceomorpha. There are seventeen species of hedgehog in five genera, found through parts of Europe, Asia, Africa and New Zealand. ";
    private Font font;
    private boolean humanWatching = Boolean.valueOf(System.getProperty("junit.human.watching"));
    private SizeCache sizeCache;
    private Control control;
    private Point expectedSize;

    static {
        try {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        catch (Throwable throwable) {
            display = new Display();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.font = new Font((Device)display, "Arial", 12, 0);
        this.shell = new Shell(display);
        this.shell.setSize(600, 400);
        this.shell.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.shell.setFont(this.font);
        this.shell.open();
    }

    @After
    public void tearDown() throws Exception {
        if (this.humanWatching) {
            SizeCacheTest.dispatch(1000);
        }
        this.shell.dispose();
        this.font.dispose();
    }

    private static void dispatch0() {
        while (display.readAndDispatch()) {
        }
    }

    private static void dispatch(int msec) {
        long cur = System.currentTimeMillis();
        while (true) {
            SizeCacheTest.dispatch0();
            long pass = System.currentTimeMillis() - cur;
            if (pass >= (long)msec) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private Label createLabel(Composite comp, String text, int style) {
        Label l = new Label(comp, style);
        l.setText(text);
        l.setFont(comp.getFont());
        return l;
    }

    private Button createButton(Composite comp, String text, int style) {
        Button l = new Button(comp, style);
        l.setText(text);
        l.setFont(comp.getFont());
        return l;
    }

    private Point checkSizeEquals(int whint, int hhint) {
        this.expectedSize = this.controlComputeSize(whint, hhint);
        this.control.setSize(this.expectedSize);
        this.dispatch();
        this.checkDoubleCall(whint, hhint);
        this.checkPreferedThenOther(whint, hhint);
        return this.expectedSize;
    }

    private Point controlComputeSize(int wHint, int hHint) {
        int adjustedHeightHint;
        Point adjusted = this.computeHintOffset();
        int adjustedWidthHint = wHint;
        if (adjustedWidthHint != -1) {
            adjustedWidthHint = Math.max(0, wHint - adjusted.x);
        }
        if ((adjustedHeightHint = hHint) != -1) {
            adjustedHeightHint = Math.max(0, hHint - adjusted.y);
        }
        Point result = this.control.computeSize(adjustedWidthHint, adjustedHeightHint, true);
        if (wHint != -1) {
            result.x = wHint;
        }
        if (hHint != -1) {
            result.y = hHint;
        }
        return result;
    }

    private Point checkAlterate(int whint, int hhint) {
        Point expectedSize1 = this.controlComputeSize(-1, hhint);
        Point expectedSize2 = this.controlComputeSize(whint, -1);
        this.resetCache();
        this.checkCacheComputeSize(expectedSize1, -1, hhint);
        this.checkCacheComputeSize(expectedSize1, -1, hhint);
        this.checkCacheComputeSize(expectedSize2, whint, -1);
        this.checkCacheComputeSize(expectedSize2, whint, -1);
        return expectedSize1;
    }

    private Point computeHintOffset() {
        Point size = new Point(0, 0);
        if (this.control instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)this.control;
            Rectangle trim = scrollable.computeTrim(0, 0, 0, 0);
            size.x = trim.width;
            size.y = trim.height;
        } else {
            size.y = size.x = this.control.getBorderWidth() * 2;
        }
        return size;
    }

    private void checkPreferedThenOther(int whint, int hhint) {
        this.resetCache();
        this.sizeCache.computeSize(-1, -1);
        this.checkCacheComputeSize(this.expectedSize, whint, hhint);
    }

    private void checkDoubleCall(int whint, int hhint) {
        this.resetCache();
        this.checkCacheComputeSize(this.expectedSize, whint, hhint);
        this.checkCacheComputeSize(this.expectedSize, whint, hhint);
    }

    private void resetCache() {
        this.sizeCache = new SizeCache(this.control);
    }

    private void checkCacheComputeSize(Point calcSize, int whint, int hhint) {
        Point cachedSize = this.sizeCache.computeSize(whint, hhint);
        Assert.assertEquals((Object)calcSize, (Object)cachedSize);
    }

    private void update() {
        this.shell.layout(true, true);
        this.dispatch();
    }

    private void dispatch() {
        if (this.humanWatching) {
            SizeCacheTest.dispatch(200);
        } else {
            SizeCacheTest.dispatch0();
        }
    }

    private Composite createComposite(Composite parent, int flags) {
        Composite comp = new Composite(parent, flags);
        comp.setFont(parent.getFont());
        comp.setBackground(comp.getDisplay().getSystemColor(11));
        return comp;
    }

    private Composite createFillComp(Composite parent, int flags) {
        Composite comp = this.createComposite(parent, flags);
        GridLayoutFactory.fillDefaults().applyTo(comp);
        Label l = this.createLabel(comp, LONG_TEXT, 64);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)l);
        return comp;
    }

    private Composite createFixedComp(Composite parent, int flags) {
        Composite comp = this.createComposite(parent, flags);
        GridLayoutFactory.fillDefaults().applyTo(comp);
        Label l = this.createLabel(comp, SHORT_TEXT, 0);
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)l);
        return comp;
    }

    private void checkCacheSize(Control inner) {
        this.update();
        this.control = inner;
        Point size = this.controlComputeSize(-1, -1);
        int w = size.x;
        int h = size.y;
        this.checkSizeEquals(-1, -1);
        this.checkSizeEquals(w, -1);
        this.checkSizeEquals(w / 2, -1);
        this.checkSizeEquals(w * 2, -1);
        this.checkSizeEquals(-1, h);
        this.checkSizeEquals(-1, h / 2);
        this.checkSizeEquals(-1, h * 2);
        this.checkSizeEquals(w, h);
        this.checkSizeEquals(w / 2, h * 2);
        this.checkSizeEquals(w * 2, h * 2);
        this.checkSizeEquals(1, -1);
        this.checkSizeEquals(-1, 1);
        this.checkSizeEquals(0, 0);
        this.checkAlterate(w, h);
        this.checkAlterate(w * 2, h * 2);
        this.checkAlterate(w / 2, h / 2);
    }

    @Test
    public void testFixedLabel() {
        this.checkCacheSize((Control)this.createLabel((Composite)this.shell, SHORT_TEXT, 0));
    }

    @Test
    public void testWrapLabel() {
        this.checkCacheSize((Control)this.createLabel((Composite)this.shell, SHORT_TEXT, 64));
    }

    @Test
    public void testFixedComp() {
        this.checkCacheSize((Control)this.createFixedComp((Composite)this.shell, 0));
    }

    @Test
    public void testFixedCompWithWrapFlag() {
        this.checkCacheSize((Control)this.createFixedComp((Composite)this.shell, 64));
    }

    @Test
    public void testFillComp() {
        this.checkCacheSize((Control)this.createFillComp((Composite)this.shell, 0));
    }

    @Test
    public void testFillCompWithWrapFlag() {
        this.checkCacheSize((Control)this.createFillComp((Composite)this.shell, 64));
    }

    @Test
    public void testFillCompWithBorder() {
        this.checkCacheSize((Control)this.createFillComp((Composite)this.shell, 2048));
    }

    @Test
    public void testWrapCompNonWrapLabels() {
        Composite inner = this.createComposite((Composite)this.shell, 0);
        inner.setLayout((Layout)new TableWrapLayout());
        this.createLabel(inner, SHORT_TEXT, 0);
        this.createLabel(inner, LONG_TEXT, 0);
        this.checkCacheSize((Control)inner);
    }

    @Test
    public void testWrapCompWrapLabels() {
        Composite inner = this.createComposite((Composite)this.shell, 0);
        inner.setLayout((Layout)new TableWrapLayout());
        this.createLabel(inner, SHORT_TEXT, 64);
        this.createLabel(inner, LONG_TEXT, 64);
        this.checkCacheSize((Control)inner);
    }

    @Test
    public void testFixedLabelLong() {
        this.checkCacheSize((Control)this.createLabel((Composite)this.shell, LONG_TEXT, 0));
    }

    @Test
    public void testWrapLabelLong() {
        this.checkCacheSize((Control)this.createLabel((Composite)this.shell, LONG_TEXT, 64));
    }

    @Test
    public void testHyperlink() {
        Hyperlink link = new Hyperlink((Composite)this.shell, 0);
        link.setText(LONG_TEXT);
        link.setFont(this.shell.getFont());
        this.checkCacheSize((Control)link);
    }

    @Test
    public void testHyperlinkWithBorder() {
        Hyperlink link = new Hyperlink((Composite)this.shell, 2048);
        link.setText(LONG_TEXT);
        link.setFont(this.shell.getFont());
        this.checkCacheSize((Control)link);
    }

    public void suppressed_testWrapHyperlink() {
        Hyperlink link = new Hyperlink((Composite)this.shell, 64);
        link.setText(LONG_TEXT);
        link.setFont(this.shell.getFont());
        this.checkCacheSize((Control)link);
    }

    public void suppressed_testButton() {
        this.checkCacheSize((Control)this.createButton((Composite)this.shell, LONG_TEXT, 8));
    }

    @Test
    public void testCheckButton() {
        this.checkCacheSize((Control)this.createButton((Composite)this.shell, LONG_TEXT, 32));
    }

    @Test
    public void testWrapCompButtonsWrap() {
        Composite inner = this.createComposite((Composite)this.shell, 0);
        inner.setLayout((Layout)new TableWrapLayout());
        this.createButton(inner, SHORT_TEXT, 96);
        this.createButton(inner, LONG_TEXT, 96);
        this.checkCacheSize((Control)inner);
    }

    @Test
    public void testWrapCompWrapLabels3() {
        Composite inner = this.createComposite((Composite)this.shell, 0);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        inner.setLayout((Layout)layout);
        this.createLabel(inner, SHORT_TEXT, 64);
        this.createLabel(inner, LONG_TEXT, 64);
        this.checkCacheSize((Control)inner);
    }

    @Test
    public void testGripWrap3() {
        Composite inner = this.createComposite((Composite)this.shell, 2048);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(inner);
        GridDataFactory gdf = GridDataFactory.fillDefaults();
        this.createLabel(inner, SHORT_TEXT, 64).setLayoutData((Object)gdf.create());
        this.createLabel(inner, LONG_TEXT, 64).setLayoutData((Object)gdf.create());
        this.createLabel(inner, SHORT_TEXT, 0).setLayoutData((Object)gdf.create());
        this.checkCacheSize((Control)inner);
    }
}

