/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.harness.util;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.junit.Assert;

public class ActionUtil {
    public static void runAction(TestCase test, IContributionItem item) {
        Assert.assertTrue((boolean)(item instanceof ActionContributionItem));
        ((ActionContributionItem)item).getAction().run();
    }

    public static void runActionWithLabel(TestCase test, IMenuManager mgr, String label) {
        IContributionItem[] items;
        IContributionItem[] iContributionItemArray = items = mgr.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof SubContributionItem) {
                item = ((SubContributionItem)item).getInnerItem();
            }
            if (item instanceof ActionContributionItem && label.equals((action = ((ActionContributionItem)item).getAction()).getText())) {
                action.run();
                return;
            }
            ++n2;
        }
        Assert.fail((String)("Unable to find action: " + label));
    }

    public static void runActionWithLabel(TestCase test, IWorkbenchWindow win, String label) {
        WorkbenchWindow realWin = (WorkbenchWindow)win;
        IMenuManager mgr = realWin.getMenuBarManager();
        ActionUtil.runActionWithLabel(test, mgr, label);
    }

    public static void runActionUsingPath(TestCase test, IMenuManager mgr, String idPath) {
        IContributionItem item = mgr.findUsingPath(idPath);
        Assert.assertNotNull((Object)item);
        ActionUtil.runAction(test, item);
    }

    public static void runActionUsingPath(TestCase test, IWorkbenchWindow win, String idPath) {
        WorkbenchWindow realWin = (WorkbenchWindow)win;
        IMenuManager mgr = realWin.getMenuBarManager();
        ActionUtil.runActionUsingPath(test, mgr, idPath);
    }

    public static IAction getActionWithLabel(IMenuManager mgr, String label) {
        IContributionItem[] items;
        IContributionItem[] iContributionItemArray = items = mgr.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof SubContributionItem) {
                item = ((SubContributionItem)item).getInnerItem();
            }
            if (item instanceof ActionContributionItem && label.equals((action = ((ActionContributionItem)item).getAction()).getText())) {
                return action;
            }
            ++n2;
        }
        return null;
    }

    public static void fireAboutToShow(MenuManager mgr) throws Throwable {
        Class<?> clazz = mgr.getClass();
        Method method = clazz.getDeclaredMethod("handleAboutToShow", new Class[0]);
        method.setAccessible(true);
        method.invoke((Object)mgr, new Object[0]);
    }
}

