/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.harness.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class FileUtil {
    private static final int MAX_RETRY = 5;

    public static IProject createProject(String name) throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = ws.getRoot();
        IProject proj = root.getProject(name);
        if (!proj.exists()) {
            proj.create(null);
        }
        if (!proj.isOpen()) {
            proj.open(null);
        }
        return proj;
    }

    public static void deleteProject(IProject proj) throws CoreException {
        proj.delete(true, null);
    }

    public static IFile createFile(String name, IProject proj) throws CoreException {
        IFile file = proj.getFile(name);
        if (!file.exists()) {
            String str = " ";
            ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes());
            file.create((InputStream)in, true, null);
        }
        return file;
    }

    public static void delete(IResource resource) throws CoreException {
        int i = 0;
        while (i < 5) {
            try {
                resource.delete(true, null);
                i = 5;
            }
            catch (CoreException e) {
                if (i == 4) {
                    throw e;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++i;
        }
    }
}

