/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.internal.util;

import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.tests.internal.util.AccessibilityTestPass;
import org.eclipse.ui.tests.internal.util.FailureDialog;
import org.eclipse.ui.tests.internal.util.FocusTestPass;
import org.eclipse.ui.tests.internal.util.IDialogTestPass;
import org.eclipse.ui.tests.internal.util.SizingTestPass;

public class VerifyDialog
extends TitleAreaDialog {
    private int SIZING_WIDTH = 400;
    private static int TEST_TYPE;
    public static final int TEST_SIZING = 0;
    public static final int TEST_FOCUS = 1;
    public static final int TEST_ACCESS = 2;
    private IDialogTestPass[] _dialogTests = new IDialogTestPass[3];
    private Dialog _testDialog;
    private Point _testDialogSize;
    private Label _queryLabel;
    private Button _yesButton;
    private Button[] _checkList;
    private String _failureText;

    public VerifyDialog(Shell parent) {
        super(parent);
        if (TEST_TYPE > 2 && TEST_TYPE < 0) {
            TEST_TYPE = 0;
        }
        this._failureText = "";
        this._dialogTests[0] = new SizingTestPass();
        this._dialogTests[1] = new FocusTestPass();
        this._dialogTests[2] = new AccessibilityTestPass();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Dialog Verification");
        this.setShellStyle(0);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this._yesButton = this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
        this.createButton(parent, 3, IDialogConstants.NO_LABEL, false);
    }

    public void buttonPressed(int buttonId) {
        if (2 == buttonId) {
            this.setReturnCode(2);
            if (this._testDialog != null && this._testDialog.getShell() != null) {
                this._testDialog.close();
            }
            this.close();
        } else if (3 == buttonId) {
            this.handleFailure();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        composite.setSize(this.SIZING_WIDTH, -1);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createTestSelectionGroup(composite);
        this.createCheckListGroup(composite);
        this._queryLabel = new Label(composite, 0);
        this._queryLabel.setLayoutData((Object)new GridData(768));
        this.initializeTest();
        return composite;
    }

    private void createTestSelectionGroup(Composite parent) {
        Group group = new Group(parent, 32);
        group.setText("Testing:");
        group.setLayout((Layout)new GridLayout());
        GridData data = new GridData(768);
        group.setLayoutData((Object)data);
        IDialogTestPass[] iDialogTestPassArray = this._dialogTests;
        int n = this._dialogTests.length;
        int n2 = 0;
        while (n2 < n) {
            IDialogTestPass dialogTest = iDialogTestPassArray[n2];
            Button radio = new Button((Composite)group, 16);
            radio.setText(dialogTest.label());
            final int testID = dialogTest.getID();
            radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TEST_TYPE = testID;
                    VerifyDialog.this.initializeTest();
                    VerifyDialog.this._yesButton.setEnabled(true);
                }
            });
            if (TEST_TYPE == dialogTest.getID()) {
                radio.setSelection(true);
            }
            ++n2;
        }
    }

    private void createCheckListGroup(Composite parent) {
        Group group = new Group(parent, 32);
        group.setText("Verify that:");
        group.setLayout((Layout)new GridLayout());
        GridData data = new GridData(768);
        group.setLayoutData((Object)data);
        int checkListSize = 0;
        int i = 0;
        while (i < this._dialogTests.length) {
            int size = this._dialogTests[i].checkListTexts().size();
            if (size > checkListSize) {
                checkListSize = size;
            }
            ++i;
        }
        this._checkList = new Button[checkListSize];
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VerifyDialog.this.checkYesEnable();
            }
        };
        int i2 = 0;
        while (i2 < checkListSize) {
            this._checkList[i2] = new Button((Composite)group, 32);
            this._checkList[i2].addSelectionListener((SelectionListener)selectionAdapter);
            data = new GridData(256);
            data.grabExcessHorizontalSpace = true;
            this._checkList[i2].setLayoutData((Object)data);
            ++i2;
        }
    }

    private void checkYesEnable() {
        boolean enable = true;
        Button[] buttonArray = this._checkList;
        int n = this._checkList.length;
        int n2 = 0;
        while (n2 < n) {
            Button checkButton = buttonArray[n2];
            if (!checkButton.getSelection()) {
                enable = false;
            }
            ++n2;
        }
        this._yesButton.setEnabled(enable);
    }

    private void initializeTest() {
        IDialogTestPass test = this._dialogTests[TEST_TYPE];
        this.setTitle(test.title());
        this.setMessage(test.description());
        Iterator<String> iterator = test.checkListTexts().iterator();
        Button[] buttonArray = this._checkList;
        int n = this._checkList.length;
        int n2 = 0;
        while (n2 < n) {
            Button checkButton = buttonArray[n2];
            if (iterator.hasNext()) {
                checkButton.setText(iterator.next().toString());
                checkButton.setVisible(true);
                checkButton.update();
            } else {
                checkButton.setVisible(false);
                checkButton.update();
            }
            checkButton.setSelection(true);
            ++n2;
        }
        this._queryLabel.setText(test.queryText());
    }

    public String getFailureText() {
        return this._failureText;
    }

    public int open() {
        this._failureText = "Testing dialog is required, use VerifyDialog::open(Dialog)";
        return 3;
    }

    public int open(Dialog testDialog) {
        if (this.getShell() == null) {
            this.create();
        }
        this.getShell().setLocation(0, 0);
        this.getShell().setSize(Math.max(this.SIZING_WIDTH, this.getShell().getSize().x), this.getShell().getSize().y);
        this._testDialog = testDialog;
        if (this._testDialog.getShell() == null) {
            this._testDialog.create();
        }
        this._testDialogSize = this._testDialog.getShell().getSize();
        this.openNewTestDialog();
        return super.open();
    }

    private void openNewTestDialog() {
        if (this._testDialog.getShell() == null) {
            this._testDialog.create();
        }
        this._testDialog.setBlockOnOpen(false);
        this._testDialog.getShell().setLocation(this.getShell().getSize().x + 1, 0);
        this._testDialog.getShell().setSize(this._testDialogSize);
        this._testDialog.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                e.doit = false;
            }
        });
        this._testDialog.open();
    }

    private void handleFailure() {
        IDialogTestPass test = this._dialogTests[TEST_TYPE];
        StringBuffer text = new StringBuffer();
        String label = test.label();
        label = String.valueOf(label.substring(0, label.indexOf("&"))) + label.substring(label.indexOf("&") + 1);
        text.append(label).append(" failed on the ").append(Util.getWS()).append(" platform:\n");
        String[] failureMessages = test.failureTexts();
        int i = 0;
        while (i < test.checkListTexts().size()) {
            if (!this._checkList[i].getSelection()) {
                text.append("- ").append(failureMessages[i]).append("\n");
            }
            ++i;
        }
        FailureDialog dialog = new FailureDialog(this.getShell());
        dialog.create();
        dialog.setText(text.toString());
        if (dialog.open() == 0) {
            this._failureText = dialog.toString();
            this.setReturnCode(3);
            if (this._testDialog.getShell() != null) {
                this._testDialog.close();
            }
            this.close();
        }
    }

    protected void handleShellCloseEvent() {
        this.handleFailure();
    }
}

