/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.tests.navigator.NavigatorTestBase;
import org.eclipse.ui.tests.navigator.m12.M1ContentProvider;
import org.eclipse.ui.tests.navigator.m12.M2ContentProvider;
import org.eclipse.ui.tests.navigator.m12.model.M1Project;
import org.eclipse.ui.tests.navigator.m12.model.M2File;
import org.junit.Assert;
import org.junit.Test;

public class M12Tests
extends NavigatorTestBase {
    private static final boolean SLEEP_LONG = false;

    public M12Tests() {
        this._navigatorInstanceId = "org.eclipse.ui.tests.navigator.M12View";
    }

    private void _initContent() {
        String[] EXTENSIONS = new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.ui.tests.navigator.m12.M1", "org.eclipse.ui.tests.navigator.m12.M2"};
        this._contentService.bindExtensions(EXTENSIONS, false);
        this._contentService.getActivationService().activateExtensions(EXTENSIONS, true);
    }

    @Test
    public void testM1ChildrenAreThere() throws Exception {
        this._initContent();
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        this._expand(rootItems);
        TreeItem p1Item = rootItems[0];
        Assert.assertEquals((String)"P1 tree item should be an M1Project", M1Project.class, p1Item.getData().getClass());
        TreeItem[] p1Children = p1Item.getItems();
        this._expand(p1Children);
        TreeItem f1Child = this._findChild("f1", p1Children);
        Assert.assertNotNull((String)"P1 should have a child named f1", (Object)f1Child);
        TreeItem[] f1Children = f1Child.getItems();
        Assert.assertEquals((String)"[bug #285353] f1 folder should have 2 children", (long)2L, (long)f1Children.length);
    }

    @Test
    public void testM1ChildrenAreThereWithoutM2() throws Exception {
        String[] EXTENSIONS = new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.ui.tests.navigator.m12.M1"};
        this._contentService.bindExtensions(EXTENSIONS, false);
        this._contentService.getActivationService().activateExtensions(EXTENSIONS, true);
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        this._expand(rootItems);
        TreeItem[] p1Children = rootItems[0].getItems();
        this._expand(p1Children);
        TreeItem f1Child = this._findChild("f1", p1Children);
        Assert.assertNotNull((String)"P1 should have a child named f1", (Object)f1Child);
        TreeItem[] f1Children = f1Child.getItems();
        Assert.assertEquals((String)"f1 folder should have 2 children", (long)2L, (long)f1Children.length);
    }

    @Test
    public void testM2Override() throws Exception {
        this._initContent();
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        this._expand(rootItems);
        TreeItem p2Item = this._findChild("p2", rootItems);
        TreeItem[] p2Children = p2Item.getItems();
        this._expand(p2Children);
        TreeItem file2Child = this._findChild("file2.txt", p2Children);
        Assert.assertNotNull((String)"P2 should have a child named file2.txt", (Object)file2Child);
        Assert.assertEquals((String)"file2.txt should be provided by M2 content provider", M2File.class, file2Child.getData().getClass());
    }

    @Test
    public void testInterceptAdd() throws CoreException {
        this._initContent();
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        this._expand(rootItems);
        IFolder newFolder1 = this._p1.getFolder("newFolder1");
        newFolder1.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        TreeItem folder1Item = this._findChild("newFolder1", rootItems[0].getItems());
        Assert.assertNotNull((String)"M1 interceptAdd method should have been called", (Object)folder1Item);
    }

    public void XXXtestInterceptRemove() throws CoreException {
        this._initContent();
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        this._expand(rootItems);
        IFolder newFolder1 = this._p1.getFolder("newFolder1");
        if (!newFolder1.exists()) {
            newFolder1.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        TreeItem folder1Item = this._findChild("newFolder1", rootItems[0].getItems());
        newFolder1.delete(true, (IProgressMonitor)new NullProgressMonitor());
        folder1Item = this._findChild("newFolder1", rootItems[0].getItems());
        Assert.assertNull((String)"[bug 285529] M1 interceptRemove method should have been called", (Object)folder1Item);
    }

    public void XXXtestInterceptRefreshOnChildTypeChange() throws CoreException {
        this._initContent();
        final IFile file2 = this._p2.getFile("file2.txt");
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                file2.delete(true, (IProgressMonitor)new NullProgressMonitor());
                file2.create(null, true, null);
            }
        };
        M1ContentProvider.resetCounters();
        M2ContentProvider.resetCounters();
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((String)"[bug 285529] M1 intercept update or refresh should have been called", (M1ContentProvider.getInterceptRefreshCount() + M1ContentProvider.getInterceptUpdateCount() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"[bug 285529] M2 intercept update or refresh should have been called", (M2ContentProvider.getInterceptRefreshCount() + M2ContentProvider.getInterceptUpdateCount() >= 1 ? 1 : 0) != 0);
    }
}

