/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.DecimalFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.navigator.ICommonViewerMapper;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.tests.harness.util.EditorTestHelper;
import org.eclipse.ui.tests.navigator.NavigatorTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PerformanceTest
extends NavigatorTestBase {
    private int _numProjects = 50;
    private int _numFiles = 1000;
    private static final boolean DEBUG = false;
    DecimalFormat _df = new DecimalFormat("000");

    public PerformanceTest() {
        this._navigatorInstanceId = "org.eclipse.ui.navigator.ProjectExplorer";
        this._initTestData = false;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
    }

    protected void createProjects() {
        Job createJob = new Job("Create projects"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    int i = 0;
                    while (i < PerformanceTest.this._numProjects) {
                        String name = PerformanceTest.this._df.format(i);
                        IProject p1 = ResourcesPlugin.getWorkspace().getRoot().getProject("p" + name);
                        p1.create(null);
                        p1.open(null);
                        IFile f1 = p1.getFile("f" + PerformanceTest.this._df.format(0L));
                        f1.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
                        ++i;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Assert.fail((String)("Unexpected exception: " + ex));
                }
                return Status.OK_STATUS;
            }
        };
        createJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        createJob.schedule();
        try {
            createJob.join();
        }
        catch (InterruptedException interruptedException) {
            Assert.fail((String)"Should not throw an exception");
        }
        Assert.assertEquals((Object)createJob.getResult(), (Object)Status.OK_STATUS);
        DisplayHelper.runEventLoop((Display)Display.getCurrent(), (long)10L);
        int numOfProjects = this._viewer.getTree().getItemCount();
        System.out.println("Projects created: " + numOfProjects);
        Assert.assertEquals((long)this._numProjects, (long)numOfProjects);
    }

    protected void deleteProjects() {
        Job deleteJob = new Job("Delete Projects"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    int i = 0;
                    while (i < PerformanceTest.this._numProjects) {
                        String name = PerformanceTest.this._df.format(i);
                        IProject p1 = ResourcesPlugin.getWorkspace().getRoot().getProject("p" + name);
                        p1.delete(true, null);
                        ++i;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Assert.fail((String)("Unexpected exception: " + ex));
                }
                return Status.OK_STATUS;
            }
        };
        deleteJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        deleteJob.schedule();
        try {
            deleteJob.join();
        }
        catch (InterruptedException interruptedException) {
            Assert.fail((String)"Should not throw an exception");
        }
        Assert.assertEquals((Object)deleteJob.getResult(), (Object)Status.OK_STATUS);
        DisplayHelper.runEventLoop((Display)Display.getCurrent(), (long)10L);
    }

    protected void createFiles(final IProject project, final int startNumber) {
        Job createJob = new Job("Create Files"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    int i = startNumber;
                    while (i < PerformanceTest.this._numFiles) {
                        String name = PerformanceTest.this._df.format(i);
                        IFile f1 = project.getFile("f" + name);
                        f1.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
                        ++i;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Assert.fail((String)("Unexpected exception: " + ex));
                }
                return Status.OK_STATUS;
            }
        };
        createJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        createJob.schedule();
        try {
            createJob.join();
        }
        catch (InterruptedException interruptedException) {
            Assert.fail((String)"Should not throw an exception");
        }
        Assert.assertEquals((Object)createJob.getResult(), (Object)Status.OK_STATUS);
    }

    protected void touchFiles(final IProject p1) throws Exception {
        Job touchJob = new Job("Touch Files"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    int i = 0;
                    while (i < PerformanceTest.this._numFiles) {
                        String name = PerformanceTest.this._df.format(i);
                        IFile f1 = p1.getFile("f" + name);
                        f1.touch(null);
                        ++i;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Assert.fail((String)("Unexpected exception: " + ex));
                }
                return Status.OK_STATUS;
            }
        };
        touchJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        touchJob.schedule();
        touchJob.join();
        Assert.assertEquals((Object)touchJob.getResult(), (Object)Status.OK_STATUS);
    }

    @Test
    public void testCreateAndDeleteProjects() {
        this._numProjects = 100;
        this.createProjects();
        try {
            EditorTestHelper.showView((String)this._navigatorInstanceId, (boolean)false);
        }
        catch (PartInitException partInitException) {
            Assert.fail((String)"Should not throw an exception");
        }
        long start = System.currentTimeMillis();
        this.deleteProjects();
        DisplayHelper.sleep((long)500L);
        System.out.println("No project explorer delete " + this._numProjects + " Time: " + (System.currentTimeMillis() - start));
        this.showNavigator();
        DisplayHelper.sleep((long)100L);
        this.createProjects();
        DisplayHelper.sleep((long)200L);
        start = System.currentTimeMillis();
        this.deleteProjects();
        DisplayHelper.sleep((long)500L);
        System.out.println("Project explorer " + this._numProjects + " Time: " + (System.currentTimeMillis() - start));
        DisplayHelper.sleep((long)500L);
    }

    public void XXXtestCreateAndTouchFiles() throws Exception {
        final IProject p1 = ResourcesPlugin.getWorkspace().getRoot().getProject("p1");
        p1.create(null);
        p1.open(null);
        this.createFiles(p1, 0);
        this._viewer.collapseAll();
        long start = System.currentTimeMillis();
        Job touchJob = new Job("Touch Files"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    int i = 0;
                    while (i < PerformanceTest.this._numFiles) {
                        String name = PerformanceTest.this._df.format(i);
                        IFile f1 = p1.getFile("f" + name);
                        f1.touch(null);
                        ++i;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Assert.fail((String)("Unexpected exception: " + ex));
                }
                return Status.OK_STATUS;
            }
        };
        touchJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        touchJob.schedule();
        touchJob.join();
        Assert.assertEquals((Object)touchJob.getResult(), (Object)Status.OK_STATUS);
        System.out.println("Touch " + this._numFiles + " Time: " + (System.currentTimeMillis() - start));
    }

    protected void createFilesForProjects() {
        int i = 0;
        while (i < this._numProjects) {
            String name = this._df.format(i);
            IProject p1 = ResourcesPlugin.getWorkspace().getRoot().getProject("p" + name);
            this.createFiles(p1, 1);
            ++i;
        }
    }

    @Test
    public void testLabelProviderMapping() throws Exception {
        ICommonViewerMapper mapper = this._viewer.getMapper();
        this._numProjects = 1;
        this._numFiles = 2000;
        this.createProjects();
        this.createFilesForProjects();
        IProject p1 = ResourcesPlugin.getWorkspace().getRoot().getProject("p000");
        try {
            p1.close(null);
        }
        catch (CoreException coreException) {
            Assert.fail((String)"Should not throw an exception");
        }
        long start = System.currentTimeMillis();
        this._viewer.setMapper(null);
        p1.open(null);
        DisplayHelper.sleep((long)200L);
        long createUnMappedTime = System.currentTimeMillis() - start;
        System.out.println("Unmapped Time: " + createUnMappedTime);
        p1.close(null);
        DisplayHelper.sleep((long)200L);
        this._viewer.setMapper(mapper);
        start = System.currentTimeMillis();
        p1.open(null);
        DisplayHelper.sleep((long)200L);
        long createMappedTime = System.currentTimeMillis() - start;
        System.out.println("Mapped Time: " + createMappedTime);
        Assert.assertTrue((createMappedTime < createUnMappedTime ? 1 : 0) != 0);
    }
}

