/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.ResourceTransfer;
import org.junit.Assert;
import org.junit.Test;

public class ResourceTransferTest {
    @Test
    public void testMaxResourcesLimitForTransfer() throws Exception {
        System.gc();
        ResourceTransfer transfer = ResourceTransfer.getInstance();
        IProject dummyProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Dummy");
        Transfer[] types = new Transfer[]{transfer, TextTransfer.getInstance()};
        Clipboard clip = new Clipboard(Display.getDefault());
        try {
            clip.clearContents();
            int count = 1000000;
            Object[] data = new IResource[count];
            String names = this.createtextBuffer(count, dummyProject.getName());
            Arrays.fill(data, dummyProject);
            clip.setContents(new Object[]{data, names}, types);
            Assert.assertNotNull((Object)clip.getContents((Transfer)transfer));
            data = new IResource[++count];
            names = this.createtextBuffer(count, dummyProject.getName());
            Arrays.fill(data, dummyProject);
            clip.setContents(new Object[]{data, names}, types);
            Assert.assertNull((Object)clip.getContents((Transfer)transfer));
            clip.clearContents();
        }
        finally {
            clip.dispose();
            System.gc();
        }
    }

    String createtextBuffer(int count, String name) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < count) {
            if (i > 0) {
                sb.append('\n');
            }
            sb.append(name);
            ++i;
        }
        return sb.toString();
    }
}

