/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.cdt;

import java.util.Comparator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.tests.navigator.cdt.CContainer;
import org.eclipse.ui.tests.navigator.cdt.CElement;
import org.eclipse.ui.tests.navigator.cdt.CProject;
import org.eclipse.ui.tests.navigator.cdt.CRoot;

public class CElementSorter
extends ViewerSorter {
    protected static final int CMODEL = 0;
    protected static final int PROJECTS = 10;
    protected static final int BINARYCONTAINER = 12;
    protected static final int ARCHIVECONTAINER = 13;
    protected static final int INCLUDEREFCONTAINER = 14;
    protected static final int LIBRARYREFCONTAINER = 15;
    protected static final int SOURCEROOTS = 16;
    protected static final int CCONTAINERS = 17;
    protected static final int LIBRARYREFERENCES = 18;
    protected static final int INCLUDEREFERENCES = 19;
    protected static final int TRANSLATIONUNIT_HEADERS = 20;
    protected static final int TRANSLATIONUNIT_SOURCE = 21;
    protected static final int TRANSLATIONUNITS = 22;
    protected static final int BINARIES = 23;
    protected static final int ARCHIVES = 24;
    protected static final int INCLUDES = 28;
    protected static final int MACROS = 29;
    protected static final int USINGS = 30;
    protected static final int NAMESPACES = 32;
    protected static final int NAMESPACES_RESERVED = 33;
    protected static final int NAMESPACES_SYSTEM = 34;
    protected static final int TYPES = 35;
    protected static final int VARIABLEDECLARATIONS = 36;
    protected static final int FUNCTIONDECLARATIONS = 37;
    protected static final int VARIABLES = 38;
    protected static final int VARIABLES_RESERVED = 39;
    protected static final int VARIABLES_SYSTEM = 40;
    protected static final int FUNCTIONS = 41;
    protected static final int FUNCTIONS_RESERVED = 42;
    protected static final int FUNCTIONS_SYSTEM = 43;
    protected static final int METHODDECLARATIONS = 44;
    protected static final int CELEMENTS = 100;
    protected static final int CELEMENTS_RESERVED = 101;
    protected static final int CELEMENTS_SYSTEM = 102;
    protected static final int RESOURCEFOLDERS = 200;
    protected static final int RESOURCES = 201;
    protected static final int STORAGE = 202;
    protected static final int OTHERS = 500;

    public int category(Object element) {
        if (element instanceof CElement) {
            if (element instanceof CRoot) {
                return 0;
            }
            if (element instanceof CProject) {
                return 10;
            }
            if (element instanceof CContainer) {
                return 17;
            }
            return 35;
        }
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            switch (resource.getType()) {
                case 4: {
                    return 10;
                }
                case 2: {
                    return 200;
                }
            }
            return 201;
        }
        if (element instanceof IStorage) {
            return 202;
        }
        return 500;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        String name2;
        int idx;
        String name1;
        String ns1;
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        Comparator comparator = this.getComparator();
        if (cat1 == 10) {
            IWorkbenchAdapter a1 = (IWorkbenchAdapter)((IAdaptable)e1).getAdapter(IWorkbenchAdapter.class);
            IWorkbenchAdapter a2 = (IWorkbenchAdapter)((IAdaptable)e2).getAdapter(IWorkbenchAdapter.class);
            return comparator.compare(a1.getLabel(e1), a2.getLabel(e2));
        }
        if (cat1 == 201 || cat1 == 200 || cat1 == 202 || cat1 == 500) {
            return this.compareWithLabelProvider(viewer, e1, e2);
        }
        String ns2 = ns1 = "";
        if (e1 instanceof CElement) {
            name1 = ((CElement)e1).getElementName();
            idx = name1.lastIndexOf("::");
            if (idx >= 0) {
                ns1 = name1.substring(0, idx);
                name1 = name1.substring(idx + 2);
            }
            if (name1.length() > 0 && name1.charAt(0) == '~') {
                name1 = name1.substring(1);
            }
        } else {
            name1 = e1.toString();
        }
        if (e2 instanceof CElement) {
            name2 = ((CElement)e2).getElementName();
            idx = name2.lastIndexOf("::");
            if (idx >= 0) {
                ns2 = name2.substring(0, idx);
                name2 = name2.substring(idx + 2);
            }
            if (name2.length() > 0 && name2.charAt(0) == '~') {
                name2 = name2.substring(1);
            }
        } else {
            name2 = e2.toString();
        }
        if ((result = comparator.compare(ns1, ns2)) != 0) {
            return result;
        }
        if (result != 0) {
            return result;
        }
        result = comparator.compare(name1, name2);
        if (result != 0) {
            return result;
        }
        return result;
    }

    private int compareWithLabelProvider(Viewer viewer, Object e1, Object e2) {
        IBaseLabelProvider prov;
        if (viewer instanceof ContentViewer && (prov = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
            ILabelProvider lprov = (ILabelProvider)prov;
            String name1 = lprov.getText(e1);
            String name2 = lprov.getText(e2);
            if (name1 != null && name2 != null) {
                Comparator comparator = this.getComparator();
                return comparator.compare(name1, name2);
            }
        }
        return 0;
    }
}

