/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.extension;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IDescriptionProvider;

public class TrackingLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
IDescriptionProvider,
IColorProvider,
IFontProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final boolean PRINT_DEBUG_INFO = false;
    public static Color BG_COLOR = Display.getCurrent().getSystemColor(15);
    public static Color FG_COLOR = Display.getCurrent().getSystemColor(2);
    public static Font FONT = new Font((Device)Display.getDefault(), new FontData());
    public static final Map descriptionQueries = new HashMap();
    public static final Map backgroundQueries = new HashMap();
    public static final Map foregroundQueries = new HashMap();
    public static final Map fontQueries = new HashMap();
    public static final Map styledTextQueries = new HashMap();
    public static final Map textQueries = new HashMap();
    public static final Map imageQueries = new HashMap();
    private String _id;

    public void init(ICommonContentExtensionSite config) {
        this._id = config.getExtension().getId();
        int i = this._id.lastIndexOf(46);
        if (i >= 0) {
            this._id = this._id.substring(i + 1);
        }
    }

    public Image getImage(Object element) {
        this._track(imageQueries, element);
        return null;
    }

    private void _track(Map map, Object element) {
        String entry = (String)map.get(element);
        StringBuffer builder = new StringBuffer(entry == null ? "" : entry);
        builder.append(this._id);
        map.put(element, builder.toString());
    }

    public String getText(Object element) {
        this._track(textQueries, element);
        return null;
    }

    public String getDescription(Object element) {
        this._track(descriptionQueries, element);
        return null;
    }

    public Color getBackground(Object element) {
        this._track(backgroundQueries, element);
        return null;
    }

    public Color getForeground(Object element) {
        this._track(foregroundQueries, element);
        return null;
    }

    public Font getFont(Object element) {
        this._track(fontQueries, element);
        return null;
    }

    public StyledString getStyledText(Object element) {
        this._track(styledTextQueries, element);
        return null;
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public static void resetQueries() {
        descriptionQueries.clear();
        backgroundQueries.clear();
        foregroundQueries.clear();
        fontQueries.clear();
        styledTextQueries.clear();
        textQueries.clear();
        imageQueries.clear();
    }
}

