/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.resources;

import java.util.Comparator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.internal.navigator.resources.nested.PathComparator;
import org.junit.Assert;
import org.junit.Test;

public class PathComparatorTest {
    private static final Comparator<IPath> COMPARATOR = new PathComparator();

    private static void assertConsistentWithEquals(IPath p1, IPath p2) {
        int compare;
        boolean equals = p1.equals((Object)p2);
        if (equals != ((compare = COMPARATOR.compare(p1, p2)) == 0)) {
            Assert.fail((String)("Path.equals() == " + equals + " inconsistent with " + PathComparator.class.getName() + ".compare() == " + compare + " for paths '" + p1 + "' and '" + p2 + "'"));
        }
    }

    private static void assertLessThan(IPath p1, IPath p2) {
        int compare = COMPARATOR.compare(p1, p2);
        Assert.assertTrue((String)(String.valueOf(PathComparator.class.getName()) + ".compare() returned " + compare + " expected less than zero for paths '" + p1 + "' and '" + p2 + "'"), (compare < 0 ? 1 : 0) != 0);
    }

    @Test
    public void checkInvariant() {
        Path ab = new Path("a/b");
        Path abc = new Path("a/b/c");
        Path ac = new Path("a/c");
        Path acb = new Path("a/c/b");
        Assert.assertTrue((COMPARATOR.compare((IPath)ab, (IPath)abc) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((COMPARATOR.compare((IPath)abc, (IPath)ac) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((COMPARATOR.compare((IPath)ac, (IPath)acb) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void consistentWithEqualsDistLength() {
        PathComparatorTest.assertConsistentWithEquals((IPath)Path.forWindows((String)"a:/f1/f2"), (IPath)Path.forWindows((String)"a:/f1/f2/f3"));
    }

    @Test
    public void consistentWithEqualsDist() {
        PathComparatorTest.assertConsistentWithEquals((IPath)Path.forWindows((String)"a:/f1/f2"), (IPath)Path.forWindows((String)"a:/f1/f3"));
    }

    @Test
    public void consistentWithEqualsDistDevice() {
        PathComparatorTest.assertConsistentWithEquals((IPath)Path.forWindows((String)"a:/f1/f2"), (IPath)Path.forWindows((String)"b:/f1/f2"));
    }

    @Test
    public void consistentWithEqualsDistLeadingSlash() {
        PathComparatorTest.assertConsistentWithEquals((IPath)Path.forWindows((String)"/f1/f2"), (IPath)Path.forWindows((String)"f1/f2"));
    }

    @Test
    public void consistentWithEqualsDistTrailingSlash() {
        PathComparatorTest.assertConsistentWithEquals((IPath)Path.forWindows((String)"f1/f2/"), (IPath)Path.forWindows((String)"f1/f2"));
    }

    @Test
    public void consistentWithEqualsSame() {
        PathComparatorTest.assertConsistentWithEquals((IPath)Path.forWindows((String)"a:/f1/f2"), (IPath)Path.forWindows((String)"a:/f1/f2"));
    }

    @Test
    public void consistentWithEqualsUncAbsolute() {
        PathComparatorTest.assertConsistentWithEquals((IPath)Path.forWindows((String)"//f1/f2"), (IPath)Path.forWindows((String)"/f1/f2"));
    }

    @Test
    public void consistentWithEqualsUncRelative() {
        PathComparatorTest.assertConsistentWithEquals((IPath)Path.forWindows((String)"//f1/f2"), (IPath)Path.forWindows((String)"f1/f2"));
    }

    @Test
    public void consistentWithEqualsWinPosix() {
        PathComparatorTest.assertConsistentWithEquals((IPath)Path.forWindows((String)"f1/f2"), (IPath)Path.forPosix((String)"f1/f2"));
    }

    @Test
    public void lessThanRelativeDashSlash() {
        PathComparatorTest.assertLessThan((IPath)Path.forWindows((String)"f1/f1"), (IPath)Path.forWindows((String)"f1-f2"));
    }

    @Test
    public void lessThanRelativeDepth1() {
        PathComparatorTest.assertLessThan((IPath)Path.forWindows((String)"f1"), (IPath)Path.forWindows((String)"f2"));
    }

    @Test
    public void lessThanRelativeDepth2() {
        PathComparatorTest.assertLessThan((IPath)Path.forWindows((String)"f1/f1"), (IPath)Path.forWindows((String)"f1/f2"));
    }

    @Test
    public void deviceALessThanDeviceB() {
        PathComparatorTest.assertLessThan((IPath)Path.forWindows((String)"a:/f1/f2"), (IPath)Path.forWindows((String)"b:/f1/f2"));
    }

    @Test
    public void relativeLessThanAbsolute() {
        PathComparatorTest.assertLessThan((IPath)Path.forWindows((String)"f1/f2"), (IPath)Path.forWindows((String)"/f1/f2"));
    }

    @Test
    public void absoluteLessThanUnc() {
        PathComparatorTest.assertLessThan((IPath)Path.forWindows((String)"/f1/f2"), (IPath)Path.forWindows((String)"//f1/f2"));
    }

    @Test
    public void uncLessThanDevice() {
        PathComparatorTest.assertLessThan((IPath)Path.forWindows((String)"//f1/f2"), (IPath)Path.forWindows((String)"a:/f1/f2"));
    }
}

