/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ProjectUnzipUtil {
    private IPath zipLocation;
    private String[] projectNames;
    private IPath rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
    private static final String META_PROJECT_NAME = ".project";

    public ProjectUnzipUtil(IPath aLocalZipFilePath, String[] aProjectNames) {
        this.zipLocation = this.getLocalPath(aLocalZipFilePath);
        this.projectNames = aProjectNames;
    }

    public IPath getLocalPath(IPath zipFilePath) {
        Bundle bundle = FrameworkUtil.getBundle(ProjectUnzipUtil.class);
        URL url = FileLocator.find((Bundle)bundle, (IPath)zipFilePath, null);
        try {
            url = FileLocator.toFileURL((URL)url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Path(url.getPath());
    }

    public boolean createProjects() {
        try {
            this.expandZip();
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
            this.buildProjects();
        }
        catch (IOException | CoreException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean reset() {
        try {
            this.expandZip();
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        }
        catch (IOException | CoreException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private IProgressMonitor getProgessMonitor() {
        return new NullProgressMonitor();
    }

    private void expandZip() throws CoreException, IOException {
        IProgressMonitor monitor = this.getProgessMonitor();
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipFile zipFile = new ZipFile(this.zipLocation.toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                monitor.subTask(entry.getName());
                File aFile = this.computeLocation(entry.getName()).toFile();
                File parentFile = null;
                if (entry.isDirectory()) {
                    aFile.mkdirs();
                } else {
                    parentFile = aFile.getParentFile();
                    if (!parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    if (!aFile.exists()) {
                        aFile.createNewFile();
                    }
                    ProjectUnzipUtil.copy(zipFile.getInputStream(entry), new FileOutputStream(aFile));
                    if (entry.getTime() > 0L) {
                        aFile.setLastModified(entry.getTime());
                    }
                }
                monitor.worked(1);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private IPath computeLocation(String name) {
        return this.rootLocation.append(name);
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        try {
            int n = in.read(buffer);
            while (n > 0) {
                out.write(buffer, 0, n);
                n = in.read(buffer);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    public void setRootLocation(IPath rootLocation) {
        this.rootLocation = rootLocation;
    }

    private void buildProjects() throws IOException, CoreException {
        int i = 0;
        while (i < this.projectNames.length) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Path projectPath = new Path("/" + this.projectNames[i] + "/" + META_PROJECT_NAME);
            IPath path = this.rootLocation.append((IPath)projectPath);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectNames[i]);
            IProjectDescription description = workspace.loadProjectDescription(path);
            project.create(description, this.getProgessMonitor());
            project.open(this.getProgessMonitor());
            ++i;
        }
    }
}

