/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.tests.performance.JFacePerformanceSuite;
import org.eclipse.jface.tests.performance.TestTreeElement;
import org.eclipse.jface.tests.performance.TreeAddTest;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.tests.performance.TestRunnable;

public class FastTreeTest
extends TreeAddTest {
    public FastTreeTest(String testName, int tagging) {
        super(testName, tagging);
    }

    public FastTreeTest(String testName) {
        super(testName);
    }

    public void testAddTenTenTimes() throws CoreException {
        this.doTestAdd(10, TEST_COUNT, false);
    }

    public void testAddFiftyTenTimes() throws CoreException {
        this.doTestAdd(50, TEST_COUNT, false);
    }

    public void testAddHundredTenTimes() throws CoreException {
        this.tagIfNecessary("JFace - Add 10000 items 100 at a time TreeViewer 10 times", Dimension.ELAPSED_PROCESS);
        this.doTestAdd(100, TEST_COUNT, false);
    }

    @Override
    protected void doTestAdd(final int increment, final int total, final boolean preSort) throws CoreException {
        this.openBrowser();
        FastTreeTest.exercise(new TestRunnable(){

            @Override
            public void run() {
                TestTreeElement input = new TestTreeElement(0, null);
                FastTreeTest.this.viewer.setInput((Object)input);
                input.createChildren(total);
                if (preSort) {
                    FastTreeTest.this.viewer.getSorter().sort((Viewer)FastTreeTest.this.viewer, (Object[])input.children);
                }
                ArrayList<Object[]> batches = new ArrayList<Object[]>();
                int blocks = input.children.length / increment;
                int j = 0;
                while (j < blocks) {
                    Object[] batch = new Object[increment];
                    System.arraycopy(input.children, j * increment, batch, 0, increment);
                    batches.add(batch);
                    j += increment;
                }
                FastTreeTest.processEvents();
                Object[] batchArray = batches.toArray();
                FastTreeTest.this.startMeasuring();
                int i = 0;
                while (i < 10) {
                    FastTreeTest.this.viewer.remove((Object[])input.children);
                    int k = 0;
                    while (k < batchArray.length) {
                        FastTreeTest.this.viewer.add((Object)input, (Object[])batchArray[k]);
                        FastTreeTest.processEvents();
                        ++k;
                    }
                    ++i;
                }
                FastTreeTest.this.stopMeasuring();
            }
        }, MIN_ITERATIONS, ITERATIONS, JFacePerformanceSuite.MAX_TIME);
        this.commitMeasurements();
        this.assertPerformance();
    }
}

