/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.tests.performance.JFacePerformanceSuite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.TestRunnable;
import org.eclipse.ui.tests.performance.UIPerformancePlugin;
import org.osgi.framework.Bundle;

public class FileImageDescriptorTest
extends BasicPerformanceTest {
    protected static final String IMAGES_DIRECTORY = "/icons/imagetests";

    public FileImageDescriptorTest(String testName, int tagging) {
        super(testName, tagging);
    }

    public FileImageDescriptorTest(String testName) {
        super(testName);
    }

    public void testRefresh() throws Throwable {
        FileImageDescriptorTest.exercise(new TestRunnable(){

            @Override
            public void run() {
                Class missing = null;
                ArrayList<Image> images = new ArrayList<Image>();
                Bundle bundle = UIPerformancePlugin.getDefault().getBundle();
                Enumeration bundleEntries = bundle.getEntryPaths(FileImageDescriptorTest.IMAGES_DIRECTORY);
                while (bundleEntries.hasMoreElements()) {
                    String localImagePath = (String)bundleEntries.nextElement();
                    if (localImagePath.indexOf(46) < 0) continue;
                    URL[] files = FileLocator.findEntries((Bundle)bundle, (IPath)new Path(localImagePath));
                    int i = 0;
                    while (i < files.length) {
                        block6: {
                            ImageDescriptor descriptor;
                            FileImageDescriptorTest.this.startMeasuring();
                            try {
                                descriptor = ImageDescriptor.createFromFile(missing, (String)FileLocator.toFileURL((URL)files[i]).getFile());
                            }
                            catch (IOException e) {
                                FileImageDescriptorTest.fail((String)e.getLocalizedMessage(), (Throwable)e);
                                break block6;
                            }
                            int j = 0;
                            while (j < 10) {
                                Image image = descriptor.createImage();
                                images.add(image);
                                ++j;
                            }
                            FileImageDescriptorTest.processEvents();
                            FileImageDescriptorTest.this.stopMeasuring();
                        }
                        ++i;
                    }
                }
                Iterator imageIterator = images.iterator();
                while (imageIterator.hasNext()) {
                    ((Image)imageIterator.next()).dispose();
                }
            }
        }, 20, 100, JFacePerformanceSuite.MAX_TIME);
        this.commitMeasurements();
        this.assertPerformance();
    }
}

