/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.tests.performance.TreeAddTest;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.TestRunnable;

public class SWTTreeTest
extends BasicPerformanceTest {
    Shell browserShell;
    Tree tree;

    public SWTTreeTest(String testName, int tagging) {
        super(testName, tagging);
    }

    public SWTTreeTest(String testName) {
        super(testName);
    }

    protected void openBrowser() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = new Display();
        }
        this.browserShell = new Shell(display);
        this.browserShell.setSize(500, 500);
        this.browserShell.setLayout((Layout)new FillLayout());
        this.tree = new Tree((Composite)this.browserShell, 0);
        this.createChildren();
        this.browserShell.open();
    }

    private void createChildren() {
        int i = 0;
        while (i < TreeAddTest.TEST_COUNT) {
            TreeItem item = new TreeItem(this.tree, 0);
            item.setText("Element " + String.valueOf(i));
            ++i;
        }
    }

    public void testGetItems() throws CoreException {
        this.openBrowser();
        SWTTreeTest.exercise(new TestRunnable(){

            @Override
            public void run() throws Exception {
                SWTTreeTest.processEvents();
                SWTTreeTest.this.startMeasuring();
                int j = 0;
                while (j < TreeAddTest.TEST_COUNT) {
                    SWTTreeTest.this.tree.getItems();
                    SWTTreeTest.processEvents();
                    ++j;
                }
                SWTTreeTest.this.stopMeasuring();
            }
        });
        this.commitMeasurements();
        this.assertPerformance();
        this.browserShell.close();
    }

    public void testGetItemAt() throws CoreException {
        this.openBrowser();
        SWTTreeTest.exercise(new TestRunnable(){

            @Override
            public void run() throws Exception {
                SWTTreeTest.processEvents();
                SWTTreeTest.this.startMeasuring();
                int j = 0;
                while (j < TreeAddTest.TEST_COUNT) {
                    SWTTreeTest.this.tree.getItem(j);
                    SWTTreeTest.processEvents();
                    ++j;
                }
                SWTTreeTest.this.stopMeasuring();
            }
        });
        this.commitMeasurements();
        this.assertPerformance();
        this.browserShell.close();
    }
}

