/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.tests.performance.JFacePerformanceSuite;
import org.eclipse.jface.tests.performance.TestTreeElement;
import org.eclipse.jface.tests.performance.TreeTest;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.tests.performance.TestRunnable;

public class ShrinkingTreeTest
extends TreeTest {
    public ShrinkingTreeTest(String testName) {
        super(testName);
    }

    public ShrinkingTreeTest(String testName, int tagging) {
        super(testName, tagging);
    }

    public void testTreeViewerRefresh() throws CoreException {
        this.tagIfNecessary("JFace - Refresh from 1000 items to 100 items", Dimension.ELAPSED_PROCESS);
        this.openBrowser();
        this.testRefresh(100, 1000);
    }

    private void testRefresh(final int smallSize, final int largeSize) throws CoreException {
        ShrinkingTreeTest.exercise(new TestRunnable(){

            @Override
            public void run() {
                TestTreeElement input = new TestTreeElement(0, null);
                ShrinkingTreeTest.this.viewer.setInput((Object)input);
                input.createChildren(largeSize);
                ShrinkingTreeTest.processEvents();
                ShrinkingTreeTest.this.viewer.refresh();
                ShrinkingTreeTest.this.viewer.expandAll();
                input.createChildren(smallSize);
                ShrinkingTreeTest.this.startMeasuring();
                ShrinkingTreeTest.this.viewer.refresh();
                ShrinkingTreeTest.this.stopMeasuring();
            }
        }, MIN_ITERATIONS, ITERATIONS, JFacePerformanceSuite.MAX_TIME);
        this.commitMeasurements();
        this.assertPerformance();
    }
}

