/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.ui.tests.performance.EditorSwitchTest;
import org.eclipse.ui.tests.performance.OpenCloseEditorTest;
import org.eclipse.ui.tests.performance.OpenMultipleEditorTest;

public class EditorPerformanceSuite
extends TestSuite {
    public static final String[] EDITOR_FILE_EXTENSIONS = new String[]{"perf_basic", "perf_outline", "java"};
    public static final String[][] EDITOR_SWITCH_PAIRS = new String[][]{{"perf_outline", "java"}, {"perf_basic", "perf_outline"}};

    public static Test suite() {
        return new EditorPerformanceSuite();
    }

    public EditorPerformanceSuite() {
        this.addOpenCloseScenarios();
        this.addSwitchScenarios();
        this.addOpenMultipleScenarios(true);
        this.addOpenMultipleScenarios(false);
    }

    private void addSwitchScenarios() {
        int i = 0;
        while (i < EDITOR_SWITCH_PAIRS.length) {
            this.addTest((Test)new EditorSwitchTest(EDITOR_SWITCH_PAIRS[i]));
            ++i;
        }
    }

    private void addOpenMultipleScenarios(boolean closeAll) {
        int i = 0;
        while (i < EDITOR_FILE_EXTENSIONS.length) {
            this.addTest((Test)new OpenMultipleEditorTest(EDITOR_FILE_EXTENSIONS[i], closeAll, 0));
            ++i;
        }
    }

    private void addOpenCloseScenarios() {
        int i = 0;
        while (i < EDITOR_FILE_EXTENSIONS.length) {
            this.addTest((Test)new OpenCloseEditorTest(EDITOR_FILE_EXTENSIONS[i], i == 3 ? 1 : 0));
            ++i;
        }
    }
}

