/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.EditorTestHelper;

public class EditorSwitchTest
extends BasicPerformanceTest {
    private String extension1;
    private String extension2;

    public EditorSwitchTest(String[] pair) {
        super("testEditorSwitch:" + pair[0] + "," + pair[1]);
        this.extension1 = pair[0];
        this.extension2 = pair[1];
    }

    protected void runTest() throws CoreException {
        IWorkbenchWindow window = this.openTestWindow("org.eclipse.ui.tests.performancePerspective1");
        IWorkbenchPage activePage = window.getActivePage();
        IFile file1 = this.getProject().getFile("1." + this.extension1);
        EditorSwitchTest.assertTrue((boolean)file1.exists());
        IFile file2 = this.getProject().getFile("1." + this.extension2);
        EditorSwitchTest.assertTrue((boolean)file2.exists());
        IDE.openEditor((IWorkbenchPage)activePage, (IFile)file1, (boolean)true);
        IDE.openEditor((IWorkbenchPage)activePage, (IFile)file2, (boolean)true);
        EditorSwitchTest.processEvents();
        EditorTestHelper.calmDown(500L, 30000L, 500L);
        EditorSwitchTest.waitForBackgroundJobs();
        int j = 0;
        while (j < 100) {
            this.startMeasuring();
            int i = 0;
            while (i < 12) {
                IDE.openEditor((IWorkbenchPage)activePage, (IFile)file1, (boolean)true);
                EditorSwitchTest.processEvents();
                IDE.openEditor((IWorkbenchPage)activePage, (IFile)file2, (boolean)true);
                EditorSwitchTest.processEvents();
                ++i;
            }
            this.stopMeasuring();
            EditorTestHelper.calmDown(500L, 30000L, 100L);
            ++j;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }
}

